<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include "inc.php";
global $kernel;
global $globals;
set_script_timeout();
$php_bin = preg_quote($globals["com"]["php"]);
$script_name = preg_quote(__FILE__);
vexec("/bin/ps -e -o cmd | grep -E \"^" . $php_bin . "\\s+" . $script_name . "\"", $out);
if(1 < count($out)) {
    exit("[" . gmdate("D M d H:i:s T Y", time()) . "] Previous cron is still running\n");
}
echo "[" . gmdate("D M d H:i:s T Y", time()) . "] Started \n";
$kernel->calculate_vps_bandwidth();
if(is_master()) {
    foreach ($servers as $k => $v) {
        if($v["serid"] == 0) {
        } else {
            $ret = $cluster->get_vps_used_bw($k);
            vps_used_bandwidth(1, $ret);
        }
    }
}
if(empty($globals["is_master_only"])) {
    $vpslist = getvpsthreshold();
    $vpsids = array_keys($vpslist);
    $cputhreshold = $cluster->vscpu(0, $vpsids);
    $thisip = " (" . get_softaculous_file(fastestmirror() . "/ip.php") . ")";
    $hostname = $cluster->hostname(0);
    foreach ($vpslist as $vpsid => $v) {
        $uuid = $v["uuid"];
        if($cputhreshold[$vpsid] < $v["threshold"]) {
            $res = makequery("DELETE FROM `vps_meta` WHERE `vps_uuid` = :uuid AND meta_key = :meta_key", [":uuid" => $uuid, ":meta_key" => "threshold_count"]);
        } else {
            $dmail = vpsthresholdlimit($uuid, $v["time"]);
            if(!empty($dmail)) {
                $email_vars = ["cpu_usage" => number_format($cputhreshold[$vpsid], 2), "vpsid" => $dmail["vpsid"], "ip" => $dmail["ip"], "time" => $v["time"], "sn" => $globals["sn"], "server_ip" => $thisip, "hostname" => $hostname];
                $cluster->suspendvps($dmail["vpsid"]);
                send_emailtemp_mail("cpu_threshold", $globals["soft_email"], $email_vars, 1);
                $data["title"] = lang_vars_name($l["admin_mail_cputhreshold_sub"], $email_vars);
                $data["body"] = lang_vars_name($l["host_cpu_notify"], $email_vars);
                $data["data"] = lang_vars_name($l["admin_cputhreshold_notify"], $email_vars);
                save_notification("server_load_warn", $data);
                if(is_slave()) {
                    to_master("vps", "suspended", $vpsid, "vpsid", 1);
                    to_master("vps", "suspend_reason", $vpsid, "vpsid", $l["cpu_threshold_exceeded"]);
                }
            }
        }
    }
    if(is_slave()) {
        initiate_reverse_sync();
    }
}
echo "[" . gmdate("D M d H:i:s T Y", time()) . "] Finished \n";

?>