<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addplan()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $done;
    global $_ubc;
    global $mgs;
    global $isos;
    global $oslist;
    global $vnc_keymap_array;
    global $plans;
    global $recipes;
    global $backup_plans;
    global $supported_nics;
    global $servergroups;
    global $ippools;
    global $bus_driver_list;
    global $bios;
    global $cpu_info;
    global $ostemplates;
    global $firewall_plans;
    global $firewall_users;
    if(!load_lang("admin/addplan")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/addplan";
    $theme["init_theme_name"] = "addplan";
    $theme["init_theme_func"] = ["addplan_theme"];
    $theme["call_theme_func"] = "addplan_theme";
    if(!is_allowed("addplan")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $res = makequery("SELECT * FROM plans");
    $plans = [];
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $plans[$row["plid"]] = $row;
        if(!empty($row["openvz_features"])) {
            $tmp_openvz_features = unserialize($row["openvz_features"]);
            $plans[$row["plid"]] = array_merge($plans[$row["plid"]], $tmp_openvz_features);
        }
    }
    $virt = optREQ("virt");
    $cpu_info = prox_cpu_flags();
    $temp_plid = optREQ("plan_template");
    if(empty($virt) && !empty($temp_plid)) {
        $virt = $plans[$temp_plid]["virt"];
    }
    $tmp_plan_type = optREQ("cplan");
    if(empty($virt) && !empty($tmp_plan_type)) {
        $virt = $tmp_plan_type;
    }
    oslist();
    sort_media("ostemplates", "name");
    $mgs = listmgs();
    isolist();
    $_ubc = ["kmemsize", "lockedpages", "numproc", "physpages", "numtcpsock", "numflock", "numpty", "numsiginfo", "tcpsndbuf", "tcprcvbuf", "othersockbuf", "dgramrcvbuf", "numothersock", "dcachesize", "numfile", "numiptent", "swappages", "diskinodes"];
    $vnc_keymap_array = ["en-us", "de-ch", "ar", "da", "et", "fo", "fr-be", "fr-ch", "hu", "it", "lt", "mk", "nl", "no", "pt", "ru", "sv", "tr", "de", "en-gb", "es", "fi", "fr", "fr-ca", "hr", "is", "ja", "lv", "nl-be", "pl", "pt-br", "sl", "th"];
    $servergroups = server_groups();
    $servergroups[-1] = ["sgid" => -1, "sg_name" => $l["all_reg"], "sg_reseller_name" => $l["all_reg"], "sg_desc" => $l["all_reg"], "sg_select" => 0];
    $backup_plans = [];
    $res = makequery("SELECT * FROM backup_plans");
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $backup_plans[$row["bpid"]] = $row;
    }
    get_fw_plans_by_user([], 1);
    $res = makequery("SELECT rid, name FROM recipes ORDER BY rid ASC");
    $recipes = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $recipes[$row["rid"]] = $row;
    }
    $resid = makequery("SELECT * FROM ippool WHERE uid = 0");
    $ippools = [];
    for ($i = 0; $i < vsql_num_rows($resid); $i++) {
        $row = vsql_fetch_assoc($resid);
        $ippools[$row["ippid"]] = $row;
    }
    $supported_nics = $kernel->features("nic", $virt);
    $tmp_bus_driver_list = $kernel->features("bus_driver_list", $virt);
    $bus_driver_list = empty($tmp_bus_driver_list) ? [] : $tmp_bus_driver_list;
    $bios = $kernel->features("bios", $virt);
    if(isset($_POST["addplan"])) {
        $plan_type = POST("cplan", $l["noplantype"]);
        $cpu_cores = (int) POST("cpu_cores", $l["no_cpu_cores"]);
        $topology_sockets = 0;
        $topology_cores = 0;
        $topology_threads = 0;
        if($plan_type == "openvz") {
            $burst_ram = (int) POST("burst_ram", $l["no_burst_ram"]);
            $percent_cpu = (int) POST("percent_cpu", $l["no_percent_cpu"]);
            $io = (int) POST("priority", $l["no_io"]);
            $cpu_units = (int) POST("cpu_units", $l["no_cpu_units"]);
            $swapram = 0;
        } elseif($plan_type == "xen" || $plan_type == "kvm" || $plan_type == "xcp" || $plan_type == "xcphvm" || $plan_type == "xenhvm" || $plan_type == "proxk") {
            $burst_ram = 0;
            $percent_cpu = (int) optPOST("percent_cpu");
            $io = 0;
            $swapram = (int) POST("swapram", $l["no_swap_ram"]);
            if($kernel->features("cpu_topology", $virt)) {
                $cpu_units = (int) optPOST("cpu_units");
                $topology_sockets = (int) optPOST("topology_sockets");
                $topology_cores = (int) optPOST("topology_cores");
                $topology_threads = (int) optPOST("topology_threads");
                if(!empty($topology_sockets) || !empty($topology_cores) || !empty($topology_threads)) {
                    if(!$kernel->features("cpu_threads", $virt)) {
                        $topology_threads = 1;
                    }
                    if(empty($topology_sockets) || empty($topology_cores) || empty($topology_threads)) {
                        $error[] = $l["inv_topology"];
                        return false;
                    }
                    $vcpus = $topology_sockets * $topology_cores * $topology_threads;
                    if($cpu_cores != $vcpus) {
                        $error[] = $l["err_topology_calc"];
                        return false;
                    }
                }
            } else {
                $cpu_units = (int) POST("cpu_units", $l["no_cpu_units"]);
            }
            if($plan_type != "xen" && $plan_type != "xcp") {
                $acpi = checkbox("acpi") ? 1 : 0;
                $apic = checkbox("apic") ? 1 : 0;
                $pae = checkbox("pae") ? 1 : 0;
            }
        } elseif($plan_type == "lxc") {
            $burst_ram = 0;
            $cpu_units = (int) POST("cpu_units", $l["no_cpu_units"]);
            $io = 0;
            $swapram = (int) POST("swapram", $l["no_swap_ram"]);
        } elseif($plan_type == "proxo") {
            $swapram = (int) POST("swapram", $l["no_swap_ram"]);
            $cpu_units = (int) POST("cpu_units", $l["no_cpu_units"]);
            $percent_cpu = (int) POST("percent_cpu", $l["no_percent_cpu"]);
            $burst_ram = 0;
            $io = 0;
        } elseif($plan_type == "proxl") {
            $swapram = (int) optPOST("swapram");
            $cpu_units = (int) POST("cpu_units", $l["no_cpu_units"]);
            $percent_cpu = (int) POST("percent_cpu", $l["no_percent_cpu"]);
        } elseif($plan_type == "vzo" || $plan_type == "vzk") {
            $io = (int) POST("priority", $l["no_io"]);
            $percent_cpu = (int) optPOST("percent_cpu");
            $cpu_units = (int) POST("cpu_units", $l["no_cpu_units"]);
            $swapram = (int) POST("swapram", $l["no_swap_ram"]);
        }
        if($kernel->features("bus_driver_list", $plan_type)) {
            $bus_driver = optPOST("bus_driver");
            $bus_driver_num = (int) optPOST("bus_driver_num");
            if($bus_driver == "ide" && ($bus_driver_num < 2 || 3 < $bus_driver_num)) {
                $error[] = $l["ide_bus_num_err"];
            }
            if(!array_key_exists($bus_driver, $bus_driver_list)) {
                $error[] = $bus_driver . $l["inv_bus_driver"];
            }
        }
        $plan_name = POST("plan_name", $l["no_name"]);
        $disk_space = (int) POST("disk_space", $l["no_disk_space"]);
        $guaranteed_ram = (int) POST("guaranteed_ram", $l["no_ram"]);
        $bandwidth = (int) POST("bandwidth", $l["no_bandwidth"]);
        $ips = (int) optPOST("ips");
        $ips6 = (int) optPOST("ips6");
        $ips6_subnet = (int) optPOST("ips6_subnet");
        $ips_int = (int) optPOST("ips_int");
        $network_speed = (int) optPOST("network_speed");
        $nic_type = optPOST("nic_type");
        $virtio = (int) optPOST("virtio");
        $ploop = checkbox("ploop") ? 1 : 0;
        $numa = checkbox("numa") ? 1 : 0;
        $band_suspend = checkbox("band_suspend") ? 1 : 0;
        $upload_speed = (int) optPOST("upload_speed");
        $speed_cap_down = (int) optPOST("speed_cap_down");
        $speed_cap_up = (int) optPOST("speed_cap_up");
        $tuntap = checkbox("tuntap") ? 1 : 0;
        $ppp = checkbox("ppp") ? 1 : 0;
        $rdp = checkbox("rdp") ? 1 : 0;
        $ubcsetting = checkbox("ubcsettings") ? 1 : 0;
        $control_panel = optPOST("control_panel");
        $cpu_mode = optPOST("cpu_mode");
        $sec_iso = optPOST("sec_iso");
        $iso = optPOST("iso");
        $osreinstall_limit = (int) optPOST("osreinstall_limit");
        $osid = (int) optPOST("osid");
        $kvm_vga = checkbox("kvm_vga") ? 1 : 0;
        $acceleration = checkbox("acceleration") ? 1 : 0;
        $vnc = checkbox("vnc") ? 1 : 0;
        $vif_type = "";
        $pv_on_hvm = 0;
        $admin_managed = checkbox("admin_managed") ? 1 : 0;
        $bpid = (int) optPOST("bpid");
        $fwid = (int) optPOST("fwid");
        $vps_data = ["os_type", "rtc", "unprivileged", "nested_virt", "vga_vram", "ha", "discard", "vlan_tag", "disable_guest_agent", "ssd_emulation", "custom_cpu_model", "machine_type", "disable_password", "bios", "enable_tpm", "min_ram", "scsi_controller", "cpu_flags", "enable_cpu_threshold", "cpu_threshold", "cpu_threshold_time", "demo"];
        if(check_licensepro()) {
            $vps_data = array_merge($vps_data, ["enable_ver_scaling", "ver_max_ram", "ver_ram_threshold", "ver_ram_inc_by", "ver_max_cpu", "ver_cpu_threshold", "ver_cpu_inc_by"]);
        }
        foreach ($vps_data as $vk => $vv) {
            $newplan[$vv] = 0;
        }
        $newplan["dont_add_ptr"] = checkbox("dont_add_ptr") ? 1 : 0;
        if($kernel->features("balloon", $virt)) {
            $min_ram = (int) optPOST("min_ram");
            if(!empty($min_ram)) {
                if($guaranteed_ram < $min_ram) {
                    $error[] = $l["min_ram_error"];
                    return false;
                }
                $newplan["min_ram"] = $min_ram;
            }
        }
        if($kernel->features("cpu_flags", $plan_type)) {
            $cpus = prox_cpu_flags($cpu_mode);
            $cpu_flags = [];
            foreach ($cpus["cpu_flags"] as $f) {
                $cpu_flags = array_merge($cpu_flags, [$f => optREQ($f)]);
            }
            $newplan["cpu_flags"] = $cpu_flags;
        }
        if($kernel->features("os_type", $virt)) {
            $newplan["os_type"] = optPOST("os_type");
            if(empty($newplan["os_type"])) {
                $newplan["os_type"] = "other";
            }
        }
        if($kernel->features("rtc", $virt)) {
            $newplan["rtc"] = (int) optPOST("rtc");
        }
        if($kernel->features("cpu_mode", $virt)) {
            $newplan["custom_cpu_model"] = optPOST("custom_cpu_model");
        }
        if($kernel->features("machine_type", $virt)) {
            $newplan["machine_type"] = optPOST("machine_type");
        }
        if($kernel->features("scsihw", $virt)) {
            $newplan["scsi_controller"] = optPOST("scsi_controller");
        }
        if($kernel->features("vga_vram", $virt)) {
            $newplan["vga_vram"] = (int) optPOST("vga_vram");
        }
        if($kernel->features("nested_virt", $virt)) {
            $newplan["nested_virt"] = (int) optPOST("nested_virt");
        }
        if($kernel->features("unprivileged", $virt)) {
            $newplan["unprivileged"] = (int) optPOST("unprivileged");
        }
        if($kernel->features("ha", $virt)) {
            $newplan["ha"] = checkbox("ha") ? 1 : 0;
        }
        if($kernel->features("discard", $virt)) {
            $newplan["discard"] = (int) optPOST("discard");
        }
        if($kernel->features("vlan_tag", $virt)) {
            $newplan["vlan_tag"] = (int) optPOST("vlan_tag");
        }
        if(!empty($newplan["vlan_tag"]) && ($newplan["vlan_tag"] < 0 || 4094 < $newplan["vlan_tag"])) {
            $error[] = $l["vlan_tag_err"];
            return false;
        }
        if($kernel->features("ssd_emulation", $virt) && $bus_driver != "virtio") {
            $newplan["ssd_emulation"] = (int) optPOST("ssd_emulation");
        }
        if(!empty($bios)) {
            $newplan["bios"] = optPOST("bios");
        }
        if(preg_match("/uefi/is", $newplan["bios"])) {
            $newplan["enable_tpm"] = optREQ("enable_tpm");
        }
        $enable_ver_scaling = (int) optPOST("enable_ver_scaling");
        if(check_licensepro() && $kernel->features("vertical_scaling", $virt) && !empty($enable_ver_scaling)) {
            $arr = ["ver_max_ram", "ver_ram_threshold", "ver_ram_inc_by", "ver_max_cpu", "ver_cpu_threshold", "ver_cpu_inc_by"];
            foreach ($arr as $v) {
                $newplan[$v] = (int) POST($v, $l[$v . "_err"], 0);
            }
            $newplan["enable_ver_scaling"] = $enable_ver_scaling;
        }
        $load_balancer = 0;
        if($kernel->features("load_balancer", $virt)) {
            $load_balancer = (int) optPOST("load_balancer");
            if(!empty($load_balancer)) {
                $admin_managed = 1;
                if(!empty($iso)) {
                    $error[] = $l["iso_load_balancer"];
                    return false;
                }
                if(empty($osid)) {
                    $error[] = $l["lb_no_osid"];
                    return false;
                }
                if(!empty($bandwidth)) {
                    $error[] = $l["lb_must_have_unlimited_bw"];
                    return false;
                }
                $check_os = check_os_load_balancer($ostemplates[$osid]["name"]);
                if(empty($check_os)) {
                    $error[] = $l["lb_os_not_supported"];
                    return false;
                }
            }
        }
        if(!empty($_POST["recipe"])) {
            $recipe = $_POST["recipe"];
            if(is_array($recipe)) {
                foreach ($recipe as $rk => $rv) {
                    $recipe[$rk] = (int) $rv;
                }
                $recipe = serialize($recipe);
            } else {
                $recipe = (int) $recipe;
            }
        }
        $disable_nw_config = checkbox("disable_nw_config") ? 1 : 0;
        $tmp_openvz_features["fuse"] = (int) optREQ("fuse");
        $tmp_openvz_features["ipip"] = (int) optREQ("ipip");
        $tmp_openvz_features["ipgre"] = (int) optREQ("ipgre");
        $tmp_openvz_features["nfs"] = (int) optREQ("nfs");
        $tmp_openvz_features["quotaugidlimit"] = (int) optREQ("quotaugidlimit");
        $tmp_openvz_features["iolimit"] = (int) optREQ("iolimit");
        $tmp_openvz_features["iopslimit"] = (int) optREQ("iopslimit");
        $openvz_features = serialize($tmp_openvz_features);
        $install_xentools = (int) optREQ("install_xentools");
        $ippoolid = $_POST["ippoolid"];
        $premium_apps_plan = 0;
        if(!empty($globals["premium_apps"])) {
            $premium_apps_plan = checkbox("premium_apps_plan") ? 1 : 0;
        }
        if(!empty($globals["inhouse_billing"])) {
            $sgrates = [];
            foreach (["h_rate", "m_rate", "y_rate"] as $k => $v) {
                if(!empty($_POST[$v])) {
                    foreach ($_POST[$v] as $kk => $vv) {
                        $vv = trim($vv);
                        if(empty($servergroups[$kk]) && $kk != -1) {
                        } elseif(preg_match("/^\\d+\\.{0,1}\\d*\$/", $vv)) {
                            $sgrates[$kk][$v] = (double) $vv;
                        } else {
                            $error[] = lang_vars_name($l["inv_val_for"], ["region" => $kk != -1 ? $servergroups[$kk]["sg_name"] : $l["all_reg"], "field" => $l[$v]]) . $vv;
                        }
                    }
                }
            }
        }
        if(preg_match("/hvm/is", $plan_type)) {
            $hvm = 1;
        }
        if($plan_type == "xenhvm") {
            $shadow = (int) POST("shadow", $l["no_shadow"]);
            $pv_on_hvm = checkbox("pv_on_hvm") ? 1 : 0;
            if(empty($pv_on_hvm)) {
                $vif_type = optPOST("vif_type");
            }
        }
        if(!isset($upload_speed) || strlen($upload_speed) < 1) {
            $upload_speed = -1;
        }
        $speed_cap = "";
        if(empty($band_suspend) && (!empty($speed_cap_down) || !empty($speed_cap_up))) {
            validate_speed_cap($speed_cap_down, $speed_cap_up, $network_speed, $upload_speed);
            $speed_cap = ["down" => $speed_cap_down, "up" => $speed_cap_up, "reason" => "", "bw" => 0];
        }
        if(!empty($error)) {
            return false;
        }
        if(isset($_POST["mgs"])) {
            $_POST["mgs"] = is_array($_POST["mgs"]) ? $_POST["mgs"] : [$_POST["mgs"]];
            foreach ($_POST["mgs"] as $k => $v) {
                $v = (int) $v;
                if(empty($mgs[$v]) || $mgs[$v]["mg_type"] != $plan_type) {
                } else {
                    $_mgs[$v] = $v;
                }
            }
        }
        $qres = makequery("SELECT plan_name \n\t\t\t\t\t\tFROM plans \n\t\t\t\t\t\tWHERE plan_name=:plan_name", [":plan_name" => $plan_name]);
        $row = vsql_num_rows($qres);
        if(0 < $row) {
            $error[] = $l["plannameexist"];
            return false;
        }
        $dns = $_POST["dns"];
        $_dns = [];
        if(!empty($dns[0])) {
            foreach ($dns as $key => $value) {
                if(!empty($value) && (valid_ip($value) || valid_ipv6($value))) {
                    $_dns[] = $value;
                }
            }
        }
        $vnc_keymap = optPOST("vnc_keymap");
        if(!empty($vnc_keymap) && !in_array($vnc_keymap, ["en-us", "de-ch", "ar", "da", "et", "fo", "fr-be", "fr-ch", "hu", "it", "lt", "mk", "nl", "no", "pt", "ru", "sv", "tr", "de", "en-gb", "es", "fi", "fr", "fr-ca", "hr", "is", "ja", "lv", "nl-be", "pl", "pt-br", "sl", "th"])) {
            $error[] = $l["inv_vnc_keymap"];
        }
        $ubc = [];
        if(!empty($ubcsetting)) {
            foreach ($_ubc as $k) {
                if(strlen($_POST["b" . $k]) || strlen($_POST["l" . $k])) {
                    $bar = POST("b" . $k, $l["no_b" . $k]);
                    $lim = POST("l" . $k, $l["no_l" . $k]);
                    $ubc[$k][0] = !is_numeric($bar) ? "unlimited" : $bar;
                    $ubc[$k][1] = !is_numeric($lim) ? "unlimited" : $lim;
                }
            }
        }
        $kvm_cache = optPOST("kvm_cache");
        $io_mode = optPOST("io_mode");
        $total_iops_sec = (int) optPOST("total_iops_sec");
        $read_bytes_sec = (int) optPOST("read_bytes_sec");
        $write_bytes_sec = (int) optPOST("write_bytes_sec");
        if(!empty($error)) {
            return false;
        }
        $serializedubc = serialize($ubc);
        $disable_password = optPOST("disable_password");
        if(!empty($disable_password)) {
            $newplan["disable_password"] = 1;
        }
        $newplan["enable_cpu_threshold"] = (int) optPOST("enable_cpu_threshold");
        if(!empty($newplan["enable_cpu_threshold"])) {
            $newplan["cpu_threshold"] = (int) optPOST("cpu_threshold");
            $newplan["cpu_threshold_time"] = (int) optPOST("cpu_threshold_time");
            $cputhreshold = $newplan["cpu_threshold"];
            if(100 < $cputhreshold || empty($cputhreshold)) {
                $error[] = $l["percent_err_threshold"];
            }
            if($newplan["cpu_threshold_time"] % 5 !== 0 || empty($newplan["cpu_threshold_time"])) {
                $error[] = $l["time_err_threshold"];
            }
        }
        $demo_check = (int) optREQ("enable_demo");
        if($demo_check == 1) {
            $demo = [];
            $demo_duration = (int) POST("demo_duration", $l["no_duration_days"]);
            $demo_action = (int) optPOST("demo_action", 0);
            if($demo_duration < 1) {
                $error[] = $l["invalid_duration"];
            }
            if($demo_action != 0 && $demo_action != 1) {
                $error[] = $l["invalid_option_demo"];
            }
            $demo["duration_days"] = $demo_duration;
            $demo["action"] = $demo_action;
            $newplan["demo"] = $demo;
        }
        if(!empty($error)) {
            return false;
        }
        $data_set = [];
        foreach ($vps_data as $vk => $vv) {
            $data_set[$vv] = $newplan[$vv];
        }
        $data_encode = json_encode($data_set);
        unset($data_set);
        $plid = insert_and_id("INSERT INTO plans SET \n\t\t\t\t\t\t\tplan_name = :plan_name,\n\t\t\t\t\t\t\tvirt = :virt,\n\t\t\t\t\t\t\tips = :ips,\n\t\t\t\t\t\t\tips6 = :ips6,\n\t\t\t\t\t\t\tips6_subnet = :ips6_subnet,\n\t\t\t\t\t\t\tips_int = :ips_int,\n\t\t\t\t\t\t\tspace = :space,\n\t\t\t\t\t\t\tram = :ram,\n\t\t\t\t\t\t\tburst = :burst,\n\t\t\t\t\t\t\tswap = :swap,\n\t\t\t\t\t\t\tcpu = :cpu,\n\t\t\t\t\t\t\tcores = :cores,\n\t\t\t\t\t\t\tcpu_percent = :cpu_percent,\n\t\t\t\t\t\t\tbandwidth = :bandwidth,\n\t\t\t\t\t\t\tnetwork_speed = :network_speed,\n\t\t\t\t\t\t\tnic_type = :nic_type,\n\t\t\t\t\t\t\tvirtio = :virtio,\n\t\t\t\t\t\t\tio = :io,\n\t\t\t\t\t\t\tdns_nameserver = :dns_nameserver,\n\t\t\t\t\t\t\tploop = :ploop,\n\t\t\t\t\t\t\tband_suspend = :band_suspend,\n\t\t\t\t\t\t\tupload_speed = :upload_speed,\n\t\t\t\t\t\t\ttuntap = :tuntap,\n\t\t\t\t\t\t\tppp = :ppp,\n\t\t\t\t\t\t\tcontrol_panel = :control_panel,\n\t\t\t\t\t\t\tmgs = :mgs,\n\t\t\t\t\t\t\tcpu_mode = :cpu_mode,\n\t\t\t\t\t\t\tsec_iso = :sec_iso,\n\t\t\t\t\t\t\tiso = :iso,\n\t\t\t\t\t\t\thvm = :hvm,\n\t\t\t\t\t\t\tkvm_cache = :kvm_cache,\n\t\t\t\t\t\t\tio_mode = :io_mode,\n\t\t\t\t\t\t\tosreinstall_limit = :osreinstall_limit,\n\t\t\t\t\t\t\ttotal_iops_sec = :total_iops_sec,\n\t\t\t\t\t\t\tread_bytes_sec = :read_bytes_sec,\n\t\t\t\t\t\t\twrite_bytes_sec = :write_bytes_sec,\n\t\t\t\t\t\t\tvnc_keymap = :vnc_keymap,\n\t\t\t\t\t\t\tosid = :osid,\n\t\t\t\t\t\t\tubc = :ubc,\n\t\t\t\t\t\t\tkvm_vga = :kvm_vga,\n\t\t\t\t\t\t\tacceleration = :acceleration,\n\t\t\t\t\t\t\tvif_type = :vif_type,\n\t\t\t\t\t\t\tpv_on_hvm = :pv_on_hvm,\n\t\t\t\t\t\t\tvnc = :vnc,\n\t\t\t\t\t\t\tadmin_managed = :admin_managed,\n\t\t\t\t\t\t\tshadow = :shadow,\n\t\t\t\t\t\t\tnuma = :numa,\n\t\t\t\t\t\t\tacpi = :acpi,\n\t\t\t\t\t\t\tapic = :apic,\n\t\t\t\t\t\t\tpae = :pae,\n\t\t\t\t\t\t\trecipe = :recipe,\n\t\t\t\t\t\t\trdp = :rdp,\n\t\t\t\t\t\t\tdisable_nw_config = :disable_nw_config,\n\t\t\t\t\t\t\ttopology_sockets = :topology_sockets,\n\t\t\t\t\t\t\ttopology_cores = :topology_cores,\n\t\t\t\t\t\t\ttopology_threads = :topology_threads,\n\t\t\t\t\t\t\topenvz_features = :openvz_features,\n\t\t\t\t\t\t\tspeed_cap = :speed_cap,\n\t\t\t\t\t\t\tinstall_xentools = :install_xentools,\n\t\t\t\t\t\t\tbpid = :bpid,\n\t\t\t\t\t\t\tippoolid = :ippoolid,\n\t\t\t\t\t\t\tbus_driver = :bus_driver,\n\t\t\t\t\t\t\tbus_driver_num = :bus_driver_num,\n\t\t\t\t\t\t\twebuzo_data = :webuzo_data,\n\t\t\t\t\t\t\tload_balancer = :load_balancer,\n\t\t\t\t\t\t\tfwid = :fwid,\n\t\t\t\t\t\t\tdata =:data", [":plan_name" => $plan_name, ":virt" => $plan_type, ":ips" => $ips, ":ips6" => $ips6, ":ips6_subnet" => $ips6_subnet, ":ips_int" => $ips_int, ":space" => $disk_space, ":ram" => $guaranteed_ram, ":burst" => $burst_ram, ":swap" => $swapram, ":cpu" => $cpu_units, ":cores" => $cpu_cores, ":cpu_percent" => $percent_cpu, ":bandwidth" => $bandwidth, ":network_speed" => $network_speed, ":nic_type" => $nic_type, ":virtio" => $virtio, ":io" => $io, ":ploop" => $ploop, ":band_suspend" => $band_suspend, ":dns_nameserver" => serialize($_dns), ":upload_speed" => $upload_speed, ":tuntap" => $tuntap, ":ppp" => $ppp, ":control_panel" => $control_panel, ":mgs" => implode(",", $_mgs), ":cpu_mode" => $cpu_mode, ":sec_iso" => $sec_iso, ":iso" => $iso, ":hvm" => $hvm, ":kvm_cache" => $kvm_cache, ":io_mode" => $io_mode, ":osreinstall_limit" => $osreinstall_limit, ":total_iops_sec" => $total_iops_sec, ":read_bytes_sec" => $read_bytes_sec, ":write_bytes_sec" => $write_bytes_sec, ":vnc_keymap" => $vnc_keymap, ":osid" => $osid, ":ubc" => $serializedubc, ":kvm_vga" => $kvm_vga, ":acceleration" => $acceleration, ":vif_type" => $vif_type, ":pv_on_hvm" => $pv_on_hvm, ":vnc" => $vnc, ":admin_managed" => $admin_managed, ":shadow" => $shadow, ":numa" => $numa, ":acpi" => $acpi, ":apic" => $apic, ":pae" => $pae, ":recipe" => $recipe, ":rdp" => $rdp, ":disable_nw_config" => $disable_nw_config, ":topology_sockets" => $topology_sockets, ":topology_cores" => $topology_cores, ":topology_threads" => $topology_threads, ":openvz_features" => $openvz_features, ":speed_cap" => !empty($speed_cap) ? serialize($speed_cap) : "", ":install_xentools" => $install_xentools, ":bpid" => $bpid, ":ippoolid" => !empty($ippoolid) ? serialize($ippoolid) : "", ":bus_driver" => $bus_driver, ":bus_driver_num" => $bus_driver_num, ":webuzo_data" => $premium_apps_plan, ":load_balancer" => $load_balancer, ":fwid" => $fwid, ":data" => $data_encode]);
        if(!empty($globals["inhouse_billing"]) && !empty($sgrates)) {
            $query = "INSERT INTO `pricing`(`plid`, `sgid`, `h_rate`, `m_rate`, `y_rate`) VALUES ";
            foreach ($sgrates as $k => $v) {
                $query .= "(\"" . (int) $plid . "\", \"" . (int) $k . "\", \"" . (double) $sgrates[$k]["h_rate"] . "\", \"" . (double) $sgrates[$k]["m_rate"] . "\", \"" . (double) $sgrates[$k]["y_rate"] . "\"),";
            }
            $query = rtrim($query, ",");
            $res = makequery($query);
            if(!$res) {
                $error[] = $l["err_save_reg_price"];
                return false;
            }
        }
        logs_admin("addplan", $plan_name, 1, $plid, $user["uid"]);
        $done = $plid;
    }
}
function API_addplan()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $done;
    global $plans;
    global $servergroups;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["servergroups"] = $servergroups;
}

?>