<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
class cluster_kernel
{
    public $loaded = 0;
    public $status = [];
    public $type = "openvz";
    public $user = [];
    public $calls = [];
    public function __construct()
    {
        global $user;
        global $servers;
        global $globals;
        global $cluster;
        if(empty($servers)) {
            if(!class_exists("cluster")) {
                include_once $globals["adminfiles"] . "/cluster.php";
            }
            $cluster = new cluster();
            list_servers();
        }
        $_vps = empty($user["vps"]) ? getvps($globals["vpsid"]) : $user["vps"];
        if(empty($_vps)) {
            $_vps = [];
        }
        if(array_key_exists("virt", $_vps)) {
            $this->type = $_vps["virt"];
        }
    }
    public function conf($vpsid, $conf_name)
    {
        global $user;
        global $servers;
        global $globals;
        global $cluster;
        if(!in_array(vps_virt_text($vpsid), ["openvz", "lxc", "proxl", "proxo"]) && in_array($conf_name, ["onboot_cp"])) {
            return true;
        }
        if(!in_array(vps_virt_text($vpsid), ["openvz", "proxo", "vzo"]) && in_array($conf_name, ["onboot_changepass", "onboot_hostname", "onboot_recipe"])) {
            return true;
        }
        return false;
    }
    public function new_vps_name()
    {
    }
    public function getconf($vid)
    {
    }
    public function getname($vid)
    {
        global $user;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            return $user["vps"]["vps_name"];
        }
        if($vps = getvps($vid)) {
            return $vps["vps_name"];
        }
        return false;
    }
    public function stop($vid)
    {
        global $cluster;
        global $user;
        global $l;
        if(is_master()) {
            $actid = vps_task("stop_vps", "", 0, $vid, $user["uid"], 0, $l["task_started"]);
            task_start($actid);
        }
        $details = $this->call($vid, "index.php?act=apidoings&do=e_stop");
        if(!empty($details)) {
            if(is_master()) {
                task_update($actid, $l["completed"], 100);
            }
            return $details["result"]["output"];
        }
        if(is_master()) {
            task_update($actid, $l["completed"], 100);
        }
        return false;
    }
    public function start($vid)
    {
        global $cluster;
        global $user;
        global $l;
        if(is_master()) {
            $actid = vps_task("start_vps", "", 0, $vid, $user["uid"], 0, $l["task_started"]);
            task_start($actid);
        }
        $details = $this->call($vid, "index.php?act=apidoings&do=e_start");
        $vps = getvps($vid);
        $ret = $cluster->reverse_sync($vps["serid"]);
        if(!empty($details)) {
            if(is_master()) {
                $ret_code = $details["startvps_ret"];
                $_log = empty($details["result"]) ? "Return code : " . $ret_code : $details["result"]["output"];
                $status = 100;
                if($ret_code != 0) {
                    $status = -1;
                }
                task_update($actid, $_log, $status);
            }
            return $details["result"]["output"];
        }
        if(is_master()) {
            task_update($actid, "There was no response ! The cURL call failed", -1);
        }
        return false;
    }
    public function restart($vid)
    {
        global $cluster;
        global $user;
        global $l;
        if(is_master()) {
            $actid = vps_task("restart_vps", "", 0, $vid, $user["uid"], 0, $l["task_started"]);
            task_start($actid);
        }
        $details = $this->call($vid, "index.php?act=apidoings&do=e_restart");
        if(!empty($details)) {
            if(is_master()) {
                task_update($actid, $l["completed"], 100);
            }
            return $details["result"]["output"];
        }
        if(is_master()) {
            task_update($actid, $l["completed"], 100);
        }
        return false;
    }
    public function poweroff($vid)
    {
        global $cluster;
        global $user;
        global $l;
        if(is_master()) {
            $actid = vps_task("poweroff_vps", "", 0, $vid, $user["uid"], 0, $l["task_started"]);
            task_start($actid);
        }
        $details = $this->call($vid, "index.php?act=apidoings&do=e_poweroff");
        if(!empty($details)) {
            if(is_master()) {
                task_update($actid, $l["completed"], 100);
            }
            return $details["result"]["output"];
        }
        if(is_master()) {
            task_update($actid, $l["completed"], 100);
        }
        return false;
    }
    public function changehostname($vid, $host)
    {
        global $cluster;
        $post = [];
        $post["newhost"] = $host;
        $post["changehost"] = "Change Hostname";
        $details = $this->call($vid, "index.php?act=apidoings&do=e_changehostname", 1, $post);
        $vps = getvps($vid);
        $ret = $cluster->reverse_sync($vps["serid"]);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function editvps($vid)
    {
        global $cluster;
        $vps = getvps($vid);
        if(!empty($vps["serid"])) {
            $sres = $cluster->sync($vps["serid"]);
            if(empty($sres)) {
                return false;
            }
        }
        $details = $this->call($vid, "index.php?act=apidoings&do=e_editvps", 1);
        $ret = $cluster->reverse_sync($vps["serid"]);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function createvps($vid, $create = 1)
    {
    }
    public function destroyvps($vid)
    {
    }
    public function osreinstall($vid, $format_primary)
    {
        global $cluster;
        $vps = getvps($vid);
        $post = [];
        $post["format_primary"] = (int) $format_primary;
        if(!empty($vps["serid"])) {
            $sres = $cluster->sync($vps["serid"]);
            if(empty($sres)) {
                return false;
            }
        }
        @set_time_limit(3600);
        $details = $this->call($vid, "index.php?act=apidoings&do=e_osreinstall", 1, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function changepassword($vid, $newpassword, $vm_admin_name = "")
    {
        global $cluster;
        $post = [];
        $post["newpass"] = $newpassword;
        $post["conf"] = $newpassword;
        $post["vm_admin_name"] = $vm_admin_name;
        $post["changepass"] = "Change Password";
        $details = $this->call($vid, "index.php?act=apidoings&do=e_changepassword", 1, $post);
        $vps = getvps($vid);
        $ret = $cluster->reverse_sync($vps["serid"]);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function filelist($vid, $dir = "", $searchSubdirs = 1, $directoriesonly = 0, $maxlevel = "all", $level = 1)
    {
        $ret = [];
        $details = $this->call($vid, "index.php?act=apidoings&do=e_filemanager&path=" . $dir);
        if(!empty($details)) {
            $ret = $details["files"];
        }
        return $ret;
    }
    public function processes($vid)
    {
        $ret = [];
        $details = $this->call($vid, "index.php?act=apidoings&do=e_processes");
        if(!empty($details["result"])) {
            $ret = $details["result"];
        }
        return $ret;
    }
    public function os($vid)
    {
        $details = $this->call($vid, "index.php?act=apidoings&do=e_os");
        if(empty($details["info"]["os"])) {
            $osinfo["distro"] = "others";
            $osinfo["name"] = "others-ver-platform";
        } else {
            $osinfo = $details["info"]["os"];
        }
        return $osinfo;
    }
    public function hostname($vid)
    {
        if($this->status($vid) == 0) {
            $vps = getvps($vid);
            return $vps["hostname"];
        }
        $details = $this->call($vid, "index.php?act=apidoings&do=e_hostname");
        if(!empty($details["info"]["hostname"])) {
            return $details["info"]["hostname"];
        }
        return false;
    }
    public function listips($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $ips = [];
        if(empty($vid)) {
            return $ips;
        }
        $res = makequery("SELECT i.ip, i.ipr_netmask, i.ipv6 FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\t\tORDER BY `primary` DESC", [":vpsid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(in_array($row["ip"], $ips)) {
            } else {
                $ips[] = $row["ip"] . (!empty($row["ipr_netmask"]) && !empty($row["ipv6"]) ? "/" . $row["ipr_netmask"] : "");
            }
        }
        return $ips;
    }
    public function vps_usage($vid)
    {
        $ret = [];
        $details = $this->call($vid, "index.php?act=apidoings&do=e_vps_usage");
        if(empty($details)) {
            return $ret;
        }
        $ret["cpu"] = $this->cpu($vid, ["usage" => ["cpu" => $details["usage"]["cpu"]]]);
        $ret["ram"] = $this->ram($vid, ["usage" => ["ram" => $details["usage"]["ram"]]]);
        $ret["disk"] = $this->disk($vid, ["usage" => ["disk" => $details["usage"]["disk"]]]);
        $ret["inodes"] = $this->inodes($vid, ["usage" => ["inodes" => $details["usage"]["inodes"]]]);
        $ret["netspeed"] = $this->network_speed($vid, ["network_speed" => $details["usage"]["network_speed"]]);
        return $ret;
    }
    public function cpu($vid, $details = [])
    {
        global $user;
        $ret = [];
        $ret["manu"] = "unknown";
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(empty($details)) {
            $details = $this->call($vid, "index.php?act=apidoings&do=e_cpu");
        }
        if(!empty($details)) {
            $ret["manu"] = $details["usage"]["cpu"]["manu"];
            $ret["limit"] = $details["usage"]["cpu"]["limit"];
            $ret["used"] = $details["usage"]["cpu"]["used"];
        }
        $ret["free"] = isset($details["usage"]["cpu"]["free"]) ? $details["usage"]["cpu"]["free"] : 0;
        $ret["percent"] = isset($details["usage"]["cpu"]["percent"]) ? $details["usage"]["cpu"]["percent"] : 0;
        $ret["percent_free"] = isset($details["usage"]["cpu"]["percent_free"]) ? $details["usage"]["cpu"]["percent_free"] : 0;
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function ram($vid, $details = [])
    {
        global $user;
        $ret = [];
        $ret["used"] = 0;
        $ret["limit"] = 0;
        $ret["guaranteed"] = 0;
        if(vps_virt($vid, 1)) {
            $ret["burst"] = 0;
        } else {
            $ret["swap"] = 0;
        }
        if(empty($details)) {
            $details = $this->call($vid, "index.php?act=apidoings&do=e_ram");
        }
        if(!empty($details)) {
            $ret["used"] = $details["usage"]["ram"]["used"];
            $ret["limit"] = $details["usage"]["ram"]["limit"];
            $ret["guaranteed"] = $details["usage"]["ram"]["guaranteed"];
            if(vps_virt($vid, 1)) {
                $ret["burst"] = $details["usage"]["ram"]["burst"];
            } else {
                $ret["swap"] = $details["usage"]["ram"]["swap"];
            }
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function disk($vid, $details = [])
    {
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        $ret["limit_gb"] = 0;
        $ret["used_gb"] = 0;
        if(empty($details)) {
            $details = $this->call($vid, "index.php?act=apidoings&do=e_disk");
        }
        if(!empty($details)) {
            $ret["limit"] = $details["usage"]["disk"]["limit"];
            $ret["used"] = $details["usage"]["disk"]["used"];
            $ret["limit_gb"] = $details["usage"]["disk"]["limit_gb"];
            $ret["used_gb"] = $details["usage"]["disk"]["used_gb"];
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["free_gb"] = $ret["limit_gb"] - $ret["used_gb"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function inodes($vid, $details = [])
    {
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(empty($details)) {
            $details = $this->call($vid, "index.php?act=apidoings&do=e_inodes");
        }
        if(!empty($details)) {
            $ret["limit"] = $details["usage"]["inodes"]["limit"];
            $ret["used"] = $details["usage"]["inodes"]["used"];
            if(vps_virt($vid, 1)) {
                $ret["act_limit"] = $details["usage"]["inodes"]["act_limit"];
            }
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function network_speed($vid, $details = [])
    {
        $ret["speed"] = 0;
        $ret["upload"] = 0;
        $ret["download"] = 0;
        if(empty($details)) {
            $details = $this->call($vid, "index.php?act=apidoings&do=e_network_speed");
        }
        if(!empty($details)) {
            $ret["speed"] = (int) $details["network_speed"]["speed"];
            $ret["upload"] = (int) $details["network_speed"]["upload"];
            $ret["download"] = (int) $details["network_speed"]["download"];
        }
        return $ret;
    }
    public function bandwidth($vid, $show = 0, $custDate = "")
    {
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        $ret["usage"] = [];
        $ret["limit_gb"] = 0;
        $ret["used_gb"] = 0;
        $month["yr"] = datify(time(), 0, 1, "Y");
        $month["month"] = datify(time(), 0, 1, "m");
        if(!empty($show)) {
            $month["yr"] = (int) substr($show, 0, 4);
            $month["month"] = substr($show, 4);
        }
        $tmp = mktime(1, 1, 1, $month["month"], 1, $month["yr"]);
        $month["days"] = date("t", $tmp);
        $start = $month["yr"] . $month["month"] . "01";
        $end = $month["yr"] . $month["month"] . $month["days"];
        $details = $this->call($vid, "index.php?act=apidoings&do=e_bandwidth&show=" . $show . "&custDate=" . $custDate);
        if(!empty($details)) {
            $ret["limit"] = $details["bandwidth"]["limit"];
            $ret["used"] = $details["bandwidth"]["used"];
            $ret["limit_gb"] = $details["bandwidth"]["limit_gb"];
            $ret["used_gb"] = $details["bandwidth"]["used_gb"];
            $ret["usage"] = $details["bandwidth"]["usage"];
            $ret["in"] = $details["bandwidth"]["in"];
            $ret["out"] = $details["bandwidth"]["out"];
            $ret["yr_bandwidth"] = $details["bandwidth"]["yr_bandwidth"];
            $ret["custom_date"] = $details["bandwidth"]["custom_date"];
            $ret["vps_create_month"] = $details["bandwidth"]["vps_create_month"];
        }
        $ret["free"] = empty($ret["limit"]) ? 0 : $ret["limit"] - $ret["used"];
        $ret["free_gb"] = empty($ret["limit"]) ? 0 : $ret["limit_gb"] - $ret["used_gb"];
        $ret["percent"] = $ret["limit"] ? $ret["used"] / $ret["limit"] * 100 : 0;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function vps_status($array, $live = false)
    {
        $post = [];
        $post["vids"] = $array;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_vps_status", $live, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return 0;
    }
    public function vps_status_statewise($array, $live = false)
    {
        $post = [];
        $post["vids"] = $array;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_vps_status_statewise", $live, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return 0;
    }
    public function status($vid, $live = false)
    {
        $details = $this->call($vid, "index.php?act=apidoings&do=e_status", $live);
        if(!empty($details["info"]["status"])) {
            return $details["info"]["status"];
        }
        return 0;
    }
    public function status_statewise($vid, $live = false)
    {
        $details = $this->call($vid, "index.php?act=apidoings&do=e_statuswise", $live);
        if(!empty($details["info"]["statuswise"])) {
            return $details["info"]["statuswise"];
        }
        return 0;
    }
    public function uptime($vid)
    {
        $details = $this->call($vid, "index.php?act=apidoings&do=e_uptime");
        if(!empty($details["info"]["uptime"])) {
            return $details["info"]["uptime"];
        }
        return "";
    }
    public function services($vid)
    {
        $ret = [];
        $details = $this->call($vid, "index.php?act=apidoings&do=e_services");
        if(!empty($details["running"])) {
            $ret = $details["running"];
        }
        return $ret;
    }
    public function listautoservices($vid)
    {
        $ret = [];
        $details = $this->call($vid, "index.php?act=apidoings&do=e_services");
        if(!empty($details["autostart"])) {
            $ret = $details["autostart"];
        }
        return $ret;
    }
    public function startservice($vid, $ser)
    {
        $post = [];
        $post["service"] = $ser;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_dotoservices&action=start", 1, $post);
        if(!empty($details)) {
            return true;
        }
        return false;
    }
    public function restartservice($vid, $ser)
    {
        $post = [];
        $post["service"] = $ser;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_dotoservices&action=restart", 1, $post);
        if(!empty($details)) {
            return true;
        }
        return false;
    }
    public function stopservice($vid, $ser)
    {
        $post = [];
        $post["service"] = $ser;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_dotoservices&action=stop", 1, $post);
        if(!empty($details)) {
            return true;
        }
        return false;
    }
    public function killprocess($vid, $pids)
    {
        $ret = [];
        if(!is_array($pids)) {
            $pids = [$pids];
        }
        $post = [];
        $post["pids"] = $pids;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_killprocess", 1, $post);
        if(!empty($details)) {
            return true;
        }
        return false;
    }
    public function vncDetails($vid)
    {
        $details = $this->call($vid, "index.php?act=apidoings&do=e_vncDetails");
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function changeVncPass($vid, $newpass)
    {
        global $cluster;
        global $kernel;
        $post = [];
        $post["newpass"] = $newpass;
        if($kernel->conf($vid, "vnc_store_pass") && !empty($newpass)) {
            $vps = getvps($vid);
            $res = makequery("UPDATE vps\n\t\t\t\t\tSET vnc_passwd = :vnc_passwd\n\t\t\t\t\tWHERE vpsid = :vpsid", [":vnc_passwd" => $newpass, ":vpsid" => $vid]);
            $cluster->sync($vps["serid"]);
        }
        $details = $this->call($vid, "index.php?act=apidoings&do=e_changeVncPass", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function statuslogs($vid, $page)
    {
        $details = $this->ecall($vid, "index.php?act=statuslogs&page=" . $page);
        if(!empty($details)) {
            return $details;
        }
        return [];
    }
    public function system_alerts($vid, $page)
    {
        $details = $this->ecall($vid, "index.php?act=system_alerts&page=" . $page);
        if(!empty($details)) {
            return $details;
        }
        return [];
    }
    public function install_cp($vid, $cp)
    {
        global $cluster;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_install_cp&cp=" . $cp);
        $vps = getvps($vid);
        $ret = $cluster->reverse_sync($vps["serid"]);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function create_rescue_disk($vid, $password)
    {
        global $cluster;
        $vps = getvps($vid);
        if(!empty($vps["serid"])) {
            $sres = $cluster->sync($vps["serid"]);
            if(empty($sres)) {
                return false;
            }
        }
        $post = [];
        $post["newpass"] = $password;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_create_rescue_disk", 1, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function delete_rescue_disk($vid)
    {
        global $cluster;
        $vps = getvps($vid);
        if(!empty($vps["serid"])) {
            $sres = $cluster->sync($vps["serid"]);
            if(empty($sres)) {
                return false;
            }
        }
        $details = $this->call($vid, "index.php?act=apidoings&do=e_delete_rescue_disk", 1);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function console_session_create($vid, $duration)
    {
        $details = $this->call($vid, "index.php?act=apidoings&do=e_console_session_create&duration=" . $duration, 1);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return [];
    }
    public function console_session_destroy($vid)
    {
        $details = $this->call($vid, "index.php?act=apidoings&do=e_console_session_destroy", 1);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return [];
    }
    public function call($vid, $path, $live = false, $post = [])
    {
        global $servers;
        global $user;
        global $servers_keypass;
        $vps = getvps($vid);
        $serid = $vps["serid"];
        if(empty($serid)) {
            $serid = 0;
        }
        if(empty($servers[$serid])) {
            return false;
        }
        if(!empty($this->calls[$vid][$path]) && empty($live)) {
            return $this->calls[$vid][$path];
        }
        $this->calls[$vid][$path] = E_api_call($servers[$serid]["ip"], $servers_keypass[$serid]["pass"], $vid, $path, $post);
        return $this->calls[$vid][$path];
    }
    public function ecall($vid, $path, $live = false, $post = [])
    {
        global $servers;
        global $user;
        global $servers_keypass;
        if(!empty($user["vps"])) {
            $vps = $user["vps"];
        } else {
            $vps = getvps($vid);
        }
        $serid = $vps["serid"];
        if(empty($servers[$serid])) {
            return false;
        }
        if(!empty($this->calls[$vid][$path]) && empty($live)) {
            return $this->calls[$vid][$path];
        }
        $this->calls[$vid][$path] = e_make_api_call($servers[$serid]["ip"], $servers_keypass[$serid]["pass"], $vps["vpsid"], $path, $post);
        return $this->calls[$vid][$path];
    }
    public function install_recipe($vid, $rid)
    {
        global $cluster;
        $vps = getvps($vid);
        $ips = getvpsips($vid);
        $res = makequery("SELECT email\n\t\t\t\t\t\tFROM users \n\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $vps["uid"]]);
        $row = vsql_fetch_assoc($res);
        $user_email = $row["email"];
        $tmp = get_recipe($rid);
        foreach ($tmp as $k => $v) {
            $tmp[$k]["code"] = lang_vars_name($v["code"], ["username" => $user_email, "vps_hostname" => $vps["hostname"], "ips" => implode(", ", $ips["ips"]), "ips6" => implode(", ", $ips["ips6"]), "ips6_subnet" => implode(", ", $ips["ips6_subnet"]), "vpsid" => $vid]);
        }
        $recipe["recipe"] = base64_encode(serialize($tmp));
        $details = $this->call($vid, "index.php?act=apidoings&do=e_install_recipes&rid=" . $rid, false, $recipe);
        $vps = getvps($vid);
        $ret = $cluster->reverse_sync($vps["serid"]);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function vps_statistics($vid, $from = 0, $to = 0)
    {
        $details = $this->call($vid, "index.php?act=apidoings&do=e_vps_statistics&from=" . $from . "&to=" . $to . "");
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function save_haproxy($vid)
    {
        global $cluster;
        $vps = getvps($vid);
        if(!empty($vps["serid"])) {
            $sres = $cluster->sync($vps["serid"]);
            if(empty($sres)) {
                return false;
            }
        }
        $details = $this->call($vid, "index.php?act=apidoings&do=save_haproxy");
        return $details["save_haproxy"];
    }
    public function plan_backupvps($vid)
    {
        global $cluster;
        $vps = getvps($vid);
        $details = $this->call($vid, "index.php?act=apidoings&do=e_plan_backupvps");
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function plan_restorevps($vid, $date, $file)
    {
        $post["date"] = $date;
        $post["file"] = $file;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_plan_restorevps", 1, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function plan_listvpsbackups($vid)
    {
        $details = $this->call($vid, "index.php?act=apidoings&do=e_plan_listvpsbackups");
        if(is_array($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function backuply_delete_backup($vpsid, $time, $chain, $dir, $bid)
    {
        $post["time"] = $time;
        $post["chain"] = $chain;
        $post["dir"] = $dir;
        $post["bid"] = $bid;
        $post["vps"] = getvps($vpsid);
        $details = $this->call($vpsid, "index.php?act=apidoings&do=e_backuply_delete_backup", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function backuply_restore_backup($vpsid, $backup_date, $backup_file)
    {
        $post["backup_date"] = $backup_date;
        $post["backup_file"] = $backup_file;
        $details = $this->call($vpsid, "index.php?act=apidoings&do=e_backuply_restore_backup", 1, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function backuply_backup($vpsid, $type)
    {
        $post["type"] = $type;
        $details = $this->call($vpsid, "index.php?act=apidoings&do=e_backuply_backup", 1, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function plan_deletevpsbackup($vid, $date, $file)
    {
        $post["date"] = $date;
        $post["file"] = $file;
        $details = $this->call($vid, "index.php?act=apidoings&do=e_plan_deletevpsbackup", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function addsshkeys($vid, $ssh_keys)
    {
        $post["ssh_keys"] = serialize($ssh_keys);
        $details = $this->call($vid, "index.php?act=apidoings&do=e_addsshkeys", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function removesshkeys($vid, $keys_to_remove)
    {
        $post["keys_to_remove"] = serialize($keys_to_remove);
        $details = $this->call($vid, "index.php?act=apidoings&do=e_removesshkeys", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function saveiso($actid, $isoid)
    {
        $post["actid"] = $actid;
        $post["isoid"] = $isoid;
        $details = $this->call(0, "index.php?act=apidoings&do=e_saveiso", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function deleuiso($actid)
    {
        $post["actid"] = $actid;
        $details = $this->call(0, "index.php?act=apidoings&do=e_del_euiso", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function billing_unsuspend($uid)
    {
        $post["uid"] = $uid;
        $details = $this->call(0, "index.php?act=apidoings&do=e_billing_unsuspend", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function script_req($sid)
    {
        $post["sid"] = $sid;
        $details = $this->call(0, "index.php?act=apidoings&do=e_script_req", 1, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function update_webuzoapps($vid)
    {
        $post = [];
        $details = $this->call($vid, "index.php?act=apidoings&do=e_webuzoapps", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function le_manage_c($serid, $action, $data = [], $user_id = 0)
    {
        global $servers;
        global $globals;
        global $post;
        if(empty($user_id)) {
            return false;
        }
        $post["uid"] = $user_id;
        $post["opt"] = $action;
        $post["primary_domain"] = $data["primary_domain"];
        $post["contact_email"] = $data["contact_email"];
        $post["key_size"] = $data["key_size"];
        $post["renew_days"] = $data["renew_days"];
        $post["staging"] = $data["staging"];
        $post["enable_force"] = $data["enable_force"];
        $ret = make_api_call($servers[0]["ip"], $globals["pass"], "index.php?act=letsencrypt", $data, $post);
        return $ret;
    }
    public function build_dhcp($vid)
    {
        return $this->call($vid, "index.php?act=apidoings&do=e_build_dhcp", 1);
    }
    public function get_all_vpsmanage($vpsid)
    {
        $details = $this->call($vpsid, "index.php?act=apidoings&do=e_get_all_vpsmanage", 1);
        if(!empty($details["info"])) {
            return $details["info"];
        }
        return 0;
    }
    public function check_licensepro($vpsid)
    {
        $details = $this->call($vpsid, "index.php?act=apidoings&do=check_licensepro", 1);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function has_plugin_license($vpsid, $plugin)
    {
        $post = [];
        $post["plugin"] = $plugin;
        $details = $this->call($vpsid, "index.php?act=apidoings&do=has_plugin_license", 1, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return false;
    }
    public function get_disk_json($vpsid, $disk_num = 0)
    {
        $post = [];
        $post["vpsid"] = $vpsid;
        $post["disk_num"] = $disk_num;
        $details = $this->call($vpsid, "index.php?act=apidoings&do=get_disk_json", 1, $post);
        if(!empty($details["result"])) {
            return $details["result"];
        }
        return [];
    }
    public function ga_change_vps_timezone($vpsid, $timezone)
    {
        $post = [];
        $post["vpsid"] = $vpsid;
        $post["timezone"] = $timezone;
        $details = $this->call($vpsid, "index.php?act=apidoings&do=ga_change_vps_timezone", 1, $post);
        return $details["result"];
    }
    public function apply_vpsfirewall_rule($vpsid, $admin_fwid, $fwid, $actid)
    {
        $post = [];
        $post["fwid"] = $fwid;
        $post["admin_fwid"] = $admin_fwid;
        $post["admin_fwid_actid"] = $actid;
        $details = $this->call($vpsid, "index.php?act=apidoings&do=apply_vpsfirewall_rule", 1, $post);
        if(empty($details["apply_vpsfirewall_rule"])) {
            return false;
        }
        return $details["apply_vpsfirewall_rule"];
    }
    public function delete_vpsfirewall_rule($vpsid, $firewall_data)
    {
        $post = [];
        $post["firewall_data"] = base64_encode(json_encode($firewall_data));
        $details = $this->call($vpsid, "index.php?act=apidoings&do=delete_vpsfirewall_rule", 1, $post);
        if(empty($details["delete_vpsfirewall_rule"])) {
            return false;
        }
        return $details["delete_vpsfirewall_rule"];
    }
    public function updatefirewallplans($actid)
    {
        $post["actid"] = $actid;
        $details = $this->call(0, "index.php?act=apidoings&do=e_updatefirewallplans", 1, $post);
        if(!empty($details["result"])) {
            return true;
        }
        return false;
    }
    public function remove_multiple_vpsfirewall($vpses_to_be_removed = [])
    {
        if(!empty($vpses_to_be_removed)) {
            foreach ($vpses_to_be_removed as $k => $v) {
                $vpsid = array_key_first($vpses_to_be_removed[$k]);
                $post["vpses_to_be_removed"] = json_encode($v);
                $details = $this->call($vpsid, "index.php?act=apidoings&do=remove_multiple_vpsfirewall", 1, $post);
                if(empty($details["result"])) {
                    return false;
                }
            }
            return true;
        }
    }
    public function apply_multiple_vpsfirewall($vpses_to_be_applied = [])
    {
        if(!empty($vpses_to_be_applied)) {
            foreach ($vpses_to_be_applied as $k => $v) {
                $vpsid = array_key_first($vpses_to_be_applied[$k]);
                $post["vpses_to_be_applied"] = json_encode($v);
                $details = $this->call($vpsid, "index.php?act=apidoings&do=apply_multiple_vpsfirewall", 1, $post);
                if(empty($details["result"])) {
                    return false;
                }
            }
            return true;
        }
    }
}

?>