<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function editbackupserver()
{
    global $theme;
    global $globals;
    global $cluster;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $done;
    global $backup_server;
    if(!load_lang("admin/editbackupserver")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/editbackupserver";
    $theme["init_theme_name"] = "editbackupserver";
    $theme["init_theme_func"] = ["editbackupserver_theme"];
    $theme["call_theme_func"] = "editbackupserver_theme";
    if(!is_allowed("editbackupservsers")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $bid = (int) optGET("id");
    if(empty($bid)) {
        redirect("act=backupservers");
    }
    $res = makequery("SELECT * FROM backup_servers WHERE bid=:bid", [":bid" => $bid]);
    $backup_server = vsql_fetch_assoc($res);
    if(isset($_POST["editbackupserver"])) {
        $name = POST("name", $l["no_name"]);
        $hostname = POST("hostname", $l["no_hostname"]);
        $type = POST("type", $l["no_type"]);
        $username = POST("username", $l["no_username"]);
        $password = trim($_POST["password"]);
        $port = (int) POST("port", $l["no_port"]);
        $ssh_key = optPOST("ssh_key");
        $ftps = (int) optPOST("ftps");
        $sshpub_key = $sshpri_key = "";
        if(empty($password) && empty($ssh_key)) {
            $error["password"] = $l["no_password"];
        }
        if(!empty($password)) {
            $password = pass_encrypt($password, $backup_server["salt"]);
        }
        if(!empty($error)) {
            return false;
        }
        if($type == "SSH" && !extension_loaded("ssh2")) {
            $error[] = $l["extension_not_found"];
            return false;
        }
        if(!empty($ssh_key)) {
            $sshpub_key = trim($_POST["sshpub_key"]);
            $sshpri_key = trim($_POST["sshpri_key"]);
            $password = "";
            if(empty($sshpub_key) || empty($sshpri_key)) {
                $error[] = $l["no_ssh_key_err"];
                return false;
            }
            $tmpfile_pub = "/tmp/sshkey-" . generateRandStr(8) . ".pub";
            file_put_contents($tmpfile_pub, $sshpub_key);
            $tmpfile_pri = "/tmp/sshkey-" . generateRandStr(8);
            file_put_contents($tmpfile_pri, $sshpri_key);
            vexec("ssh-keygen -lf " . xss($tmpfile_pub), $out, $ret);
            if($ret != 0) {
                unlink($tmpfile_pub);
                unlink($tmpfile_pri);
                $error[] = $l["invalid_pub_key"];
                return false;
            }
            $tmp_conn = ssh2_connect($hostname, $port);
            $auth_key = ssh2_auth_pubkey_file($tmp_conn, $username, $tmpfile_pub, $tmpfile_pri);
            unlink($tmpfile_pub);
            unlink($tmpfile_pri);
            if(!$auth_key) {
                $error[] = $l["ssh_key_con_err"];
                return false;
            }
        }
        $qres = makequery("SELECT * FROM backup_servers WHERE name=:name AND bid != :bid", [":name" => $name, ":bid" => $bid]);
        $row = vsql_num_rows($qres);
        if(0 < $row) {
            $error[] = $l["nameexist"];
            return false;
        }
        $token_vals = [":name" => $name, ":hostname" => $hostname, ":type" => $type, ":username" => $username, ":port" => $port, ":bid" => $bid, ":ssh_key" => $ssh_key, ":sshpub_key" => base64_encode($sshpub_key), ":sshpri_key" => base64_encode($sshpri_key), ":password" => $password, ":ftps" => $ftps];
        $qres = makequery("UPDATE backup_servers SET\n\t\t\t\t\tname = :name,\n\t\t\t\t\thostname = :hostname,\n\t\t\t\t\ttype = :type,\n\t\t\t\t\tusername = :username,\n\t\t\t\t\tpassword = :password,\n\t\t\t\t\tport = :port,\n\t\t\t\t\tssh_key = :ssh_key,\n\t\t\t\t\tsshpub_key = :sshpub_key,\n\t\t\t\t\tsshpri_key = :sshpri_key,\n\t\t\t\t\tftps = :ftps\n\t\t\t\t\tWHERE bid = :bid", $token_vals);
        if(!$qres) {
            $error[] = $l["err_edit_backup_server"];
            return false;
        }
        vexec($globals["com"]["php"] . " " . $globals["scriptfiles"] . "/sync_config.php 2>&1", $o, $r);
        $done = true;
        logs_admin("editbackupserver", $name, 1, $bid, $user["uid"]);
    }
}
function API_editbackupserver()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $done;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
}

?>