<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addserver()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $cluster;
    global $error;
    global $servers;
    global $saved;
    global $servergroups;
    @ini_set("memory_limit", "512M");
    if(!load_lang("admin/addserver")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["cant_add"], $l["cant_add_exp"], $l["cant_add_head"]);
        return false;
    }
    $theme["init_theme"] = "admin/addserver";
    $theme["init_theme_name"] = "Add Server";
    $theme["init_theme_func"] = ["addserver_theme"];
    $theme["call_theme_func"] = "addserver_theme";
    if(!is_allowed("addserver")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $servergroups = server_groups();
    if(isset($_POST["addserver"])) {
        $server_name = POST("server_name", $l["no_name"]);
        $ip = POST("ip", $l["no_ip"]);
        $pass = POST("pass", $l["no_pass"]);
        $sgid = (int) optPOST("sgid");
        $locked = checkbox("locked");
        $internal_ip = optPOST("internal_ip");
        if(!empty($internal_ip) && !valid_ip($internal_ip)) {
            $error["internal_ip"] = $l["wrong_internal_ip"];
        }
        if(!valid_ip($ip)) {
            $error["ip"] = $l["wrong_ip"];
        }
        if($globals["primary_ip"] == $ip) {
            $error[] = $l["self_slave"];
        }
        if(!empty($error)) {
            return false;
        }
        $res = makequery("SELECT serid FROM servers\n\t\t\t\t\t\tORDER BY serid DESC\n\t\t\t\t\t\tLIMIT 0, 1");
        $serid = 1;
        if(0 < vsql_num_rows($res)) {
            $temp = vsql_fetch_assoc($res);
            $serid = $temp["serid"] + $serid;
        }
        $temp = $cluster->serverdetails($ip, $pass);
        if(empty($temp)) {
            $error[] = $l["curl_error"];
            return false;
        }
        if(!empty($temp["license_expired"])) {
            $error[] = $l["slave_lic_exp"];
            return false;
        }
        if($temp["globals"]["version"] != $globals["version"]) {
            $error[] = $l["ver_missmatch"];
        }
        if(!empty($temp["globals"]["inhouse_billing"])) {
            $error[] = $l["err_billing_enabled"];
        }
        if(!empty($error)) {
            return false;
        }
        if(!empty($temp["ips"])) {
            $slaveips = [];
            foreach ($temp["ips"] as $k => $v) {
                if(empty($v["vpsid"])) {
                } else {
                    $slaveips[] = $v["ip"];
                }
            }
            $slaveips_tokens = vsql_in_tokens($slaveips);
            $qres = makequery("SELECT DISTINCT ip \n\t\t\t\t\t\tFROM ips \n\t\t\t\t\t\tWHERE ip IN (" . $slaveips_tokens["query"] . ")\n\t\t\t\t\t\tAND vpsid > 0", $slaveips_tokens["tokens"]);
            $common = [];
            for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                $row = vsql_fetch_assoc($qres);
                $common[] = $row["ip"];
            }
            if(!empty($common)) {
                $error[] = $l["ips_exist"] . " : " . implode(", ", $common);
                return false;
            }
        }
        $keys = [];
        if(!empty($servergroups[$sgid]["sg_ha"])) {
            $keys["public_key"] = $servergroups[$sgid]["sg_public_key"];
            $keys["private_key"] = $servergroups[$sgid]["sg_private_key"];
        }
        $tables_to_check = [];
        $tables_to_check["backup_plans"] = ["unique_column" => "plan_name"];
        foreach ($tables_to_check as $t => $c) {
            $params["query"] = "SELECT DISTINCT(`" . $c["unique_column"] . "`) FROM `" . $t . "`";
            $rows = select_query($params);
            if(empty($rows)) {
                unset($tables_to_check[$t]);
            } else {
                $tables_to_check[$t]["rows"] = $rows;
            }
        }
        if(!empty($tables_to_check)) {
            $ret = base64_encode(gzcompress(serialize($tables_to_check)));
            $res = $cluster->check_duplicate_entries($ip, $pass, $serid, $ret, $keys);
            if(is_array($res["duplicate_entries"]) && !empty($res["duplicate_entries"])) {
                $error["duplicate_entries"] = $l["duplicate_entries_error"] . "<br><span class=\"roundflare\">" . implode(", ", array_keys($res["duplicate_entries"])) . "</span>";
                return false;
            }
        }
        $details = $cluster->setslave($ip, $pass, $serid, $keys);
        if(empty($details)) {
            $error[] = $l["details_err"];
            return false;
        }
        if(!empty($details["error"])) {
            $error = $details["error"];
            return false;
        }
        $serid = insert_and_id("INSERT INTO `servers`\n\t\t\t\tSET serid = :serid,\n\t\t\t\tsgid = :sgid,\n\t\t\t\tserver_name = :server_name,\n\t\t\t\tvirt = :virt,\n\t\t\t\tip = :ip,\n\t\t\t\tinternal_ip = :internal_ip,\n\t\t\t\t`key` = :key,\n\t\t\t\tpass = :pass,\n\t\t\t\thvm = :hvm,\n\t\t\t\tlocked = :locked", [":serid" => $serid, ":sgid" => $sgid, ":server_name" => $server_name, ":virt" => $details["globals"]["kernel"], ":ip" => $ip, ":internal_ip" => $internal_ip, ":key" => $details["globals"]["key"], ":pass" => $pass, ":hvm" => empty($details["servers"][0]["hvm"]) ? 0 : $details["servers"][0]["hvm"], ":locked" => $locked]);
        if(empty($serid)) {
            $error[] = $l["err_saving"];
            return false;
        }
        list_servers();
        if(!empty($details["admin_acl"])) {
            foreach ($details["admin_acl"] as $k => $v) {
                $_aclid = $v["aclid"];
                unset($v["aclid"]);
                $new_aclid = insert_and_id("INSERT INTO `admin_acl` SET " . create_query($v));
                if(empty($new_aclid)) {
                    $error[] = $l["err_saving_acl"];
                    return false;
                }
                $ACLS[$_aclid] = $new_aclid;
            }
        }
        if(!empty($details["users"])) {
            foreach ($details["users"] as $k => $v) {
                $_uid = $v["uid"];
                unset($v["uid"]);
                $qres = makequery("SELECT * FROM `users` \n\t\t\t\t\t\tWHERE email = :email_id", [":email_id" => $v["email"]]);
                if(0 < vsql_num_rows($qres)) {
                    $tuser = vsql_fetch_assoc($qres);
                    $users[$_uid] = $tuser["uid"];
                } else {
                    $v["aclid"] = empty($ACLS[$v["aclid"]]) ? 0 : $ACLS[$v["aclid"]];
                    $uid = insert_and_id("INSERT INTO `users`\n\t\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
                    if(empty($uid)) {
                        $error[] = $l["err_saving_users"];
                        return false;
                    }
                    $users[$_uid] = $uid;
                }
            }
        }
        if(!empty($details["storage"])) {
            $stids = [];
            foreach ($details["storage"] as $k => $v) {
                $_stid = $v["stid"];
                unset($v["stid"]);
                $stid = insert_and_id("INSERT INTO `storage`\n\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
                if(empty($stid)) {
                    $error[] = $l["err_saving_storage"];
                    return false;
                }
                $stids[$_stid] = $stid;
            }
        }
        if(!empty($details["storage_servers"])) {
            foreach ($details["storage_servers"] as $k => $v) {
                $v["stid"] = $stids[$v["stid"]];
                $v["serid"] = $serid;
                $v["sgid"] = -2;
                $stid = insert_and_id("INSERT INTO `storage_servers`\n\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
            }
        }
        if(!empty($details["vps"])) {
            foreach ($details["vps"] as $k => $v) {
                $_vpsid = $v["vpsid"];
                $v["serid"] = $serid;
                $v["uid"] = empty($users[$v["uid"]]) ? 0 : $users[$v["uid"]];
                unset($v["vpsid"]);
                $vpsid = insert_and_id("INSERT INTO `vps`\n\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
                if(empty($vpsid)) {
                    $error[] = $l["err_saving_vps"];
                    return false;
                }
                $vpsids[$_vpsid] = $vpsid;
            }
        }
        if(!empty($details["ippool"])) {
            $ippids = [];
            foreach ($details["ippool"] as $k => $v) {
                $_ippid = $v["ippid"];
                $v["ipp_serid"] = $serid;
                unset($v["ippid"]);
                $ippid = insert_and_id("INSERT INTO `ippool`\n\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
                if(empty($ippid)) {
                    $error[] = $l["err_saving_ippool"];
                    return false;
                }
                $ippids[$_ippid] = $ippid;
            }
        }
        if(!empty($details["ippool_servers"])) {
            foreach ($details["ippool_servers"] as $k => $v) {
                $v["ippid"] = $ippids[$v["ippid"]];
                $v["serid"] = $serid;
                $ippid = insert_and_id("INSERT INTO `ippool_servers`\n\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
            }
        }
        if(!empty($details["ips"])) {
            foreach ($details["ips"] as $k => $v) {
                $v["ip_serid"] = $serid;
                unset($v["ipid"]);
                if(!empty($v["ippid"])) {
                    $v["ippid"] = empty($ippids[$v["ippid"]]) ? 0 : $ippids[$v["ippid"]];
                }
                if(!empty($v["vpsid"])) {
                    $v["vpsid"] = empty($vpsids[$v["vpsid"]]) ? 0 : $vpsids[$v["vpsid"]];
                }
                $qres = makequery("SELECT * FROM `ips` \n\t\t\t\t\t\tWHERE ip = :ip", [":ip" => $v["ip"]]);
                if(0 < vsql_num_rows($qres)) {
                    $_tmp_ip = vsql_fetch_assoc($qres);
                    if(empty($_tmp_ip["vpsid"])) {
                        makequery("UPDATE `ips`\n\t\t\t\t\t\t\t\tSET vpsid = :vpsid\n\t\t\t\t\t\t\t\tWHERE ip = :ip", [":vpsid" => $v["vpsid"], ":ip" => $v["ip"]]);
                    }
                } else {
                    $ipid = insert_and_id("INSERT INTO `ips`\n\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
                    if(empty($ipid)) {
                        $error[] = $l["err_saving_ips"];
                        return false;
                    }
                }
            }
        }
        if(!empty($details["vpsbackup_settings"])) {
            foreach ($details["vpsbackup_settings"] as $k => $v) {
                $v["serid"] = $serid;
                unset($v["vbid"]);
                $curr_bid = $v["bid"];
                $qres = insert_and_id("INSERT INTO `vpsbackup_settings`\n\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
                if(!$qres) {
                    $error[] = $l["err_saving_vpsbackup_settings"];
                    return false;
                }
            }
        }
        $backup_servers = [];
        if(!empty($details["backupservers"])) {
            foreach ($details["backupservers"] as $k => $v) {
                $old_bid = $v["bid"];
                unset($v["bid"]);
                $qres = makequery("SELECT * FROM `backup_servers`\n\t\t\t\t\t\tWHERE hostname = :hostname AND type = :type AND username = :username", [":hostname" => $v["hostname"], ":type" => $v["type"], ":username" => $v["username"]]);
                if(vsql_num_rows($qres) < 1) {
                    $match_not_found = 1;
                    $new_bid = insert_and_id("INSERT INTO `backup_servers`\n\t\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
                    if(empty($new_bid)) {
                        $error[] = $l["err_saving_backupservers"];
                        return false;
                    }
                } else {
                    $tmp_row = vsql_fetch_assoc($qres);
                    $new_bid = $tmp_row["bid"];
                }
                $backup_servers[$old_bid] = $new_bid;
                if($old_bid == $curr_bid) {
                    makequery("UPDATE vpsbackup_settings SET \n\t\t\t\t\t\t\tbid = :bid \n\t\t\t\t\t\t\tWHERE serid = :serid", [":bid" => $new_bid, ":serid" => $serid]);
                }
            }
        }
        if(!empty($details["backup_plans"])) {
            foreach ($details["backup_plans"] as $k => $v) {
                $old_bpid = $v["bpid"];
                unset($v["bpid"]);
                $v["bid"] = empty($backup_servers[$v["bid"]]) ? 0 : $backup_servers[$v["bid"]];
                $new_bpid = insert_and_id("INSERT INTO `backup_plans`\n\t\t\t\t\t\t\t\t\t\t\tSET " . create_query($v));
                if(!$new_bpid) {
                    $error[] = $l["err_saving_backup_plans"];
                    return false;
                }
                makequery("UPDATE vps SET \n\t\t\t\t\t\t\tbpid = :new_bpid\n\t\t\t\t\t\t\tWHERE bpid = :old_bpid\n\t\t\t\t\t\t\tAND serid = :serid", [":new_bpid" => $new_bpid, ":old_bpid" => $old_bpid, ":serid" => $serid]);
            }
        }
        if(!empty($details["haproxy"])) {
            foreach ($details["haproxy"] as $k => $v) {
                unset($v["id"]);
                $v["serid"] = $serid;
                $res = makequery("INSERT INTO `haproxy`\n\t\t\t\t\t\t\t\t\tSET " . create_query($v), [], 1);
            }
        }
        if(!empty($details["ssh_keys"])) {
            foreach ($details["ssh_keys"] as $k => $v) {
                unset($v["keyid"]);
                $v["uid"] = empty($users[$v["uid"]]) ? 0 : $users[$v["uid"]];
                $res = makequery("INSERT INTO `ssh_keys`\n\t\t\t\t\t\t\t\t\tSET " . create_query($v), [], 1);
            }
        }
        if(!empty($details["disks"])) {
            foreach ($details["disks"] as $k => $v) {
                unset($v["did"]);
                $res = makequery("INSERT INTO `disks`\n\t\t\t\t\t\t\t\t\tSET " . create_query($v), [], 1);
            }
        }
        if(!empty($details["passthrough"])) {
            foreach ($details["passthrough"] as $v) {
                $v["serid"] = $serid;
                unset($v["pid"]);
                $q = [];
                if(!empty($vpsids[$v["vpsid"]])) {
                    $v["vpsid"] = $vpsids[$v["vpsid"]];
                }
                foreach ($v as $col => $value) {
                    if(in_array($col, ["serid", "vpsid", "status"])) {
                        $q[$col] = "`" . $col . "` = " . intval($value);
                    } else {
                        $q[$col] = "`" . $col . "` = '" . $value . "'";
                    }
                }
                $q = implode(", ", $q);
                $pid = insert_and_id("INSERT INTO `passthrough` SET " . $q);
            }
        }
        $keys = "add_as_slave";
        $details_slave = $cluster->setslave($ip, $pass, $serid, $keys);
        if(empty($details_slave["saved"])) {
            $error[] = $l["err_slaving"];
            return false;
        }
        $sres = $cluster->sync($serid);
        if(empty($sres)) {
            $error[] = $l["err_save_slave"];
            return false;
        }
        if(!empty($servergroups[$sgid]["sg_ha"]) && !empty($details["ha_ssh_keys"])) {
            $data = [];
            $data["sg_password"] = $servergroups[$sgid]["sg_password"];
            $data["sg_name"] = $servergroups[$sgid]["sg_name"];
            $data["sg_salt"] = $servergroups[$sgid]["sg_salt"];
            $data["server_ip"] = $ip;
            $data["serid"] = $serid;
            $data["add_node"] = 0;
            $count = 0;
            foreach ($servers as $k => $v) {
                if($v["sgid"] == $sgid) {
                    $count++;
                }
            }
            if(1 < $count) {
                $data["add_node"] = $serid;
                foreach ($servers as $k => $v) {
                    if($v["sgid"] == $sgid && !empty($v["ha_master"])) {
                        $data["ha_master"] = $v["serid"];
                    }
                }
            } else {
                makequery("UPDATE `servers` SET\n\t\t\t\t\tha_master = :ha_master\n\t\t\t\t\tWHERE serid = :serid", [":serid" => $serid, ":ha_master" => $sgid]);
            }
            $slaveactid = $cluster->installha($serid, $data);
            for ($i = 0; $i <= 3; $i++) {
                $cluster->reverse_sync($serid);
                $res = makequery("SELECT * FROM tasks WHERE\n\t\t\t\t\t\t\t\t\tserid = :serid\n\t\t\t\t\t\t\t\t\t" . ($serid == 0 ? "AND actid = :slaveactid" : "AND slaveactid = :slaveactid") . " ORDER BY time DESC", [":serid" => $serid, ":slaveactid" => $slaveactid]);
                $row = vsql_fetch_assoc($res);
                $actid = $row["actid"];
                if(!empty($actid)) {
                    break;
                }
                sleep(1);
            }
            vexec($globals["com"]["php"] . " " . $globals["scriptfiles"] . "/installha_master.php " . $actid . " > " . logdir() . "installha_master.log 2>&1 &");
            logs_admin("installha", $info["version"], 1, 0, $user["uid"]);
        }
        $cluster->resources($serid);
        logs_admin("addserver", $server_name, 1, $serid, $user["uid"]);
        $saved = $serid;
    }
    vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/sync_backup_plans.php >> " . logdir() . "sync_backup_plans.log 2>&1 &");
}
function create_query($array, $implode = ", ")
{
    $ret = [];
    foreach ($array as $k => $v) {
        $ret[$k] = "`" . $k . "` = '" . $v . "'";
    }
    if(empty($implode)) {
        return $ret;
    }
    return implode($implode, $ret);
}
function API_addserver()
{
    global $theme;
    global $globals;
    global $user;
    global $l;
    global $cluster;
    global $error;
    global $saved;
    global $servergroups;
    global $started;
    if(!empty($saved)) {
        $GLOBALS["_api"]["saved"] = $saved;
    }
    $GLOBALS["_api"]["servergroups"] = $servergroups;
}

?>