<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addiprange()
{
    global $theme;
    global $globals;
    global $cluster;
    global $user;
    global $l;
    global $servers;
    global $error;
    global $ippools;
    global $done;
    global $ips;
    global $allowed_netmasks;
    global $allowed_input_netmasks;
    if(!load_lang("admin/addiprange")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/addiprange";
    $theme["init_theme_name"] = "addiprange";
    $theme["init_theme_func"] = ["addiprange_theme"];
    $theme["call_theme_func"] = "addiprange_theme";
    if(!is_allowed("addips")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $res = makequery("SELECT * FROM ippool\n\t\t\t\t\tWHERE ipv6 > 0\n\t\t\t\t\tORDER BY ippid");
    $ippools = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ippools[$row["ippid"]] = $row;
    }
    $ippid = (int) optGET("ippid");
    $allowed_netmasks[48] = 3;
    $allowed_netmasks[64] = 4;
    $allowed_netmasks[80] = 5;
    $allowed_netmasks[96] = 6;
    $allowed_netmasks[112] = 7;
    $i = 32;
    while ($i <= 108) {
        $allowed_input_netmasks[$i] = ceil($i / 16);
        $i += 4;
    }
    if(isset($_POST["submitip"])) {
        $range = $range_ = [];
        $netmask = (int) optPOST("netmask");
        $input_netmask = (int) optPOST("input_netmask");
        if(empty($allowed_netmasks[$netmask])) {
            $error[] = $l["inv_netmask"];
            return false;
        }
        if(empty($allowed_input_netmasks[$input_netmask])) {
            $error[] = $l["inv_netmask"];
            return false;
        }
        $ippid = (int) optPOST("ippid");
        if(empty($ippid)) {
            $error[] = $l["no_ip_pool"];
            return false;
        }
        if(empty($ippools[$ippid]) || empty($ippools[$ippid]["ipv6"])) {
            $error[] = $l["inv_ippool"];
            return false;
        }
        $ip_serid = (int) $ippools[$ippid]["ipp_serid"];
        $ips = $_POST["ips6"];
        if(is_array($ips) && !empty($ips)) {
            $invalid = [];
            foreach ($ips as $ip) {
                for ($x = $allowed_netmasks[$netmask] + 1; $x <= 8; $x++) {
                    unset($ip[$x]);
                }
                $ip = implode(":", $ip);
                $ip_ = trim($ip, ":");
                if(empty($ip_)) {
                } elseif(substr_count($ip, ":") != $allowed_netmasks[$netmask] - 1) {
                    $invalid[] = $ip;
                } elseif(!valid_ipv6($ip . "::")) {
                    $invalid[] = $ip;
                } else {
                    $range_[] = $ip;
                }
            }
            if(!empty($invalid)) {
                $error[] = $l["ips_inv"] . " : " . implode(", ", $invalid);
                return false;
            }
        }
        $ipv6[1] = optPOST("ipv6_1");
        $ipv6[2] = optPOST("ipv6_2");
        $ipv6[3] = optPOST("ipv6_3");
        $ipv6[4] = optPOST("ipv6_4");
        $ipv6[5] = optPOST("ipv6_5");
        $ipv6[6] = optPOST("ipv6_6");
        $ipv6[7] = optPOST("ipv6_7");
        $ipv6[8] = optPOST("ipv6_8");
        if(!empty($ipv6[1]) && !empty($ipv6[2])) {
            if($netmask <= $input_netmask) {
                $error[] = $l["input_mask_bigger"];
            }
            for ($x = $allowed_input_netmasks[$input_netmask]; $x <= 8; $x++) {
                if(empty($ipv6[$x])) {
                    unset($ipv6[$x]);
                }
            }
            if(substr_count(implode(":", $ipv6), ":") != $allowed_input_netmasks[$input_netmask] - 1) {
                $error[] = lang_vars_name($l["ip_gen_inv"], ["from" => $input_netmask, "to" => $netmask]);
                return false;
            }
            if(!valid_ipv6(implode(":", $ipv6) . "::")) {
                $error[] = $l["inv_ipv6"];
            }
            $ipv6_num = (int) POST("ipv6_num", $l["no_ipv6_num"]);
            $max_ipv6 = pow(2, $netmask - $input_netmask);
            if($max_ipv6 < $ipv6_num) {
                $error[] = $l["err_max_ipv6"] . $max_ipv6;
                return false;
            }
            if(5000 < $ipv6_num) {
                $error[] = $l["ipv6_too_much"];
            }
            if(!empty($error)) {
                return false;
            }
            $tmp_ipv6_num = $ipv6_num - count($range);
            if($tmp_ipv6_num <= 1) {
            } else {
                $tmp_range = ip6range(implode(":", $ipv6), $tmp_ipv6_num, $allowed_netmasks[$netmask] - 1, $input_netmask);
                $range = array_merge($range, $tmp_range);
                $range = array_unique($range);
                if(count($range) < $ipv6_num) {
                }
            }
            if(empty($range)) {
                $error[] = $l["inv_ipv6"];
                return false;
            }
        }
        $range = array_merge($range, $range_);
        $range = array_unique($range);
        if(empty($range)) {
            $error[] = $l["no_ips"];
            return false;
        }
        $qres = makequery("SELECT DISTINCT ip\n\t\t\t\t\t\tFROM ips\n\t\t\t\t\t\tWHERE ip LIKE '" . implode(":%' OR ip LIKE '", $range) . ":%'");
        $common = [];
        for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
            $row = vsql_fetch_assoc($qres);
            $common[] = $row["ip"];
        }
        if(!empty($common)) {
            $error[] = $l["ips_exist_in_ip"] . " : " . implode(", ", $common);
            return false;
        }
        foreach ($range as $k => $value) {
            for ($i = $allowed_netmasks[$netmask]; $i < 8; $i++) {
                $value = $value . ($i == 7 ? ":0001" : ":0000");
            }
            $range[$k] = $value;
        }
        $_range = [];
        foreach ($range as $k => $value) {
            $qres = insert_and_id("INSERT INTO ips\n\t\t\t\t\t\t  SET ippid = :ippid,\n\t\t\t\t\t\t  ip = :ip,\n\t\t\t\t\t\t  ipr_netmask = :ipr_netmask,\n\t\t\t\t\t\t  ipv6 = '1'", [":ippid" => $ippid, ":ip" => $value, ":ipr_netmask" => $netmask]);
            if(empty($qres)) {
                $error[] = $l["err_ip"] . " : " . $value;
                return false;
            }
            $_range[$qres] = $value;
        }
        $done = [];
        $done["range"] = $_range;
        $done["done"] = 1;
    }
}
function API_addiprange()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $done;
    global $ips;
    $GLOBALS["_api"]["done"] = $done;
}

?>