<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(posix_getuid() != 0) {
    exit("Only CLI usage allowed");
}
define("VIRTUALIZOR", 1);
define("VIRTCLI", 1);
error_reporting(0);
include_once dirname(__FILE__) . "/universal.php";
include_once dirname(__FILE__) . "/globals.php";
include_once dirname(__FILE__) . "/main/functions.php";
if(!defined("APP")) {
    define("APP", "Virtualizor");
}
loadlicense();
load_lang("admin/index");
load_lang("admin/cli");
unset($argv[0]);
if(empty($argv[1])) {
    echo "Please provide some input.\n";
    exit(1);
}
foreach ($argv as $k => $v) {
    $v = ltrim($v, "-");
    $temp = explode("=", $v);
    $args[trim($temp[0])] = trim($temp[1]);
    if(empty($first_arg)) {
        $first_arg = trim($temp[0]);
    }
}
if($argv[1] == "-v" || $argv[1] == "--version") {
    echo $globals["version"] . "\n";
    exit(0);
}
if($argv[1] == "--generate_apikey" && is_master()) {
    $pass = $globals["pass"];
    $key = generateRandStr(8);
    $apikey = make_apikey($key, $pass);
    echo $apikey . "\n";
    exit(0);
}
if($argv[1] == "-l" || $argv[1] == "--license") {
    if(empty($globals["lictype"])) {
        $lic_type = $l["free"];
    }
    if(date("Ymd") <= $globals["licexpires"]) {
        $lic_expire = $globals["licexpires_txt"];
    } else {
        $lic_expire = $l["expired"];
    }
    preg_match("/\\>(.*?)\\</is", $globals["active_txt"], $match);
    $active_txt = $match[1];
    echo $l["virt_license"] . " : " . $globals["license"] . "\n" . $l["lic_type"] . " : " . $lic_type . "\n" . $l["num_vps"] . (empty($globals["licnumvs"]) ? " " . $l["unlimited"] : $globals["licnumvs"]) . "\n" . $l["licexpires"] . " (DD/MM/YYYY) : " . (!empty($globals["licexpires"]) ? $lic_expire : "") . "\n" . $l["status_active"] . " : " . $active_txt . "\n" . $l["primary_ip"] . " : " . $globals["primary_ip"] . "\n";
    exit(0);
}
if($argv[1] == "--help") {
    shell_exec("clear");
    echo $l["help"];
    exit(0);
}
if($argv[1] == "--fix_permissions") {
    fix_permissions();
    P("Fix Permissions done");
    exit(0);
}
if($first_arg == "admin_test") {
    $host = empty($args["host"]) ? "127.0.0.1" : $args["host"];
    $logdir = V_LOG_DIR . "/admin-test-logs/";
    if(!file_exists($logdir)) {
        mkdir($logdir);
    }
    include_once $globals["path"] . "/sdk/admin.php";
    $SDK = new Virtualizor_Admin_SDK("127.0.0.1", $globals["key"], $globals["pass"]);
    $tests = !empty($args["tests"]) ? cexplode(",", $args["tests"]) : [];
    foreach (glob($globals["path"] . "/admin/*.php") as $file) {
        $test_name = str_replace(".php", "", basename($file));
        if(!empty($tests) && !in_array($test_name, $tests)) {
        } else {
            $file = $globals["path"] . "/test/admin/" . basename($file);
            echo "Testing file : " . $file . "\n";
            $logfile = $logdir . basename($file);
            echo " - Log file : " . $logfile . "\n";
            $content = file_get_contents($file);
            preg_match_all("/function(\\s*)(TEST_" . $test_name . "(.*?))\\(\\)/is", $content, $matches);
            if(empty($matches[2])) {
                P(" - No test functions");
            } else {
                include_once $file;
                file_put_contents($logfile, "");
                foreach ($matches[2] as $k => $v) {
                    $sub_test = $matches[2][$k];
                    ob_start();
                    $result = $sub_test();
                    $out = ob_get_clean();
                    file_put_contents($logfile, json_encode(["result" => $result, "output" => $out], JSON_PRETTY_PRINT), FILE_APPEND);
                    if(!empty($result["error"])) {
                        $ret = "Errors were found !";
                    } else {
                        $ret = "Success :)";
                    }
                    echo " - Result of [" . $test_name . "] " . $sub_test . " : " . $ret . "\n\n";
                }
            }
        }
    }
    exit(0);
} elseif($first_arg == "enduser_test") {
    $host = empty($args["host"]) ? "127.0.0.1" : $args["host"];
    $logdir = V_LOG_DIR . "/enduser-test-logs/";
    if(!file_exists($logdir)) {
        mkdir($logdir);
    }
    include_once $globals["path"] . "/sdk/enduser.php";
    $SDK = new Virtualizor_Enduser_SDK("127.0.0.1", $globals["key"], $globals["pass"]);
    $tests = !empty($args["tests"]) ? cexplode(",", $args["tests"]) : [];
    foreach (glob($globals["path"] . "/main/*.php") as $file) {
        $test_name = str_replace(".php", "", basename($file));
        if(!empty($tests) && !in_array($test_name, $tests)) {
        } else {
            $file = $globals["path"] . "/test/enduser/" . basename($file);
            echo "Testing file : " . $file . "\n";
            $logfile = $logdir . basename($file);
            echo " - Log file : " . $logfile . "\n";
            $content = file_get_contents($file);
            preg_match_all("/function(\\s*)(TEST_" . $test_name . "(.*?))\\(\\)/is", $content, $matches);
            if(empty($matches[2])) {
                P(" - No test functions");
            } else {
                include_once $file;
                file_put_contents($logfile, "");
                foreach ($matches[2] as $k => $v) {
                    $sub_test = $matches[2][$k];
                    ob_start();
                    $result = $sub_test();
                    $out = ob_get_clean();
                    file_put_contents($logfile, json_encode(["result" => $result, "output" => $out], JSON_PRETTY_PRINT), FILE_APPEND);
                    if(!empty($result["error"])) {
                        $ret = "Errors were found !";
                    } else {
                        $ret = "Success :)";
                    }
                    echo " - Result of [" . $test_name . "] " . $sub_test . " : " . $ret . "\n\n";
                }
            }
        }
    }
    exit(0);
} else {
    echo "Nothing to do. Please provide proper arguments.\n";
    exit(1);
}

?>