<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once "inc.php";
oslist();
$actid = (int) $argv[1];
if(!bg_rebuildvs($actid)) {
    unlockvps($vpsid);
    foreach ($error as $key) {
        $err_msg .= $key . "\n";
    }
    $err_msg = strip_tags($err_msg);
    send_emailtemp_mail("admin_rebuild_vs_err", $globals["soft_email"], ["err_msg" => $err_msg, "vpsid" => $vpsid, "vps_name" => $vps_name, "node_ip" => $globals["primary_ip"], "sn" => $globals["sn"]], 1);
}
$cluster->sync($vps["serid"]);
echo "Errors: \n";
r_print($error);
if(defined("debug")) {
    r_print($GLOBALS["logr"]);
}
function combine_error()
{
    global $error;
    $tmp = $error;
    unset($tmp["derr"]);
    return !empty($tmp) ? implode(" ", $tmp) . " " : "";
}
function bg_rebuildvs($actid)
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $oslist;
    global $done;
    global $vpsid;
    global $vps_name;
    global $plans;
    global $ips;
    global $ips6;
    global $ipools;
    global $ostemplates;
    global $users;
    global $isos;
    global $virt;
    global $hvm;
    global $newvs;
    global $resources;
    global $storages;
    if(!load_lang("admin/rebuild")) {
        return false;
    }
    echo "Starting Task : " . $actid . "\n";
    $serid = 0;
    $newvs = $vps = [];
    if(!empty($globals["queue_creation"])) {
        while (true) {
            echo "Checking for running tasks at " . date("Ymd H:i:s") . "\n";
            $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\t\t  WHERE actid != " . $actid . "\n\t\t\t\t\t\t\t  AND action IN ('addvs', 'rebuildvs', 'addvs_restore')\n\t\t\t\t\t\t\t  AND started > 0\n\t\t\t\t\t\t\t  AND ended = 0\n\t\t\t\t\t\t\t  AND updated >= '" . (time() - 900) . "'");
            $running = vsql_num_rows($res);
            if($globals["queue_creation"] <= $running) {
                echo $running . " tasks found at " . date("Ymd H:i:s") . " ... sleeping...\n";
                task_update($actid, $l["in_queue"], 10);
                sleep(30);
                break;
            }
            echo $running . " tasks found at " . date("Ymd H:i:s") . ". NOW RUNNING\n\n";
        }
    }
    task_start($actid);
    $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t  WHERE actid = " . $actid . "\n\t\t\t\t\t  AND action = 'rebuildvs'");
    if(0 < vsql_num_rows($res)) {
        $task = vsql_fetch_assoc($res);
        $data = unserialize($task["data"]);
        $task["data"] = $data;
        $newvs = $data["newvs"];
        $vps = $data["vps"];
        $vpsid = $data["vps"]["vpsid"];
        $vps_name = $data["vps"]["vps_name"];
    }
    $res = makequery("SELECT email\n\t\t\t\t\t\tFROM `users`\n\t\t\t\t\t  WHERE uid = :uid", [":uid" => $vps["uid"]]);
    if(0 < vsql_num_rows($res)) {
        $row = vsql_fetch_assoc($res);
        $user_email = $row["email"];
    }
    lockvps($vpsid, $l["vm_locked_rebuild"]);
    echo "Setting Active server " . $vps["serid"] . "\n\n";
    set_active_server($vps["serid"]);
    list_storages();
    $_storages = $storages;
    $task["data"]["newvs"]["pass"] = "XXXXXXXX";
    $keys = [];
    if(empty($data["remove_old_ssh_keys"]) && !empty($vps["data"]["added_keys"])) {
        $keys = array_values($vps["data"]["added_keys"]);
    }
    if(!empty($data["sshkey"])) {
        $keys[] = base64_decode($data["sshkey"]);
        $task["data"]["sshkey"] = "";
    }
    $vps["data"]["vm_admin_name"] = "root";
    if(preg_match("/windows/is", $ostemplates[$task["data"]["newvs"]["osid"]]["name"])) {
        $vps["data"]["vm_admin_name"] = "Administrator";
        if(!empty($ostemplates[$task["data"]["newvs"]["osid"]]["template_admin_name"])) {
            $vps["data"]["vm_admin_name"] = $ostemplates[$task["data"]["newvs"]["osid"]]["template_admin_name"];
        }
    }
    $vps["data"]["added_keys"] = $keys;
    $data_encode = json_encode($vps["data"]);
    $res = makequery("UPDATE `vps`\n\t\t\t\t\tSET data = :data\n\t\t\t\t\tWHERE vpsid = :vpsid", [":data" => $data_encode, ":vpsid" => $vps["vpsid"]]);
    task_update($actid, $l["prog_update2"], 20, serialize($task));
    echo "Syncing up with Slave \n";
    $sres = $cluster->sync($vps["serid"]);
    if(empty($sres)) {
        $error["err_save_slave"] = combine_error() . $l["err_save_slave"];
        task_update($actid, $error["err_save_slave"], -1);
        return false;
    }
    _task_update($actid, $l["prog_update3"], 40, "group");
    _task_update($actid, "", 40, "create_vps");
    echo "Performing Reinstall of VPS : " . $vpsid . "\n";
    $format_primary = (int) $task["data"]["format_primary"];
    echo "Format Primary Disk: " . $format_primary . "\n";
    if(!empty($format_primary)) {
        $disk_og = get_vps_disk($vpsid);
        if(!empty($disk_og)) {
            $disk_og[] = $disk_og;
        }
    } else {
        $disk_og = get_vps_DISKS($vpsid);
    }
    $lightbit_data_og = [];
    if(!empty($disk_og)) {
        foreach ($disk_og as $k => $v) {
            if(preg_match("/lightbit/is", $v["type"]) && preg_match("/block/is", $v["type"])) {
                $lightbit_data_og[$k] = $disk_og[$k];
            }
        }
    }
    if(!empty($lightbit_data_og)) {
        $vps = getvps($vpsid);
        foreach ($lightbit_data_og as $k => $v) {
            $suffix = (preg_match("/swap/is", $v["path"]) ? "swap" : "") . "-" . $v["disk_uuid"];
            $path = vpsdisk_path_build($suffix, $_storages[$v["stid"]], $vps);
            $qres = update_query("UPDATE disks SET\n\t\t\t\t\t\t\t\t\tpath = :path\n\t\t\t\t\t\t\t\t\tWHERE disk_uuid = :disk_uuid", [":path" => $path, ":disk_uuid" => $v["disk_uuid"]]);
        }
        $cluster->sync($vps["serid"]);
    }
    $res1 = $cluster->osreinstall($vpsid, $format_primary);
    if(empty($res1)) {
        foreach ($lightbit_data_og as $k => $v) {
            $qres = update_query("UPDATE disks SET\n\t\t\t\t\t\t\t\t\tpath = :path\n\t\t\t\t\t\t\t\t\tWHERE disk_uuid = :disk_uuid", [":path" => $v["path"], ":disk_uuid" => $v["disk_uuid"]]);
            $cluster->sync($vps["serid"]);
        }
        $error["error_reins"] = combine_error() . $l["error_reins"];
        task_update($actid, $error["error_reins"], -1);
        return false;
    } else {
        $owner = !empty($vps["pid"]) ? $vps["pid"] : $vps["uid"];
        $res = makequery("SELECT vps_uuid \n\t\t\t\t\t\tFROM `usage` \n\t\t\t\t\t\tWHERE vps_uuid = :vps_uuid", [":vps_uuid" => $vps["uuid"]]);
        if(!empty($globals["inhouse_billing"]) && !empty($vps["inhouse_billing"]) && vsql_num_rows($res) < 1) {
            $vals = $set = [];
            $vals["vps_uuid"] = $vps["uuid"];
            $vals["uid"] = $owner;
            $vals["starttime"] = time();
            $vals["plid"] = $vps["plid"];
            $vals["data"] = serialize(["hostname" => $vps["hostname"]]);
            foreach ($vals as $k => $v) {
                $set[$k] = "`" . $k . "` = :" . $k;
            }
            $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
            $vals = $set = [];
            $vals["vps_uuid"] = $vps["uuid"];
            $vals["uid"] = $owner;
            $vals["starttime"] = time();
            $vals["resource"] = "bandwidth";
            $vals["data"] = serialize(["hostname" => $vps["hostname"]]);
            foreach ($vals as $k => $v) {
                $set[$k] = "`" . $k . "` = :" . $k;
            }
            $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
        }
        echo "Reinstall Done\n";
        _task_update($actid, "", 40, "group_end");
        $cluster->reverse_sync($vps["serid"]);
        $_virt = $vps["virt"] . (!empty($vps["hvm"]) ? "hvm" : "");
        if(!empty($vps["rdp"]) && $kernel->features("win_support", $_virt)) {
            echo "Enabling Remote Desktop\n";
            $cluster->remote_desktop($vpsid, $vps["rdp"]);
        }
        if(empty($newvs["dont_set_pass"])) {
            echo "Setting Root / Admin Password\n";
            _task_update($actid, $l["prog_update4"], 60, "group");
            _task_update($actid, "", 60, "changepassword");
            if(!$cluster->change_vps_pass($vpsid, $newvs["pass"])) {
                $error["err_changing"] = combine_error() . $l["err_changing"];
                task_update($actid, $error["err_changing"], -1);
                return false;
            }
            _task_update($actid, "", 60, "group_end");
        }
        if(!empty($globals["save_vm_pass"]) && !empty($newvs["pass"])) {
            $salt = generateRandStr(8);
            $pass_crypt = pass_encrypt($newvs["pass"], $salt);
            $vps["data"]["crypted_pass"] = $pass_crypt;
            $vps["data"]["crypted_salt"] = $salt;
            $data_encode = json_encode($vps["data"]);
            $res = makequery("UPDATE `vps`\n\t\t\t\t\t\tSET data = :data\n\t\t\t\t\t\tWHERE vpsid = :vpsid", [":data" => $data_encode, ":vpsid" => $vps["vpsid"]]);
        }
        if($kernel->features("build_dhcp", $_virt)) {
            echo "Building DHCP\n";
            $cluster->build_dhcp($vps["serid"]);
        }
        if($kernel->features("xenserver_tools", $_virt) && !empty($vps["install_xentools"])) {
            echo "Installing Xentools\n";
            $cluster->install_xentools($vpsid);
        }
        if(!empty($data["control_panel"]) && !$kernel->features("control_panel_live", $vps["virt"])) {
            _task_update($actid, $l["install_cp"], 70, "group");
            _task_update($actid, "", 77, "install_cp");
            $ret = E_api_call($servers[$vps["serid"]]["ip"], $GLOBALS["servers_keypass"][$vps["serid"]]["pass"], $vpsid, "index.php?act=apidoings&do=e_install_cp&cp=" . $data["control_panel"], []);
            _task_update($actid, "", 77, "group_end");
        }
        if(!empty($data["recipe"]) && !$kernel->features("recipe_live", $vps["virt"])) {
            _task_update($actid, $l["install_recipe"], 70, "group");
            _task_update($actid, "", 77, "install_recipe");
            $tmp = get_recipe($data["recipe"]);
            foreach ($tmp as $k => $v) {
                $tmp[$k]["code"] = lang_vars_name($v["code"], ["username" => $user_email, "vps_hostname" => $vps["hostname"], "root_pass" => $newvs["pass"], "ips" => implode(", ", $vps["ips"]), "ips6" => implode(", ", $vps["ips6"]), "ips6_subnet" => implode(", ", $vps["ips6_subnet"]), "vpsid" => $vpsid]);
            }
            $recipe["recipe"] = base64_encode(serialize($tmp));
            $ret = E_api_call($servers[$vps["serid"]]["ip"], $GLOBALS["servers_keypass"][$vps["serid"]]["pass"], $vpsid, "index.php?act=apidoings&do=e_install_recipes&svs=" . $vpsid, $recipe);
            _task_update($actid, $l["install_recipe"], 77, "group_end");
        }
        if(!preg_match("/windows/is", $newvs["os_name"]) && !empty($vps["data"]["disable_password"]) && !$kernel->features("recipe_live", $virt)) {
            $tmp = [];
            $tmp[0] = ["rid" => rand(rand(-3, -10), rand(-500, -1000)), "code" => "sed -i \"s/#PasswordAuthentication yes/PasswordAuthentication no/i\" /etc/ssh/sshd_config;\nsed -i \"s/PasswordAuthentication yes/PasswordAuthentication no/i\" /etc/ssh/sshd_config;\nservice sshd restart;"];
            $recipe["recipe"] = base64_encode(serialize($tmp));
            $ret = E_api_call($servers[$vps["serid"]]["ip"], $GLOBALS["servers_keypass"][$vps["serid"]]["pass"], $vpsid, "index.php?act=apidoings&do=e_install_recipes&svs=" . $vpsid, $recipe);
        }
        if(!empty($keys)) {
            $cluster->addsshkeys($vps["serid"], $vpsid, $keys);
        }
        if(!preg_match("/windows/is", $newvs["os_name"])) {
            $res = makequery("SELECT preferences FROM users WHERE uid = :uid", [":uid" => $newvs["uid"]]);
            $row = vsql_fetch_assoc($res);
            $preferences_data = unserialize($row["preferences"]);
            if(!empty($globals["default_enduser_timezone"]) || !empty($preferences_data["timezone"])) {
                $timezone = !empty($preferences_data["timezone"]) ? $preferences_data["timezone"] : $globals["default_enduser_timezone"];
                $tmp = [];
                $tmp[0] = ["rid" => -1, "code" => "timedatectl set-timezone \"" . $timezone . "\""];
                $recipe["recipe"] = base64_encode(serialize($tmp));
                $preferences_data = E_api_call($servers[$serid]["ip"], $GLOBALS["servers_keypass"][$serid]["pass"], $vpsid, "index.php?act=apidoings&do=e_install_recipes&svs=" . $vpsid, $recipe);
                if($preferences_data["result"] === true) {
                    echo "VPS Timezone will be changed to " . $timezone . "\n";
                    makequery("UPDATE vps SET timezone = :timezone\n\t\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":timezone" => $timezone, ":vpsid" => $vpsid]);
                }
            }
        }
        if(!empty($vps["fwid"])) {
            $cluster->apply_vpsfirewall_rule($vps["serid"], [$vpsid], $vps["fwid"]);
        }
        _task_update($actid, $l["prog_update5"], 80, "group");
        _task_update($actid, "", 80, "start_vps");
        echo "Starting VPS\n";
        $start_log = $cluster->startvps($vps["serid"], $vpsid);
        _task_update($actid, "", 80, "group_end");
        echo "Fetching VPS Status\n";
        $status = $cluster->vps_status([$vpsid => $vps["serid"]]);
        $start_log = print_r($start_log["output"], 1);
        logs_vps("start", $start_log, $status[$vpsid], $vpsid, $user["uid"]);
        if(empty($status[$vpsid])) {
            $error["err_start"] = combine_error() . $l["err_start"];
            task_update($actid, $error["err_start"], -1);
            return false;
        }
        if(!empty($data["control_panel"]) && $kernel->features("control_panel_live", $virt)) {
            sleep(5);
            $ret = E_api_call($servers[$vps["serid"]]["ip"], $GLOBALS["servers_keypass"][$vps["serid"]]["pass"], $vpsid, "index.php?act=apidoings&do=e_install_cp&cp=" . $data["control_panel"], []);
        }
        if(!empty($data["recipe"]) && $kernel->features("recipe_live", $vps["virt"])) {
            $tmp = get_recipe($data["recipe"]);
            foreach ($tmp as $k => $v) {
                $tmp[$k]["code"] = lang_vars_name($v["code"], ["username" => $user_email, "vps_hostname" => $vps["hostname"], "root_pass" => $newvs["pass"], "ips" => implode(", ", $vps["ips"]), "ips6" => implode(", ", $vps["ips6"]), "ips6_subnet" => implode(", ", $vps["ips6_subnet"]), "vpsid" => $vpsid]);
            }
            $recipe["recipe"] = base64_encode(serialize($tmp));
            sleep(5);
            $ret = E_api_call($servers[$vps["serid"]]["ip"], $GLOBALS["servers_keypass"][$vps["serid"]]["pass"], $vpsid, "index.php?act=apidoings&do=e_install_recipes&svs=" . $vpsid, $recipe);
        }
        if(!preg_match("/windows/is", $newvs["os_name"]) && !empty($vps["data"]["disable_password"]) && $kernel->features("recipe_live", $virt)) {
            $tmp = [];
            $tmp[0] = ["rid" => -1, "code" => "sed -i \"s/#PasswordAuthentication yes/PasswordAuthentication no/i\" /etc/ssh/sshd_config;\nsed -i \"s/PasswordAuthentication yes/PasswordAuthentication no/i\" /etc/ssh/sshd_config;\nservice sshd restart;"];
            $recipe["recipe"] = base64_encode(serialize($tmp));
            $ret = E_api_call($servers[$vps["serid"]]["ip"], $GLOBALS["servers_keypass"][$vps["serid"]]["pass"], $vpsid, "index.php?act=apidoings&do=e_install_recipes&svs=" . $vpsid, $recipe);
        }
        logs_admin("rebuild", $vps["vps_name"], 1, $vpsid, $user["uid"]);
        if(!empty($task["data"]["newvs"]["enduser_rebuild"])) {
            $res = makequery("INSERT INTO osreinstall\n\t\t\t\t\t\tSET `vpsid` = :vpsid,\n\t\t\t\t\t\t`osid` = :osid,\n\t\t\t\t\t\t`uid` = :uid,\n\t\t\t\t\t\t`time` = :time", [":vpsid" => $vps["vpsid"], ":osid" => $vps["osid"], ":uid" => $task["uid"], ":time" => time()]);
            logs_vps("os", $ostemplates[$newos]["name"], 1, $vps["vpsid"], $task["uid"]);
        }
        if(!empty($vps["vnc"])) {
            $vnc = $cluster->vncDetails($vpsid);
        }
        $done = $vpsid;
        echo "Rebuild Completed !\n";
        if($cluster->check_licensepro($vps["serid"]) && $kernel->features("load_balancer", $vps["virt"]) && $vps["load_balancer"] == -1) {
            $rules = lb_get_default_rule();
            $lb = get_load_balancer();
            if(!empty($lb[$vps["uuid"]]["settings"])) {
                $rules = $lb[$vps["uuid"]]["settings"];
            }
            foreach ($rules as $f => $fv) {
                if(in_array($fv["source_protocol"], ["https", "http2", "http3"]) && !empty($fv["ssl_id"])) {
                    $q["query"] = "SELECT * FROM `lb_ssl_certs` WHERE ssl_id = " . $fv["ssl_id"];
                    $q["id"] = "ssl_id";
                    $lb_ssl_certs = select_query($q);
                    if(!empty($lb_ssl_certs[$fv["ssl_id"]])) {
                        $rules[$f]["ssl"]["cert"] = base64_decode($lb_ssl_certs[$fv["ssl_id"]]["ssl_cert"]);
                        $rules[$f]["ssl"]["key"] = base64_decode($lb_ssl_certs[$fv["ssl_id"]]["ssl_key"]);
                    }
                }
            }
            $post["config"] = base64_encode(gzcompress(serialize($rules)));
            $ret = E_api_call($servers[$serid]["ip"], $GLOBALS["servers_keypass"][$serid]["pass"], $vpsid, "index.php?act=apidoings&do=lb_default_rule&vpsid=" . $vpsid, $post);
        }
        $task["data"]["progress_msg"] = $l["prog_update6"];
        $task["data"]["vnc"] = $vnc;
        task_update($actid, $l["prog_update6"], 100, serialize($task["data"]));
        unlockvps($vpsid);
        $callback = [];
        if(!empty($globals["enable_cb"])) {
            $callback["act"][] = "reinstall";
            $callback["data"]["os_name"] = $ostemplates[$task["data"]["newvs"]["osid"]]["name"];
            $actid = vps_task("reinstall_callback", serialize($callback), 0, $vpsid, $user["uid"], 0, $l["task_pending"]);
        }
        if(!empty($task["data"]["newvs"]["enduser_rebuild"]) || empty($GLOBALS["noemail"]) && empty($globals["email_update_client"]) && !empty($task["data"]["eu_send_rebuild_email"])) {
            $res = makequery("SELECT email\n\t\t\t\t\t\tFROM `users`\n\t\t\t\t\t  WHERE uid = :uid", [":uid" => $vps["uid"]]);
            if(0 < vsql_num_rows($res)) {
                $row = vsql_fetch_assoc($res);
                $user_email = $row["email"];
            }
            send_emailtemp_mail("rebuildvs", $user_email, ["root_pass" => $vps["load_balancer"] == -1 ? "xxxxxxx" : $newvs["pass"], "ips" => implode(", ", $vps["ips"]), "sn" => $globals["sn"], "vpsid" => $vpsid, "root_username" => username_vps($vps["osid"]), "vps_name" => $vps_name, "vncdetails" => $virt != "openvz" && !empty($vps["vnc"]) ? $l["mail_temp_vnctitle"] . "\n" . $l["mail_temp_vncdetails"] . " " . $vnc["ip"] . ":" . $vnc["port"] . "\n" . $l["mail_temp_vncpasswd"] . " " . $vnc["password"] : "", "macdetails" => $virt != "openvz" && !empty($vps["mac"]) ? $l["mac_temp_vncdetails"] . " " . $vps["mac"] : ""], 1);
            echo "Emailed User !\n";
        }
        send_emailtemp_mail("admin_rebuild_vs", $globals["soft_email"], ["root_pass" => $newvs["pass"], "ips" => implode(", ", $vps["ips"]), "sn" => $globals["sn"], "vpsid" => $vpsid, "root_username" => username_vps($vps["osid"]), "vps_name" => $vps_name, "vncdetails" => $virt != "openvz" ? !empty($vps["vnc"]) ? $l["mail_temp_vnctitle"] . "\n" . $l["mail_temp_vncdetails"] . " " . $vnc["ip"] . ":" . $vnc["port"] . "\n" . $l["mail_temp_vncpasswd"] . " " . $vnc["password"] . "" : "" : "", "macdetails" => $virt != "openvz" && !empty($vps["mac"]) ? $l["mac_temp_vncdetails"] . " " . $vps["mac"] : ""], 1);
        echo "Emailed Admin !\n";
        return true;
    }
}

?>