<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
global $error;
function razorpay_config()
{
    $configarray = ["name" => "Razorpay", "description" => "This is a sample config function for an addon module", "version" => "1.0", "author" => "Virtualizor", "fields" => ["razorpay_sandbox" => ["type" => "checkbox", "friendly_name" => "Razorpay Sandbox", "description" => ""], "razorpay_test_key" => ["type" => "text", "friendly_name" => "Razorpay Test Key", "description" => ""], "razorpay_test_secret" => ["type" => "text", "friendly_name" => "Razorpay Test Secret", "description" => ""], "razorpay_live_key" => ["type" => "text", "friendly_name" => "Razorpay Live Key", "description" => ""], "razorpay_live_secret" => ["type" => "text", "friendly_name" => "Razorpay Live Secret", "description" => ""]]];
    return $configarray;
}
function razorpay_execute_payment($data)
{
    global $globals;
    global $error;
    $post = [];
    $post["amount"] = $data["amount"] * 100;
    $post["currency"] = $data["billing_currency"];
    $post["key"] = empty($data["razorpay_sandbox"]) ? $data["razorpay_live_key"] : $data["razorpay_test_key"];
    $post["secret"] = empty($data["razorpay_sandbox"]) ? $data["razorpay_live_secret"] : $data["razorpay_test_secret"];
    $post["receipt"] = $data["token"];
    $url = "https://api.razorpay.com/v1/orders";
    if(empty($post["key"])) {
        $error[] = "Gateway key not specified";
    }
    if(empty($post["secret"])) {
        $error[] = "Gateway secret not specified";
    }
    $res = razorpay_init_curl_call($url, $post);
    if($res["httpcode"] == 200) {
        $res["result"] = json_decode($res["result"], 1);
        $res["key"] = $post["key"];
        $res["callback_url"] = $data["return_url"];
        $res["sn"] = $globals["sn"];
        echo json_encode($res);
        exit;
    }
    $error_message = json_decode($res["result"], true);
    $error[] = $error_message["error"]["description"];
    return $error;
}
function razorpay_process_payment($data)
{
    global $user_details;
    global $error;
    global $l;
    $razorpay_payment_id = optREQ("razorpay_payment_id");
    $razorpay_order_id = optREQ("razorpay_order_id");
    $razorpay_signature = optREQ("razorpay_signature");
    $secret = empty($data["razorpay_sandbox"]) ? $data["razorpay_live_secret"] : $data["razorpay_test_secret"];
    if(!empty($razorpay_payment_id)) {
        $processed_sign = hash_hmac("SHA256", $razorpay_order_id . "|" . $razorpay_payment_id, $secret, false);
        if($processed_sign == $razorpay_signature) {
            $user_details = ["fees" => 0, "status" => 1, "data" => []];
            return true;
        }
        $error[] = "Signature Mismatch";
    } else {
        $error[] = "Payment Failed";
    }
}
function razorpay_init_curl_call($url, $post = [])
{
    $resp = [];
    if(empty($url)) {
        $resp["error"] = "Undefined Parameters";
        return $resp;
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, !empty($GLOBALS["globals"]["curl_timeout"]) ? $GLOBALS["globals"]["curl_timeout"] : 3);
    curl_setopt($ch, CURLOPT_TIMEOUT, 3600);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, "Softaculous");
    $key = $post["key"];
    $secret = $post["secret"];
    unset($post["key"]);
    unset($post["secret"]);
    if(!empty($post)) {
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post));
        curl_setopt($ch, CURLOPT_USERPWD, $key . ":" . $secret);
    }
    $headers = [];
    $headers[] = "Accept: application/json";
    $headers[] = "Content-Type: application/json";
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $resp["result"] = curl_exec($ch);
    $resp["error"] = curl_error($ch);
    $resp["httpcode"] = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return $resp;
}

?>