<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function paypal_config()
{
    $configarray = ["name" => "PayPal", "description" => "This is a sample config function for an addon module", "version" => "1.0", "author" => "Virtualizor", "fields" => ["paypal_sandbox" => ["type" => "checkbox", "friendly_name" => "PayPal Sandbox", "description" => ""], "paypal_api_user" => ["type" => "text", "friendly_name" => "PayPal API Key (Username)", "description" => ""], "paypal_api_pass" => ["type" => "text", "friendly_name" => "PayPal API Pass", "description" => ""], "paypal_api_sig" => ["type" => "text", "friendly_name" => "PayPal API Signature", "description" => ""]]];
    return $configarray;
}
function paypal_execute_payment($data)
{
    global $error;
    global $l;
    $nvpStr = "&PAYMENTREQUEST_0_PAYMENTACTION=SALE&PAYMENTREQUEST_0_AMT=" . rawurlencode($data["amount"]) . "&PAYMENTREQUEST_0_ALLOWEDPAYMENTMETHOD=InstantPaymentOnly" . "&PAYMENTREQUEST_0_CURRENCYCODE=" . $data["billing_currency"] . "&PAYMENTREQUEST_0_INVNUM=" . rawurlencode($data["token"]) . "&PAYMENTREQUEST_0_CUSTOM=" . rawurlencode($data["user_id"]) . "&PAYMENTREQUEST_0_DESC=" . rawurlencode($data["billing_currency"] . " Fund Added") . "&VERSION=93" . "&PAYMENTREQUEST_0_NOTIFYURL=" . rawurlencode($data["return_url"]) . "&RETURNURL=" . rawurlencode($data["success_url"]) . "&CANCELURL=" . rawurlencode($data["fail_url"]);
    $httpParsedResponseAr = PPHttpPost("SetExpressCheckout", $nvpStr, $data);
    if("SUCCESS" == strtoupper($httpParsedResponseAr["ACK"]) || "SUCCESSWITHWARNING" == strtoupper($httpParsedResponseAr["ACK"])) {
        $url = PPURL($data);
        redirect($url . "/cgi-bin/webscr?cmd=_express-checkout&token=" . $httpParsedResponseAr["TOKEN"], 1, 1);
        return false;
    }
    $error["pay_err_ectoken"] = $l["pay_err_ectoken"];
}
function paypal_process_payment($data)
{
    global $user_details;
    global $l;
    $nvpStr = "&VERSION=93&TOKEN=" . rawurlencode(optREQ("token")) . "&PAYERID=" . rawurlencode(optREQ("PayerID"));
    $httpParsedResponseAr = PPHttpPost("GetExpressCheckoutDetails", $nvpStr, $data);
    $EC_PAYERID = optREQ("PayerID");
    $EC_INVOICE = $httpParsedResponseAr["PAYMENTREQUEST_0_INVNUM"];
    $nvpStr = "&PAYMENTREQUEST_0_PAYMENTACTION=SALE&PAYMENTREQUEST_0_AMT=" . rawurlencode($httpParsedResponseAr["PAYMENTREQUEST_0_AMT"]) . "&PAYMENTREQUEST_0_ALLOWEDPAYMENTMETHOD=InstantPaymentOnly" . "&PAYMENTREQUEST_0_CURRENCYCODE=" . $data["currency"] . "&VERSION=93" . "&TOKEN=" . rawurlencode(optREQ("token")) . "&PAYERID=" . rawurlencode($EC_PAYERID);
    $httpParsedResponseAr = PPHttpPost("DoExpressCheckoutPayment", $nvpStr, $data);
    if("SUCCESS" == strtoupper($httpParsedResponseAr["ACK"]) || "SUCCESSWITHWARNING" == strtoupper($httpParsedResponseAr["ACK"])) {
        $_REQUEST["txn_id"] = $httpParsedResponseAr["PAYMENTINFO_0_TRANSACTIONID"];
        $_REQUEST["payer_id"] = $EC_PAYERID;
        $_REQUEST["invoice"] = $EC_INVOICE;
    }
    $invoid = optREQ("invoice");
    $txn_id = optREQ("txn_id");
    $payerid = optREQ("payer_id");
    if(empty($txn_id) || empty($invoid)) {
        $error["pay_pp_missing"] = $l["pay_pp_missing"];
        return false;
    }
    $transactionID = urlencode($txn_id);
    $nvpStr = "&TRANSACTIONID=" . $transactionID;
    $details = PPHttpPost("GetTransactionDetails", $nvpStr, $data);
    if("Completed" == $details["PAYMENTSTATUS"]) {
        $user_details = ["fees" => $details["FEEAMT"], "status" => 1, "data" => ""];
    }
}
function PPHttpPost($methodName_, $nvpStr_, $data)
{
    global $error;
    global $l;
    $API_UserName = urlencode($data["paypal_api_user"]);
    $API_Password = urlencode($data["paypal_api_pass"]);
    $API_Signature = urlencode($data["paypal_api_sig"]);
    $API_Endpoint = "https://api-3t.paypal.com/nvp";
    if($data["paypal_sandbox"] == 1) {
        $API_Endpoint = "https://api-3t.sandbox.paypal.com/nvp";
    }
    $version = urlencode("51.0");
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $API_Endpoint);
    curl_setopt($ch, CURLOPT_VERBOSE, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    $nvpreq = "METHOD=" . $methodName_ . "&VERSION=" . $version . "&PWD=" . $API_Password . "&USER=" . $API_UserName . "&SIGNATURE=" . $API_Signature . $nvpStr_;
    curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpreq);
    $httpResponse = curl_exec($ch);
    if(!$httpResponse) {
        $error["pay_pp_connect"] = $l["pay_pp_connect"];
        return false;
    }
    parse_str($httpResponse, $httpParsedResponseAr);
    if(0 == sizeof($httpParsedResponseAr) || !array_key_exists("ACK", $httpParsedResponseAr)) {
        $error["pay_pp_resp"] = $l["pay_pp_resp"];
        return false;
    }
    return $httpParsedResponseAr;
}
function PPURL($data)
{
    global $error;
    if($data["paypal_sandbox"] == 1) {
        $url = "https://www.sandbox.paypal.com";
    } else {
        $url = "https://www.paypal.com";
    }
    return $url;
}

?>