<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once "inc.php";
global $theme;
global $globals;
global $kernel;
global $user;
global $l;
global $error;
global $cluster;
global $servers;
global $oslist;
global $done;
if(!load_lang("admin/passthrough")) {
    return false;
}
if(!function_exists("readline")) {
    function readline($prompt = NULL)
    {
        if($prompt) {
            echo $prompt;
        }
        $fp = fopen("php://stdin", "r");
        $line = rtrim(fgets($fp, 1024));
        return $line;
    }
}
run_function("1");
while (true) {
    $input = readline("Enter The number as per your need: ");
    if($input == 0) {
        break;
    }
    run_function($input);
    echo "\n\n\n";
}
function run_function($input)
{
    global $l;
    $options = [$l["quit"], $l["print_all"], $l["list_pci"], $l["list_iommu_grp"], $l["check_iommu"], $l["enable_iommu"], $l["enable_interrupt_mapping"], $l["blacklist_modules"], $l["dump_vga_bios"], $l["check_interrupt_remapping"], $l["VFIO_Modules"]];
    if(!isset($options[$input])) {
        print_r($l["Invalid_option"]);
    } else {
        $check_iommu_support = function () {
            global $servers;
            global $cluster;
            global $l;
            $iommu_support = $cluster->pci_manager(0, "", "iommu_support");
            if($iommu_support) {
                echo $l["iommu_supported"];
            } else {
                echo $l["iommu_not_supported"];
            }
        };
        $check_interrupt_remapping = function () {
            global $cluster;
            global $l;
            $cpu = $cluster->cpu(0);
            $interrupt_remapping = $cluster->pci_manager(0, $cpu, "interrupt_remapping");
            if($interrupt_remapping) {
                echo $l["iommu_interrupt_supported"];
            } else {
                echo $l["iommu_interrupt_not_supported"];
            }
        };
        $enable_iommu = function () {
            global $servers;
            global $cluster;
            global $l;
            $os = $servers[0]["os"];
            $cpu = $cluster->cpu(0);
            if(!empty($os) && preg_match("/AlmaLinux|Centos/is", $os)) {
                exec("cat /etc/default/grub | grep GRUB_CMDLINE_LINUX", $out, $ret);
                if($ret == "0" && !empty($out[0]) && !empty($cpu["manu"])) {
                    if(preg_match("/amd/is", $cpu["manu"]) && preg_match("/amd_iommu|iommu_pt/is", $out[0])) {
                        print_r($l["grub_edit"] . PHP_EOL . PHP_EOL . preg_replace("/\"\$/i", " amd_iommu=on iommu=pt video=efifb:off\"", $out[0]));
                    } elseif(preg_match("/intel/is", $cpu["manu"])) {
                        print_r($l["grub_edit"] . PHP_EOL . PHP_EOL . preg_replace("/\"\$/i", " intel_iommu=on iommu=pt \"", $out[0]));
                    }
                    print_r(PHP_EOL . "Execute following command " . PHP_EOL . "update-grub or update-grub2" . PHP_EOL);
                }
            }
            if(!empty($os) && preg_match("/ubuntu/is", $os)) {
                exec("cat /etc/default/grub | grep GRUB_CMDLINE_LINUX", $out, $ret);
                if($ret == "0" && !empty($out[0]) && !empty($cpu["manu"])) {
                    if(preg_match("/amd/is", $cpu["manu"]) && !preg_match("/amd_iommu|intel_iommu|iommu/is", $out[0])) {
                        print_r($l["grub_edit"] . PHP_EOL . PHP_EOL . preg_replace("/\"\$/i", " amd_iommu=on iommu=pt video=efifb:off\"", $out[0]));
                    } elseif(preg_match("/intel/is", $cpu["manu"]) && !preg_match("/intel_iommu|amd_iommu|iommu/is", $out[0])) {
                        print_r($l["grub_edit"] . PHP_EOL . PHP_EOL . preg_replace("/\"\$/i", " intel_iommu=on iommu=pt\"", $out[0]));
                    }
                    print_r(PHP_EOL . "Execute following command " . PHP_EOL . "update-grub or update-grub2" . PHP_EOL);
                }
            }
        };
        $list_iommu_group = function () {
            global $globals;
            oexec("bash " . $globals["path"] . "/scripts/iommu_grp.sh", $out, $ret);
            print_r($out);
        };
        $enable_interrupt_mapping = function () {
            print_r("echo \"options vfio_iommu_type1 allow_unsafe_interrupts=1\" > /etc/modprobe.d/iommu_unsafe_interrupts.conf");
        };
        $modules_to_load = function () {
            global $globals;
            global $servers;
            global $l;
            $os = $servers[0]["os"];
            if(!empty($os) && preg_match("/AlmaLinux|Centos/is", $os)) {
                echo $l["modules_to_load_redhat"] . PHP_EOL . "vfio" . PHP_EOL . "vfio_iommu_type1" . PHP_EOL . "vfio_pci" . PHP_EOL . "vfio_virqfd";
            } elseif(!empty($os) && preg_match("/ubuntu/is", $os)) {
                echo $l["modules_to_load_ubuntu"] . PHP_EOL . "vfio" . PHP_EOL . "vfio_iommu_type1" . PHP_EOL . "vfio_pci" . PHP_EOL . "vfio_virqfd";
            }
        };
        $blacklisting_drivers = function () {
            print_r("echo \"blacklist radeon\" >> /etc/modprobe.d/blacklist.conf" . PHP_EOL . "echo \"blacklist nouveau\" >> /etc/modprobe.d/blacklist.conf" . PHP_EOL . "echo \"blacklist nvidia\" >> /etc/modprobe.d/blacklist.conf");
        };
        $dumps_bios = function () {
            global $globals;
            global $l;
            print_r($l["gpu_id"] . PHP_EOL . "echo 1 > /sys/bus/pci/devices/0000:01:00.0/rom" . PHP_EOL . "cat /sys/bus/pci/devices/0000:01:00.0/rom > /usr/share/vbios.rom" . PHP_EOL . "echo 0 > /sys/bus/pci/devices/0000:01:00.0/rom");
        };
        $list_pci = function () {
            global $globals;
            oexec("lspci -nn", $out, $ret);
            print_r($out);
        };
        if($input == 1) {
            foreach ($options as $key => $value) {
                print_r($key . " " . $value . PHP_EOL);
            }
        } elseif($input == 2) {
            $list_pci();
        } elseif($input == 3) {
            $list_iommu_group();
        } elseif($input == 4) {
            $check_iommu_support();
        } elseif($input == 5) {
            $enable_iommu();
        } elseif($input == 6) {
            $enable_interrupt_mapping();
        } elseif($input == 7) {
            $blacklisting_drivers();
        } elseif($input == 8) {
            $dumps_bios();
        } elseif($input == 9) {
            $check_interrupt_remapping();
        } elseif($input == 10) {
            $modules_to_load();
        }
    }
}

?>