<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function managevdf()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $cluster;
    global $user;
    global $l;
    global $haproxydata;
    global $arr_haproxy_src_ips;
    global $supported_protocols;
    global $error;
    global $vpses;
    global $done;
    global $server_haconfigs;
    global $servers;
    global $vpsuuid;
    global $vps;
    $theme["init_theme"] = "managevdf";
    $theme["init_theme_name"] = "managevdf";
    $theme["init_theme_func"] = ["managevdf_theme"];
    $theme["call_theme_func"] = "managevdf_theme";
    if(!empty($user["vps"]["suspended"])) {
        $error[] = $l["vps_is_suspended"];
        return false;
    }
    if(!empty($globals["disable_domain_forward"])) {
        $error[] = $l["disable_domain_forward"];
        return false;
    }
    $vps = getvps($globals["vpsid"]);
    $serid = (int) $user["vps"]["serid"];
    $vpsuuid = $vps["uuid"];
    $res = makequery("SELECT ipid, ip, vpsid \n\t\t\t\t\tFROM ips \n\t\t\t\t\tWHERE vpsid = :vpsid \n\t\t\t\t\tAND ipv6 = 0", [":vpsid" => $vps["vpsid"]]);
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $vps["ips"][$row["ip"]] = $row;
    }
    $server_info = get_slave_settings($serid);
    $server_haconfigs = ["haproxy_enable" => $server_info["haproxy_enable"], "haproxy_src_ips" => $server_info["haproxy_src_ips"], "haproxy_reservedports" => $server_info["haproxy_reservedports"], "haproxy_reservedports_http" => $server_info["haproxy_reservedports_http"], "haproxy_allowedports" => $server_info["haproxy_allowedports"]];
    $arr_haproxy_src_ips = !empty($server_haconfigs["haproxy_src_ips"]) ? preg_split("/\\s*\\,\\s*/", trim($server_haconfigs["haproxy_src_ips"])) : [server_publicip($user["vps"]["serid"])];
    $supported_protocols = ["HTTP", "HTTPS", "TCP"];
    $haproxydata = [];
    $haproxydata = gethaproxylist();
    $action = optPOST("vdf_action");
    if(empty($action)) {
        $error["action"] = $l["no_action"];
        return false;
    }
    if(!empty($action)) {
        $protocol = optPOST("protocol");
        $src_port = (int) optPOST("src_port");
        $dest_port = (int) optPOST("dest_port");
        $src_hostname = optPOST("src_hostname");
        $dest_ip = optPOST("dest_ip");
        $id = (int) optPOST("vdfid");
        $ids = optPOST("ids");
        $log_str = "";
        if($action == "addvdf" || $action == "editvdf") {
            $log_str = $l["vdf_source"] . " (" . $src_hostname . ":" . $src_port . ") " . $l["vdf_destination"] . " (" . $dest_ip . ":" . $dest_port . ") " . $l["vdf_proto"] . ": " . $protocol;
            if(!in_array($protocol, $supported_protocols)) {
                $error["proto"] = lang_vars_name($l["vdf_proto_no_support"], ["protocolid" => $protocol]);
                return false;
            }
            if(!validate_ports_list($dest_port)) {
                unset($error["validate_ports_list"]);
                $error["dest_port"] = lang_vars_name($l["vdf_inv_dest_port"], ["dest_port" => $dest_port]);
            }
            if(!validate_ports_list($src_port)) {
                unset($error["validate_ports_list"]);
                $error["src_port"] = lang_vars_name($l["vdf_inv_src_port"], ["src_port" => $src_port]);
            }
            if($protocol == "TCP" && empty($server_haconfigs["haproxy_src_ips"])) {
                $error["empty_allowed_src_ips"] = $l["vdf_empty_allowed_src_ips"];
                return false;
            }
            if(!validate_ports_list($src_port, $server_haconfigs["haproxy_allowedports"], 1)) {
                unset($error["validate_ports_list"]);
                $error["src_port"] = lang_vars_name($l["vdf_notin_haproxy_allowedports"], ["src_port" => $src_port]);
                return false;
            }
            if(!validate_ports_list($src_port, $server_haconfigs["haproxy_reservedports"])) {
                unset($error["validate_ports_list"]);
                $error["src_port"] = lang_vars_name($l["vdf_in_haproxy_reservedports"], ["src_port" => $src_port]);
                return false;
            }
            $update = true;
            if(!empty($id)) {
                $update = false;
                if($haproxydata[$id]["serid"] != $serid || $haproxydata[$id]["src_hostname"] != $src_hostname || $haproxydata[$id]["src_port"] != $src_port) {
                    $update = true;
                }
            }
            $new = ["serid" => $serid, "src_hostname" => $src_hostname, "src_port" => $src_port];
            if($update && !vdf_no_duplicates($new, $serid)) {
                $error["err_exist_src_hostname_and_port"] = lang_vars_name($l["vdf_err_exist_src_hostname_and_port"], ["src_hostname" => $src_hostname, "src_port" => $src_port]);
                return false;
            }
            if($protocol == "TCP") {
                if(empty($src_hostname) || !valid_ip($src_hostname) || $src_hostname == -1) {
                    $error["src_hname"] = lang_vars_name($l["vdf_inv_src_ip"], ["src_ip" => $src_hostname]);
                } else {
                    $found = false;
                    foreach ($arr_haproxy_src_ips as $k => $v) {
                        if($v == $src_hostname) {
                            $found = true;
                        }
                    }
                    if(!$found) {
                        $error["src_hname"] = lang_vars_name($l["vdf_not_available_src_ip"], ["src_ip" => $src_hostname]);
                        return false;
                    }
                }
                if(!validate_ports_list($src_port, $server_haconfigs["haproxy_reservedports_http"])) {
                    unset($error["validate_ports_list"]);
                    $error["src_port"] = lang_vars_name($l["vdf_in_haproxy_reservedports_http"], ["src_port" => $src_port]);
                    return false;
                }
            } elseif(($protocol == "HTTP" || $protocol == "HTTPS") && (!is_valid_domain_name($src_hostname) || valid_ip($src_hostname))) {
                $error["src_hname"] = lang_vars_name($l["vdf_inv_src_hostname"], ["src_hostname" => $src_hostname]);
                return false;
            }
            if(($src_port == 80 || $src_port == 443) && $protocol == "TCP") {
                $error["dest_port"] = lang_vars_name($l["vdf_port_not_supported_tcp"], ["src_port" => $src_port]);
            }
            if(!valid_ip($dest_ip) || !array_key_exists($dest_ip, $vps["ips"])) {
                $error["dest_ip"] = lang_vars_name($l["vdf_inv_dest_ip"], ["dest_ip" => $dest_ip]);
            }
            if(!empty($error)) {
                return false;
            }
            if(empty($haproxydata[$id]) || $src_port != $haproxydata[$id]["src_port"]) {
                $where_tcp = "AND protocol = 'TCP'";
                $tokens = [];
                if($protocol == "TCP") {
                    $where_tcp = "AND ((protocol = 'TCP' AND src_hostname = :src_hostname) OR (protocol != 'TCP'))";
                    $tokens[":src_hostname"] = $src_hostname;
                }
                $tokens[":serid"] = $serid;
                $tokens[":src_port"] = $src_port;
                $res = makequery("SELECT id, protocol \n\t\t\t\t\t\t\t\tFROM haproxy \n\t\t\t\t\t\t\t\tWHERE serid = :serid\n\t\t\t\t\t\t\t\t" . $where_tcp . " \n\t\t\t\t\t\t\t\tAND src_port = :src_port", $tokens);
                if(0 < vsql_num_rows($res)) {
                    $error["src_port"] = lang_vars_name($l["vdf_in_use_src_port"], ["src_port" => $src_port]);
                }
            }
            if(!empty($error)) {
                return false;
            }
            $tokens = [];
            $tokens[":vpsuuid"] = $vpsuuid;
            $tokens[":serid"] = $serid;
            $tokens[":protocol"] = $protocol;
            $tokens[":src_hostname"] = $src_hostname;
            $tokens[":src_port"] = $src_port;
            $tokens[":dest_ip"] = $dest_ip;
            $tokens[":dest_port"] = $dest_port;
            if($action == "addvdf") {
                $tokens[":timeadded"] = time();
                $query = "INSERT INTO haproxy \n\t\t\t\t\t\tSET vpsuuid = :vpsuuid, \n\t\t\t\t\t\tserid = :serid, \n\t\t\t\t\t\tprotocol = :protocol, \n\t\t\t\t\t\tsrc_hostname = :src_hostname, \n\t\t\t\t\t\tsrc_port = :src_port, \n\t\t\t\t\t\tdest_ip = :dest_ip, \n\t\t\t\t\t\tdest_port = :dest_port, \n\t\t\t\t\t\ttimeadded = :timeadded";
                $res = insert_and_id($query, $tokens);
                $done["id"] = $res;
                $done["msg"] = $l["vdf_success_add"] . "\n" . ($protocol != "TCP" ? lang_vars_name($l["vdf_note_point_domain"], ["src_hostname" => $src_hostname, "ips_list" => implode("\n", $arr_haproxy_src_ips)]) : "");
                logs_vps($l["vdf_domain_forwarding"], $l["vdf_added"] . ":<br />" . $res . ": " . $log_str, 1, $vps["vpsid"], $user["uid"]);
            } elseif($action == "editvdf") {
                $tokens[":id"] = $id;
                $tokens[":timeupdated"] = time();
                $query = "UPDATE `haproxy` \n\t\t\t\t\t\tSET vpsuuid = :vpsuuid,\n\t\t\t\t\t\tserid = :serid, \n\t\t\t\t\t\tprotocol = :protocol, \n\t\t\t\t\t\tsrc_hostname = :src_hostname,\n\t\t\t\t\t\tsrc_port = :src_port, \n\t\t\t\t\t\tdest_ip = :dest_ip, \n\t\t\t\t\t\tdest_port = :dest_port, \n\t\t\t\t\t\ttimeupdated = :timeupdated \n\t\t\t\t\t\tWHERE id = :id \n\t\t\t\t\t\tAND vpsuuid = :vpsuuid \n\t\t\t\t\t\tAND serid = :serid";
                $res = update_query($query, $tokens);
                if($res != 1) {
                    $error["query"] = $res;
                }
                $done["msg"] = $l["vdf_success_save"];
                logs_vps($l["vdf_domain_forwarding"], $l["vdf_updated"] . ":<br />" . $id . ": " . $log_str, 1, $vps["vpsid"], $user["uid"]);
            }
        }
        if($action == "delvdf") {
            $log_str = "";
            if(empty($ids) && isset($id)) {
                $ids = [$id];
            } else {
                $ids = explode(",", trim($ids));
            }
            foreach ($ids as $k => $v) {
                $log_str .= $v . ": " . $l["vdf_source"] . " (" . $haproxydata[$v]["src_hostname"] . ":" . $haproxydata[$v]["src_port"] . ") " . $l["vdf_destination"] . " (" . $haproxydata[$v]["dest_ip"] . ":" . $haproxydata[$v]["dest_port"] . ") " . $l["protocol"] . ": " . $haproxydata[$v]["protocol"] . "<br />";
                if(!in_array($v, array_keys($haproxydata))) {
                    $error["vdfids"] .= lang_vars_name($l["vdf_no_id_found"], ["id" => $v]) . "\n";
                }
            }
            if(!empty($error)) {
                return false;
            }
            $ptoks = vsql_in_tokens($ids, "01");
            $res = makequery("DELETE FROM `haproxy` \n\t\t\t\t\t\t\tWHERE id IN (" . $ptoks["query"] . ")", $ptoks["tokens"]);
            unset($ptoks);
            $done["msg"] = $l["vdf_success_del_entries"];
            logs_vps($l["vdf_domain_forwarding"], $l["vdf_removed" . (!isset($id) ? "_multiple" : "") . ""] . ":<br />" . $log_str, 1, $vps["vpsid"], $user["uid"]);
        }
        $ckernel->save_haproxy($vps["vpsid"]);
    }
    if(!empty($error)) {
        return false;
    }
}
function gethaproxylist($all = 0)
{
    global $globals;
    global $vps;
    global $vpsuuid;
    $haproxydata = [];
    $tok = [];
    $tok[":serid"] = $vps["serid"];
    if(empty($all)) {
        $tok[":vpsuuid"] = $vpsuuid;
    }
    $res = makequery("SELECT h.*, v.vpsid, v.vps_name, v.hostname \n\t\t\t\t\tFROM haproxy h \n\t\t\t\t\tJOIN vps v on (v.uuid = h.vpsuuid) \n\t\t\t\t\tWHERE h.serid = :serid" . (!empty($all) ? "" : " AND vpsuuid = :vpsuuid"), $tok);
    unset($tok);
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        if($row["skipped"] != "") {
            $row["skipped"] = _unserialize($row["skipped"]);
            $row["skipped_json"] = json_encode($row["skipped"]);
        } else {
            $row["skipped"] = "";
        }
        $haproxydata[$row["id"]] = $row;
    }
    return $haproxydata;
}
function API_managevdf()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $haproxydata;
    global $arr_haproxy_src_ips;
    global $supported_protocols;
    global $vpses;
    global $done;
    global $server_haconfigs;
    global $vpsuuid;
    global $vps;
    $vpses = [];
    $vpses[$vps["uuid"]] = ["vpsid" => $vps["vpsid"], "uuid" => $vps["uuid"], "vps_name" => $vps["vps_name"], "serid" => $vps["serid"], "uid" => $vps["uid"], "hostname" => $vps["hostname"], "ips" => $vps["ips"]];
    $GLOBALS["_api"]["haproxydata"] = $haproxydata;
    $GLOBALS["_api"]["supported_protocols"] = $supported_protocols;
    $GLOBALS["_api"]["vpses"] = $vpses;
    $GLOBALS["_api"]["arr_haproxy_src_ips"] = $arr_haproxy_src_ips;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["server_haconfigs"] = [$vps["serid"] => $server_haconfigs];
}

?>