<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function manageserver()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $usage;
    global $info;
    global $cluster;
    global $servers;
    if(!load_lang("admin/manageserver")) {
        return false;
    }
    $theme["init_theme"] = "admin/manageserver";
    $theme["init_theme_name"] = "manageserver";
    $theme["init_theme_func"] = ["manageserver_theme"];
    $theme["call_theme_func"] = "manageserver_theme";
    if(!is_allowed("manageserver")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    header("Cache-Control: no-cache, must-revalidate");
    header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
    if(optGET("reboot")) {
        if(!is_allowed("rebootserver")) {
            reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
            return false;
        }
        $GLOBALS["rebooted"] = $cluster->reboot($globals["server"]);
    }
    if(!is_allowed("server_statistics")) {
        return false;
    }
    $virt = optREQ("virt");
    if(!empty($virt) && in_array($virt, $servers[$globals["server"]]["virts"])) {
    } else {
        $virt = "";
    }
    $show = optGET("show");
    $manager_server_fetch = $cluster->club_manageserver_call($globals["server"], $show, $virt);
    $usage["cpu"] = $manager_server_fetch["cpu"];
    $usage["ram"] = $manager_server_fetch["ram"];
    $usage["disk"] = $manager_server_fetch["disk"];
    $usage["inodes"] = $manager_server_fetch["inodes"];
    $usage["bandwidth"] = $manager_server_fetch["bandwidth"];
    $usage["io"] = $manager_server_fetch["io"];
    $info["check_kernel"] = $manager_server_fetch["check_kernel"];
    $info["os"] = $manager_server_fetch["resources"]["os"];
    $info["details"] = $GLOBALS["servers"][$globals["server"]];
    $info["numvps"] = $servers[$globals["server"]]["numvps"];
    $info["ips"] = $manager_server_fetch["ips"];
    $info["hostname"] = $manager_server_fetch["hostname"];
    $info["status"] = $manager_server_fetch["status"];
    $info["uptime"] = $manager_server_fetch["uptime"];
    $info["resources"] = $manager_server_fetch["resources"];
    $info["kernel_name"] = $manager_server_fetch["kernel_name"];
}
function API_manageserver()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $usage;
    global $info;
    global $cluster;
    $hypervisor_status = $cluster->statewise($globals["server"]);
    if($hypervisor_status == 0 || $hypervisor_status == 2) {
        $GLOBALS["_api"]["offline"] = $l["server_status_" . $hypervisor_status];
    } else {
        if(!empty($GLOBALS["rebooted"])) {
            $GLOBALS["_api"]["rebooted"] = $GLOBALS["rebooted"];
        }
        $GLOBALS["_api"]["usage"] = $usage;
        $GLOBALS["_api"]["info"] = $info;
    }
}

?>