<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function manage_load_balancer()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $v;
    global $host;
    global $current;
    global $error;
    global $done;
    global $onboot;
    global $load_balancer;
    global $cluster;
    global $servergroups;
    global $vpses;
    global $save_settings_done;
    global $lb_uuid;
    global $edit_settings_done;
    global $lb_ssl_certs;
    global $remove_rule_done;
    global $lb_status;
    global $remove_vps_done;
    global $lb_stats;
    global $lb_logs;
    if(!load_lang("admin/manage_load_balancer")) {
        return false;
    }
    $theme["init_theme"] = "admin/manage_load_balancer";
    $theme["init_theme_name"] = "manage_load_balancer";
    $theme["init_theme_func"] = ["manage_load_balancer_theme"];
    $theme["call_theme_func"] = "manage_load_balancer_theme";
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    if(!is_allowed("manage_load_balancer")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    if(!check_licensepro() && empty($globals["is_master_only"])) {
        $error[] = $l["require_prolic"];
        return false;
    }
    $lb_uuid = optREQ("lb_uuid");
    if(empty($lb_uuid)) {
        redirect("act=load_balancer");
    }
    $load_balancer = get_load_balancer(["vps_uuid" => $lb_uuid])[$lb_uuid];
    if(empty($load_balancer)) {
        redirect("act=load_balancer");
    }
    $no_stats = optREQ("no_stats");
    if(empty($no_stats)) {
        $lb_stats = lb_get_stats($lb_uuid, $load_balancer["ip"]);
    }
    $no_logs = optREQ("no_logs");
    if(empty($no_logs)) {
        $lb_logs = lb_get_logs($lb_uuid);
    }
    $get_stats = optREQ("get_stats");
    if(!empty($get_stats)) {
        return false;
    }
    $lb_status = lb_get_status($lb_uuid);
    $vpses = lb_get_vps($lb_uuid);
    $q["query"] = "SELECT ssl_id, ssl_name FROM `lb_ssl_certs`";
    $q["id"] = "ssl_id";
    $lb_ssl_certs = select_query($q);
    $save_settings_done = $edit_settings_done = $remove_rule_done = $remove_vps_done = 0;
    $save_settings = optREQ("save_settings");
    $edit_settings = optREQ("edit_settings");
    if(!empty($save_settings) || !empty($edit_settings)) {
        $lb_method = POST((!empty($edit_settings) ? "edit_" : "") . "lb_method", $l["no_lb_method"]);
        $source_protocol = POST((!empty($edit_settings) ? "edit_" : "") . "source_protocol", $l["no_source_protocol"]);
        $source_port = (int) POST((!empty($edit_settings) ? "edit_" : "") . "source_port", $l["no_source_port"]);
        $dest_protocol = POST((!empty($edit_settings) ? "edit_" : "") . "dest_protocol", $l["no_dest_protocol"]);
        $dest_port = (int) POST((!empty($edit_settings) ? "edit_" : "") . "dest_port", $l["no_dest_port"]);
        if(!empty($error)) {
            return false;
        }
        if(empty($edit_settings) && !empty($load_balancer["settings"]) && isset($load_balancer["settings"][$source_port . "_" . $dest_port])) {
            $error[] = $l["rule_exists"];
            return false;
        }
        if(!empty($edit_settings)) {
            $old_key = optPOST("old_key");
            $reinstall_ssl = optPOST("reinstall_ssl");
            if(in_array($source_protocol, ["https", "http2", "http3"]) && $source_port != $load_balancer["settings"][$old_key]["source_port"]) {
                $reinstall_ssl = 1;
            }
            $ssl_id = $load_balancer["settings"][$old_key]["ssl_id"];
        }
        if(in_array($source_protocol, ["https", "http2", "http3"]) && (!empty($save_settings) || !empty($edit_settings) && (!empty($reinstall_ssl) || $load_balancer["settings"][$old_key]["source_protocol"] == "http"))) {
            $ssl_options = POST((!empty($edit_settings) ? "edit_" : "") . "ssl_options", $l["no_ssl_options"]);
            if(!empty($error)) {
                return false;
            }
            $file_name = $source_port . "_" . $dest_port;
            if($ssl_options == "create") {
                $cluster->lb_self_signed_cert($load_balancer["serid"], $lb_uuid, $file_name);
            } elseif($ssl_options == "use_own") {
                $chain = optPOST((!empty($edit_settings) ? "edit_" : "") . "chain");
                $ssl_name = POST((!empty($edit_settings) ? "edit_" : "") . "ssl_name", $l["no_ssl_name"]);
                $cert = POST((!empty($edit_settings) ? "edit_" : "") . "cert", $l["no_cert"]);
                $key = POST((!empty($edit_settings) ? "edit_" : "") . "key", $l["no_key"]);
                if(!empty($error)) {
                    return false;
                }
                $ssl_id = insert_and_id("INSERT INTO `lb_ssl_certs` SET \n\t\t\t\t\t\t\t\t\t\t\t`ssl_name` = :ssl_name, \n\t\t\t\t\t\t\t\t\t\t\t`ssl_cert` = :ssl_cert,\n\t\t\t\t\t\t\t\t\t\t\t`ssl_key` = :ssl_key,\n\t\t\t\t\t\t\t\t\t\t\t`ssl_chain` = :ssl_chain", [":ssl_name" => $ssl_name, ":ssl_cert" => base64_encode($cert), ":ssl_key" => base64_encode($key), ":ssl_chain" => $chain]);
                $cluster->lb_use_own_cert($load_balancer["serid"], $lb_uuid, ["cert" => $cert, "key" => $key], $file_name);
            } elseif(0 < $ssl_options) {
                $ssl_id = $ssl_options;
                $q["query"] = "SELECT * FROM `lb_ssl_certs` WHERE `ssl_id` = :ssl_id";
                $q["id"] = "ssl_id";
                $q["token"] = [":ssl_id" => $ssl_id];
                $certs = select_query($q);
                if(empty($certs[$ssl_id])) {
                    $error[] = $l["no_valid_certs"];
                    return false;
                }
                $cluster->lb_use_own_cert($load_balancer["serid"], $lb_uuid, ["cert" => base64_decode($certs[$ssl_id]["ssl_cert"]), "key" => base64_decode($certs[$ssl_id]["ssl_key"])], $file_name);
            }
        }
        if(!empty($edit_settings) && $old_key != $source_port . "_" . $dest_port) {
            unset($load_balancer["settings"][$old_key]);
        }
        $load_balancer["settings"][$source_port . "_" . $dest_port] = ["source_protocol" => $source_protocol, "source_port" => $source_port, "dest_protocol" => $dest_protocol, "dest_port" => $dest_port, "lb_method" => $lb_method, "ssl_id" => $ssl_id];
        makequery("UPDATE `load_balancer` \n\t\t\t\tSET settings = :settings \n\t\t\t\tWHERE vps_uuid = :vps_uuid", [":settings" => json_encode($load_balancer["settings"]), ":vps_uuid" => $lb_uuid]);
        $cluster->lb_save_config($load_balancer["serid"], $lb_uuid, $load_balancer["settings"]);
        if(!empty($edit_settings)) {
            $edit_settings_done = 1;
        } else {
            $save_settings_done = 1;
        }
        return true;
    }
    $remove_vps = (int) optREQ("remove_vps");
    if(!empty($remove_vps)) {
        $res = makequery("SELECT serid FROM vps WHERE vpsid = :vpsid", [":vpsid" => $remove_vps]);
        if(vsql_num_rows($res) < 1) {
            $error[] = $l["no_valid_vps"];
            return false;
        }
        $vps = vsql_fetch_assoc($res);
        $delete_vm = (int) optREQ("delete_vm");
        $vps_data = getvps($remove_vps);
        if(!empty($vps_data["locked"]) && !empty($delete_vm)) {
            $error_msg = $l["lb_vps_is_locked"];
            $error[] = $error_msg;
            return false;
        }
        update_query("UPDATE `vps` SET load_balancer = null \n\t\t\t\t\t\t\tWHERE vpsid = :vpsid", ["vpsid" => $remove_vps]);
        $cluster->sync($load_balancer["serid"]);
        if(!empty($delete_vm)) {
            $data = ["progress_msg" => $l["prog_begin"], "serid" => $vps["serid"]];
            $actid = tasks_admin_process("deletevs", serialize($data), 10, $remove_vps, $user["uid"], 0, 0, $l["initiate_del"]);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/deletevs.php " . $actid . " > " . logdir("deletevs") . $remove_vps . ".log 2>&1 &");
        }
        lb_refresh_config($lb_uuid);
        $remove_vps_done = 1;
    }
    $remove_rule = optREQ("remove_rule");
    if(!empty($remove_rule)) {
        $settings = $load_balancer["settings"];
        if(empty($settings[$remove_rule])) {
            $error[] = $l["no_valid_rule"];
            return false;
        }
        unset($load_balancer["settings"][$remove_rule]);
        makequery("UPDATE `load_balancer` \n\t\t\t\tSET settings = :settings \n\t\t\t\tWHERE vps_uuid = :vps_uuid", [":settings" => json_encode($load_balancer["settings"]), ":vps_uuid" => $lb_uuid]);
        $cluster->lb_save_config($load_balancer["serid"], $lb_uuid, $load_balancer["settings"]);
        $remove_rule_done = 1;
        return true;
    }
}
function API_manage_load_balancer()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $v;
    global $host;
    global $current;
    global $error;
    global $done;
    global $load_balancer;
    global $vpses;
    global $save_settings_done;
    global $edit_settings_done;
    global $lb_uuid;
    global $remove_rule_done;
    global $lb_status;
    global $remove_vps_done;
    global $lb_stats;
    global $lb_ssl_certs;
    global $lb_logs;
    if(!empty($save_settings_done)) {
        $GLOBALS["_api"]["save_settings_done"] = $save_settings_done;
    }
    if(!empty($edit_settings_done)) {
        $GLOBALS["_api"]["edit_settings_done"] = $edit_settings_done;
    }
    if(!empty($remove_rule_done)) {
        $GLOBALS["_api"]["remove_rule_done"] = $remove_rule_done;
    }
    if(!empty($remove_vps_done)) {
        $GLOBALS["_api"]["remove_vps_done"] = $remove_vps_done;
    }
    $get_stats = optREQ("get_stats");
    if(empty($get_stats)) {
        $GLOBALS["_api"]["load_balancer"] = $load_balancer;
        $GLOBALS["_api"]["vpses"] = $vpses;
        $GLOBALS["_api"]["lb_status"] = $lb_status;
        $GLOBALS["_api"]["lb_ssl_certs"] = $lb_ssl_certs;
    }
    $GLOBALS["_api"]["lb_stats"] = $lb_stats;
    $GLOBALS["_api"]["lb_logs"] = $lb_logs;
}

?>