<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
class kvm
{
    public $loaded = 0;
    public $status = [];
    public $status_statewise = [];
    public $forcestatus = [];
    public $type = "kvm";
    public $user = [];
    public $bandwidth_device = "";
    public function __construct()
    {
        if(!empty($GLOBALS["globals"]["interface"])) {
            $this->bandwidth_device = $GLOBALS["globals"]["interface"];
        }
    }
    public function conf($vpsid, $conf_name)
    {
        if(in_array($conf_name, ["onboot_changepass", "onboot_hostname", "onboot_cp", "iso_support", "sec_iso_support", "cpu_pinning", "win_support", "vnc_support", "vnc_key_map", "hvm_support", "cpu_mode", "virtio", "cpu_topology", "cpu_threads", "video", "ha", "file_backup_support", "fstrim_handle", "perf_ops", "vga_vram", "vps_ram_info", "enable_guest_agent", "inc_backup", "vertical_scaling", "boot_order"])) {
            return true;
        }
        if(in_array($conf_name, ["load_balancer", "vertical_scaling"])) {
            if(check_licensepro()) {
                return true;
            }
            return false;
        }
        if(in_array($conf_name, ["disks_support", "multiple_disk_support", "rescue_support", "kvm_cache", "io_mode", "format_primary", "iops_sec", "use_dd_migrate", "post_migrate", "disk_hotplug", "ssd_emulation"])) {
            return true;
        }
        if(in_array($conf_name, ["build_dhcp", "mac_support", "change_dns", "ebtables_support", "nw_config"])) {
            return true;
        }
        if($conf_name == "vncpasslen") {
            return 8;
        }
        if($conf_name == "nic") {
            $nictypes["virtio"] = 1;
            $nictypes["default"] = 1;
            $nictypes["e1000"] = 1;
            return array_keys($nictypes);
        }
        if($conf_name == "cpu_mode_list") {
            $cpu_modes["default"] = "Default";
            $cpu_modes["host-model"] = "Host Model";
            $cpu_modes["host-passthrough"] = "Host Passthrough";
            return $cpu_modes;
        }
        if($conf_name == "storage_types") {
            return ["block", "file", "thin block", "zfs block", "zfs thin block", "zfs block compressed", "zfs thin block compressed", "ceph block", "lightbit block"];
        }
        if($conf_name == "possible_mig_virts") {
            return ["xen"];
        }
        if($conf_name == "live_mig") {
            return ["kvm"];
        }
        if($conf_name == "bios") {
            return ["seabios" => "seabios Default", "uefi" => "UEFI"];
        }
        if(in_array($conf_name, ["passthrough", "usb_passthrough", "pci_passthrough"])) {
            return true;
        }
        return false;
    }
    public function vps_uuid($vid)
    {
        $vps_uuid_run = $this->vps_uuid_run($vid);
        if(!empty($vps_uuid_run)) {
            return $vps_uuid_run;
        }
        $path = "/etc/libvirt/qemu/" . $this->getname($vid) . ".xml";
        $config_xml = xmlstring2array(file_get_contents($path));
        if(!empty($config_xml["uuid"])) {
            return $config_xml["uuid"];
        }
        if(!empty($config_xml["domain"]["uuid"])) {
            return $config_xml["domain"]["uuid"];
        }
    }
    public function vps_uuid_run($vid)
    {
        $path = "/var/run/libvirt/qemu/" . $this->getname($vid) . ".xml";
        $config_xml = xmlstring2array(file_get_contents($path));
        if(!empty($config_xml["uuid"])) {
            return $config_xml["uuid"];
        }
        if(!empty($config_xml["domain"]["uuid"])) {
            return $config_xml["domain"]["uuid"];
        }
    }
    public function new_vps_name($suggested_name = "")
    {
        vexec("/usr/bin/virsh list", $output, $return);
        unset($output[0]);
        unset($output[1]);
        $ret = empty($suggested_name) ? 1001 : str_replace("v", "", $suggested_name);
        foreach ($output as $k => $v) {
            $v = trim($v);
            if(empty($v)) {
            } else {
                $v = preg_split("/[\\s]+/", $v);
                $v[1] = trim($v[1]);
                $names[$v[1]] = $v[1];
            }
        }
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\tAND virt = 'kvm'\n\t\t\t\t\t\tORDER BY vps_name DESC");
        if(0 < vsql_num_rows($res)) {
            for ($x = 0; $x < vsql_num_rows($res); $x++) {
                $row = vsql_fetch_assoc($res);
                $row["vps_name"] = trim($row["vps_name"]);
                $names[$row["vps_name"]] = $row["vps_name"];
                $tmp_int = (int) $row["vps_name"];
                if($ret < $tmp_int && $tmp_int < 2000) {
                    $ret = $tmp_int + 1;
                }
            }
        }
        $x = 0;
        while ($x < 100000) {
            if(in_array("v" . $ret, $names) || in_array($ret, $names)) {
                $ret = $ret + 1;
                $x++;
                break;
            }
        }
        return "v" . $ret;
    }
    public function get_raw_conf($vpsid)
    {
        $vps_name = $this->getname($vpsid);
        return file_get_contents("/etc/libvirt/qemu/" . $vps_name . ".xml");
    }
    public function getconf($vid)
    {
        $vps_name = $this->getname($vid);
        if(empty($this->conf[$vid])) {
            $r = [];
            $tmp = file("/etc/libvirt/qemu/" . $vps_name . ".xml");
            foreach ($tmp as $k => $l) {
                $tmp[$k] = trim(preg_replace("/(\\#(.*))/is", "", trim($l)));
                if(empty($tmp[$k])) {
                } else {
                    return $tmp;
                }
            }
            foreach ($r as $k => $v) {
                $r[$k] = trim($v, "\"");
            }
            $this->conf[$vid] = $r;
        }
        return $r;
    }
    public function getname($vid)
    {
        global $user;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            return $user["vps"]["vps_name"];
        }
        if($vps = getvps($vid)) {
            return $vps["vps_name"];
        }
        return false;
    }
    public function stop($vid)
    {
        global $l;
        $vps = getvps($vid);
        $vps_name = $this->getname($vid);
        $actid = vps_task("stop_vps", "", 0, $vid, $vps["uid"], 0, $l["stop_vps"]);
        task_start($actid);
        task_update($actid, $l["stop_vps"], 57);
        if(!empty($vps["ha"])) {
            vexec("/usr/sbin/pcs resource delete resource_" . $vps["vps_name"] . "_" . $vps["uuid"]);
            sleep(1);
        }
        oexec("/usr/bin/virsh shutdown " . xss($this->vps_uuid($vid)), $output);
        writefile(logdir("stop") . $vid . ".log", $output, 1);
        $autostart = "/etc/libvirt/qemu/autostart";
        if(file_exists($autostart . "/" . $vps_name . ".xml")) {
            @unlink($autostart . "/" . $vps_name . ".xml");
        }
        task_update($actid, $l["stop_vps_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function poweroff($vid)
    {
        global $l;
        $vps = getvps($vid);
        $status = $this->vps_status_statewise($vid);
        if($status == 2) {
            return false;
        }
        $actid = vps_task("poweroff_vps", "", 0, $vid, $vps["uid"], 0, $l["power_off_vps"]);
        task_start($actid);
        task_update($actid, $l["power_off_vps"], 60);
        if(!empty($vps["ha"])) {
            vexec("/usr/sbin/pcs resource delete resource_" . $vps["vps_name"] . "_" . $vps["uuid"]);
            sleep(1);
        }
        $vps_name = $this->getname($vid);
        oexec("/usr/bin/virsh destroy " . xss($this->vps_uuid($vid)), $output);
        writefile(logdir("poweroff") . $vid . ".log", $output, 1);
        $autostart = "/etc/libvirt/qemu/autostart";
        if(file_exists($autostart . "/" . $vps_name . ".xml")) {
            @unlink($autostart . "/" . $vps_name . ".xml");
        }
        task_update($actid, $l["power_off_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        return $out;
    }
    public function start($vid, &$sret = "")
    {
        global $user;
        global $globals;
        global $l;
        $vps = getvps($vid);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        writefile(logdir("start") . $vid . ".log", "Attempting to Start VM \n", 1);
        $vps_name = $this->getname($vid);
        if(!file_exists("/etc/libvirt/qemu/" . $vps_name . ".xml")) {
            log_message(logdir("start") . $vid . ".log", "Copying file from kvm-conf to libvirt \n");
            @copy($globals["var"] . "/kvm-conf/" . $vps_name . ".xml", "/etc/libvirt/qemu/" . $vps_name . ".xml");
            @chmod("/etc/libvirt/qemu/" . $vps_name . ".xml", 384);
        }
        if($this->status($vid, 1) == 1) {
            return false;
        }
        $actid = vps_task("start_vps", "", 0, $vid, $vps["uid"], 0, $l["beginning_start_vps"]);
        task_start($actid);
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\t\tAND started = 0 \n\t\t\t\t\t\tAND updated = 0 \n\t\t\t\t\t\tAND ended = 0\n\t\t\t\t\t\tORDER BY actid ASC", [":vid" => $vid]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $tasks[$row["actid"]] = $row;
            }
        }
        $apply_lb_rule = 0;
        if(!empty($tasks)) {
            task_update($actid, $l["performing_vps_pending_tasks"], 5);
            foreach ($tasks as $k => $v) {
                if($v["action"] == "changepassword") {
                    _task_update($actid, $l["change_password"], 20, $v["actid"]);
                    $this->changepassword($vid, json_decode(base64_decode($v["data"])), $v["actid"]);
                    logs_vps("changepassword", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "remotedesktop") {
                    _task_update($actid, $l["remotedesktop"], 22, $v["actid"]);
                    $this->remotedesktop($vid, $v["data"], $v["actid"]);
                    logs_vps("remotedesktop", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "hostname") {
                    _task_update($actid, $l["change_hostname"], 25, $v["actid"]);
                    $this->changehostname($vid, $v["data"], $v["actid"]);
                    logs_vps("hostname", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_cp") {
                    _task_update($actid, $l["install_cp"], 27, $v["actid"]);
                    $this->install_cp($vid, $v["data"], $v["actid"]);
                    logs_vps("install_cp", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "change_dnsnameserver") {
                    _task_update($actid, $l["change_dnsnameserver"], 30, $v["actid"]);
                    $this->change_dnsnameserver($v["data"], $v["actid"]);
                    logs_vps("change_dnsnameserver", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "resizevps") {
                    _task_update($actid, $l["resize_vps"], 32, $v["actid"]);
                    $this->resizevps($vid, $v["actid"]);
                    logs_vps("resizevps", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "fstab_handle") {
                    _task_update($actid, $l["fstab_handle"], 35, $v["actid"]);
                    $this->fstab_handle($vid, [], $v["actid"]);
                    logs_vps("fstab_handle", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "delete_vpsdisks") {
                    _task_update($actid, $l["delete_vpsdisks"], 37, $v["actid"]);
                    $del_data = _unserialize($v["data"]);
                    $this->delete_vpsdisks($vid, $del_data, $v["actid"]);
                    logs_vps("delete_vpsdisks", $del_data, 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_recipe") {
                    _task_update($actid, $l["install_recipe"], 40, $v["actid"]);
                    $recipe = _unserialize($v["data"]);
                    $this->install_recipe($vid, $recipe, $v["actid"]);
                    logs_vps("install_recipe", !array_key_exists("rid", $recipe) ? implode(", ", array_keys($recipe)) : $recipe["rid"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "addsshkeys") {
                    _task_update($actid, $l["add_sshkeys"], 42, $v["actid"]);
                    $ssh_keys = _unserialize($v["data"]);
                    $this->addsshkeys($vid, $ssh_keys, $v["actid"]);
                    logs_vps("addsshkeys", $ssh_keys, 1, $vid, $user["uid"]);
                }
                if($v["action"] == "removesshkeys") {
                    _task_update($actid, $l["remove_sshkeys"], 43, $v["actid"]);
                    $ssh_keys = _unserialize($v["data"]);
                    $this->removesshkeys($vid, $ssh_keys, $v["actid"]);
                    logs_vps("removesshkeys", $v["data"], 1, $vid, $user["uid"]);
                }
                if($v["action"] == "fstrim_handle") {
                    $this->fstrim_handle($vid, [], $v["actid"]);
                    logs_vps("fstrim_handle", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "install_ga") {
                    $this->install_ga($vid, [], $v["actid"]);
                    logs_vps("install_ga", "", 1, $vid, $user["uid"]);
                }
                if($v["action"] == "apply_lb_rule") {
                    $apply_lb_rule["actid"] = $v["actid"];
                    $apply_lb_rule["data"] = unserialize($v["data"]);
                }
                if($v["action"] == "change_winips") {
                    $this->change_winips($vid, [], $v["actid"]);
                    logs_vps("change_winips", "", 1, $vid, $user["uid"]);
                }
            }
        }
        _task_update($actid, $l["performing_startup_process"], 43, "group");
        $this->onstartup($vid);
        _task_update($actid, "", 45, "group_end");
        $conf_path = "/etc/libvirt/qemu/" . $vps_name . ".xml";
        $conf = file_get_contents($conf_path);
        if(preg_match("/<graphics(\\s*?)(.*?)(\\s*?)passwd\\=('|\")(.*?)('|\")/is", $conf, $passtmp)) {
            $pass = $passtmp[5];
        }
        if(8 < strlen($pass)) {
            $new_pass = substr($pass, 0, 8);
            $conf = str_replace($pass, $new_pass, $conf);
            file_put_contents($conf_path, $conf);
        }
        $config = file_get_contents($conf_path);
        if(!empty($config)) {
            oexec("virsh undefine " . ($vps["data"]["bios"] == "uefi" ? "--nvram " : "") . xss($vps_name), $output, $ret);
            writefile($conf_path, $config, 1);
            @chmod($conf_path, 384);
        } else {
            task_update($actid, $l["err_get_conf_file"], -1);
        }
        task_update($actid, $l["call_hook_before_startvps"], 45);
        apply_filters("before_startvps", $vps);
        task_update($actid, $l["first_create_conf"], 52);
        oexec("/usr/bin/virsh define " . xss($conf_path) . " 2>&1", $o, $sr);
        $this->vnc_fix($vid);
        oexec("/usr/bin/virsh create " . xss($conf_path) . " 2>&1", $output, $sret);
        if(preg_match("/Failed to reserve port/s", $output)) {
            $this->reconfigure_vnc_port($vid);
        }
        if(preg_match("/Unable to open \\/dev\\/net\\/tun/s", $output)) {
            vexec("mkdir -p /dev/net");
            vexec("mknod /dev/net/tun c 10 200");
            vexec("chmod 600 /dev/net/tun");
        }
        if(!file_exists($conf_path)) {
            task_update($actid, $l["err_first_create_conf"], 57);
            @chmod($conf_path, 384);
        }
        oexec("ls -lha " . xss($conf_path) . " 2>&1", $output);
        if($sret != "0") {
            task_update($actid, $l["second_create_conf"], 64);
            sleep(2);
            oexec("/usr/bin/virsh define " . xss($conf_path) . " 2>&1", $o, $sr);
            oexec("/usr/bin/virsh create " . xss($conf_path) . " 2>&1", $output, $sret);
        }
        if($sret != "0") {
            oexec("/usr/bin/virsh start " . xss($vps_name) . " 2>&1", $out, $sret);
        }
        $this->vncDetails($vid);
        sleep(2);
        _task_update($actid, $l["tc_rule_create"], 72, "group");
        $this->tc_create($vid);
        _task_update($actid, $l["tc_rule_done"], 72, "group_end");
        if(!empty($vps["nw_suspended"])) {
            $this->suspend_vps_net($vps["vpsid"]);
        }
        $autostart = "/etc/libvirt/qemu/autostart";
        if(empty($vps["ha"]) && !file_exists($autostart . "/" . $vps_name . ".xml")) {
            task_update($actid, $l["set_autostart"], 79);
            if(!is_dir($autostart)) {
                @mkdir($autostart);
            }
            vexec("/bin/ln -s " . xss($conf_path) . " " . xss($autostart . "/" . $vps_name . ".xml") . " 2>/dev/null");
        }
        if(!empty($vps["ha"])) {
            vexec("/usr/sbin/pcs resource create  resource_" . $vps["vps_name"] . "_" . $vps["uuid"] . " VirtualDomain hypervisor=\"qemu:///system\" config=" . xss("/etc/libvirt/qemu/" . $vps_name . ".xml") . " migration_transport=ssh op start timeout=\"120s\" op stop timeout=\"120s\" op monitor  timeout=\"30\" interval=\"10\"  meta allow-migrate=\"true\" priority=\"100\" op migrate_from interval=\"0\" timeout=\"120s\" op migrate_to interval=\"0\" timeout=\"120\"");
        }
        if(!empty($apply_lb_rule)) {
            $this->lb_default_rule($vid, $apply_lb_rule["data"], $apply_lb_rule["actid"]);
            logs_vps("apply_lb_rule", "", 1, $vid, $user["uid"]);
        }
        task_update($actid, $l["call_hook_after_startvps"], 88);
        apply_filters("after_startvps", $vps);
        task_update($actid, $l["start_done"], 100);
        $out = [];
        $out["output"] = $output;
        $out["taskid"] = $actid;
        $ram_log_path = logdir("/scaling/ver_scaling/") . $vps["vpsid"] . "_ram";
        unlink($ram_log_path);
        $cpu_log_path = logdir("/scaling/ver_scaling/") . $vps["vpsid"] . "_cpu";
        unlink($cpu_log_path);
        return $out;
    }
    public function vnc_fix($vpsid)
    {
        $vps = getvps($vpsid);
        $file_path = "/etc/libvirt/qemu/" . $vps["vps_name"] . ".xml";
        $file_cont = file_get_contents($file_path);
        preg_match("/\\<graphics (.*)(\\/\\>)/", $file_cont, $mat);
        if(!empty($mat)) {
            preg_match("/\\<\\/graphics\\>/", $file_cont, $mat2);
            if(!empty($mat2)) {
                $file_cont = str_replace($mat[0], "<graphics " . $mat[1] . " >", $file_cont);
            }
        }
        file_put_contents($file_path, $file_cont);
    }
    public function detach_disk($vpsid, $path)
    {
        global $globals;
        global $servers;
        global $cluster;
        global $kernel;
        global $l;
        $ret = [];
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return false;
        }
        $actid = vps_task("detach_volume", "", 0, $vpsid, $vps["uid"], 0, $l["task_started"]);
        task_start($actid);
        task_update($actid, "detach_volume", 30);
        vexec("virsh detach-disk --domain " . $vps["vps_name"] . " " . $path . " --persistent --config --live 2>&1", $output, $return);
        if($return != 0) {
            $ret["error"]["detach_disk"] = $output;
            task_update($actid, print_r($output, 1), -1);
            return $ret;
        }
        task_update($actid, $l["completed"], 100);
        return $ret;
    }
    public function hotplug_disk($vpsid, $disk, $mnt = "")
    {
        global $globals;
        global $servers;
        global $cluster;
        global $kernel;
        global $l;
        $ret = [];
        if(empty($vpsid)) {
            return false;
        }
        $vps = getvps($vpsid);
        if(empty($vps) || empty($disk)) {
            return false;
        }
        $actid = vps_task("hotplug_disk", "", 0, $vpsid, $vps["uid"], 0, $l["task_started"]);
        task_start($actid);
        task_update($actid, "hotplug_disk", 30);
        vexec("virsh domblklist " . $vps["vps_name"] . " --details | awk {' print  \$2, \$3 '} 2>&1", $o, $r);
        if($r != 0) {
            $ret["error"]["hotplug_disk"] = $o[0];
            task_update($actid, print_r($o, 1), -1);
            return $ret;
        }
        $ext = "";
        $bus = "";
        foreach ($o as $k => $v) {
            if(preg_match("/disk/is", $v) && (preg_match("/vd(.*)/is", $v, $m) || preg_match("/hd(.*)/is", $v, $m))) {
                $ext = end($m);
                $bus = reset($m);
            }
        }
        if(3 <= strlen($bus) && empty($ext)) {
            $ret["error"]["hotplug_disk"] = $l["invalid_new_disk"];
            task_update($actid, $l["invalid_new_disk"], -1);
            return $ret;
        }
        $new_disk_bus = substr($bus, 0, 2);
        $next_char = ++$ext;
        if(1 < strlen($next_char)) {
            $ret["error"]["hotplug_disk"] = $l["invalid_new_disk"];
            task_update($actid, $l["invalid_new_disk"], -1);
            return $ret;
        }
        $new_disk = trim($new_disk_bus . $next_char);
        if(!preg_match("/hd([a-z])|vd([a-z])/", $new_disk)) {
            $ret["error"]["hotplug_disk"] = $l["invalid_new_disk"];
            task_update($actid, $l["invalid_new_disk"], -1);
            return $ret;
        }
        if(!empty($mnt) && !empty($vps["data"]["enable_guest_agent"])) {
            $og_disk = $this->ga_exec($vpsid, "lsblk", ["-r"]);
            $og_disk = implode("\n", $og_disk);
            preg_match_all("/(s|v)d[a-z][^0-9]/", $og_disk, $matches);
            if(!empty($matches[0])) {
                $og_disk_arr = array_map("rtrim", $matches[0]);
            }
        }
        $drivers = ["1" => "virtio", "2" => "scsi"];
        $bus_driver = $drivers[$vps["virtio"]];
        if(preg_match("/file/is", $disk["type"])) {
            vexec("virsh attach-disk --domain " . $vps["vps_name"] . " " . $disk["path"] . " --target " . $new_disk . " --driver qemu --subdriver " . $disk["format"] . "  " . (!empty($bus_driver) ? "--targetbus " . $bus_driver : "") . " --persistent --config --live 2>&1", $output, $return);
        } else {
            vexec("virsh attach-disk --domain " . $vps["vps_name"] . " " . $disk["path"] . " --target " . $new_disk . " " . (!empty($bus_driver) ? "--targetbus " . $bus_driver : "") . " --persistent --config --live 2>&1", $output, $return);
        }
        if($return != 0) {
            $ret["error"]["hotplug_disk"] = $output[0];
            task_update($actid, print_r($output, 1), -1);
            return $ret;
        }
        if(!empty($mnt) && !empty($vps["data"]["enable_guest_agent"])) {
            $new_disk = $this->ga_exec($vpsid, "lsblk", ["-r"]);
            $new_disk = implode("\n", $new_disk);
            preg_match_all("/(s|v)d[a-z][^0-9]/", $new_disk, $matches);
            if(!empty($matches[0])) {
                $new_disk_arr = array_map("rtrim", $matches[0]);
            }
            if(!empty($new_disk_arr) && !empty($og_disk_arr)) {
                $_disk_name = array_merge(array_diff($og_disk_arr, $new_disk_arr), array_diff($new_disk_arr, $og_disk_arr));
            }
            $disk_name = !empty($_disk_name[0]) ? $_disk_name[0] : "";
            if(preg_match("/sd([a-z])|vd([a-z])/", trim($disk_name))) {
                $this->ga_exec($vpsid, "mkdir", [$mnt]);
                $k = $this->ga_exec($vpsid, "mount", ["/dev/" . $disk_name, $mnt]);
            }
        }
        task_update($actid, $l["completed"], 100);
        return $ret;
    }
    public function reconfigure_vnc_port($vid)
    {
        $vps = getvps($vid);
        if(!empty($vps["vnc"])) {
            $vncport = $this->_newVncPort();
            to_master("vps", "vncport", $vps["vpsid"], "vpsid", $vncport);
            $cfg = "/etc/libvirt/qemu/" . $vps["vps_name"] . ".xml";
            $doc = new DOMDocument();
            if(!$doc->load($cfg)) {
                return NULL;
            }
            $vps_xp = new DOMXpath($doc);
            $vnc_elems = $vps_xp->query("//graphics[@type='vnc']");
            $vnc_elem = $vnc_elems->item(0);
            $vnc_elem->setAttribute("port", $vncport);
            $doc->save($cfg);
        }
    }
    public function restart($vid)
    {
        global $l;
        $vps = getvps($vid);
        if(!empty($vps["suspended"])) {
            return 0;
        }
        $actid = vps_task("restart_vps", "", 0, $vid, $vps["uid"], 0, $l["restart_vps"]);
        task_start($actid);
        task_update($actid, $l["restart_vps"], 57);
        if($this->status($vid) == 0) {
            task_update($actid, $l["restart_vps_done"], 100);
            return $this->start($vid);
        }
        $vps_name = $this->getname($vid);
        if(!empty($vps["ha"])) {
            vexec("/usr/sbin/pcs resource delete resource_" . $vps["vps_name"] . "_" . $vps["uuid"]);
            sleep(1);
        }
        oexec("/usr/bin/virsh shutdown " . xss($this->vps_uuid($vid)), $output);
        for ($i = 1; $i <= 60; $i++) {
            $status = no_log_status($vid, 1, $this);
            if($status != 0 && $i != 60) {
                sleep(1);
            } elseif($status == 0) {
            } elseif($i == 60) {
                oexec("/usr/bin/virsh destroy " . xss($this->vps_uuid($vid)), $output);
            }
        }
        sleep(2);
        task_update($actid, $l["restart_vps_done"], 100);
        $output = $this->start($vid);
        $out = [];
        $out["output"] = $output["output"];
        $out["taskid"] = $actid;
        return $out;
    }
    public function onstartup($vid)
    {
        global $globals;
        global $user;
        global $ostemplates;
        global $l;
        if($this->status($vid, 1) == 1) {
            return -1;
        }
        $vps = getvps($vid);
        $vps_name = $vps["vps_name"];
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
        }
        $this->ebtables_remove($vid);
        if(!empty($vps["ubc"])) {
            $this->tc_destroy($vid);
            unset($vps["ubc"]);
            $ubc_res = makequery("UPDATE vps SET ubc = '' WHERE vpsid=:vpsid", [":vpsid" => $vps["vpsid"]]);
            to_master("vps", "ubc", $vps["vpsid"], "vpsid", "");
            $vps = getvps($vid, 0);
        }
        $vif_name = $this->vifname($vid);
        $mac_addr = $this->getmac($vid);
        $vinf_name = $this->vifname($vid, 1);
        $int_mac_addr = $this->getmac($vid, 1);
        vs_ebtables_add($vid, $vif_name, $mac_addr, $vinf_name, $int_mac_addr);
        $mount = mount($vid, "", 1);
        if(is_array($mount)) {
            vexec("df -P " . xss($mount["mount_point"]) . " 2>/dev/null", $tmp_out, $tmp_ret);
            $elements = preg_split("/\\s+/", $tmp_out[1]);
            $vps_disk_usage = ["Filesystem" => $elements[0], "1K-blocks" => $elements[1], "Used" => $elements[2], "Available" => $elements[3], "Use%" => $elements[4], "mounted_on" => $elements[5]];
            vexec("df -Pi " . xss($mount["mount_point"]) . " 2>/dev/null", $itmp_out, $itmp_ret);
            $elements = preg_split("/\\s+/", $itmp_out[1]);
            $vps_inode_usage = ["Filesystem" => $elements[0], "Inodes" => $elements[1], "IUsed" => $elements[2], "IFree" => $elements[3], "IUse%" => $elements[4], "mounted_on" => $elements[5]];
            if(!empty($vps_disk_usage) || !empty($vps_inode_usage)) {
                $tmp_data = ["disk" => $vps_disk_usage, "inode" => $vps_inode_usage];
                to_master("vps", "cached_disk", $vps["vpsid"], "vpsid", serialize($tmp_data));
            }
            if(file_exists($mount["mount_point"] . "/etc/shadow") && empty($globals["disable_nw_config"]) && empty($vps["disable_nw_config"])) {
                if(empty($ips[0])) {
                    $umount = umount($mount);
                    return false;
                }
                $routing = $ips[0]["routing"];
                $post = [];
                if(!empty($vps["dns_nameserver"])) {
                    $dns = unserialize($vps["dns_nameserver"]);
                    $post["dns"] = $dns;
                }
                network_configure($mount["mount_point"], $ips, $post, $routing);
            }
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["kvm_err_unmount"];
                return false;
            }
        }
        return true;
    }
    public function ebtables_remove($vid)
    {
        global $globals;
        $vps = getvps($vid);
        $vps_name = $vps["vps_name"];
        $vif_name = $this->vifname($vid);
        vs_ebtables_remove($vps_name, $vif_name);
    }
    public function changehostname($vid, $host, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("hostname", $host, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "hostname", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return true;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(file_exists($mount["mount_point"] . "/etc/shadow")) {
            hostname_configure($mount["mount_point"], $host);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function resizevps($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("resizevps", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "resizevps", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        $disks = get_vps_DISKS($vid);
        foreach ($disks as $dk => $DISK) {
            $disk_size = vpsdisk_size($DISK);
            if(empty($disk_size) || $DISK["size"] <= $disk_size) {
            } else {
                $resize = vpsdisk_resize($vid, $DISK["path"]);
                if(!empty($resize["error"])) {
                    $error = merge_error($error, $resize["error"]);
                    task_update($actid, $l["vpsdisk_resize_err"], -1);
                    return false;
                }
                if(empty($resize["altered_partitions"])) {
                } elseif(!empty($DISK["primary"])) {
                    $DISK["diskinfo"] = $resize["diskinfo"];
                    $fs_resize = vpsdisk_resize_filesystem($DISK);
                    if(!empty($fs_resize["error"])) {
                        $error = merge_error($error, $fs_resize["error"]);
                        task_update($actid, $l["kvm_err_resizefs"], -1);
                        return false;
                    }
                }
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vifname($vid, $internal = 0)
    {
        $vps = getvps($vid);
        $inf_type = $internal ? "vinf" : "viif";
        if(!empty($vps["ubc"]) && $vps["ubc"]["imported_from"] == "solusvm" && isset($vps["ubc"][$inf_type . "_name"])) {
            return $vps["ubc"][$inf_type . "_name"];
        }
        return $inf_type . $vps["vps_name"];
    }
    public function tc_create($vid)
    {
        $interface = $this->vifname($vid);
        return vs_tc_create($vid, $interface);
    }
    public function tc_destroy($vid)
    {
        $interface = $this->vifname($vid);
        return vs_tc_destroy($interface);
    }
    public function change_dnsnameserver($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("change_dnsnameserver", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "change_dnsnameserver", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["change_onboot"], 57);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return true;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        dns_configure($mount["mount_point"], $vps);
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function change_winips($vid, $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("change_winips", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["change_onboot"], 57);
        perform_vps_operation($vid, 0, "config_network", ["config_network" => ["pub" => $this->getmac($vid), "int" => $this->getmac($vid, 1)]]);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function fstab_handle($vid, $_mount = [], $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("fstab_handle", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "fstab_handle", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        if(empty($_mount)) {
            $mount = mount($vid);
        } else {
            $mount = $_mount;
        }
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return true;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(file_exists($mount["mount_point"] . "/etc/fstab") && is_safe_file($mount["mount_point"] . "/etc/fstab")) {
            $file = file_get_contents($mount["mount_point"] . "/etc/fstab");
            if(!empty($vps["virtio"]) && $vps["virtio"] == 1 && preg_match("/sda2/is", $file)) {
                $file = str_replace("sda2", "vda2", $file);
            }
            if((empty($vps["virtio"]) || $vps["virtio"] == 2) && preg_match("/vda2/is", $file)) {
                $file = str_replace("vda2", "sda2", $file);
            }
            writefile($mount["mount_point"] . "/etc/fstab", $file, 1);
        }
        if(empty($_mount)) {
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["kvm_err_unmount"];
                task_update($actid, $l["kvm_err_unmount"], -1);
                return false;
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function editvps($vid)
    {
        $this->tc_destroy($vid);
        return $this->createvps($vid, 0);
    }
    public function createvps($vid, $create = 1, $format_primary = 0)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        global $error;
        global $l;
        $vps = getvps($vid, 0);
        $action = "edit_vps";
        if(!empty($create)) {
            $action = "create_vps";
        }
        $actid = vps_task($action, "", 0, $vid, $vps["uid"], 0, $l["beginning_creation"]);
        task_start($actid);
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        $vps_name = $vps["vps_name"];
        $data_decode = $vps["data"];
        if(empty($oslist)) {
            oslist();
        }
        task_update($actid, $l["beginning_creation"], 5);
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        $isopath = $sec_isopath = $isotype = $sec_isotype = "";
        if(!empty($vps["iso"])) {
            $isopath = iso_path($vps["uid"], $vps["iso"], $isotype);
            task_update($actid, $l["downloading_iso"], 10);
            getos($isopath, $isotype);
        }
        if(!empty($vps["sec_iso"])) {
            $sec_isopath = iso_path($vps["uid"], $vps["sec_iso"], $sec_isotype);
            task_update($actid, $l["downloading_iso2"], 15);
            getos($sec_isopath, $sec_isotype);
        }
        if(!empty($data_decode["bios"]) && preg_match("/uefi/is", $data_decode["bios"])) {
            $uefi = 1;
        }
        if(!empty($vps["boot"]) && unserialize($vps["boot"])) {
            $vps["boot"] = unserialize($vps["boot"]);
            $total_count = count($disks) + (!empty($vps["iso"]) ? 1 : 0) + (!empty($vps["sec_iso"]) ? 1 : 0);
            if(count($vps["boot"]) != $total_count) {
                $bootorder = [];
                if(!empty($vps["iso"])) {
                    array_push($bootorder, "cdrom1");
                }
                if(!empty($vps["sec_iso"])) {
                    array_push($bootorder, "cdrom2");
                }
                for ($i = 1; $i < count($disks) + 1; $i++) {
                    array_push($bootorder, "disk" . $i);
                }
                $vps["boot"] = $bootorder;
            }
        } else {
            $bootorder = [];
            if($vps["boot"] == "cda" || $vps["boot"] == "dca") {
                if($vps["boot"] == "dca" && !empty($vps["iso"])) {
                    array_push($bootorder, "cdrom1");
                }
                if($vps["boot"] == "dca" && !empty($vps["sec_iso"])) {
                    array_push($bootorder, "cdrom2");
                }
                for ($i = 1; $i < count($vps["disks"]) + 1; $i++) {
                    array_push($bootorder, "disk" . $i);
                }
                if(!empty($vps["iso"]) && $vps["boot"] == "cda") {
                    array_push($bootorder, "cdrom1");
                }
                if(!empty($vps["sec_iso"]) && $vps["boot"] == "cda") {
                    array_push($bootorder, "cdrom2");
                }
            } else {
                if(!empty($vps["iso"])) {
                    array_push($bootorder, "cdrom1");
                }
                if(!empty($vps["sec_iso"])) {
                    array_push($bootorder, "cdrom2");
                }
                for ($i = 1; $i < count($disks) + 1; $i++) {
                    array_push($bootorder, "disk" . $i);
                }
            }
            $vps["boot"] = $bootorder;
            to_master("vps", "boot", $vid, "vpsid", serialize($vps["boot"]));
        }
        if(!empty($create) && !defined("DONT_DD_OS_TEMPLATE")) {
            if(!empty($vps["osid"])) {
                task_update($actid, $l["downloading_os"], 20);
                getos($ostemplates[$vps["osid"]]["filename"], "kvmos");
            }
            if(empty($ostemplates[$vps["osid"]]) || !file_exists($globals["kvmos"] . "/" . $ostemplates[$vps["osid"]]["filename"])) {
                $noos = true;
            }
            if(empty($vps["iso"]) || !file_exists($globals[$isotype] . "/" . $isopath)) {
                $noiso = true;
            }
            if(isset($noos) && isset($noiso)) {
                $error[] = $l["build_no_os_iso"];
                task_update($actid, $l["build_no_os_iso"], -1);
                return false;
            }
        }
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        $internal = 0;
        $internal_mac = 0;
        $vlan_bridge = 0;
        $mtu = 0;
        $mtu_internal = 0;
        $has_normal_ip = 0;
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
            if(empty($ips[$i]["internal"])) {
                $has_normal_ip = 1;
            }
            if(!empty($ips[$i]["internal"])) {
                $internal = $ips[$i]["bridge"];
                if(!empty($ips[$i]["mac_addr"]) && empty($internal_mac)) {
                    $internal_mac = $ips[$i]["mac_addr"];
                }
            } elseif(!empty($ips[$i]["vlan"])) {
                $vlan_bridge = $ips[$i]["bridge"];
            }
            $t_mtu = intval($ips[$i]["mtu"]);
            if(0 < $t_mtu) {
                if(!empty($ips[$i]["internal"]) && $mtu_internal == 0) {
                    $mtu_internal = $t_mtu;
                } elseif($ips[$i]["primary"] == 1 && $mtu == 0) {
                    $mtu = $t_mtu;
                }
            }
            unset($t_mtu);
        }
        if(empty($ips[0])) {
            $error[] = $l["build_no_ip"];
            task_update($actid, $l["build_no_ip"], -1);
            return false;
        }
        $nat = $ips[0]["nat"];
        $nat_name = $ips[0]["nat_name"];
        $routing = $ips[0]["routing"];
        $cfg = "/etc/libvirt/qemu/" . $vps_name . ".xml";
        $mac_flag = 0;
        if(!empty($create)) {
            if(empty($ips[0]["mac_addr"])) {
                $mac = substr_replace(new_mac(), !empty($globals["custom_mac"]) ? $globals["custom_mac"] : "00:16:3e", 0, 8);
                $mac_flag = 1;
            } else {
                $mac = $ips[0]["mac_addr"];
            }
            $internal_mac = !empty($internal_mac) ? $internal_mac : substr_replace(new_mac(), !empty($globals["custom_mac"]) ? $globals["custom_mac"] : "00:16:3e", 0, 8);
            $vncport = !empty($GLOBALS["use_vnc_port"]) ? $GLOBALS["use_vnc_port"] : $this->_newVncPort();
        } else {
            $tmp = file($cfg);
            if(preg_match("/<uuid>(.*?)<\\/uuid>/is", implode("", $tmp), $uuidtmp)) {
                $uuid = trim($uuidtmp[1]);
            }
            $vncdetails = $this->vncDetails($vid);
            $vncpass = $vncdetails["password"];
            $vncport = !empty($vncdetails["port"]) ? $vncdetails["port"] : $this->_newVncPort();
            $tmp_xml = xmlstring2array(implode("", $tmp));
            $interface_tmp = is_array($tmp_xml["devices"]["interface"][0]) ? $tmp_xml["devices"]["interface"] : [$tmp_xml["devices"]["interface"]];
            foreach (["viif", "vinf"] as $k => $v) {
                $rest = 0;
                if(preg_match("/<mac address/i", implode("", $tmp)) && !empty($interface_tmp[$k]["mac"]["@attributes"]["address"])) {
                    $rest = $interface_tmp[$k]["mac"]["@attributes"]["address"];
                }
                if(!empty($rest)) {
                    $tmac = $rest;
                } else {
                    $tmac = substr_replace(new_mac(), !empty($globals["custom_mac"]) ? $globals["custom_mac"] : "00:16:3e", 0, 8);
                    $mac_flag = 1;
                }
                if($v == "viif") {
                    $mac = !empty($ips[0]["mac_addr"]) ? $ips[0]["mac_addr"] : $tmac;
                } elseif($v == "vinf" && empty($internal_mac)) {
                    $internal_mac = $tmac;
                }
            }
        }
        if(!empty($vps["mac"])) {
            $mac = $vps["mac"];
        }
        if(!empty($ips[0]["mac_addr"])) {
            $mac = $ips[0]["mac_addr"];
        }
        task_update($actid, $l["preparing_config_file"], 23);
        $extra = empty($ostemplates[$vps["osid"]]["extra"]) ? "" : $ostemplates[$vps["osid"]]["extra"];
        $vncpass = empty($vncpass) ? generateRandStr(8) : $vncpass;
        $res = makequery("SELECT uid, inhouse_billing FROM users \n\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $vps["uid"]]);
        $_user = vsql_fetch_assoc($res);
        oexec("/usr/bin/uuidgen", $tuuid);
        $uuid = empty($uuid) ? trim($tuuid) : $uuid;
        $min_ram = $vps["ram"] * 1024;
        $min_vcpu = $vps["cores"];
        if(!preg_match("/windows/is", $vps["os_name"]) && !empty($globals["inhouse_billing"]) && !empty($_user["inhouse_billing"])) {
            $vps_data = $vps["data"];
            $max_ram = $min_ram;
            if(!empty($globals["ver_max_ram"])) {
                $max_ram = $globals["ver_max_ram"] * 1024;
            }
            if(!empty($vps_data["ver_max_ram"])) {
                $max_ram = $vps_data["ver_max_ram"] * 1024;
            }
            if($max_ram < $min_ram) {
                $max_ram = $min_ram;
            }
            $max_vcpu = $min_vcpu;
            if(!empty($globals["ver_max_cpu"])) {
                $max_vcpu = $globals["ver_max_cpu"];
            }
            if(!empty($vps_data["ver_max_cpu"])) {
                $max_vcpu = $vps_data["ver_max_cpu"];
            }
            if($max_vcpu < $min_vcpu) {
                $max_vcpu = $min_vcpu;
            }
            if(!empty($vps["topology_sockets"])) {
                $tmp_vcpu = $vps["topology_sockets"] * $vps["topology_cores"] * $vps["topology_threads"];
                if($max_vcpu < $tmp_vcpu) {
                    $max_vcpu = $min_vcpu;
                }
            }
        } else {
            $max_ram = $min_ram;
            $max_vcpu = $min_vcpu;
        }
        $cache_passthrough = 0;
        $qemu_verison = get_qemu_details();
        $assignedpcis = get_passthrough_devs($vid, "pci");
        $gpu_extra_config = "";
        if(!empty($assignedpcis)) {
            foreach ($assignedpcis as $iommu_grp_num => $arr) {
                foreach ($arr as $pid => $row) {
                    if(!empty($row["description"]["isgpu"]) && preg_match("/" . $row["description"]["vendor"] . "/is", "nvidia") && !empty($row["description"]["1000_series"])) {
                        $vendor_value = !empty($tmp_xml["features"]["hyperv"]["vendor_id"]["@attributes"]["value"]) ? $tmp_xml["features"]["hyperv"]["vendor_id"]["@attributes"]["value"] : generateRandStr(12);
                        $gpu_extra_config = "<hyperv>\n<relaxed state='on'/>\n<vapic state='on'/>\n<spinlocks state='on' retries='8191'/>\n<vendor_id state='on' value='" . $vendor_value . "'/>\n</hyperv>\n<kvm>\n<hidden state='on'/>\n</kvm>\n<vmport state='off'/>\n<ioapic driver='kvm'/>\n";
                    }
                }
            }
        }
        $vps = apply_filters("before_config_write", $vps);
        $conf = "<domain type='kvm' " . (!empty($data_decode["ssd_emulation"]) && (version_compare($qemu_verison["libvirt_ver"], "7.3.0", "<") || preg_match("/windows/is", $vps["os_name"])) && (os_check("centos", ">=", 7) || os_check("ubuntu", ">=", 0)) ? " xmlns:qemu='http://libvirt.org/schemas/domain/qemu/1.0'" : "") . ">\n  <name>" . $vps["vps_name"] . "</name>\n  <uuid>" . $uuid . "</uuid>\n  <memory>" . $max_ram . "</memory>\n  <currentMemory>" . $min_ram . "</currentMemory>\n  <vcpu " . ($vps["cpupin"] != -1 ? "cpuset=\"" . $vps["cpupin"] . "\"" : "") . " current='" . $min_vcpu . "'>" . $max_vcpu . "</vcpu>";
        if(!empty($vps["cpu_mode"]) && $vps["cpu_mode"] != "default" || !empty($globals["cpu_nm"]) || !empty($vps["topology_sockets"])) {
            if($vps["cpu_mode"] == "host-passthrough") {
                $cache_passthrough = 1;
            }
            $conf .= "\n  <cpu ";
            $cpu_models = $this->get_cpu_models();
            $is_custom_model = 0;
            if(!empty($vps["cpu_mode"]) && $vps["cpu_mode"] != "default" && in_array($vps["cpu_mode"], ["host-model", "host-passthrough"])) {
                $conf .= "mode='" . $vps["cpu_mode"] . "'";
            } elseif(!empty($cpu_models) && in_array($vps["cpu_mode"], $cpu_models)) {
                $conf .= "mode='custom' match='exact' check='none'";
                $is_custom_model = 1;
            } elseif(!empty($globals["cpu_nm"])) {
                $conf .= "mode='host-passthrough'";
                $cache_passthrough = 1;
            }
            $conf .= ">\n";
            if($is_custom_model) {
                $conf .= "    <model fallback='forbid'>" . $vps["cpu_mode"] . "</model>\n";
            }
            if(!empty($vps["topology_sockets"])) {
                $conf .= "    <topology sockets='" . $vps["topology_sockets"] . "' cores='" . $vps["topology_cores"] . "' threads='" . $vps["topology_threads"] . "' />";
            }
            $conf .= "\n  " . (!empty($cache_passthrough) && version_compare($qemu_verison["libvirt_ver"], "3.3.0", ">=") && version_compare($qemu_verison["qemu_ver"], "2.0.0", ">=") ? "<cache mode=\"passthrough\"/>\n" : "") . " </cpu>";
        }
        $vps["cpu_percent"] = (int) $vps["cpu_percent"];
        if(!empty($vps["cpu"]) || !empty($vps["cpu_percent"])) {
            $conf .= "\n  <cputune>\n" . (!empty($vps["cpu"]) ? "    <shares>" . $vps["cpu"] . "</shares>\n" : "") . (!empty($vps["cpu_percent"]) ? "    <period>100000</period>\n    <quota>" . $vps["cpu_percent"] / 100 * 100000 . "</quota>\n    <emulator_period>100000</emulator_period>\n    <emulator_quota>" . $vps["cpu_percent"] / 100 * 100000 . "</emulator_quota>\n" : "") . "  </cputune>\n";
        }
        $conf .= "  <os>\n    <type arch='x86_64' machine=" . (!empty($uefi) ? "\"q35\"" : "\"pc\"") . ">hvm</type>\n\t" . (!empty($uefi) ? " <loader readonly='yes' secure='yes' type='pflash'>" . $globals["secure_efi_path"] . "</loader>" : "") . "\n\t<bootmenu enable='yes'/>  \n  </os>\n  <features>\n" . (!empty($vps["acpi"]) ? "    <acpi/>\n" : "") . (!empty($vps["apic"]) ? "    <apic/>\n" : "") . (!empty($vps["pae"]) ? "    <pae/>\n" : "") . (!empty($uefi) ? "\t<smm state='on'/>\n" : "") . (!empty($gpu_extra_config) ? $gpu_extra_config : "") . " </features>";
        $vps["timezone"] = !empty($vps["timezone"]) ? $vps["timezone"] : $globals["default_enduser_timezone"];
        if(!empty($vps["timezone"])) {
            $conf .= "<clock offset='timezone' timezone='" . $vps["timezone"] . "' />";
        } else {
            $conf .= "<clock offset='utc'>\n\t<timer name='pit' tickpolicy='delay'/>\n\t<timer name='rtc' tickpolicy='catchup'/>\n\t<timer name='hpet' present='no'/>\n  </clock>";
        }
        $conf .= "\n  \n  <on_poweroff>destroy</on_poweroff>\n  <on_reboot>restart</on_reboot>\n  <on_crash>restart</on_crash>\n  <pm>\n\t<suspend-to-mem enabled='no'/>\n\t<suspend-to-disk enabled='no'/>\n  </pm>\n\n  <devices>\n" . ($globals["distro"] == "ubuntu" ? "<emulator>/usr/bin/kvm</emulator>\n" : "<emulator>/usr/libexec/qemu-kvm</emulator>");
        $dev_d = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"];
        $i = 1;
        foreach ($disks as $dk => $D) {
            $dev = $dev_d[$i];
            if(!empty($D["primary"])) {
                $dev = "a";
            } else {
                $i++;
            }
            $device = !empty($vps["virtio"]) && $vps["virtio"] == 1 ? "vd" : "hd";
            $device_bus = empty($vps["virtio"]) ? "ide" : ($vps["virtio"] == 1 ? "virtio" : ($vps["virtio"] == 2 ? "scsi" : "ide"));
            $is_centos7 = os_check("centos", ">=", 7);
            $is_ubuntu12 = os_check("ubuntu", ">=", 12);
            $is_ubuntu12 or $os_check = $is_ubuntu12 || $is_centos7;
            $discard_unmap = (preg_match("/file/is", $D["type"]) || preg_match("/thin block/is", $D["type"])) && $vps["virtio"] == 2 ? " discard='unmap'" : "";
            $rotational_rate = !empty($data_decode["ssd_emulation"]) && (version_compare($qemu_verison["libvirt_ver"], "7.3.0", ">=") || preg_match("/windows/is", $vps["os_name"])) && (os_check("centos", ">=", 7) || os_check("ubuntu", ">=", 0)) ? " rotation_rate='1'" : "";
            $boot_order = array_search("disk" . $i, $vps["boot"]) + 1;
            $conf .= "\n\t<disk type='" . (preg_match("/file/is", $D["type"]) ? "file" : "block") . "' device='disk'>\n\t<driver name='qemu' " . (preg_match("/file/is", $D["type"]) ? "type='" . $D["format"] . "'" : "") . " cache='" . (empty($vps["kvm_cache"]) ? "none" : $vps["kvm_cache"]) . "' " . (empty($vps["io_mode"]) ? "" : " io='" . $vps["io_mode"] . "'") . $discard_unmap . "/>\n\t<source " . (preg_match("/file/is", $D["type"]) ? "file" : "dev") . "='" . $D["path"] . "'/>\n\t  <target dev='" . $device . $dev . "' bus='" . $device_bus . "' " . $rotational_rate . "/>\n" . ($os_check && (!empty($vps["total_iops_sec"]) || !empty($vps["read_bytes_sec"]) || !empty($vps["write_bytes_sec"])) ? "      <iotune>\n" . (!empty($vps["total_iops_sec"]) ? "\t<total_iops_sec>" . $vps["total_iops_sec"] . "</total_iops_sec>\n" : "") . (!empty($vps["read_bytes_sec"]) ? "\t<read_bytes_sec>" . $vps["read_bytes_sec"] * 1024 * 1024 . "</read_bytes_sec>\n" : "") . (!empty($vps["write_bytes_sec"]) ? "\t<write_bytes_sec>" . $vps["write_bytes_sec"] * 1024 * 1024 . "</write_bytes_sec>\n" : "") . "      </iotune>" : "") . "\n\t \t<boot order='" . $boot_order . "'/>\n    </disk>";
        }
        if(!empty($vps["virtio"]) && $vps["virtio"] == 1) {
            $i = 0;
        }
        $mtu_supported = version_compare($qemu_verison["libvirt_ver"], "3.1.0", ">=") && version_compare($qemu_verison["qemu_ver"], "2.9.0", ">=") && isset($globals["set_vps_config_mtu"]) && $globals["set_vps_config_mtu"] != 0;
        $conf .= (!empty($vps["iso"]) && !empty($isopath) && file_exists($globals[$isotype] . "/" . $isopath) && is_file($globals[$isotype] . "/" . $isopath) ? "\n    <disk type='file' device='cdrom'>\n      <source file='" . $globals[$isotype] . "/" . $isopath . "'/>\n\t  <target dev= " . (!empty($uefi) ? "'sd" . $dev_d[$i + 0] . "'" : "'hd" . $dev_d[$i + 0] . "'") . " bus=" . (!empty($uefi) ? "'sata'" : "'ide'") . "/>\n\t  <boot order='" . (array_search("cdrom1", $vps["boot"]) + 1) . "'/>\n      <readonly/>\n    </disk>" : "") . "\n    " . (!empty($vps["sec_iso"]) && !empty($sec_isopath) && file_exists($globals[$sec_isotype] . "/" . $sec_isopath) && is_file($globals[$sec_isotype] . "/" . $sec_isopath) ? "\n    <disk type='file' device='cdrom'>\n      <source file='" . $globals[$sec_isotype] . "/" . $sec_isopath . "'/>\n      <target dev= " . (!empty($uefi) ? "'sd" . $dev_d[$i + 1] . "'" : "'hd" . $dev_d[$i + 1] . "'") . " bus=" . (!empty($uefi) ? "'sata'" : "'ide'") . "/>\n\t  <boot order='" . (array_search("cdrom2", $vps["boot"]) + 1) . "'/>\n      <readonly/>\n    </disk>" : "") . "\n\t";
        if(!empty($has_normal_ip)) {
            $conf .= (empty($nat) ? "<interface type='bridge'>\n\t<source bridge='" . (!empty($vlan_bridge) ? $vlan_bridge : $globals["bridge"]) . "' />\n\t<target dev='viif" . $vps["vps_name"] . "'/>" : "<interface type='network'>\n\t<source network='" . $nat_name . "'/>\n\t<target dev='viif" . $vps["vps_name"] . "'/>\n\t<forward mode='route' />") . "\n\t" . (!empty($vps["nic_type"]) && $vps["nic_type"] != "default" ? "<model type='" . $vps["nic_type"] . "' /><driver name='vhost' queues='" . $vps["cores"] . "'/>" : "") . "\n\t<mac address='" . $mac . "' />\n\t" . ($mtu_supported && !empty($mtu) ? "<mtu size='" . $mtu . "'/>" : "");
            $release = shell_exec("cat /etc/redhat-release");
            $conf .= "\n\t</interface>\n\t";
        }
        if(!empty($internal)) {
            $conf .= "<interface type='bridge'>\n      <source bridge='" . $internal . "' />\n      <target dev='vinf" . $vps["vps_name"] . "'/>\n\t  " . ($mtu_supported && !empty($mtu_internal) ? "<mtu size='" . $mtu_internal . "'/>" : "") . "\n\t  " . (!empty($vps["nic_type"]) && $vps["nic_type"] != "default" ? "<model type='" . $vps["nic_type"] . "' /><driver name='vhost' queues='" . $vps["cores"] . "'/>" : "") . "\n\t  " . (!empty($internal_mac) ? "<mac address='" . $internal_mac . "' />" : "") . "\n    </interface>\n    ";
        }
        if(!empty($assignedpcis)) {
            $detachdata = [];
            foreach ($assignedpcis as $iommu_grp_num => $arr) {
                foreach ($arr as $pid => $row) {
                    $gpu_file = "";
                    if(!empty($row["description"]["isgpu"]) && !empty($row["description"]["gpu_rom_file"])) {
                        $gpu_file = $globals["vgabios_path"] . trim($row["description"]["gpu_rom_file"]);
                    }
                    $pci_props = passthrough_dev_properties($row["dev_fullname"], "pci", "all");
                    $detachdata[$pid]["pci_name"] = $pci_props["pci_name"];
                    $conf .= "\n\t\t\t\t<hostdev mode='subsystem' type='pci' managed='yes'>\n\t\t\t\t\t<source>\n\t\t\t\t\t\t<address domain='0x" . $pci_props["domain"] . "' bus='0x" . $pci_props["bus"] . "' slot='0x" . $pci_props["slot"] . "' function='0x" . $pci_props["function"] . "'/>\n\t\t\t\t\t</source>";
                    if(!empty($gpu_file)) {
                        $conf .= "<rom file='" . $gpu_file . "'/>";
                    }
                    $conf .= "</hostdev>\n\t\t\t\t";
                }
            }
            $this->detach_pci_device($vid, $detachdata);
        }
        if($device_bus == "scsi") {
            $conf .= "<controller type='scsi' index='0' model='virtio-scsi'></controller>";
        }
        if(!distro_check(0, 0, 0, 0, 1)) {
            $conf .= "\n    <serial type='pty'>\n      <target port='0'/>\n    </serial>\n    <console type='pty'>\n      <target port='0'/>\n    </console>";
        }
        $conf .= "<sound model=" . (distro_check(1) ? "'ac97'>" : "'ich6'>\n\t<codec type='micro'/>") . "  \n    </sound>\n    " . (!empty($vps["kvm_vga"]) ? "<video>\n\t<model type='vga' vram='" . (empty($data_decode["vga_vram"]) ? 8192 : (int) (1024 * $data_decode["vga_vram"])) . "' heads='1'>" . (!empty($vps["acceleration"]) ? "\n\t<acceleration accel3d='yes' accel2d='yes'/>" : "") . "\n      </model>\n    </video>" : "") . "\n    <input type='tablet' bus='usb'/>\n    <input type='mouse' bus='ps2'/>\n\t<graphics type='vnc' port='" . $vncport . "' autoport='no' listen='" . server_vncip($vps["serid"]) . "' passwd='" . $vncpass . "' keymap='" . (empty($vps["vnc_keymap"]) ? "en-us" : $vps["vnc_keymap"]) . "'/>";
        $assignedusbs = get_passthrough_devs($vid, "usb");
        oexec("lsusb -t", $lsusb, $r);
        $controller_index = 0;
        if(!empty($assignedusbs)) {
            foreach ($globals["usb_models"] as $model => $usb_controller) {
                if(preg_match("/" . $model . "/i", $lsusb)) {
                    $usb_controller["attributes"]["port_start"] = !is_null($usb_controller["attributes"]["port_start"]) ? $usb_controller["attributes"]["port_start"] : 2;
                    $usb_controller["attributes"]["port_end"] = !is_null($usb_controller["attributes"]["port_end"]) ? $usb_controller["attributes"]["port_end"] : 6;
                    $usb_controller["attributes"]["total_ports"] = $usb_controller["attributes"]["port_end"] - $usb_controller["attributes"]["port_start"] + 1;
                    $conf .= "\n<controller type='usb' index='" . ++$controller_index . "' model='" . $usb_controller["name"] . "' " . (empty($usb_controller["attributes"]["port_attribute_option"]) ? "" : " ports='" . $usb_controller["attributes"]["total_ports"] . "'") . "/>";
                    $controller_port = $usb_controller["attributes"]["port_start"];
                    foreach ($assignedusbs as $pid => $row) {
                        $usb = passthrough_dev_properties($row["dev_fullname"], "usb", "all");
                        if(preg_match("/" . $usb["model"]["name"] . "/is", $usb_controller["name"])) {
                            if($usb_controller["attributes"]["port_end"] < $controller_port) {
                                $conf .= "\n<controller type='usb' index='" . ++$controller_index . "' model='" . $usb_controller["name"] . "' " . (empty($usb_controller["attributes"]["port_attribute_option"]) ? "" : " ports='" . $usb_controller["attributes"]["total_ports"] . "'") . "/>";
                                $controller_port = $usb_controller["attributes"]["port_start"];
                            }
                            $conf .= "\n\t\t\t\t\t\t\t<hostdev mode='subsystem' type='usb' managed='yes'>\n\t\t\t\t\t\t\t\t<source>\n\t\t\t\t\t\t\t\t\t<vendor id='0x" . $usb["vendor_id"] . "'/>\n\t\t\t\t\t\t\t\t\t<product id='0x" . $usb["product_id"] . "'/>\n\t\t\t\t\t\t\t\t\t<address bus='" . $usb["bus_id"] . "' device='" . $usb["dev_id"] . "'/>\n\t\t\t\t\t\t\t\t</source>\n\t\t\t\t\t\t\t\t<address type='usb' bus='" . $controller_index . "' port='" . $controller_port . "'/>\n\t\t\t\t\t\t\t</hostdev>\n\t\t\t\t\t\t\t";
                            $controller_port++;
                        }
                    }
                }
            }
        }
        if(!empty($uefi) && !empty($data_decode["enable_tpm"])) {
            $conf .= "\n\t<tpm model='tpm-tis'>\n      <backend type='emulator' version='2.0'/>\n\t</tpm>";
        }
        if(!empty($vps["data"]["enable_guest_agent"])) {
            if(!is_dir("/var/virtualizor/tmp")) {
                mkdir_recursive("/var/virtualizor/tmp", 777);
            }
            $conf .= "\n\t<channel type='unix'>\n\t\t" . (os_check("centos", "<=", "7") ? "<source mode='bind' path='/var/virtualizor/tmp/" . $vps["vps_name"] . "_guest_agent' />" : "") . "\n\t\t<target type='virtio' name='org.qemu.guest_agent.0'/>\n\t</channel>";
        }
        $conf .= "\n    </devices>\n" . $extra . "";
        if(!empty($data_decode["ssd_emulation"]) && (version_compare($qemu_verison["libvirt_ver"], "7.3.0", "<") || preg_match("/windows/is", $vps["os_name"])) && (os_check("centos", ">=", 7) || os_check("ubuntu", ">=", 0))) {
            $conf .= "\n<qemu:commandline>";
            for ($i = 0; $i < count($disks); $i++) {
                $conf .= "\n\t<qemu:arg value='-set'/>\n\t<qemu:arg value='device.scsi0-0-0-" . $i . ".rotation_rate=1'/>";
            }
            $conf .= "\n</qemu:commandline>";
        }
        $conf .= "\n</domain>";
        writefile($cfg, $conf, 1);
        @chmod($cfg, 384);
        task_update($actid, $l["written_config_file"], 25);
        writefile($globals["var"] . "/kvm-conf/" . $vps_name . ".xml", $conf, 1);
        @chmod($globals["var"] . "/kvm-conf/" . $vps_name . ".xml", 384);
        task_update($actid, $l["calling_after_config_write"], 27);
        apply_filters("after_config_write", $vps);
        task_update($actid, $l["called_after_config_write"], 30);
        to_master("vps", "vncport", $vps["vpsid"], "vpsid", $vncport);
        if(!empty($mac_flag)) {
            to_master("vps", "mac", $vps["vpsid"], "vpsid", $mac);
        }
        if(empty($vps["suspended"])) {
            $autostart = "/etc/libvirt/qemu/autostart";
            if(!is_dir($autostart)) {
                @mkdir($autostart);
            }
            vexec("/bin/ln -s " . xss($cfg) . " " . xss($autostart . "/" . $vps_name . ".xml") . " 2>/dev/null");
        }
        $task_disk_num = 1;
        $task_disk_progress = 35;
        if(empty($create)) {
            _task_update($actid, $l["tc_rule_create"], 35, "group");
            $this->tc_create($vid);
            _task_update($actid, "", 35, "group_end");
            if(!preg_match("/windows/is", $vps["os_name"]) && !empty($vps["data"]["enable_guest_agent"])) {
                $this->install_ga($vid);
            }
            if(preg_match("/windows/is", $vps["os_name"]) && ($ostemplates[$vps["osid"]]["perf_ops"] && $globals["use_win_script"])) {
                $this->change_winips($vid);
            }
            $resize_break = 0;
            foreach ($disks as $dk => $DISK) {
                $disk_size = vpsdisk_size($DISK);
                if(empty($disk_size) && 0 < $DISK["size"] && empty($DISK["primary"])) {
                    task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                    $storage_create = vpsdisk_create($DISK);
                    if(!empty($storage_create)) {
                        $error = merge_error($error, $storage_create);
                        task_update($actid, implode("<br>", $error), -1);
                        return false;
                    }
                }
                if(preg_match("/lightbit/is", $DISK["type"])) {
                    getvps($vid, 0);
                    $light_bit = 1;
                }
                if((!empty($disk_size) || $DISK["format"] == "qcow2") && $disk_size < $DISK["size"] && empty($resize_break)) {
                    $this->resizevps($vid);
                    $resize_break = 1;
                }
                $task_disk_progress = $task_disk_progress + ceil(30 / count($disks));
            }
            $disks = get_vps_DISKS($vid);
            $DISK = get_vps_disk($vid);
            if($this->status($vid, 1) == 1 && empty($create)) {
                $vps_uuid = $this->vps_uuid($vid);
                task_update($actid, $l["setting_cpu"], 60);
                if(!empty($vps["cpu"])) {
                    vexec("virsh schedinfo " . xss($vps_uuid) . " --set cpu_shares=" . $vps["cpu"]);
                }
                task_update($actid, $l["setting_cpu_perc"], 62);
                if(!empty($vps["cpu_percent"])) {
                    vexec("virsh schedinfo " . xss($vps_uuid) . " --set vcpu_quota=" . $vps["cpu_percent"] / 100 * 100000);
                    vexec("virsh schedinfo " . xss($vps_uuid) . " --set emulator_quota=" . $vps["cpu_percent"] / 100 * 100000);
                }
                $vif_name = $this->vifname($vid);
                $mac_addr = $this->getmac($vid);
                $vinf_name = $this->vifname($vid, 1);
                $int_mac_addr = $this->getmac($vid, 1);
                vs_ebtables_add($vid, $vif_name, $mac_addr, $vinf_name, $int_mac_addr);
            }
            _task_update($actid, $l["change_dnsnameserver"], 75, "group");
            _task_update($actid, "", 75, "change_dnsnameserver");
            $this->change_dnsnameserver($vps["vpsid"]);
            _task_update($actid, "", 75, "group_end");
            task_update($actid, $l["fstab_handle"], 90);
            if(!empty($vps["virtio"])) {
                $this->fstab_handle($vps["vpsid"]);
                to_master("vps", "virtio", $vps["vpsid"], "vpsid", $vps["virtio"]);
            }
            if(empty($vps["virtio"])) {
                $this->fstab_handle($vps["vpsid"]);
                to_master("vps", "virtio", $vps["vpsid"], "vpsid", 0);
            }
            $this->fstrim_handle($vid);
            if(preg_match("/lightbit/is", $DISK["type"]) && preg_match("/block/is", $DISK["type"])) {
                $this->change_disk_conf($vid);
            }
            task_update($actid, $l["edit_done"], 100);
            return true;
        } else {
            foreach ($disks as $dk => $DISK) {
                $os_template = "";
                if(!empty($format_primary) && empty($DISK["primary"])) {
                } else {
                    if(!empty($DISK["primary"]) && !empty($vps["osid"])) {
                        $os_template = $globals["kvmos"] . "/" . $ostemplates[$vps["osid"]]["filename"];
                    }
                    task_update($actid, $l["creating_disk"] . $task_disk_num, $task_disk_progress);
                    $storage_create = vpsdisk_create($DISK, $os_template);
                    if(!empty($storage_create)) {
                        $error = merge_error($error, $storage_create);
                        task_update($actid, implode("<br>", $error), -1);
                        return false;
                    }
                    if(preg_match("/lightbit/is", $DISK["type"])) {
                        getvps($vid, 0);
                        $light_bit = 1;
                    }
                    $task_disk_num++;
                    $task_disk_progress = $task_disk_progress + ceil(30 / count($disks));
                }
            }
            $disks = get_vps_DISKS($vid);
            $DISK = get_vps_disk($vid);
            if(!empty($vps["osid"])) {
                task_update($actid, $l["resizing_disk"], 60);
                $resize = vpsdisk_resize($vid);
                if(!empty($resize["error"])) {
                    $error = merge_error($error, $resize["error"]);
                    task_update($actid, implode("<br>", $error), -1);
                    return false;
                }
                task_update($actid, $l["resizing_disk_done"], 65);
                $disk = $resize["diskinfo"];
                $DISK = get_vps_disk($vid);
                $DISK["diskinfo"] = $resize["diskinfo"];
                if(empty($disk["parttype"])) {
                    $DISK["diskinfo"] = get_ostype_from_disk($DISK, $disk);
                    $disk = $DISK["diskinfo"];
                }
                if(empty($ostemplates[$vps["osid"]]["noresizefs"])) {
                    task_update($actid, $l["resizing_fs"], 70);
                    $fs_resize = vpsdisk_resize_filesystem($DISK);
                    if(!empty($fs_resize["error"])) {
                        $error = merge_error($error, $fs_resize["error"]);
                        task_update($actid, implode("<br>", $error), -1);
                        return false;
                    }
                    task_update($actid, $l["resizing_fs_done"], 75);
                }
                if(!empty($disk["parttype"][0]["type"]) && preg_match("/" . $disk["parttype"][0]["type"] . "/is", "islinux")) {
                    if(!empty($ostemplates[$vps["osid"]]["perf_ops"])) {
                        $mount = mount($vid);
                        if(!is_array($mount)) {
                            $error[] = $l["kvm_err_mount"];
                            task_update($actid, $l["kvm_err_mount"], -1);
                            return false;
                        }
                        apply_filters("perform_operations", $mount);
                        $post = [];
                        if(!empty($vps["dns_nameserver"])) {
                            $dns = unserialize($vps["dns_nameserver"]);
                            $post["dns"] = $dns;
                        }
                        task_update($actid, $l["fstab_handle"], 80);
                        $this->fstab_handle($vps["vpsid"], $mount);
                        $this->fstrim_handle($vps["vpsid"], $mount);
                        task_update($actid, $l["net_config"], 85);
                        network_configure($mount["mount_point"], $ips, $post, $routing);
                        task_update($actid, $l["hostname_config"], 90);
                        hostname_configure($mount["mount_point"], $vps["hostname"]);
                        task_update($actid, $l["sshkey_clean"], 95);
                        sshkey_clean($mount["mount_point"]);
                        $umount = umount($mount);
                        if(!empty($umount)) {
                            $error[] = $l["kvm_err_unmount"];
                            task_update($actid, $l["kvm_err_unmount"], -1);
                            return false;
                        }
                    }
                } elseif(!empty($disk["parttype"][0]["type"]) && preg_match("/" . $disk["parttype"][0]["type"] . "/is", "iswindows")) {
                }
            }
            if(preg_match("/windows/is", $vps["os_name"]) && !empty($ostemplates[$vps["osid"]]["perf_ops"]) && $globals["use_win_script"]) {
                $this->change_winips($vid);
            }
            if(!empty($light_bit)) {
                $this->change_disk_conf($vid);
            }
            task_update($actid, $l["calling_after_createvps"], 96);
            apply_filters("after_createvps", $vps);
            if(!preg_match("/windows/is", $vps["os_name"]) && !empty($vps["data"]["enable_guest_agent"])) {
                $this->install_ga($vid);
            }
            task_update($actid, $l["create_done"], 100);
            return true;
        }
    }
    public function destroyvps($vid, $format_primary = 0)
    {
        global $globals;
        global $l;
        global $error;
        $vps = getvps($vid);
        $actid = vps_task("deletevs", "", 0, $vid, $vps["uid"], 0, $l["del_vps"]);
        task_start($actid);
        $data = ["serid" => $vps["serid"]];
        task_update($actid, $l["start_del_vps"], 5, serialize($data));
        _task_update($actid, $l["tc_rule_delete"], 20, "group");
        $this->tc_destroy($vid);
        _task_update($actid, "", 20, "group_end");
        $vps_name = $this->getname($vid);
        task_update($actid, $l["call_hook_before_delvps"], 25);
        apply_filters("before_deletevps", $vps);
        $r = get_passthrough_devs($vid, "all");
        if(!empty($r)) {
            update_query("UPDATE `passthrough` SET vpsid = 0 WHERE vpsid = :vpsid", [":vpsid" => $vid]);
            if(!empty($r["pci"])) {
                foreach ($r["pci"] as $iommu => $arr) {
                    foreach ($arr as $k => $v) {
                        to_master("passthrough", "vpsid", $k, "pid", NULL);
                    }
                }
            } elseif($r["usb"]) {
                foreach ($r["usb"] as $k => $v) {
                    to_master("passthrough", "vpsid", $k, "pid", NULL);
                }
            }
            task_update($actid, $l["passthrough_removed"], 30);
        }
        task_update($actid, $l["del_vps"], 35);
        vexec("/usr/bin/virsh destroy " . xss($this->vps_uuid($vid)));
        sleep(1);
        if(!defined("DONT_DESTROY_LIVE_MIG_VM")) {
            $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\t\t\tAND action = 'delete_vpsdisks'\n\t\t\t\t\t\t\tORDER BY actid ASC", [":vid" => $vid]);
            if(0 < vsql_num_rows($res)) {
                for ($i = 0; $i < vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $tasks[$row["actid"]] = $row;
                    $del_data = _unserialize($row["data"]);
                    $this->delete_vpsdisks($vid, $del_data, $row["actid"]);
                    logs_vps("delete_vpsdisks", $del_data, 1, $vid, $user["uid"]);
                }
            }
            $disks = get_vps_DISKS($vid);
            foreach ($disks as $dk => $DISK) {
                if(!empty($format_primary) && empty($DISK["primary"])) {
                } else {
                    umount($DISK);
                    task_update($actid, $l["del_kpartx"], 40);
                    kpartx_delete($vid, $DISK["path"]);
                    task_update($actid, $l["del_storage"], 50);
                    $storage_destroy = vpsdisk_destroy($DISK);
                    if(!empty($storage_destroy)) {
                        $error = merge_error($error, $storage_destroy);
                    }
                }
            }
        }
        _task_update($actid, $l["del_ebtables"], 63, "group");
        $this->ebtables_remove($vid);
        ebtables_save();
        _task_update($actid, "", 63, "group_end");
        task_update($actid, $l["del_config"], 70);
        @unlink("/etc/libvirt/qemu/" . $vps_name . ".xml");
        @unlink("/etc/libvirt/qemu/" . $vps_name . ".xml.bak");
        @unlink("/etc/libvirt/qemu/autostart/" . $vps_name . ".xml");
        @unlink($globals["var"] . "/kvm-conf/" . $vps_name . ".xml");
        if(!empty($vps["ha"])) {
            vexec("/usr/sbin/pcs resource delete resource_" . $vps["vps_name"] . "_" . $vps["uuid"]);
            sleep(1);
            vexec("/usr/sbin/pcs resource cleanup resource_" . $vps["vps_name"] . "_" . $vps["uuid"]);
            sleep(1);
        }
        vexec("/usr/bin/virsh undefine " . xss($vps["vps_name"]));
        vexec("/usr/bin/virsh undefine --nvram " . xss($vps["vps_name"]));
        if(is_dir("/home/" . $vps["vps_name"])) {
            vexec("rm -rf /home/" . $vps["vps_name"]);
        }
        task_update($actid, $l["call_hook_after_delvps"], 88);
        apply_filters("after_deletevps", $vps);
        task_update($actid, $l["del_vps_done"], 100);
        return true;
    }
    public function osreinstall($vid, $format_primary = 0)
    {
        $vps_name = $this->getname($vid);
        $vnc = $this->vncDetails($vid);
        if(!empty($vnc["port"])) {
            $GLOBALS["use_vnc_port"] = $vnc["port"];
        }
        $passthrough_devs = get_passthrough_devs($vid, "all");
        $this->destroyvps($vid, $format_primary);
        if(!empty($passthrough_devs)) {
            if(!empty($passthrough_devs["pci"])) {
                foreach ($passthrough_devs["pci"] as $iommu_grp_num => $ar) {
                    foreach ($ar as $k => $v) {
                        to_master("passthrough", "vpsid", $k, "pid", $vid);
                        update_query("UPDATE passthrough set vpsid = :vid where pid = :pid", [":vid" => $vid, ":pid" => $k]);
                    }
                }
            }
            if(!empty($passthrough_devs["usb"])) {
                foreach ($passthrough_devs["usb"] as $k => $v) {
                    to_master("passthrough", "vpsid", $k, "pid", $vid);
                    update_query("UPDATE passthrough set vpsid = :vid where pid = :pid", [":vid" => $vid, ":pid" => $k]);
                }
            }
        }
        if(!$this->createvps($vid, 1, $format_primary)) {
            return false;
        }
        if(!empty($vnc["password"])) {
            $this->changeVncPass($vid, $vnc["password"]);
        }
        return true;
    }
    public function changepassword($vid, $newpassword, $actid = 0, $vm_username = "")
    {
        global $globals;
        global $user;
        global $ostemplates;
        global $l;
        global $oslist;
        global $error;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("changepassword", base64_encode(json_encode([$newpassword, $vm_username])), 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1 && !empty($vps["data"]["enable_guest_agent"])) {
                $abort_task = function ($actid, $msg) {
                    task_update($actid, $msg, 0);
                    makequery("UPDATE tasks SET \n\t\t\t\t\t\t\t\tstarted = 0, \n\t\t\t\t\t\t\t\tupdated = 0,\n\t\t\t\t\t\t\t\tstatus = 0,\n\t\t\t\t\t\t\t\tprogress = 0\n\t\t\t\t\t\t\t\tWHERE actid = :actid", [":actid" => $actid]);
                };
                task_start($actid);
                $ga_pass_support = $this->guest_agent_support($vid, "guest-set-user-password", $not_installed);
                if(!empty($not_installed) || empty($ga_pass_support["done"])) {
                    $abort_task($actid, $ga_pass_support["error"] . " " . $l["kvm_pass_poweroff"]);
                    return -1;
                }
                task_update($actid, $l["kvm_live_pass_update"], 20);
                $encoded_password = base64_encode($newpassword);
                $params = ["password" => $encoded_password];
                $username = username_vps($vps["osid"], $vps["data"], $vm_username);
                vexec("virsh qemu-agent-command " . $vps["vps_name"] . " " . xss("{\"execute\":\"guest-set-user-password\", \"arguments\":{\"username\":\"" . $username . "\", \"password\":\"" . $encoded_password . "\", \"crypted\" : false }}") . " --pretty", $o, $ret, $params);
                unset($encoded_password);
                unset($username);
                unset($params);
                if(!empty($ret)) {
                    $abort_task($actid, $l["kvm_live_pass_err"]);
                    return -1;
                }
                task_update($actid, $l["kvm_live_pass"], 90);
                task_update($actid, $l["completed"], 100);
                return true;
            }
            save_notification("pending_task", ["action" => "changepassword", "vpsid" => $vid, "actid" => $actid]);
            return -1;
        }
        if(!empty($actid)) {
            return perform_vps_operation($vid, $actid, "change_password", $newpassword);
        }
    }
    public function remotedesktop($vid, $rdp, $actid = 0)
    {
        global $globals;
        global $l;
        global $user;
        global $oslist;
        global $ostemplates;
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("remotedesktop", $rdp, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "remotedesktop", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "remote_desktop", [$rdp]);
    }
    public function filelist($vid, $dir = "", $searchSubdirs = 1, $directoriesonly = 0, $maxlevel = "all", $level = 1)
    {
        return -1;
    }
    public function processes($vid)
    {
        $processes = [];
        return $processes;
    }
    public function os($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $vps = getvps($vid);
        $osid = $vps["osid"];
        if(empty($ostemplates)) {
            oslist();
        }
        $osinfo = $ostemplates[$vps["osid"]];
        if(empty($osinfo)) {
            $osinfo["name"] = $vps["os_name"];
            $osinfo["distro"] = distro_find($vps["os_name"]);
        }
        return $osinfo;
    }
    public function hostname($vid)
    {
        $vps = getvps($vid);
        return $vps["hostname"];
    }
    public function listips($vid)
    {
        global $globals;
        global $oslist;
        global $ostemplates;
        global $distros;
        global $user;
        $ips = [];
        $res = makequery("SELECT * FROM `ips`\n\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(in_array($row["ip"], $ips)) {
            } else {
                $ips[] = $row["ip"];
            }
        }
        return $ips;
    }
    public function cpu($vid)
    {
        global $user;
        $ret = [];
        $ret["manu"] = "unknown";
        $ret["limit"] = 0;
        $ret["used"] = 0;
        oexec("cat /proc/cpuinfo", $tmp);
        if(preg_match("/intel/is", $tmp)) {
            $ret["manu"] = "intel";
        } elseif(preg_match("/amd/is", $tmp)) {
            $ret["manu"] = "amd";
        }
        virt_preg_replace("/cpu(\\s*?)MHz(\\s*?)\\:(\\s*?)(.*?)(\\s*?)\\n/is", $tmp, $mhz, 4);
        $vps = getvps($vid);
        if($this->status($vid) !== 0) {
            $vps_name = $this->getname($vid);
            $_cpu_stats = $this->_cpu_stats();
            $ret["used"] = trim($_cpu_stats[$vps_name]["cpu"]);
        }
        $vps_cores = $vps["cores"];
        $node_cores = get_cores();
        $ret["percent"] = $node_cores / $vps_cores * $ret["used"];
        if(100 < $ret["percent"]) {
            $ret["percent"] = 100;
        }
        $ret["percent_free"] = 100 - $ret["percent"];
        if(!empty($mhz)) {
            $ret["limit"] = $mhz;
            $ret["used"] = $ret["percent"] * $mhz / 100;
            $ret["free"] = $ret["limit"] - $ret["used"];
        } else {
            $ret["limit"] = 100;
            $ret["used"] = $ret["percent"];
            $ret["free"] = $ret["limit"] - $ret["used"];
        }
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        return $ret;
    }
    public function ram($vid)
    {
        global $user;
        $ret = [];
        $ret["used"] = 0;
        $ret["limit"] = 0;
        $ret["guaranteed"] = 0;
        $ret["swap"] = 0;
        if(!empty($user["vps"])) {
            $vps = $user["vps"];
        } else {
            $vps = getvps($vid);
        }
        if(!empty($vps)) {
            $ret["limit"] = $vps["ram"];
            $ret["guaranteed"] = $vps["ram"];
            $ret["swap"] = $vps["swap"];
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        if($this->status($vid) !== 0 && !empty($vps["data"]["enable_guest_agent"])) {
            $has_support = $this->guest_agent_support($vid);
            if(!empty($has_support["done"])) {
                $os_name = $vps["os_name"];
                $os_info = $this->ga_os_info($vid);
                if(!empty($os_info)) {
                    $os_name = strtolower($os_info["name"]);
                }
                if(preg_match("/windows/is", $os_name)) {
                    $systeminfo = $this->ga_exec($vid, "systeminfo");
                    if(!empty($systeminfo)) {
                        foreach ($systeminfo as $info) {
                            if(!preg_match("/(Available Physical Memory:\\s+)(\\w+.*)(MB)/", $info, $matches)) {
                            } else {
                                $ret["free"] = (int) implode("", explode(",", $matches[2]));
                                unset($matches);
                                unset($systeminfo);
                                $ret["used"] = $ret["limit"] - $ret["free"];
                                $ret["has_ga"] = 1;
                            }
                        }
                    }
                } else {
                    $ram_data = $this->ga_read_file($vid, "/proc/meminfo");
                    if(!empty($ram_data)) {
                        $meminfo = get_meminfo("", $ram_data);
                        $free = $meminfo["Buffers"] + $meminfo["Cached"] + $meminfo["MemFree"];
                        $ret["used"] = $meminfo["MemTotal"] - $free;
                        $ret["has_ga"] = 1;
                        $ret["free"] = $ret["limit"] - $ret["used"];
                        if(preg_match("/ubuntu/is", $os_name)) {
                            $ret["used"] = $meminfo["MemTotal"] - $meminfo["MemFree"];
                            $ret["free"] = $meminfo["MemTotal"] - $ret["used"];
                        }
                        unset($meminfo);
                        unset($ram_data);
                    }
                }
            }
        }
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function disk($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            $vps = $user["vps"];
            $ret["limit"] = $user["vps"]["space"] * 1024;
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = $vps["space"] * 1024;
        }
        if(!empty($vps["cached_disk"]["disk"]["Used"])) {
            $ret["used"] = $vps["cached_disk"]["disk"]["Used"] / 1024;
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        if($this->status($vid) !== 0 && !empty($vps["data"]["enable_guest_agent"])) {
            $has_support = $this->guest_agent_support($vid);
            if(!empty($has_support["done"])) {
                $os_name = $vps["os_name"];
                $os_info = $this->ga_os_info($vid);
                if(!empty($os_info)) {
                    $os_name = strtolower($os_info["name"]);
                }
                if(preg_match("/windows/is", $os_name)) {
                    $out = $this->ga_exec($vid, "fsutil", ["volume", "diskfree", "c:"]);
                    $tmp = explode(":", $out[0]);
                    $tmp_free_disk = (int) preg_replace("/[,]/", "", $tmp[1]);
                    $ret["free"] = $tmp_free_disk / 1024 / 1024;
                    $ret["used"] = $ret["limit"] - $ret["free"];
                } else {
                    $out = $this->ga_exec($vid, "df", ["-m", "/"]);
                    unset($out[0]);
                    $tmp = cexplode(" ", $out[1], 0, 1);
                    $tmp = array_values($tmp);
                    list($ret["used"], $ret["free"]) = $tmp;
                }
            }
        }
        $ret["limit_gb"] = $ret["limit"] / 1024;
        $ret["used_gb"] = $ret["used"] / 1024;
        $ret["free_gb"] = $ret["limit_gb"] - $ret["used_gb"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function inodes($vid)
    {
        global $user;
        $vps_name = $this->getname($vid);
        $ret = [];
        $ret["limit"] = 0;
        $ret["used"] = 0;
        if(!empty($user["vps"]) && $user["vps"]["vpsid"] == $vid) {
            $vps = $user["vps"];
            $ret["limit"] = $user["vps"]["inodes"];
        } elseif($vps = getvps($vid)) {
            $ret["limit"] = $vps["inodes"];
        }
        if(empty($ret["limit"])) {
            $ret["limit"] = $vps["cached_disk"]["inode"]["Inodes"];
        }
        if(!empty($vps["cached_disk"]["inode"]["IUsed"])) {
            $ret["used"] = $vps["cached_disk"]["inode"]["IUsed"];
        }
        $ret["free"] = $ret["limit"] - $ret["used"];
        $ret["percent"] = $ret["used"] / ($ret["limit"] ? $ret["limit"] : 1) * 100;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            $ret[$k] = round($v, 2);
        }
        return $ret;
    }
    public function network_speed($vid, $dev1 = [], $dev2 = [])
    {
        $vps = getvps($vid);
        $ret["speed"] = 0;
        $ret["upload"] = 0;
        $ret["download"] = 0;
        $value = $this->_network_usage($vid, $dev1);
        if(empty($value["in"]) && empty($value["out"])) {
        } else {
            if(empty($dev2)) {
                usleep(1000000);
            }
            $value2 = $this->_network_usage($vid, $dev2);
        }
        if($value2["in"] < $value["in"]) {
            $value2["in"] = $value["in"];
            $value2["out"] = $value["out"];
        }
        $ret["download"] = $value2["in"] - $value["in"];
        $ret["upload"] = $value2["out"] - $value["out"];
        $ret["speed"] = $ret["upload"] + $ret["download"];
        return $ret;
    }
    public function status($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            vexec("/usr/bin/virsh list", $output);
            unset($output[0]);
            unset($output[1]);
            foreach ($output as $v) {
                $v = preg_split("/[\\s]+/", trim($v));
                $vid = @array_search($v[1], $vs);
                if(!empty($vid) && !preg_match("/paused/is", $v[2])) {
                    $this->status[$vid] = 1;
                    $on[$vid] = 1;
                }
            }
        }
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = !empty($on[$k]) ? 1 : 0;
            } else {
                $ret[$k] = !empty($this->status[$k]) ? 1 : 0;
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function vps_status_statewise($vids, $live = false)
    {
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $impvids = implode(", ", $vids);
        $res = makequery("SELECT vpsid, vps_name FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($impvids) ? 0 : $impvids) . ")");
        $ret = $vs = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vs[$row["vpsid"]] = $row["vps_name"];
            $ret[$row["vpsid"]] = 0;
            if(!isset($this->status_statewise[$row["vpsid"]])) {
                $status_absent = true;
            }
        }
        if(!empty($live) || !empty($status_absent)) {
            $on = [];
            vexec("/usr/bin/virsh list", $output);
            unset($output[0]);
            unset($output[1]);
            foreach ($output as $v) {
                $v = preg_split("/[\\s]+/", trim($v));
                $vid = @array_search($v[1], $vs);
                if(!empty($vid)) {
                    if(preg_match("/(running)/is", $v[2])) {
                        $this->status_statewise[$vid] = 1;
                        $on[$vid] = 1;
                    }
                    if(preg_match("/(paused)/is", $v[2])) {
                        $this->status_statewise[$vid] = 2;
                        $on[$vid] = 2;
                    }
                    if(!preg_match("/(running|paused)/is", $v[2])) {
                        $this->status_statewise[$vid] = 0;
                        $on[$vid] = 0;
                    }
                }
            }
        }
        foreach ($vs as $k => $v) {
            if(!empty($live)) {
                $ret[$k] = $on[$k] == 1 ? 1 : ($on[$k] == 2 ? 2 : 0);
            } else {
                $ret[$k] = $this->status_statewise[$k] == 1 ? 1 : ($this->status_statewise[$k] == 2 ? 2 : 0);
            }
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function uptime($vid)
    {
        return false;
    }
    public function services($vid)
    {
        $services = [];
        return $services;
    }
    public function startservice($vid, $ser)
    {
        return true;
    }
    public function restartservice($vid, $ser)
    {
        return true;
    }
    public function stopservice($vid, $ser)
    {
        return true;
    }
    public function listautoservices($vid)
    {
        $services = [];
        return $services;
    }
    public function killprocess($vid, $pid)
    {
        return true;
    }
    public function install_cp($vid, $cp, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("install_cp", $cp, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "install_cp", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "install_cp", [$cp]);
    }
    public function install_recipe($vid, $recipe, $actid = 0)
    {
        global $globals;
        global $user;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $recipe_data = serialize($recipe);
            $actid = vps_task("install_recipe", $recipe_data, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "install_recipe", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        return perform_vps_operation($vid, $actid, "install_recipe", $recipe);
    }
    public function lb_save_config($lb_uuid, $config)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $conf = file_get_contents($globals["path"] . "/conf/load_balancer.conf");
        $confs = lb_get_raw_config($lb_uuid, $config);
        $final_config = $conf . "\n" . implode("\n", $confs) . "\n\n";
        $this->ga_write_file($vpsid, "/etc/haproxy/haproxy.cfg", $final_config);
        $this->ga_exec($vpsid, "service", ["haproxy", "restart"]);
        return true;
    }
    public function lb_use_own_cert($lb_uuid, $keys, $file_name)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $this->ga_exec($vpsid, "mkdir", ["/usr/local/ssl"]);
        $this->ga_write_file($vpsid, "/usr/local/ssl/serve_" . $file_name . ".pem", implode("\n", [$keys["key"], $keys["cert"]]));
        return true;
    }
    public function lb_self_signed_cert($lb_uuid, $file_name)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $name = generateRandStr(6);
        vexec("openssl req -x509 -newkey rsa:4096 -nodes -out /var/virtualizor/" . $name . ".crt -keyout /var/virtualizor/" . $name . ".key -days 365 -subj \"/C=/O=/OU=/CN=\"");
        if(!file_exists("/var/virtualizor/" . $name . ".crt") || !file_exists("/var/virtualizor/" . $name . ".key")) {
            return false;
        }
        $keys[0] = file_get_contents("/var/virtualizor/" . $name . ".key");
        $keys[1] = file_get_contents("/var/virtualizor/" . $name . ".crt");
        $this->ga_exec($vpsid, "mkdir", ["/usr/local/ssl"]);
        $this->ga_write_file($vpsid, "/usr/local/ssl/serve_" . $file_name . ".pem", implode("\n", $keys));
        unlink("/var/virtualizor/" . $name . ".crt");
        unlink("/var/virtualizor/" . $name . ".key");
        return true;
    }
    public function lb_get_logs($lb_uuid)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $res = $this->ga_exec($vpsid, "journalctl", ["-u", "haproxy.service", "--since", "today", "--no-pager"]);
        return $res;
    }
    public function lb_get_status($lb_uuid)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $res = $this->ga_exec($vpsid, "systemctl", ["status", "haproxy"]);
        return !empty($res) ? true : false;
    }
    public function lb_get_stats($lb_uuid, $ip)
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        $vpsid = getvpsid($lb_uuid);
        $file = $this->ga_read_file($vpsid, "/etc/haproxy/haproxy.cfg");
        $strfile = implode("\n", $file);
        preg_match("/stats\\s+auth\\s+(\\w+):(\\w+)/", $strfile, $mat);
        $rawres = $this->ga_exec($vpsid, "curl", ["--user", "haproxy:" . $mat[2], "http://" . $ip . "/stats"]);
        $res = implode(" ", $rawres);
        if(!preg_match("/\\<table(.*)\\<\\/table\\>/", $res, $mat)) {
            return $res;
        }
        preg_match("/\\<style type\\=\\\"text\\/css\\\"\\>(.*)\\<\\/style\\>/", $res, $mat);
        $style = $mat[1];
        $style = str_replace("body { font-family: arial, helvetica, sans-serif; font-size: 12px; font-weight: normal; color: black; background: white;} th,td { font-size: 10px;} h1 { font-size: x-large; margin-bottom: 0.5em;} h2 { font-family: helvetica, arial; font-size: x-large; font-weight: bold; font-style: italic; color: #6020a0; margin-top: 0em; margin-bottom: 0em;} h3 { font-family: helvetica, arial; font-size: 16px; font-weight: bold; color: #b00040; background: #e8e8d0; margin-top: 0em; margin-bottom: 0em;} li { margin-top: 0.25em; margin-right: 2em;}", "", $style);
        $style = str_replace("<!--", "", $style);
        $style = str_replace("-->", "", $style);
        $style = str_replace(";", " !important;", $style);
        $style = str_replace("border-bottom: 1px dotted black !important;", "border-bottom: 1px dotted black !important;position: relative !important;", $style);
        preg_match("/\\<table(.*)\\<\\/table\\>/", $res, $mat);
        $res = "<style>" . $style . "</style><table " . $mat[1] . "</table>";
        $res = str_replace("<td align=\"left\" valign=\"top\" nowrap width=\"1%\">", "<td align=\"left\" valign=\"top\" nowrap width=\"1%\" style=\"display:none\">", $res);
        $res = str_replace("class=\"tbl\"", "class=\"tbl table m-0\"", $res);
        return $res;
    }
    public function lb_default_rule($vid, $config, $actid = 0)
    {
        global $globals;
        global $l;
        if(!check_licensepro()) {
            return false;
        }
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status != 1 || empty($actid)) {
            $actid = vps_task("apply_lb_rule", serialize($config), 0, $vid, $vps["uid"], 1, $l["install_guest_agent"]);
            if($status != 1) {
                return -1;
            }
        }
        $i = 0;
        while ($i <= 20) {
            $res = $this->guest_agent_support($vid);
            if(isset($res["done"])) {
                foreach ($config as $filename => $v) {
                    if(in_array($v["source_protocol"], ["https", "http2", "http3"])) {
                        if(empty($v["ssl"])) {
                            $this->lb_self_signed_cert($vps["uuid"], $filename);
                        } else {
                            $this->lb_use_own_cert($vps["uuid"], $v["ssl"], $filename);
                        }
                    }
                }
                $this->lb_save_config($vps["uuid"], $config);
                task_update($actid, "VPS Started", 100);
                return NULL;
            } else {
                task_update($actid, "VPS Not Started", 10);
                sleep(10);
                $i++;
            }
        }
        task_update($actid, "Break....", 100);
    }
    public function install_ga($vid)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("install_ga", "", 0, $vid, $vps["uid"], 1, $l["install_guest_agent"]);
            if($status == 1) {
                return -1;
            }
        }
        if(!preg_match("/windows/", $vps["os_name"]) && !empty($vps["data"]["enable_guest_agent"])) {
            $data = [];
            $data[0] = ["rid" => rand(rand(-3, -10), rand(-500, -1000)), "code" => "\nif [ -f /etc/debian_version ]; then\n\tOS=Ubuntu\nelif [ -f /etc/redhat-release ]; then\n\tOS=redhat\nelif [-f /etc/oracle-release ]; then\n\tOS=redhat\nfi\n\nif [ \"\$OS\" = redhat  ] ; then\n\tsystemctl status qemu-guest-agent\n\tif [ \$? != 0 ] ; then\n\t\tyum  --skip-broken -y install qemu-guest-agent\n\tfi\n\t" . ($vps["load_balancer"] == -1 ? "\n\t\tsystemctl status haproxy\n\t\tif [ \$? != 0 ] ; then\n\t\t\tyum  --skip-broken -y install haproxy\n\t\tfi\n\t" : "") . "\n\t\nelif [ \"\$OS\" = Ubuntu  ] ; then\n\tsystemctl status qemu-guest-agent\n\tif [ \$? != 0 ] ; then\n\t\tapt-get clean -y 2>&1\n\t\tapt-get update -y 2>&1\n\t\tapt-get install -y qemu-guest-agent 2>&1\n\tfi\n\t" . ($vps["load_balancer"] == -1 ? "\n\t\tsystemctl status haproxy\n\t\tif [ \$? != 0 ] ; then\n\t\t\tapt-get clean -y 2>&1\n\t\t\tapt-get update -y 2>&1\n\t\t\tapt-get install -y haproxy 2>&1\n\t\tfi\n\t" : "") . "\nfi\nsystemctl enable qemu-guest-agent\n" . ($vps["load_balancer"] == -1 ? "systemctl enable haproxy" : "") . "\nif [ \"\$OS\" = redhat  ] ; then\n\tconfig=/etc/sysconfig/qemu-ga\n\tsed -c -i \"s/\\(BLACKLIST_RPC *= *\\).*/\\1guest\\-file\\-seek/\" \$config\nfi\n\nREL=\$(cat /etc/redhat-release)\nrhel9=\"\$(echo \$REL | egrep -i '(release 9)')\"\necho \$rhel9\nif [ \"\$?\" -eq \"0\" ]; then\n\tconfig=/etc/sysconfig/qemu-ga\n\tsed -c -i \"s/\\(BLOCK_RPCS *= *\\).*/\\1guest\\-file\\-seek/\" \$config\nfi\n\nsystemctl unmask qemu-guest-agent\n" . ($vps["load_balancer"] == -1 ? "systemctl unmask haproxy" : "") . "\nsystemctl restart qemu-guest-agent\n" . ($vps["load_balancer"] == -1 ? "systemctl restart haproxy" : "")];
            perform_vps_operation($vps["vpsid"], $actid, "install_recipe", $data);
        }
    }
    public function fstrim_handle($vid, $_mount = [], $actid = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $user;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("fstrim_handle", $vid, 0, $vid, $user["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "fstrim_handle", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        if(empty($globals["disable_virtsparsify"])) {
            vexec("virt-sparsify -V", $o, $r);
            $o = explode(" ", $o[0]);
            $version = trim(substr(trim($o[1]), 0, 4));
            if(version_compare($version, "1.26", ">=")) {
                foreach ($vps["disks"] as $k => $_disk_) {
                    if(preg_match("/file/is", $_disk_["type"]) && preg_match("/qcow2/is", $_disk_["format"])) {
                        vexec("virt-sparsify --in-place " . $_disk_["path"], $o, $r);
                    }
                }
            }
        }
        if(empty($_mount)) {
            $mount = mount($vid);
        } else {
            $mount = $_mount;
        }
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return true;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(!is_dir($mount["mount_point"] . "/etc/cron.weekly")) {
            mkdir($mount["mount_point"] . "/etc/cron.weekly", 493);
        }
        $fstrim_file = $mount["mount_point"] . "/etc/cron.weekly/fstrim";
        $fstrim = "#!/bin/sh\n# trim all mounted file systems which support it\n/sbin/fstrim /";
        if(is_safe_file($fstrim_file) && !file_exists($fstrim_file)) {
            writefile($fstrim_file, $fstrim, 1, 493);
        }
        if(empty($_mount)) {
            $umount = umount($mount);
            if(!empty($umount)) {
                $error[] = $l["kvm_err_unmount"];
                task_update($actid, $l["kvm_err_unmount"], -1);
                return false;
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vscpu($ids, $speed = 1000000, $times = 2)
    {
        $vs_status = $this->status($ids);
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        $vpsnames = [];
        $usage = [];
        $_cpu_stats = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpsnames[$row["vpsid"]] = $row["vps_name"];
            $usage[$row["vpsid"]] = 0;
        }
        if(empty($vpsnames)) {
            return false;
        }
        $_cpu_stats = $this->_cpu_stats();
        foreach ($vpsnames as $k => $vpsname) {
            if($vs_status[$k] !== 0 && array_key_exists($vpsname, $_cpu_stats)) {
                $usage[$k] = trim($_cpu_stats[$vpsname]["cpu"]);
            } else {
                $usage[$k] = 0;
            }
        }
        return $usage;
    }
    public function vsram($ids)
    {
        $used_ram = 0;
        $ram[0]["used"] = 0;
        $ram[0]["ram"] = 0;
        $status = $this->status($ids);
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t WHERE vpsid IN (" . implode(", ", $ids) . ")");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(empty($status[$row["vpsid"]])) {
                $row["ram"] = 0;
            }
            $tmp = $this->ram($row["vpsid"]);
            $ram[$row["vpsid"]]["used"] = !empty($tmp["has_ga"]) ? $tmp["used"] : $row["ram"];
            $ram[$row["vpsid"]]["label"] = "VPS : " . $row["vps_name"];
            $ram[$row["vpsid"]]["ram"] = $row["ram"];
        }
        $meminfo = get_meminfo();
        $free = $meminfo["Buffers"] + $meminfo["Cached"] + $meminfo["MemFree"];
        $used_ram = $meminfo["MemTotal"] - $free;
        $ram[0]["used"] = $used_ram;
        $ram[0]["ram"] = $meminfo["MemTotal"];
        return $ram;
    }
    public function backup($vps, $temp_backup_dir, $disable_compress, $disk_num, $io_limit)
    {
        global $globals;
        global $error;
        global $l;
        $append = empty($disk_num) ? "" : "_" . $disk_num;
        $append .= "_" . parse_backup_hostname($vps["hostname"]);
        $DISK = get_vps_disk($vps["vpsid"], "", $disk_num);
        if(preg_match("/file/is", $DISK["type"])) {
            $filename = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . "." . ($DISK["format"] == "qcow2" ? "qcow2" : "img");
            $qemu_user = "qemu";
            $support_compress = 1;
            if(distro_check(0, 0, 1)) {
                $qemu_user = "libvirt-qemu";
                $support_compress = 0;
            }
            $qemu_details = get_qemu_details();
            $is_new_libvirt = false;
            if((os_check("centos", ">=", 8) || os_check("ubuntu", ">=", 20) || os_check("debian", ">=", 10) || os_check("almalinux", ">=", 8) || os_check("rocky", ">=", 8)) && version_compare($qemu_details["libvirt_ver"], "6.0.0", ">=")) {
                $is_new_libvirt = true;
            }
            touch($temp_backup_dir . "/" . $filename);
            chown($temp_backup_dir . "/" . $filename, $qemu_user);
            if(!defined("DONT_ECHO")) {
                echo "Temp Directory : " . $temp_backup_dir . "/" . $filename . "\n";
                echo "Qemu User : " . $qemu_user . "\n";
            }
            $qmp_command = ["execute" => "query-block"];
            if(!defined("DONT_ECHO")) {
                echo "Executing command : /usr/bin/virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($qmp_command)) . "\n";
            }
            oexec("/usr/bin/virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($qmp_command)), $out, $ret);
            if(!defined("DONT_ECHO")) {
                echo "\n OUTPUT : " . print_r($out, 1) . "\n";
            }
            $out = json_decode($out, true);
            $device = $out["return"][$disk_num]["device"];
            if($is_new_libvirt) {
                $device = $out["return"][$disk_num]["inserted"]["node-name"];
            }
            if(empty($device)) {
                $error[] = $l["log_err_disk_device"];
                return false;
            }
            $qmp_command = ["execute" => "drive-backup", "arguments" => ["device" => $device, "target" => $temp_backup_dir . "/" . $filename, "sync" => "full", "format" => $DISK["format"], "speed" => round($io_limit / 8 * 1024 * 1024)]];
            if($is_new_libvirt) {
                $qmp_command["arguments"]["job-id"] = "virt_backup_" . $vps["vpsid"];
            }
            if(!empty($support_compress)) {
                $qmp_command["arguments"]["compress"] = $DISK["format"] == "qcow2" && empty($disable_compress) ? true : false;
            }
            if(os_distro_check("debian")) {
                $this->apparmor_file_addrem($vps["vpsid"], $temp_backup_dir . "/" . $filename, "add");
                if(!empty($error)) {
                    echo print_r($error, 1) . "\n";
                }
            }
            if(!defined("DONT_ECHO")) {
                echo "\nExecuting command : /usr/bin/virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($qmp_command)) . "\n";
            }
            oexec("/usr/bin/virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($qmp_command)), $out, $ret);
            if(!defined("DONT_ECHO")) {
                echo "\n OUTPUT : " . print_r($out, 1) . "\n";
            }
            $out = json_decode($out, true);
            if(!empty($out["error"])) {
                return false;
            }
            $regex = "\\|";
            if($is_new_libvirt) {
                $regex = "|";
            }
            vexec("/usr/bin/virsh qemu-monitor-event " . $vps["vps_name"] . " --event \"BLOCK_JOB_COMPLETED" . $regex . "BLOCK_JOB_ERROR\" --regex", $out, $ret);
            if(os_distro_check("debian")) {
                $this->apparmor_file_addrem($vps["vpsid"], $temp_backup_dir . "/" . $filename, "remove");
            }
            if(preg_match("/BLOCK_JOB_ERROR/is", $out[0])) {
                $error[] = $l["log_err_drive_backup"];
                return false;
            }
            chown($temp_backup_dir . "/" . $filename, "root");
            if(empty($disable_compress)) {
                $compression_algo = get_compression_algo(1, 0);
                if(preg_match("/" . $compression_algo["file_ext"] . "/is", ".img.zst") || preg_match("/" . $compression_algo["file_ext"] . "/is", ".img.lz4") || preg_match("/" . $compression_algo["file_ext"] . "/is", ".img.lzo") || preg_match("/" . $compression_algo["file_ext"] . "/is", ".img.gz")) {
                    $compression_algo["file_ext"] = "." . substr(strrchr($compression_algo["file_ext"], "."), 1);
                }
                if(preg_match("/" . $compression_algo["file_ext"] . "/is", ".zst")) {
                    $compression_algo["compression_algo"] = preg_replace("/-c/is", "", $compression_algo["compression_algo"]);
                    vexec($compression_algo["compression_algo"] . " " . xss($temp_backup_dir . "/" . $filename) . " 2>&1");
                } else {
                    vexec($compression_algo["compression_algo"] . " " . xss($temp_backup_dir . "/" . $filename) . " > " . xss($temp_backup_dir . "/" . $filename . $compression_algo["file_ext"]) . " 2>&1");
                }
                unlink($temp_backup_dir . "/" . $filename);
                $filename = $filename . $compression_algo["file_ext"];
            }
            $ret_backup_filename = $filename;
        } else {
            $compression_algo = get_compression_algo(1, 0, 0);
            $compressed_backup = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . $compression_algo["file_ext"];
            $uncompressed_backup = $vps["vpsid"] . $append . (!empty($GLOBALS["backup_file_time"]) ? "_" . $GLOBALS["backup_file_time"] : "") . ".img";
            $DISK = vpsdisk_snapshot_create($vps["vpsid"], "backup-" . $vps["vps_name"], $disk_num);
            if(empty($DISK)) {
                $error[] = $l["temp_snap_err"];
                return false;
            }
            $sparse = "";
            if(preg_match("/thin block/i", $DISK["type"])) {
                $sparse = "conv=sparse";
            }
            $throttle_block_size = get_throttle_block_size();
            if(empty($disable_compress)) {
                $ret = vexec("/bin/dd if=" . xss($DISK["snapshot_path"]) . " bs=24M " . (!empty($globals["disable_dd_flags"]) ? "" : "iflag=direct ") . " | " . $compression_algo["compression_algo"] . " " . (empty($io_limit) ? "" : " | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit) . " | dd " . $sparse . " of=" . xss($temp_backup_dir . "/" . $compressed_backup) . " bs=24M 2>&1;");
                $ret_backup_filename = $compressed_backup;
            } else {
                $ret = vexec("/bin/dd if=" . xss($DISK["snapshot_path"]) . " bs=24M " . (!empty($globals["disable_dd_flags"]) ? "" : "iflag=direct ") . (empty($io_limit) ? "" : " | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit . " | dd ") . " " . $sparse . " of=" . xss($temp_backup_dir . "/" . $uncompressed_backup) . " bs=24M 2>&1");
                $ret_backup_filename = $uncompressed_backup;
            }
            if($ret != 0) {
                $error["err_backup_command_fail"] = $l["err_backup_command_fail"] . $ret;
            }
            $snapshot_delete = vpsdisk_snapshot_delete($DISK);
            if(!empty($snapshot_delete)) {
                $error = merge_error($error, $snapshot_delete);
                return false;
            }
            if(!empty($error)) {
                return false;
            }
        }
        if(@vfilesize($temp_backup_dir . "/" . $ret_backup_filename) < 1 || !store_backup_inf($vps, $temp_backup_dir)) {
            return false;
        }
        define("DONT_ECHO", 0);
        return $ret_backup_filename;
    }
    public function restore($vps, $temp_restore_dir, $backup_filename, $disk_num, $io_limit, $storagename = "")
    {
        global $globals;
        global $error;
        global $l;
        $last_actid = $GLOBALS["current_taskid"];
        $this->poweroff($vps["vpsid"]);
        $GLOBALS["current_taskid"] = $last_actid;
        $DISK = get_vps_disk($vps["vpsid"], "", $disk_num);
        if(preg_match("/file/is", $DISK["type"])) {
            $backup_filename_raw = "";
            $uncompression = get_decompression_algo($backup_filename, 1, 0);
            if(!in_array($uncompression["file_ext"], ["img", "qcow2"]) && in_array($uncompression["file_ext"], ["gz", "lzo", "zst", "lz4"])) {
                $backup_filename_raw = basename($backup_filename, "." . $uncompression["file_ext"]);
                vexec("/bin/tar vtf " . xss($temp_restore_dir . "/" . $backup_filename), $tar_path, $is_tar);
                $ret = 0;
                if(empty($is_tar)) {
                    $tar_path = explode(":", $tar_path[0], 2);
                    $tar_path = substr($tar_path[1], 3);
                    $strip_comp = explode("/", $tar_path);
                    array_pop($strip_comp);
                    $strip_comp = count($strip_comp);
                    vexec("/bin/tar -xzf " . xss($temp_restore_dir . "/" . $backup_filename) . " -C " . xss($temp_restore_dir . "/") . " --strip-components " . $strip_comp . " " . xss($tar_path) . " 2>&1", $o, $ret);
                } else {
                    vexec($uncompression["compression_algo"] . " " . $uncompression["params"] . " " . xss($temp_restore_dir . "/" . $backup_filename) . " > " . xss($temp_restore_dir . "/" . $backup_filename_raw) . ($uncompression["file_ext"] == "zst" ? " " : " 2>&1"), $o, $ret);
                }
                if($ret != "0") {
                    if(file_exists($temp_restore_dir . "/" . $backup_filename_raw)) {
                        @unlink($temp_restore_dir . "/" . $backup_filename_raw);
                    }
                    $error[] = $l["kvm_err_dd"];
                    return false;
                }
            }
            vexec("/usr/bin/qemu-img convert -O " . xss($DISK["format"]) . " " . xss($temp_restore_dir . "/" . (!empty($backup_filename_raw) ? $backup_filename_raw : $backup_filename)) . " " . xss($DISK["path"]), $o, $ret);
            if(!in_array($uncompression["file_ext"], ["raw", "qcow2"]) && file_exists($temp_restore_dir . "/" . $backup_filename_raw)) {
                unlink($temp_restore_dir . "/" . $backup_filename_raw);
            }
            if($ret != "0") {
                $error[] = $l["kvm_err_dd"];
                return false;
            }
        } else {
            $sparse = "";
            if(preg_match("/thin block/i", $DISK["type"])) {
                $sparse = "conv=sparse";
            }
            $throttle_block_size = get_throttle_block_size();
            $uncompression = get_decompression_algo($backup_filename, 1, 0);
            if(empty($uncompression["compression_algo"])) {
                vexec("/bin/dd " . $sparse . " if=" . xss($temp_restore_dir . "/" . $backup_filename) . (empty($io_limit) ? "" : " bs=24M | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit . " | dd") . " " . $sparse . " of=" . $DISK["path"] . " bs=24M 2>&1", $o, $ret);
            } else {
                vexec($uncompression["compression_algo"] . " " . $uncompression["params"] . " " . xss($temp_restore_dir . "/" . $backup_filename) . (empty($io_limit) ? "" : " | throttle -s " . $throttle_block_size . " -w 2 -m " . $io_limit) . " | dd " . $sparse . " of=" . xss($DISK["path"]) . " bs=24M 2>&1", $o, $ret);
            }
            if($ret != "0") {
                $error[] = $l["kvm_err_dd"];
                return false;
            }
        }
        return true;
    }
    public function vncDetails($vid)
    {
        global $globals;
        $vps = getvps($vid);
        $vps_name = $vps["vps_name"];
        $port = 0;
        $conf = file("/etc/libvirt/qemu/" . $vps_name . ".xml");
        foreach ($conf as $k => $v) {
            if(preg_match("/<graphics(\\s*?)(.*?)(\\s*?)passwd\\=('|\")(\\w*)('|\")/is", implode("", $conf), $passtmp)) {
                $vncpass = $passtmp[5];
            }
            if(preg_match("/<graphics(\\s*?)(.*?)(\\s*?)port\\=('|\")(\\d*)('|\")/is", implode("", $conf), $porttmp)) {
                $port = $porttmp[5];
            }
        }
        $info["port"] = $port;
        $info["ip"] = server_vncip($vps["serid"]);
        $info["password"] = $vncpass;
        if(empty($vps["vnc"])) {
            vexec("virsh qemu-monitor-command " . xss($vps["vps_name"]) . " --hmp \"expire_password  vnc now\"");
        } else {
            vexec("virsh qemu-monitor-command " . xss($vps["vps_name"]) . " --hmp \"change vnc password " . $info["password"] . "\"", $o, $r, [$info["password"]]);
            vexec("virsh qemu-monitor-command " . xss($vps["vps_name"]) . " --hmp \"expire_password  vnc never\"");
        }
        return $info;
    }
    public function changeVncPass($vid, $newpassword)
    {
        global $globals;
        $vps = getvps($vid);
        $vps_name = $vps["vps_name"];
        $vncdetails = $this->vncDetails($vid);
        $conf = file("/etc/libvirt/qemu/" . $vps_name . ".xml");
        foreach ($conf as $k => $v) {
            if(preg_match("/<graphics(\\s*?)(.*?)(\\s*?)passwd\\=('|\")(\\w*)('|\")/is", $v)) {
                $conf[$k] = "    <graphics type='vnc' port='" . $vncdetails["port"] . "' autoport='no' listen='" . server_vncip($vps["serid"]) . "' passwd='" . $newpassword . "' keymap='" . (empty($vps["vnc_keymap"]) ? "en-us" : $vps["vnc_keymap"]) . "'/>\n";
                $done = true;
            }
        }
        writefile("/etc/libvirt/qemu/" . $vps_name . ".xml", implode("", $conf), 1);
        $this->vnc_fix($vid);
        return true;
    }
    public function suspendvps($vpsid)
    {
        global $l;
        if($this->vps_status_statewise($vpsid, 1) == 2 || $this->vps_status_statewise($vpsid, 1) == 0) {
            return true;
        }
        $actid = vps_task("suspend_vps", "", 0, $vpsid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        $vps_name = $this->getname($vpsid);
        if($this->vps_status_statewise($vpsid, 1) == 0) {
            $this->start($vpsid);
        }
        vexec("/usr/bin/virsh suspend " . xss($this->vps_uuid($vpsid)), $output, $ret);
        if($ret == "0") {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        task_update($actid, $l["suspend_error"], -1);
        return false;
    }
    public function unsuspendvps($vpsid)
    {
        global $l;
        $vps_name = $this->getname($vpsid);
        $status = $this->status($vpsid, 1);
        if($status == 1) {
            return true;
        }
        $actid = vps_task("unsuspend_vps", "", 0, $vpsid, $GLOBALS["uid"], 0, $l["suspend_vps"]);
        task_start($actid);
        file_put_contents(logdir("unsuspend") . $vpsid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        vexec("/usr/bin/virsh resume " . xss($this->vps_uuid($vpsid)), $output, $ret);
        if($ret == "0") {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        vexec("/usr/bin/virsh destroy " . xss($this->vps_uuid($vpsid)), $dout, $dret);
        if($dret != 0) {
            task_update($actid, $l["unsuspend_error"], -1);
            return false;
        }
        sleep(1);
        oexec("/usr/bin/virsh create " . xss("/etc/libvirt/qemu/" . $vps_name . ".xml") . " 2>&1", $output, $sret);
        if($sret != 0) {
            task_update($actid, $l["unsuspend_error"], -1);
            return false;
        }
        task_update($actid, $l["unsuspend_error"], -1);
        return false;
    }
    public function suspend_vps_net($vid)
    {
        $vps_name = $this->getname($vid);
        $vif_name = $this->vifname($vid);
        vexec("ifconfig  " . xss($vif_name) . " down", $output, $ret);
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function unsuspend_vps_net($vid)
    {
        $vps_name = $this->getname($vid);
        $vif_name = $this->vifname($vid);
        file_put_contents(logdir("nw_unsuspend") . $vid . ".log", "\n" . datify(time(), 0, 1, "Y-m-d H:i:s"), FILE_APPEND);
        vexec("ifconfig " . xss($vif_name) . " up", $output, $ret);
        if($ret == "0") {
            return true;
        }
        return false;
    }
    public function vps_net_status($vpsid)
    {
        $vps_name = $this->getname($vpsid);
        $value = 0;
        $vif_name = $this->vifname($vpsid);
        if(!empty($vpsid)) {
            vexec("ifconfig", $output, $ret);
            $output = implode("\n", $output);
            $value = preg_match("/" . $vif_name . "/is", $output) ? 1 : 0;
        }
        return $value;
    }
    public function createtemplate($vid, $name)
    {
        global $globals;
        global $error;
        global $l;
        $vps = getvps($vid);
        $_DISK = get_vps_disk($vid);
        $path = $globals["kvmos"] . "/" . $name . ".img";
        if(file_exists($path)) {
            $error[] = $l["temp_exists"];
            return false;
        }
        if(preg_match("/block/is", $_DISK["type"])) {
            $DISK = vpsdisk_snapshot_create($vid, "template-" . $vps["vps_name"]);
            if(empty($DISK)) {
                $error[] = $l["temp_snap_err"];
                return false;
            }
        }
        if(preg_match("/file/is", $_DISK["type"])) {
            $vps_stat = $this->vps_status_statewise($vid, true);
            $tmp_path = $_DISK["mount_point"] . "/";
            if($vps_stat == 1 || $vps_stat == 2) {
                define("DONT_ECHO", 1);
                $filename = $this->backup($vps, $_DISK["mount_point"], 1, 0, "");
                if(!empty($filename)) {
                    sleep(1);
                    $basefile = basename($filename, "." . ($_DISK["format"] == "qcow2" ? "qcow2" : "img"));
                    if(!file_exists($tmp_path . $basefile . ".inf")) {
                        return false;
                    }
                    $tmp_file = $tmp_path . $filename;
                    $tmp_dest_file = $tmp_path . $name . "-" . generateRandStr(5) . ".img";
                    $DISK["basefile"] = $tmp_path . $basefile;
                    $DISK["snapshot_path"] = $tmp_dest_file;
                }
            } elseif($vps_stat == 0) {
                $tmp_file = $_DISK["path"];
                $tmp_dest_file = $path;
                $DISK["snapshot_path"] = "";
            }
            $ret = vexec("qemu-img convert " . $tmp_file . " -O raw " . $tmp_dest_file);
            if($ret != 0) {
                return false;
            }
        }
        if(!empty($DISK["snapshot_path"])) {
            vexec("/bin/dd if=" . xss($DISK["snapshot_path"]) . " of=" . xss($path) . " bs=24M 2>&1");
        }
        if(preg_match("/block/is", $_DISK["type"])) {
            $snapshot_delete = vpsdisk_snapshot_delete($DISK);
            if(!empty($snapshot_delete)) {
                $error = merge_error($error, $snapshot_delete);
                return false;
            }
        }
        if(preg_match("/file/is", $_DISK["type"]) && !empty($DISK["snapshot_path"])) {
            @unlink($DISK["snapshot_path"]);
            @unlink($DISK["basefile"] . ".inf");
            @unlink($DISK["basefile"] . "." . ($_DISK["format"] == "qcow2" ? "qcow2" : "img"));
        }
        if(@filesize($path) < 1) {
            return false;
        }
        return $name . ".img";
    }
    public function check_kernel()
    {
        global $l;
        global $globals;
        $return = false;
        $is_kvm = 1;
        oexec("/sbin/lsmod | grep kvm", $lsmod);
        if(!@preg_match("/kvm/is", $lsmod)) {
            oexec("ls -l /dev/kvm", $ls);
            if(!@preg_match("/kvm/is", $ls)) {
                $is_kvm = 0;
            }
        }
        if($is_kvm) {
            $return = true;
            oexec("/sbin/ifconfig", $viif);
            if(@preg_match("/" . $globals["bridge"] . "/is", $viif)) {
                $return = true;
            } else {
                $return = $l["kvm_network"];
            }
        } else {
            $return = $l["kvm_module"];
        }
        return $return;
    }
    public function get_cpu_models()
    {
        $cpu_models = [];
        vexec("virsh cpu-models x86_64 2>&1", $out, $ret);
        if($ret == 0 && !empty($out)) {
            foreach ($out as $v) {
                if(empty($v)) {
                } else {
                    $cpu_models[$v] = $v;
                }
            }
        }
        return $cpu_models;
    }
    public function resources()
    {
        global $globals;
        $ret["licnumvs"] = $globals["licnumvs"];
        $ret["ram"] = 0;
        $ret["space"] = 0;
        $ret["total_ram"] = 0;
        $ret["total_space"] = 0;
        $ret["check_kernel"] = $this->check_kernel();
        $ret["overcommit"] = $globals["overcommit"];
        $ret["lv"] = $globals["lv"];
        $ret["thin_lv"] = $globals["thin_lv"];
        $ret["disk_path"] = $globals["disk_path"];
        $meminfo = get_meminfo();
        if(array_key_exists("MemAvailable", $meminfo)) {
            $free = $meminfo["MemAvailable"];
        } else {
            $free = $meminfo["Buffers"] + $meminfo["Cached"] + $meminfo["MemFree"];
        }
        $ret["ram"] = $free;
        $ret["total_ram"] = $meminfo["MemTotal"];
        if(!empty($globals["disk_path"])) {
            vexec("df " . $globals["disk_path"], $disk);
            if(!empty($disk[1])) {
                $tmp = preg_split("/[\\s]+/", trim($disk[1]));
                $free_Kblocks = (double) trim($tmp[3]);
                $one_Kblocks = (double) trim($tmp[1]);
                $ret["total_space"] = @round($one_Kblocks / 1024 / 1024, 2);
                $ret["space"] = @round($free_Kblocks / 1024 / 1024, 2);
            }
        } elseif(!empty($globals["thin_lv"])) {
            vexec("lvdisplay -C --nosuffix --units k \"/dev/" . $globals["lv"] . "/" . $globals["thin_lv"] . "\"", $disk);
            if(!empty($disk[1])) {
                $tmp = preg_split("/[\\s]+/", trim($disk[1]));
                $used_percentage = (double) trim($tmp[4]);
                $free_percentage = 100 - $used_percentage;
                $total_space_kb = (double) trim($tmp[3]);
                $ret["total_space"] = @round($total_space_kb / 1024 / 1024, 2);
                $ret["space"] = @round($total_space_kb * $free_percentage / 100 / 1024 / 1024, 2);
            }
        } elseif(!empty($globals["lv"])) {
            vexec($globals["com"]["vgdisplay"] . " -C --nosuffix --units k \"" . $globals["lv"] . "\"", $disk);
            if(!empty($disk[1])) {
                $tmp = explode(" ", $disk[1]);
                $ret["space"] = @round((double) @trim($tmp[@count($tmp) - 1]) / 1024 / 1024, 2);
                $ret["total_space"] = @round((double) @trim($tmp[@count($tmp) - 2]) / 1024 / 1024, 2);
            }
        }
        $ret["cpu_model"] = $this->get_cpu_models();
        $ret["cpucores"] = get_cores();
        return $ret;
    }
    public function getmac($vpsid, $internal = 0)
    {
        $vps = getvps($vpsid);
        $cfg = "/etc/libvirt/qemu/" . $vps["vps_name"] . ".xml";
        $data = file_get_contents($cfg);
        $vif = $this->vifname($vpsid, $internal);
        $tmpxml = xmlstring2array($data);
        if(empty($vif) || empty($data) || empty($tmpxml["devices"]["interface"])) {
            return NULL;
        }
        $inf = is_array($tmpxml["devices"]["interface"][0]) ? $tmpxml["devices"]["interface"] : [$tmpxml["devices"]["interface"]];
        foreach ($inf as $v) {
            if($v["target"]["@attributes"]["dev"] == $vif && !empty($v["mac"]["@attributes"]["address"])) {
                $rest = $v["mac"]["@attributes"]["address"];
            }
        }
        return $rest;
    }
    public function change_mac_address($vpsid, $mac_address)
    {
        $vps = getvps($vpsid);
        $cfg = "/etc/libvirt/qemu/" . $vps["vps_name"] . ".xml";
        $doc = new DOMDocument();
        if(!$doc->load($cfg)) {
            return NULL;
        }
        $xp = new DOMXpath($doc);
        $elems = $xp->query("//interface[target[@dev='" . $this->vifname($vpsid) . "']]");
        if($elems->length != 1) {
            return NULL;
        }
        $elem = $elems->item(0);
        $mac = $elem->getElementsByTagName("mac")->item(0);
        if(empty($mac)) {
            $mac = $doc->createElement("mac");
            $elem->appendChild($mac);
        }
        if(!$mac->hasAttribute("address")) {
            $atr = $doc->createAttribute("address");
            $mac->appendChild($atr);
        }
        $mac->setAttribute("address", $mac_address);
        $doc->save($cfg);
        return true;
    }
    public function cron()
    {
        global $globals;
        global $l;
        global $kernel;
        $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_1";
        $vpses = get_bw_vps("kvm");
        $dev1 = file("/proc/net/dev");
        usleep(1000000);
        $dev2 = file("/proc/net/dev");
        $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_2";
        $cpu_usage = $this->_cpu_stats();
        $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_3";
        $status = $this->vps_status_statewise(array_keys($vpses));
        $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_4";
        $node_cores = get_cores();
        $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_5";
        $io_usage = $this->get_io_usage();
        $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_6";
        foreach ($vpses as $k => $v) {
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_7";
            if(!empty($globals["cb_bandwidth_overusage"]) && !empty($vpses[$k]["bandwidth"]) && $vpses[$k]["bandwidth"] < $vpses[$k]["used_bandwidth"]) {
                $callback["act"][] = "bandwidth_overusage";
                $callback["data"]["email"] = $vpses[$k]["email"];
                $callback["data"]["overused"] = $vpses[$k]["used_bandwidth"] - $vpses[$k]["bandwidth"];
                $service_period = get_vps_service_period($k);
                $before = $service_period["end"] - 480;
                $current = time();
                if($before < $current && $current <= $service_period["end"]) {
                    vps_task("bandwidth_overusage_callback", serialize($callback), 0, $k, $vpses[$k]["uid"], 0, $l["task_pending"]);
                }
            }
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_8";
            $vpses[$k]["status"] = $status[$k];
            if(!empty($status[$k])) {
                $autostart = "/etc/libvirt/qemu/autostart";
                if(!file_exists($autostart . "/" . $v["vps_name"] . ".xml")) {
                    if(!is_dir($autostart)) {
                        @mkdir($autostart);
                    }
                    vexec("/bin/ln -s " . xss("/etc/libvirt/qemu/" . $v["vps_name"] . ".xml") . " " . xss($autostart . "/" . $v["vps_name"] . ".xml") . " 2>/dev/null");
                }
            }
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_9";
            $ram = $this->ram($k);
            $vpses[$k]["cpu"] = $node_cores / $v["cores"] * $cpu_usage[$v["vps_name"]]["cpu"];
            if(100 < $vpses[$k]["cpu"]) {
                $vpses[$k]["cpu"] = 100;
            }
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_10";
            $vpses[$k]["net_speed"] = $this->network_speed($k, $dev1, $dev2);
            $vpses[$k]["disk"] = 0;
            $vpses[$k]["inode"] = 0;
            if(!empty($v["cached_disk"])) {
                $temp_disk = unserialize($v["cached_disk"]);
                $vpses[$k]["disk"] = $temp_disk["disk"]["Used"] / 1024;
                $vpses[$k]["inode"] = $temp_disk["inode"]["IUsed"];
            }
            makequery("INSERT INTO status SET\n\t\t\t\t\t`vpsid` = :vpsid, \n\t\t\t\t\t`time` = :time,\n\t\t\t\t\t`status` = :status,\n\t\t\t\t\t`disk` = :disk,\n\t\t\t\t\t`inode` = :inode,\n\t\t\t\t\t`ram` = :ram,\n\t\t\t\t\t`cpu` = :cpu,\n\t\t\t\t\t`actual_cpu` = :actual_cpu,\n\t\t\t\t\t`net_in` = :net_in,\n\t\t\t\t\t`net_out` = :net_out,\n\t\t\t\t\t`io_read` = :io_read,\n\t\t\t\t\t`io_write` = :io_write", [":vpsid" => $v["vpsid"], ":time" => $globals["cron_timestamp"], ":status" => $vpses[$k]["status"], ":disk" => $vpses[$k]["disk"], ":inode" => $vpses[$k]["inode"], ":ram" => !empty($ram["has_ga"]) ? $ram["used"] : 0, ":cpu" => $vpses[$k]["cpu"], ":actual_cpu" => $cpu_usage[$v["vps_name"]]["cpu"], ":net_in" => $vpses[$k]["net_speed"]["download"], ":net_out" => $vpses[$k]["net_speed"]["upload"], ":io_read" => $io_usage[$k]["read"], ":io_write" => $io_usage[$k]["write"]]);
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_11";
            $vpses[$k]["net_status"] = $this->vps_net_status($k);
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_12";
            if(!empty($vpses[$k]["suspended"]) && $vpses[$k]["status"] != 2) {
                if(time() - filemtime(logdir("unsuspend") . $k . ".log") <= 60) {
                    echo "VPSID : " . $k . " was just unsuspended and we will wait for the next CRONM\n";
                } else {
                    echo "Suspending VPSID " . $k . " as it should have been suspended\n";
                    $this->suspendvps($v["vpsid"]);
                    logs_vps("suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                }
            }
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_13";
            if(!empty($v["nw_suspended"])) {
                $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE vpsid = :vpsid \n\t\t\t\t\t\tAND action = 'bandwidth_unsuspend'\n\t\t\t\t\t\tAND started = 0 \n\t\t\t\t\t\tAND updated = 0 \n\t\t\t\t\t\tAND ended = 0", [":vpsid" => $v["vpsid"]]);
                $tmp_uvps = [];
                if(0 < vsql_num_rows($res)) {
                    $tmp_uvps = vsql_fetch_assoc($res);
                }
                $vs_nw_sus_dat = _unserialize($v["nw_suspended"]);
                if(!empty($tmp_uvps) && check_unsusp_vps_net($v["time"], $vs_nw_sus_dat["date"])) {
                    if($v["suspended"] == 1 && $v["suspend_reason"] == "bw") {
                        $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_14";
                        $this->unsuspendvps($v["vpsid"]);
                        $res = makequery("UPDATE vps SET \n\t\t\t\t\t\t\t\tsuspended = '0',\n\t\t\t\t\t\t\t\tsuspend_reason = ''\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        to_master("vps", "suspended", $v["vpsid"], "vpsid", "0");
                        to_master("vps", "suspend_reason", $v["vpsid"], "vpsid", "");
                    }
                    $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_15";
                    if($this->unsuspend_vps_net($v["vpsid"])) {
                        task_start($tmp_uvps["actid"]);
                        $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\tSET nw_suspended = NULL\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $v["vpsid"]]);
                        logs_vps("bandwidth_unsuspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                        to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", NULL);
                        task_update($tmp_uvps["actid"], $l["completed"], 100);
                    }
                } elseif($vpses[$k]["net_status"]) {
                    if(time() - filemtime(logdir("nw_unsuspend") . $k . ".log") <= 60) {
                        echo "VPSID : " . $k . " NETWORK was just unsuspended and we will wait for the next CRONM\n";
                    } else {
                        echo "Suspending network of VPSID " . $k . " as its network should have been suspended\n";
                        $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_16";
                        $this->suspend_vps_net($v["vpsid"]);
                        logs_vps("bandwidth_suspend_due_to_status", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                    }
                }
            }
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_17";
            $bandwidth_val = $kernel->bandwidth($v["vpsid"]);
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_18";
            $service_period = get_vps_service_period($v["vpsid"]);
            $timestamp_threshold = @file_get_contents($globals["var"] . "/eubwthreshold/" . $v["vpsid"]);
            $used_percent_bandw = round(100 * $bandwidth_val["used_gb"] / $bandwidth_val["limit_gb"]);
            $user_threshold_bandw = $v["preferences"]["vps_bandwidth_threshold"];
            $set_threshold_bandw = !empty($user_threshold_bandw) ? $user_threshold_bandw : $globals["vps_bandwidth_threshold"];
            if($user_threshold_bandw < 0) {
                $set_threshold_bandw = 0;
            }
            if(!empty($bandwidth_val["limit_gb"]) && !empty($set_threshold_bandw) && $set_threshold_bandw < $used_percent_bandw && $timestamp_threshold < $service_period["start"]) {
                $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "vps_bandwidth_threshold" => $set_threshold_bandw, "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                if(!empty($v["email"])) {
                    send_emailtemp_mail("bandwidth_threshold", $v["email"], $email_vars, 1);
                    writefile($globals["var"] . "/eubwthreshold/" . $v["vpsid"], time(), 1);
                }
                $data["title"] = $l["bandwidth_threshold_mail_sub"];
                $data["data"] = lang_vars_name($l["bandwidth_threshold_notify"], $email_vars);
                save_notification("vps_band_thershold", $data);
            }
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_19";
            if($bandwidth_val["limit_gb"] < $bandwidth_val["used_gb"] && !empty($bandwidth_val["limit_gb"]) && $v["band_suspend"] == 1 && empty($v["nw_suspended"]) && empty($globals["band_suspend"]) && $this->suspend_vps_net($v["vpsid"])) {
                echo "Suspending network of VPSID " . $k . " as bandwidth has been overused. Used : " . $bandwidth_val["used_gb"] . " Allowed : " . $bandwidth_val["limit_gb"] . "\n";
                $email_vars = ["hostname" => $v["hostname"], "vpsid" => $v["vpsid"], "used_gb" => $bandwidth_val["used_gb"], "limit_gb" => $bandwidth_val["limit_gb"], "sn" => $globals["sn"]];
                if(!empty($v["email"]) && empty($globals["disable_suspend_email"])) {
                    send_emailtemp_mail("bandwidth", $v["email"], $email_vars, 1);
                }
                $data["title"] = $l["bandwidth_mail_sub"];
                $data["data"] = lang_vars_name($l["bandwidth_mail_message_notify"], $email_vars);
                save_notification("vps_band_suspended", $data);
                $reason = serialize(["id" => "2", "reason" => "bw", "date" => time()]);
                $res = makequery("UPDATE vps \n\t\t\t\t\t\t\tSET nw_suspended = :reason\n\t\t\t\t\t\t\tWHERE vpsid= :vpsid", [":vpsid" => $v["vpsid"], ":reason" => $reason]);
                $v["nw_suspended"] = $reason;
                vps_task("bandwidth_unsuspend", $v["vps_name"], 0, $v["vpsid"], $v["uid"], 1);
                logs_vps("bandwidth_suspend", $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
                to_master("vps", "nw_suspended", $v["vpsid"], "vpsid", $reason);
            }
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_20";
            handle_speed_cap($v, $this, $bandwidth_val);
            $GLOBALS["cronm_exit_ret"]["kvm"][] = "kvm_kernel_cronm_21";
        }
        $this->perform_vertical_scaling();
    }
    public function cronh()
    {
        global $globals;
        if(!empty($globals["turnon_virtdf"])) {
            $res = makequery("SELECT v.*, b.in AS last_in, b.out AS last_out\n\t\t\t\t\t\t\tFROM vps v\n\t\t\t\t\t\t\tLEFT JOIN bandwidth b ON (v.vpsid = b.vpsid \n\t\t\t\t\t\t\tAND b.time = 0\n\t\t\t\t\t\t\tAND b.date = 0)\n\t\t\t\t\t\t\tWHERE v.serid = 0\n\t\t\t\t\t\t\tAND v.virt = 'kvm'");
            $vpses = [];
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $vpses[$row["vpsid"]] = $row;
            }
            $vps_disk_usage = $this->get_disk_usage();
            $vps_inode_usage = $this->get_inode_usage();
            foreach ($vpses as $k => $v) {
                if(!empty($vps_disk_usage[$v["vps_name"]]) || !empty($vps_inode_usage[$v["vps_name"]])) {
                    $tmp_data = ["disk" => $vps_disk_usage[$v["vps_name"]], "inode" => $vps_inode_usage[$v["vps_name"]]];
                    to_master("vps", "cached_disk", $k, "vpsid", serialize($tmp_data));
                }
            }
        } else {
            $vps_disk_usage = get_vps_disk_usage("kvm");
            foreach ($vps_disk_usage as $vpsid => $disk_usage) {
                to_master("vps", "cached_disk", $vpsid, "vpsid", serialize($disk_usage));
            }
        }
    }
    public function create_internal_network($ippid, $bind_ip)
    {
        global $globals;
        vexec("/sbin/ifconfig " . $globals["bridge"] . ":" . $ippid . " " . $bind_ip . " up");
    }
    public function destroy_internal_network($ippid)
    {
        global $globals;
        vexec("/sbin/ifconfig " . $globals["bridge"] . ":" . $ippid . " down");
    }
    public function create_rescue_disk($vid, $root_password)
    {
        global $globals;
        global $error;
        global $l;
        oslist();
        $vps = getvps($vid, 0);
        $data_decode = $vps["data"];
        $qemu_verison = get_qemu_details();
        $actid = vps_task("enable_rescuevs", "", 0, $vid, $vps["uid"], 0, $l["enable_rescuevs"]);
        task_start($actid);
        task_update($actid, $l["enabling_rescue"], 5);
        $GLOBALS["rescue"]["kvm"] = $GLOBALS["ostemplates_rescue"]["kvm"]["size"];
        $templ_name = $GLOBALS["ostemplates_rescue"]["kvm"]["file"];
        $lvsize = $GLOBALS["ostemplates_rescue"]["kvm"]["disk_size"];
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        if(empty($vps["rescue"])) {
            $error[] = $l["rescue_not_synced"];
            return false;
        }
        $vps_name = $vps["vps_name"];
        if(!file_exists($globals["kvmos"] . "/" . $templ_name) || filesize($globals["kvmos"] . "/" . $templ_name) != $GLOBALS["rescue"]["kvm"]) {
            task_update($actid, $l["download_rescue_temp"], 25);
            @unlink($globals["kvmos"] . "/" . $templ_name);
            $getfile = save_web_file("http://files.virtualizor.com/rescue.php?file=" . $templ_name, $globals["kvmos"] . "/" . $templ_name);
            if(empty($getfile) || filesize($globals["kvmos"] . "/" . $templ_name) != $GLOBALS["rescue"]["kvm"]) {
                $error[] = $l["err_downloading"];
                task_update($actid, $l["err_downloading"], -1);
                return false;
            }
        }
        $isopath = $sec_isopath = $isotype = $sec_isotype = "";
        if(!empty($vps["iso"])) {
            $isopath = iso_path($vps["uid"], $vps["iso"], $isotype);
        }
        if(!empty($vps["sec_iso"])) {
            $sec_isopath = iso_path($vps["uid"], $vps["sec_iso"], $sec_isotype);
        }
        $disks = get_vps_DISKS($vid);
        $DISK = get_vps_disk($vid);
        if(unserialize($vps["boot"])) {
            $vps["boot"] = unserialize($vps["boot"]);
            if(is_array($vps["boot"])) {
                array_unshift($vps["boot"], "rescuedisk");
            } else {
                $bootorder = [];
                array_push($bootorder, "rescuedisk");
                if(!empty($vps["iso"])) {
                    array_push($bootorder, "cdrom1");
                }
                if(!empty($vps["sec_iso"])) {
                    array_push($bootorder, "cdrom2");
                }
                for ($i = 1; $i < count($disks) + 1; $i++) {
                    array_push($bootorder, "disk" . $i);
                }
                $vps["boot"] = $bootorder;
            }
        }
        $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vid\n\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $ips[$i] = vsql_fetch_assoc($res);
            $_ips[$i] = $ips[$i]["ip"];
        }
        $routing = $ips[0]["routing"];
        task_update($actid, $l["creating_disk"], 35);
        $storage_create = vpsdisk_create($DISK);
        if(!empty($storage_create)) {
            $error[] = $l["kvm_err_lvm"];
            $error = merge_error($error, $storage_create);
            task_update($actid, $l["kvm_err_lvm"], -1);
            return false;
        }
        if(preg_match("/lightbit/is", $DISK["type"])) {
            $uuid = get_lightbit_uuid($DISK);
            if(empty($uuid)) {
                $return[] = $l["kvm_err_lightbit"];
                return $return;
            }
            $pathinfo = pathinfo($DISK["path"]);
            $DISK["path"] = $pathinfo["dirname"] . "/nvme-uuid." . $uuid;
        }
        task_update($actid, $l["copy_rescue"], 55);
        if(preg_match("/qcow2/is", $DISK["format"])) {
            $template_in_raw = substr($globals["kvmos"] . "/" . $templ_name, 0, -3);
            if(!(file_exists($template_in_raw) && is_safe_file($template_in_raw))) {
                vexec($globals["com"]["pgzip"] . " -dc " . xss($globals["kvmos"] . "/" . $templ_name) . " > " . xss($template_in_raw), $o, $ret);
            }
            vexec("qemu-img convert -f raw -O qcow2 " . xss($template_in_raw) . " " . xss($DISK["path"]), $o, $ret);
        } elseif(preg_match("/raw/is", $DISK["format"])) {
            vexec($globals["com"]["pgzip"] . " -dc " . xss($globals["kvmos"] . "/" . $templ_name) . " | /bin/dd of=" . xss($DISK["path"]) . " bs=24M 2>&1", $o, $ret);
        }
        if($ret != "0") {
            $error[] = $l["kvm_err_rescue_dd"];
            $error["derr"] = array_end($GLOBALS["logr"]);
            vpsdisk_destroy($DISK);
            task_update($actid, $l["kvm_err_rescue_dd"], -1);
            return false;
        }
        task_update($actid, $l["resizing_disk"], 60);
        $resize = vpsdisk_resize($vid);
        if(!empty($resize["error"])) {
            $error = merge_error($error, $resize["error"]);
            task_update($actid, implode("<br>", $error), -1);
            return false;
        }
        $DISK["diskinfo"] = $resize["diskinfo"];
        task_update($actid, $l["resizing_fs"], 63);
        $fs_resize = vpsdisk_resize_filesystem($DISK);
        if(!empty($fs_resize["error"])) {
            $error = merge_error($error, $fs_resize["error"]);
            task_update($actid, implode("<br>", $error), -1);
            return false;
        }
        task_update($actid, $l["mount"], 65);
        $mount = mount($vid);
        if(!is_array($mount)) {
            $error[] = $l["kvm_err_mount"];
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        $post = [];
        if(file_exists($mount["mount_point"] . "/etc/shadow")) {
            $shadow = file($mount["mount_point"] . "/etc/shadow");
            $tmp = explode(":", $shadow[0]);
            $tmp[1] = crypt($root_password);
            $shadow[0] = implode(":", $tmp);
            writefile($mount["mount_point"] . "/etc/shadow", implode("", $shadow), 1);
        }
        if(!empty($vps["dns_nameserver"])) {
            $dns = unserialize($vps["dns_nameserver"]);
            $post["dns"] = $dns;
        }
        task_update($actid, $l["net_config"], 70);
        network_configure($mount["mount_point"], $ips, $post, $routing);
        task_update($actid, $l["hostname_config"], 75);
        hostname_configure($mount["mount_point"], "rescue");
        task_update($actid, $l["sshkey_clean"], 80);
        sshkey_clean($mount["mount_point"]);
        task_update($actid, $l["umount"], 85);
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
            return false;
        }
        $this->poweroff($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "poweroff_vps");
        _task_update($actid, $l["power_off_vps"], 90, $next_actid);
        $new_config = (!empty($vps["iso"]) && !empty($isopath) && file_exists($globals[$isotype] . "/" . $isopath) && is_file($globals[$isotype] . "/" . $isopath) ? "\n    <disk type='file' device='cdrom'>\n      <source file='" . $globals[$isotype] . "/" . $isopath . "'/>\n      <target dev='hdc' bus='ide'/>\n\t  <boot order='" . (array_search("cdrom1", $vps["boot"]) + 1) . "'/>\n      <readonly/>\n    </disk>" : "") . "\n    " . (!empty($vps["sec_iso"]) && !empty($sec_isopath) && file_exists($globals[$sec_isotype] . "/" . $sec_isopath) && is_file($globals[$sec_isotype] . "/" . $sec_isopath) ? "\n    <disk type='file' device='cdrom'>\n      <source file='" . $globals[$sec_isotype] . "/" . $sec_isopath . "'/>\n      <target dev='hdd' bus='ide'/>\n\t  <boot order='" . (array_search("cdrom2", $vps["boot"]) + 1) . "'/>\n      <readonly/>\n    </disk>" : "");
        $dev_r = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"];
        $i = 1;
        $counter = 1;
        foreach ($disks as $dk => $D) {
            $dev = $dev_r[$i];
            if(!empty($D["primary"])) {
                $dev = "a";
            } else {
                $i++;
            }
            $device = !empty($vps["virtio"]) && $vps["virtio"] == 1 ? "vd" : "hd";
            $device_bus = empty($vps["virtio"]) ? "ide" : ($vps["virtio"] == 1 ? "virtio" : ($vps["virtio"] == 2 ? "scsi" : "ide"));
            $rotational_rate = !empty($data_decode["ssd_emulation"]) && (version_compare($qemu_verison["libvirt_ver"], "7.3.0", ">=") || preg_match("/windows/is", $vps["os_name"])) ? " rotation_rate='1'" : "";
            $type = "type='" . $D["format"] . "'";
            if(preg_match("/lightbit/is", $D["type"]) && preg_match("/rescue/is", basename($D["path"]))) {
                $uuid = get_lightbit_uuid($D);
                $pathinfo = pathinfo($D["path"]);
                $D["path"] = $pathinfo["dirname"] . "/nvme-uuid." . $uuid;
            }
            $boot_order = !empty($D["rescue"]) ? 1 : array_search("disk" . $counter, $vps["boot"]) + 1;
            $new_config .= "\n    <disk type='" . (preg_match("/file/is", $D["type"]) ? "file" : "block") . "' device='disk'>\n      <driver name='qemu' " . $type . " cache='" . (empty($vps["kvm_cache"]) ? "none" : $vps["kvm_cache"]) . "' " . (empty($vps["io_mode"]) ? "" : "io='" . $vps["io_mode"] . "'") . "/>\n      <source " . (preg_match("/file/is", $D["type"]) ? "file" : "dev") . "='" . $D["path"] . "'/>\n\t  <boot order='" . $boot_order . "'/>\n      <target dev='" . $device . $dev . "' bus='" . $device_bus . "' " . $rotational_rate . " />\n    </disk>";
            $counter += 1;
        }
        if(!empty($data_decode["ssd_emulation"]) && (version_compare($qemu_verison["libvirt_ver"], "7.3.0", "<") || preg_match("/windows/is", $vps["os_name"])) && (os_check("centos", ">=", 7) || os_check("ubuntu", ">=", 0))) {
            $ssd_conf = "";
            $ssd_conf .= "\n\t\t<qemu:commandline>";
            for ($i = 0; $i < count($disks); $i++) {
                $ssd_conf .= "\n\t\t\t<qemu:arg value='-set'/>\n\t\t\t<qemu:arg value='device.scsi0-0-0-" . $i . ".rotation_rate=1'/>";
            }
            $ssd_conf .= "\n\t\t</qemu:commandline>";
        }
        $cfg = "/etc/libvirt/qemu/" . $vps_name . ".xml";
        copy($cfg, $cfg . ".bak");
        $config_file = file_get_contents($cfg);
        $config_file = preg_replace("/\\<disk(.*)\\>(.*)\\<\\/disk\\>/is", "", $config_file);
        $config_file = str_replace("<devices>", "<devices>" . $new_config, $config_file);
        if(!empty($ssd_conf)) {
            $config_file = preg_replace("/\\<qemu:commandline(.*)\\>(.*)\\<\\/qemu:commandline\\>/is", "", $config_file);
            $config_file = str_replace("</domain>", $ssd_conf . "</domain>", $config_file);
        }
        task_update($actid, $l["written_config_file"], 93);
        writefile($cfg, $config_file, 1);
        @chmod($cfg, 384);
        if(!empty($vps["suspended"])) {
            return true;
        }
        $this->start($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "start_vps");
        _task_update($actid, $l["beginning_start_vps"], 95, $next_actid);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function delete_rescue_disk($vid)
    {
        global $globals;
        global $error;
        global $l;
        $vps = getvps($vid, 0);
        $actid = vps_task("disable_rescuevs", "", 0, $vid, $vps["uid"], 0, $l["disable_rescuevs"]);
        task_start($actid);
        task_update($actid, $l["disabling_rescue"], 5);
        if(empty($vps)) {
            $error[] = $l["build_no_vs"];
            task_update($actid, $l["build_no_vs"], -1);
            return false;
        }
        $vps_name = $vps["vps_name"];
        $this->poweroff($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "poweroff_vps");
        _task_update($actid, $l["power_off_vps"], 35, $next_actid);
        $DISK = get_vps_disk($vid);
        if(!empty($DISK["rescue"])) {
            task_update($actid, $l["delete_vpsdisks"], 45);
            $storage_destroy = vpsdisk_destroy($DISK);
            if(!empty($storage_destroy)) {
                $error = merge_error($error, $storage_destroy);
                task_update($actid, implode("<br>", $error), -1);
                return false;
            }
        }
        task_update($actid, $l["disabling_rescue"], 55);
        @unlink("/etc/libvirt/qemu/" . $vps_name . ".xml");
        rename("/etc/libvirt/qemu/" . $vps_name . ".xml.bak", "/etc/libvirt/qemu/" . $vps_name . ".xml");
        if(!empty($vps["suspended"])) {
            return true;
        }
        $this->start($vps["vpsid"]);
        $next_actid = get_next_task_actid($vps["vpsid"], $actid, "start_vps");
        _task_update($actid, $l["beginning_start_vps"], 75, $next_actid);
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vm_location($vids, $live = false)
    {
        return $vids;
    }
    public function storage_check($data)
    {
        global $l;
        if($data["type"] == "block") {
            exec("vgdisplay " . xss($data["path"]) . " >> /dev/null 2>&1", $vgout, $vgret);
            if($vgret != 0) {
                return "The Volume Group doesn't exist";
            }
            return "";
        }
        if(preg_match("/ceph/is", $data["type"])) {
            exec("ceph osd lspools", $cephout, $cephret);
            foreach ($cephout as $k => $v) {
                if(preg_match("/" . basename($data["path"]) . "/is", $v)) {
                    return "";
                }
            }
            return "The Ceph Pool doesn't exist";
        } else {
            if(!preg_match("/zfs/is", $data["type"]) && preg_match("/thin/is", $data["type"]) && preg_match("/block/is", $data["type"])) {
                $size = storage_size($data["path"], $data["type"]);
                if($size["size"] < 1) {
                    return "The Thin LVM Pool doesn't exist";
                }
                return "";
            }
            if(preg_match("/zfs/is", $data["type"])) {
                exec("zfs list >> /dev/null 2>&1", $vgout, $vgret);
                if($vgret != 0) {
                    return "ZFS module is either not installed or not configured properly on this server";
                }
                exec("zpool status " . basename($data["path"]), $out, $ret);
                if($ret != 0) {
                    return "This ZFS pool does not exist on the server";
                }
                return "";
            }
            if(preg_match("/lightbit/is", $data["type"])) {
                vexec("lbcli get project --name " . $data["project_name"], $o, $r);
                if($r != 0) {
                    return $l["kvm_err_lightbit_proj"];
                }
                if(!file_exists($data["path"])) {
                    return $l["kvm_err_lightbit_storage"];
                }
                return "";
            }
            if(!file_exists($data["path"])) {
                return "The storage doesn't exist";
            }
            return "";
        }
    }
    public function _newVncPort()
    {
        $files = filelist("/etc/libvirt/qemu/", 0);
        $vncport = 5900;
        foreach ($files as $k => $v) {
            if(!empty($v["dir"])) {
                unset($files[$k]);
            } elseif(substr($k, -3) != "xml") {
                unset($files[$k]);
            } else {
                $conf = file_get_contents($k);
                $porttmp = [];
                if(preg_match("/<graphics(\\s*?)(.*?)(\\s*?)port\\=('|\")(\\d*)('|\")/is", $conf, $porttmp)) {
                    $port = $porttmp[5];
                    if($vncport < $port) {
                        $vncport = $port;
                    }
                }
            }
        }
        for ($i = 1; $i < 1000; $i++) {
            $vncport = $vncport + 1;
            if(vexec("lsof -i:" . $vncport) != 0) {
                break;
            }
        }
        return $vncport;
    }
    public function _network_usage($vid, $dev = [])
    {
        $vps = getvps($vid);
        $vif_name = $this->vifname($vid);
        if(empty($dev)) {
            $dev = file("/proc/net/dev");
        }
        $devices = [];
        foreach ($dev as $k => $x) {
            $_dev = preg_split("/[\\s]+/", str_replace(":", ": ", trim($x)));
            $_dev[0] = trim($_dev[0], ":");
            foreach ($_dev as $kk => $vv) {
                $tmp[$kk] = trim($vv);
            }
            $devices[$tmp[0]] = $tmp;
        }
        $value = $devices[$vif_name];
        if(empty($value[1]) && empty($value[9])) {
            $value[1] = 0;
            $value[9] = 0;
        }
        list($c["out"], $c["in"]) = $value;
        return $c;
    }
    public function _cpu_stats()
    {
        global $globals;
        $ret = [];
        if(!empty($globals["disable_virttop"])) {
            return $ret;
        }
        vexec("virt-top -n 2 -d 0.005 --stream", $tmp_out, $tmp_ret);
        $i = 0;
        foreach ($tmp_out as $tk => $tv) {
            if($i == 2) {
                $tmp_data = explode(" ", $tv);
                foreach ($tmp_data as $tkk => $tvv) {
                    if(empty($tvv)) {
                    } else {
                        $final_data[] = $tvv;
                    }
                }
                $final_data = array_reverse($final_data);
                $res["name"] = empty($final_data[0]) ? 0 : trim($final_data[0]);
                $ret[$res["name"]]["mem"] = empty($final_data[2]) ? 0 : trim($final_data[2]);
                $ret[$res["name"]]["cpu"] = empty($final_data[3]) ? 0 : trim($final_data[3]);
            }
            if(preg_match("/virt-top/is", $tv)) {
                $i++;
            }
        }
        return $ret;
    }
    public function get_disk_usage()
    {
        $ret = [];
        if(!file_exists(logdir() . "virtualizor-df.log") || !is_link("/usr/bin/virtualizor-df")) {
            vexec("ln -s /usr/bin/virt-df /usr/bin/virtualizor-df");
        }
        vexec("ps aux | grep \"[v]irtualizor-df\"", $output);
        if(!empty($output)) {
            if(600 >= time() - filemtime(logdir() . "virtualizor-df.log")) {
                return $ret;
            }
            vexec("killall -s SIGKILL virtualizor-df", $out, $vret);
            if($vret != 0) {
                return $ret;
            }
        }
        writefile(logdir() . "virtualizor-df.log", "virtualizor-df Started at " . datify(time(), 0, 1, "Y-m-d H:i:s") . "\n", 1);
        vexec("virtualizor-df 2>/dev/null --csv", $tmp_out, $tmp_ret);
        $_heading = explode(",", $tmp_out[0]);
        unset($tmp_out[0]);
        foreach ($tmp_out as $tk => $tv) {
            $tmp_data = explode(",", $tv);
            foreach ($tmp_data as $k => $v) {
                $ret[$tmp_data[0]][$_heading[$k]] = trim($v);
            }
        }
        return $ret;
    }
    public function get_inode_usage()
    {
        $ret = [];
        if(!file_exists(logdir() . "virtualizor-df.log") || !is_link("/usr/bin/virtualizor-df")) {
            vexec("ln -s /usr/bin/virt-df /usr/bin/virtualizor-df");
        }
        vexec("ps aux | grep \"[v]irtualizor-df\"", $output);
        if(!empty($output)) {
            if(600 >= time() - filemtime(logdir() . "virtualizor-df.log")) {
                return $ret;
            }
            vexec("killall -s SIGKILL virtualizor-df", $out, $vret);
            if($vret != 0) {
                return $ret;
            }
        }
        writefile(logdir() . "virtualizor-df.log", "virtualizor-df Started at " . datify(time(), 0, 1, "Y-m-d H:i:s") . "\n", 1);
        vexec("virtualizor-df -i 2>/dev/null --csv", $tmp_out, $tmp_ret);
        $_heading = explode(",", $tmp_out[0]);
        unset($tmp_out[0]);
        foreach ($tmp_out as $tk => $tv) {
            $tmp_data = explode(",", $tv);
            foreach ($tmp_data as $k => $v) {
                $ret[$tmp_data[0]][$_heading[$k]] = trim($v);
            }
        }
        return $ret;
    }
    public function delete_vpsdisks($vpsid, $data, $actid = 0)
    {
        global $error;
        global $user;
        global $l;
        $status = no_log_status($vpsid, 1, $this);
        if(($status == 1 || empty($actid)) && $status == 1) {
            $disk_data = serialize($data);
            $actid = vps_task("delete_vpsdisks", $disk_data, 0, $vpsid, $user["uid"], 1, $l["change_onboot"]);
            return -1;
        }
        task_start($actid);
        foreach ($data as $k => $DISK) {
            $DISK["vpsid"] = $vpsid;
            $disk_destroy = vpsdisk_destroy($DISK);
            if(!empty($disk_destroy)) {
                $error = merge_error($error, $disk_destroy);
                task_update($actid, $l["disk_destroy_err"], -1);
                return false;
            }
        }
        task_update($actid, $l["completed"], 100);
        return true;
    }
    public function vs_ntw_speed($vpsids)
    {
        $ret = [];
        $dev1 = file("/proc/net/dev");
        usleep(1000000);
        $dev2 = file("/proc/net/dev");
        foreach ($vpsids as $k => $v) {
            $ret[$v] = $this->network_speed($v, $dev1, $dev2);
        }
        return $ret;
    }
    public function vs_disk_usage($vpsids)
    {
        $ret = [];
        $res = makequery("SELECT * FROM vps WHERE vpsid IN (" . implode(",", $vpsids) . ")");
        if(vsql_num_rows($res) < 1) {
            return false;
        }
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $tmp = _unserialize($row["cached_disk"]);
            $ret[$row["vpsid"]]["disk"]["used"] = empty($tmp["disk"]["Used"]) ? 0 : $tmp["disk"]["Used"] / 1024 / 1024;
            $ret[$row["vpsid"]]["disk"]["allocated"] = $row["space"];
            $ret[$row["vpsid"]]["inode"]["used"] = empty($tmp["inode"]["IUsed"]) ? 0 : $tmp["inode"]["IUsed"];
            $ret[$row["vpsid"]]["inode"]["allocated"] = empty($tmp["inode"]["Inodes"]) ? 0 : $tmp["inode"]["Inodes"];
        }
        return $ret;
    }
    public function migrate($vpsid, $data, $migrate_disk = 0)
    {
        global $globals;
        global $error;
        global $l;
        global $cluster;
        $speed = (int) (!empty($globals["default_mig_speed"]) ? $globals["default_mig_speed"] : 100);
        $sparse = 0;
        $vps_name = $this->getname($vpsid);
        if(!empty($data["speed_limit"])) {
            $speed = $data["speed_limit"];
        }
        if(empty($data["disable_gzip"])) {
            $data["disable_gzip"] = 0;
        }
        if($data["dest_disks"][$data["disk_num"]]["type"] == "file" || $data["dest_disks"][$data["disk_num"]]["type"] == "thin block") {
            $sparse = 1;
        }
        $throttle_block_size = get_throttle_block_size();
        if(!empty($data["live_mig"])) {
            $live_mig_tmp_path = "/var/virtualizor/tmp/live_mig/" . $vps_name;
            if(!is_dir($live_mig_tmp_path) && !mkdir($live_mig_tmp_path, 493, 1)) {
                $error[] = $l["mig_err_bg_exec"];
                $error[] = print_r(error_get_last(), 1);
                return false;
            }
            $tmp_xml_path = $live_mig_tmp_path . "/" . $vps_name . ".xml";
            vexec("virsh dumpxml " . xss($vps_name) . " --migratable", $o, $r);
            if($r || !file_put_contents($tmp_xml_path, implode("\n", $o))) {
                $error[] = $l["mig_err_bg_exec"];
                $error[] = print_r(error_get_last(), 1);
                return false;
            }
            $dest_vnc = [];
            if(isset($data["vnc_ip_dest"]) && isset($data["vnc_port_dest"])) {
                $dest_vnc = ["dest_ip" => $data["vnc_ip_dest"], "dest_port" => $data["vnc_port_dest"]];
            }
            $vps_nics = [$this->vifname($vpsid) => "viif" . $data["new_vpsname"], "vinf" . $vps_name => "vinf" . $data["new_vpsname"]];
            $this->live_mig_update_tmp_conf($tmp_xml_path, $vpsid, ["orig_disks" => $data["orig_disks"], "dest_disks" => $data["dest_disks"]], $dest_vnc, $vps_nics);
            $hn = $data["dest_server_hostname"];
            if($hn && $hn != -1) {
                $hf = file("/etc/hosts");
                $found = 0;
                foreach ($hf as $k => $v) {
                    $v = trim($v);
                    if(preg_match("/^#/", $v)) {
                    } else {
                        $v = preg_split("/\\s+/", $v);
                        if(in_array($hn, $v)) {
                            $found = 1;
                        }
                    }
                }
                if($found == 0) {
                    $hf[] = $data["to_ip"] . " " . $hn . "\n";
                    file_put_contents("/etc/hosts", implode("", $hf));
                }
            }
            $setmaxdowntime = !empty($globals["setmaxdowntime"]) ? $globals["setmaxdowntime"] : 500;
            $shared_st_mig = !empty($data["shared_st_mig"]) ? 1 : 0;
            putenv("LC_ALL=en_US.UTF-8");
            $live_mig_command = "bash " . $globals["path"] . "/scripts/live_migrate.sh " . $data["new_vpsname"] . " " . $data["to_ip"] . " " . $data["to_ssh_port"] . " " . $speed . " " . $vps_name . " " . $setmaxdowntime . " " . $shared_st_mig . " " . $tmp_xml_path . " " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log " . " > " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log 2>&1 &";
            vexec($live_mig_command, $o, $r);
            sleep(5);
            $log_file_cont = file(logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log");
            foreach ($log_file_cont as $k => $v) {
                $v = trim($v);
                if(!preg_match("/error: /i", $v)) {
                } elseif(preg_match("/target cpu feature count (\\d+) does not match source (\\d+)/i", $v, $matches)) {
                    $this->correct_live_mig_err($tmp_xml_path, logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log");
                    putenv("LC_ALL=en_US.UTF-8");
                    vexec($live_mig_command, $o, $r);
                    sleep(1);
                }
            }
            if(!$r) {
                vexec("scp -P " . $data["to_ssh_port"] . " -i /var/virtualizor/ssh-keys/id_rsa " . $tmp_xml_path . " " . $data["to_ip"] . ":/etc/libvirt/qemu/" . $data["new_vpsname"] . ".xml");
            }
            if(file_exists($tmp_xml_path) && !empty($vps_name) && preg_match("/" . preg_quote($vps_name, "/") . "/i", $tmp_xml_path)) {
                unlink($tmp_xml_path);
                if(is_dir($live_mig_tmp_path) && !empty($vps_name) && preg_match("/" . preg_quote($vps_name, "/") . "/i", $live_mig_tmp_path)) {
                    rmdir($live_mig_tmp_path);
                }
            }
        } elseif(empty($migrate_disk)) {
            vexec("bash " . $globals["path"] . "/scripts/migrate_dd.sh " . $data["orig_disks"][$data["disk_num"]]["path"] . " " . $data["dest_disks"][$data["disk_num"]]["path"] . " " . $speed . " " . $data["to_ssh_port"] . " " . $data["to_ip"] . " " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log " . logdir($data["selected_act"]) . $data["vpsid"] . "-actual_transfer.log " . $data["disable_gzip"] . " " . $sparse . " " . xss($data["from_pgzip"]) . " " . xss($data["to_pgzip"]) . " " . xss($throttle_block_size) . " > " . logdir($data["selected_act"]) . $data["vpsid"] . "-transfer.log 2>&1 &", $o, $ret);
        } else {
            $qcow2_to_raw = $raw_to_qcow2 = 0;
            if($data["dest_disks"][$data["disk_num"]]["qcow2_to_raw"]) {
                $qcow2_to_raw = 1;
            }
            if($data["dest_disks"][$data["disk_num"]]["raw_to_qcow2"]) {
                $raw_to_qcow2 = 1;
            }
            vexec("bash " . $globals["path"] . "/scripts/migrate_disk_dd.sh " . $data["orig_disks"][$data["disk_num"]]["path"] . " " . $data["dest_disks"][$data["disk_num"]]["path"] . " " . $speed . " " . logdir("migrate_disk") . $data["vpsid"] . "-transfer.log " . logdir("migrate_disk") . $data["vpsid"] . "-actual_transfer.log " . $data["disable_gzip"] . " " . $sparse . " " . xss($data["to_pgzip"]) . " " . $throttle_block_size . " " . $qcow2_to_raw . " " . $raw_to_qcow2 . " > " . logdir("migrate_disk") . $data["vpsid"] . "-transfer.log 2>&1 &", $o, $ret);
        }
        if($ret != 0) {
            $error[] = $l["mig_err_bg_exec"];
            return false;
        }
        return true;
    }
    public function get_vps_bridge($vpsid)
    {
        $ret = [];
        if(empty($vpsid)) {
            return $ret;
        }
        $ips = [];
        $res = makequery("SELECT i.ippid, ip.ippid, ip.bridge, ip.ovs_bridge FROM `ips` \n\t\t\t\t\t\ti LEFT JOIN ippool ip ON (ip.ippid = i.ippid) WHERE i.vpsid = :vid \n\t\t\t\t\t\tORDER BY `primary` DESC", [":vid" => $vpsid]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(!empty($row["bridge"])) {
                $ips[$row["bridge"]] = trim($row["bridge"]);
            }
        }
        if(!empty($ips)) {
            foreach ($ips as $k => $v) {
                oexec("/sbin/ifconfig " . $v . " 2>&1", $out, $return);
                if($return != "0") {
                    $ret[$v] = $v;
                }
            }
        }
        return $ret;
    }
    public function post_migrate($vpsid, $success = false, $live_mig = false, $is_src = false)
    {
        global $globals;
        if($live_mig) {
            if(!$success && !$is_src) {
                $vps = getvps($vpsid);
                $config_file = "/etc/libvirt/qemu/" . $vps["vps_name"] . ".xml";
                if(file_exists($config_file) && is_safe_file($config_file)) {
                    unlink($config_file);
                }
            } elseif($success) {
                $vps = getvps($vpsid);
                $vps_dom = new DOMDocument();
                $vps_dom->load("/etc/libvirt/qemu/" . $vps["vps_name"] . ".xml");
                $vps_xp = new DOMXpath($vps_dom);
                $vnc_elems = $vps_xp->query("//graphics[@type='vnc']");
                if(0 < $vnc_elems->length) {
                    $vnc_elem = $vnc_elems->item(0);
                    if($vnc_elem->getAttribute("passwd")) {
                        vexec("virsh qemu-monitor-command " . xss($vps["vps_name"]) . " --hmp --cmd change vnc password " . xss($vnc_elem->getAttribute("passwd")), $o, $r);
                    }
                }
            }
        }
        return true;
    }
    public function migrate_disk_used($vpsid)
    {
        global $globals;
        global $error;
        $vps = getvps($vpsid);
        $ret = [];
        foreach ($vps["disks"] as $k => $DISK) {
            $tmp_disk_size = vpsdisk_real_size($DISK);
            $ret[$k] = $tmp_disk_size / 1024 / 1024;
        }
        return $ret;
    }
    public function addsshkeys($vid, $ssh_keys, $actid = 0)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("addsshkeys", serialize($ssh_keys), 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "addsshkeys", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["started"], 10);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return false;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(!addsshkeys($mount["mount_point"], $ssh_keys)) {
            $error[] = $l["err_add_sshkeys"];
            task_update($actid, $l["err_add_sshkeys"], -1);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function removesshkeys($vid, $keys_to_remove, $actid = 0)
    {
        global $globals;
        global $l;
        $vps = getvps($vid);
        $status = no_log_status($vid, 1, $this);
        if($status == 1 || empty($actid)) {
            $actid = vps_task("removesshkeys", serialize($keys_to_remove), 0, $vid, $vps["uid"], 1, $l["change_onboot"]);
            if($status == 1) {
                save_notification("pending_task", ["action" => "removesshkeys", "vpsid" => $vid, "actid" => $actid]);
                return -1;
            }
        }
        task_start($actid);
        task_update($actid, $l["started"], 10);
        $mount = mount($vid);
        if(!is_array($mount)) {
            if($mount == -1) {
                task_update($actid, $l["mount_undetermined"], -1);
                return false;
            }
            task_update($actid, $l["kvm_err_mount"], -1);
            return false;
        }
        if(!removesshkeys($mount["mount_point"], $keys_to_remove)) {
            $error[] = $l["err_remove_sshkeys"];
            task_update($actid, $l["err_remove_sshkeys"], -1);
        }
        $umount = umount($mount);
        if(!empty($umount)) {
            $error[] = $l["kvm_err_unmount"];
            task_update($actid, $l["kvm_err_unmount"], -1);
        }
        if(empty($error)) {
            task_update($actid, $l["completed"], 100);
            return true;
        }
        return false;
    }
    public function get_io_usage($vid = 0)
    {
        global $globals;
        $delay = 3;
        $vpses = [];
        $io_usage = [];
        $query = "SELECT vpsid, vps_name FROM vps\n\t\t\t\t\t\t\tWHERE serid = 0\n\t\t\t\t\t\t\tAND virt = 'kvm'";
        $token_val = [];
        if(!empty($vid)) {
            $query .= " AND vpsid = :vpsid";
            $token_val[":vpsid"] = $vid;
        }
        $res = makequery($query, $token_val);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row;
            $io_usage[$row["vpsid"]] = ["read" => 0, "write" => 0];
        }
        if(!empty($globals["disable_virttop"])) {
            return $io_usage;
        }
        vexec("virt-top -b -n 2 -d " . $delay . " --stream --block-in-bytes 2> /dev/null", $out, $ret);
        if($ret != 0) {
            return false;
        }
        foreach ($out as $line) {
            $parts = preg_split("/\\s+/is", trim($line));
            if(count($parts) != 10 || !is_numeric($parts[0])) {
            } else {
                list($io_rd, $io_wr, $vps_name) = $parts;
                foreach ($vpses as $v) {
                    if($v["vps_name"] == $vps_name) {
                        $vps = $v;
                        if(empty($vps)) {
                        } else {
                            $unit = substr($io_rd, -1);
                            switch ($unit) {
                                case "K":
                                    $io_rd = (int) rtrim($io_rd, "K") * 1024;
                                    break;
                                case "M":
                                    $io_rd = (int) rtrim($io_rd, "M") * 1024 * 1024;
                                    break;
                                case "G":
                                    $io_rd = (int) rtrim($io_rd, "G") * 1024 * 1024 * 1024;
                                    break;
                                case "K":
                                    $io_rd = (int) $io_rd;
                                    $unit = substr($io_wr, -1);
                                    $io_wr = (int) rtrim($io_wr, "K") * 1024;
                                    break;
                                case "M":
                                    $io_wr = (int) rtrim($io_wr, "M") * 1024 * 1024;
                                    break;
                                case "G":
                                    $io_wr = (int) rtrim($io_wr, "G") * 1024 * 1024 * 1024;
                                    break;
                                default:
                                    $io_wr = (int) $io_wr;
                                    $io_rd /= $delay;
                                    $io_wr /= $delay;
                                    $vpsid = $vps["vpsid"];
                                    $io_usage[$vpsid] = ["read" => $io_rd, "write" => $io_wr];
                            }
                        }
                    }
                }
            }
        }
        return $io_usage;
    }
    public function get_vps_procid($vid)
    {
        global $error;
        if(empty($vid)) {
            return -1;
        }
        $res = makequery("SELECT `vps_name` FROM `vps`\n\t\t\t\t\t\t\t\tWHERE `vpsid`=:vpsid\n\t\t\t\t\t\t\t\tLIMIT 1", [":vpsid" => $vid]);
        if(vsql_num_rows($res) != 1) {
            return -2;
        }
        $row = vsql_fetch_assoc($res);
        $vps_name = $row["vps_name"];
        unset($row);
        unset($res);
        if(empty($vps_name)) {
            return -3;
        }
        $pid_file = "/var/run/libvirt/qemu/" . $vps_name . ".pid";
        unset($vps_name);
        if(file_exists($pid_file) && ($pid = file_get_contents($pid_file))) {
            return $pid;
        }
        return -4;
    }
    public function get_apparmor_state($vid)
    {
        global $kernel;
        global $error;
        global $error;
        if(empty($vid)) {
            return -1;
        }
        $pid = $this->get_vps_procid($vid);
        if($pid < 0) {
            return $pid;
        }
        $vps_uuid = $kernel->vps_uuid($vid);
        $state_file = "/proc/" . $pid . "/attr/current";
        $ret = "unconfined";
        if(file_exists($state_file) && ($state_file = file_get_contents($state_file)) && !empty($state_file)) {
            $state_file = trim($state_file);
            $reg = "/" . preg_quote("libvirt-" . $vps_uuid, "/") . "\\s+" . preg_quote("(", "/") . "(.+)" . preg_quote(")", "/") . "/i";
            preg_match($reg, $state_file, $matches);
            unset($reg);
            if(isset($matches[1])) {
                return $matches[1];
            }
        }
        return "unconfined";
    }
    public function apparmor_file_addrem($vid, $file_path, $action = "remove")
    {
        global $kernel;
        global $error;
        if(!$vid || !$file_path) {
            $error[] = "Empty VID or file path";
            return false;
        }
        $actions = ["add", "remove"];
        if(!in_array($action, $actions)) {
            $error[] = "addfile action unknown: " . $action . " Supported: " . implode(", ", $actions);
            return false;
        }
        $owner = "libvirt-qemu";
        $profile_pre = "/etc/apparmor.d/libvirt/libvirt-";
        $state = $this->get_apparmor_state($vid);
        if(is_numeric($state) && $state != "enforce") {
            return true;
        }
        $vps_uuid = $kernel->vps_uuid($vid);
        if(empty($vps_uuid)) {
            $error[] = "UID not found";
            return false;
        }
        $profile_file = $profile_pre . $vps_uuid . ".files";
        if(file_exists($profile_file)) {
            $append = "\"" . $file_path . "**\" rwk,";
            if(has_plugin_license("backuply")) {
                $reg = "/" . preg_quote("\"" . $file_path . "**\" rwk,", "/") . "/i";
            } else {
                $reg = "/" . preg_quote("\"" . $file_path . "**\" rw", " k?,/") . "/i";
            }
            $reload = false;
            if($action == "add") {
                $cont = file_get_contents($profile_file);
                if(empty($cont) || !preg_match($reg, $cont)) {
                    $cont .= $append . "\n";
                    if(!file_put_contents($profile_file, $cont)) {
                        $error[] = print_r(error_get_last(), 1);
                        return false;
                    }
                    if(!file_exists($file_path) && !touch($file_path)) {
                        $error[] = print_r(error_get_last(), 1);
                        return false;
                    }
                    if(!empty($owner) && !chown($file_path, $owner)) {
                        $error[] = print_r(error_get_last(), 1);
                        return false;
                    }
                    $reload = true;
                }
            } elseif($action == "remove") {
                $cont = file($profile_file);
                foreach ($cont as $pk => $pv) {
                    $pv = trim($pv);
                    if(!empty($pv) && preg_match($reg, $pv)) {
                        unset($cont[$pk]);
                        $reload = true;
                    }
                }
                if($reload) {
                    $cont = implode("", $cont);
                    if(!file_put_contents($profile_file, $cont)) {
                        $error[] = print_r(error_get_last(), 1);
                        return false;
                    }
                }
            }
            if($reload && file_exists("/sbin/apparmor_parser")) {
                vexec("/sbin/apparmor_parser -r " . xss($profile_pre . $vps_uuid), $o, $r);
                if($r) {
                    $error[] = print_r($o, 1) . "\nRET: " . $r;
                    return false;
                }
            }
        }
        return true;
    }
    public function live_mig_update_tmp_conf($xml_path, $src_vpsid, $vps_disks = [], $vps_vnc = [], $vps_nics = [])
    {
        global $globals;
        global $error;
        if(empty($xml_path)) {
            return false;
        }
        $doc = new DOMDocument();
        if(!$doc->load($xml_path)) {
            return false;
        }
        $xp = new DOMXpath($doc);
        foreach ($vps_disks["orig_disks"] as $k => $v) {
            if(!isset($vps_disks["dest_disks"][$k])) {
            } else {
                if(($elems = $xp->query("//disk[source[@dev='" . $v["path"] . "']]")) && $elems && $elems->length == 1) {
                    $elems->item(0)->getElementsByTagName("source")->item(0)->setAttribute("dev", $vps_disks["dest_disks"][$k]["path"]);
                } elseif(($elems = $xp->query("//disk[source[@file='" . $v["path"] . "']]")) && $elems && $elems->length == 1) {
                    $elems->item(0)->getElementsByTagName("source")->item(0)->setAttribute("file", $vps_disks["dest_disks"][$k]["path"]);
                } else {
                    return false;
                }
                $doc->save($xml_path);
            }
        }
        $elems = $xp->query("//input[@type='tablet']");
        if($elems->length != 1) {
            return false;
        }
        if(!empty($vps_vnc)) {
            $elems = $xp->query("//graphics[@type='vnc']");
            if($elems->length == 1) {
                $vnc_elem = $elems->item(0);
                $vnc_elem->setAttribute("port", $vps_vnc["dest_port"]);
                $vnc_elem->setAttribute("listen", $vps_vnc["dest_ip"]);
                $src_vps = getvps($src_vpsid);
                $src_virt_vps_dom = new DOMDocument();
                $src_virt_vps_dom->load("/etc/libvirt/qemu/" . $src_vps["vps_name"] . ".xml");
                $src_virt_vps_xp = new DOMXpath($src_virt_vps_dom);
                $src_vnc_elems = $src_virt_vps_xp->query("//graphics[@type='vnc']");
                if(0 < $src_vnc_elems->length) {
                    $src_vnc_elem = $src_vnc_elems->item(0);
                    $vnc_elem->setAttribute("passwd", $src_vnc_elem->getAttribute("passwd"));
                }
            }
            $elems = $xp->query("//graphics[listen[@type='address']]");
            if($elems->length == 1) {
                $vnc_elem = $elems->item(0);
                $vnc_elem->getElementsByTagName("listen")->item(0)->setAttribute("address", $vps_vnc["dest_ip"]);
            }
        }
        if(!empty($vps_nics)) {
            foreach ($vps_nics as $src_nic => $dest_nic) {
                $elems = $xp->query("//interface[target[@dev='" . $src_nic . "']]");
                if(0 < $elems->length) {
                    for ($i = 0; $i < $elems->length; $i++) {
                        $elem = $elems->item($i);
                        if($elem->getElementsByTagName("target")->item(0)->getAttribute("dev") == $src_nic) {
                            $elem->getElementsByTagName("target")->item(0)->setAttribute("dev", $dest_nic);
                        }
                    }
                }
            }
        }
        $doc->save($xml_path);
        return true;
    }
    public function correct_live_mig_err($xml_path, $log_file)
    {
        global $globals;
        global $error;
        if(empty($xml_path) || empty($log_file)) {
            return false;
        }
        $doc = new DOMDocument();
        $doc->load($xml_path);
        $xpath = new DOMXPath($doc);
        $log_file_cont = file($log_file);
        foreach ($log_file_cont as $k => $v) {
            $v = trim($v);
            if(!preg_match("/error: /i", $v)) {
            } elseif(preg_match("/target cpu feature count (\\d+) does not match source (\\d+)/i", $v, $matches)) {
                $domlist = $xpath->query("/domain/cpu/feature");
                for ($i = 0; $i < abs($matches[1] - $matches[2]); $i++) {
                    $elem_to_remove = $domlist->item($domlist->length - 1);
                    $elem_to_remove->parentNode->removeChild($elem_to_remove);
                }
            }
        }
        $doc->save($xml_path);
        return true;
    }
    public function is_live_mig_supported($vpsid, $src, $dest)
    {
        global $globals;
        global $cluster;
        global $servers;
        global $l;
        global $error;
        $vps = getvps($vpsid);
        $vps_xml_config = $cluster->get_raw_conf($src, $vpsid);
        $vps_xml_dom = new DOMDocument();
        if(!$vps_xml_dom->loadXML($vps_xml_config)) {
            $error[] = lang_vars_name($l["err_live_mig_no_conf"], ["node" => $servers[$src]["server_name"]]);
            $error[] = error_get_last()["message"];
            return false;
        }
        $vps_xml_dom_xpath = new DOMXPath($vps_xml_dom);
        $vps_cpu_elem_path = "/domain/cpu";
        $vps_cpu_elem = $vps_xml_dom_xpath->query($vps_cpu_elem_path);
        $cpu_src = $cluster->cpu($src);
        $cpu_dest = $cluster->cpu($dest);
        if(strtolower($cpu_src["manu"]) != strtolower($cpu_dest["manu"]) && $vps_cpu_elem->length != 0 && strtolower($vps_cpu_elem->item(0)->getAttribute("mode")) != "host-passthrough") {
            $error[] = $l["err_live_mig_cpu_diff"];
            return false;
        }
        return true;
    }
    public function list_bitmaps($vpsid)
    {
        $bitmaps = [];
        $status = $this->vps_status_statewise($vpsid, 1);
        if($status == 1) {
            $query_block = $this->get_query_block($vpsid);
            $DISKS = get_vps_DISKS($vpsid);
            foreach ($DISKS as $disk) {
                $temp_bitmaps = $query_block["return"][$disk["num"]]["dirty-bitmaps"];
                if(empty($temp_bitmaps)) {
                    $temp_bitmaps = $query_block["return"][$disk["num"]]["inserted"]["dirty-bitmaps"];
                }
                if(!empty($temp_bitmaps)) {
                    foreach ($temp_bitmaps as $v) {
                        $bitmaps[$disk["num"]][] = $v["name"];
                    }
                }
            }
        }
        return $bitmaps;
    }
    public function remove_bitmap($vpsid, $bitmap, $disk_num)
    {
        $vps = getvps($vpsid);
        $vps_name = $vps["vps_name"];
        $device = $this->get_device($vpsid, $disk_num);
        $arr = ["execute" => "block-dirty-bitmap-clear", "arguments" => ["node" => $device, "name" => $bitmap]];
        $cmd = "virsh qemu-monitor-command " . $vps_name . " " . xss(json_encode($arr)) . " 2>&1";
        oexec($cmd, $o);
        $arr = ["execute" => "block-dirty-bitmap-remove", "arguments" => ["node" => $device, "name" => $bitmap]];
        $cmd = "virsh qemu-monitor-command " . $vps_name . " " . xss(json_encode($arr)) . " 2>&1";
        oexec($cmd, $o);
    }
    public function get_query_block($vpsid)
    {
        $vps = getvps($vpsid);
        $qmp_command = ["execute" => "query-block"];
        oexec("/usr/bin/virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($qmp_command)), $out, $ret);
        $out = json_decode($out, true);
        return $out;
    }
    public function get_device($vpsid, $disk_num = 0)
    {
        $qemu_details = get_qemu_details();
        $is_new_libvirt = false;
        if((os_check("centos", ">=", 8) || os_check("ubuntu", ">=", 20) || os_check("debian", ">=", 10) || os_check("almalinux", ">=", 8) || os_check("rocky", ">=", 8)) && version_compare($qemu_details["libvirt_ver"], "6.0.0", ">=")) {
            $is_new_libvirt = true;
        }
        $get_query_block = $this->get_query_block($vpsid);
        $device = $get_query_block["return"][$disk_num]["device"];
        if($is_new_libvirt) {
            $device = $get_query_block["return"][$disk_num]["inserted"]["node-name"];
        }
        return $device;
    }
    public function can_take_inc_backup($vpsid, $type)
    {
        $vps = getvps($vpsid);
        $bitmaps = $this->list_bitmaps($vpsid);
        $chains = [];
        if(empty($bitmaps)) {
            return false;
        }
        if(!empty($GLOBALS["take_full"])) {
            return false;
        }
        foreach ($vps["disks"] as $disk) {
            $file_contents = get_disk_json($vpsid, $disk["num"]);
            if(empty($file_contents)) {
                return false;
            }
            $chains[count($file_contents)] = 1;
        }
        if(1 < count($chains)) {
            return false;
        }
        return true;
    }
    public function get_last_bitmap($vpsid, $disk_num)
    {
        $bitmaps = $this->list_bitmaps($vpsid);
        $bitmaps = $bitmaps[$disk_num];
        foreach ($bitmaps as $bitmap) {
            $tmp = explode("_", $bitmap);
            $arr[] = (int) $tmp[1];
        }
        return "bitmap_" . (int) max($arr);
    }
    public function backuply_delete($time, $chain, $dir, $bid, $vps)
    {
        global $globals;
        global $servers;
        global $vps_cache;
        $vps_cache = $vps;
        $backup_server = [];
        if(0 < $bid) {
            $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
            if(vsql_num_rows($res) == 0) {
                return false;
            }
            $backup_server = vsql_fetch_assoc($res);
        }
        $class = load_backup_class($backup_server, "utils");
        if(empty($class)) {
            return false;
        }
        $qemu_details = get_qemu_details();
        $DISKS = $vps["disks"];
        foreach ($DISKS as $disk) {
            $json = get_disk_json($vps["vpsid"], $disk["num"]);
            $bkp_dir = $dir . "/" . $vps["uuid"] . "/" . $chain . "/";
            if(!empty($json[$chain]["folder_format"])) {
                $bkp_dir = $dir . "/" . $json[$chain]["folder_format"] . "/" . $chain . "/";
            }
            if($json[$chain]["htime"] == $time) {
                $class->_unlink($bkp_dir . basename($json[$chain]["filepath"]));
                $inf_file = get_inf_name($vps, $json[$chain]["htime"]);
                $class->_unlink($bkp_dir . $inf_file);
                if(empty($GLOBALS["dont_delete_bitmap"])) {
                    $this->remove_bitmap($vps["vpsid"], "bitmap_0", $disk["num"]);
                }
                if(!empty($json[$chain]["children"])) {
                    ksort($json[$chain]["children"]);
                    foreach ($json[$chain]["children"] as $t => $file) {
                        $filepath = $bkp_dir . basename($file["filepath"]);
                        if(empty($GLOBALS["dont_delete_bitmap"])) {
                            $this->remove_bitmap($vps["vpsid"], $file["bitmap"], $disk["num"]);
                        }
                        $class->_unlink($filepath);
                        $inf_file = get_inf_name($vps, $file["htime"]);
                        $class->_unlink($bkp_dir . $inf_file);
                        unset($json[$chain]["children"][$t]);
                    }
                }
                unset($json[$chain]);
                $class->_rmdir($bkp_dir);
                save_disk_json($vps["vpsid"], $json, $disk["num"]);
            } else {
                ksort($json[$chain]["children"]);
                $children_count = count($json[$chain]["children"]);
                if($children_count == 1) {
                    $dont_delete_bitmap = 1;
                }
                $to_unlink = [];
                foreach ($json[$chain]["children"] as $t => $file) {
                    $filepath = $bkp_dir . basename($file["filepath"]);
                    if(empty($backup_server)) {
                        if(!$get_next_file && $time != $file["htime"]) {
                            $prev_file = basename($file["filepath"]);
                        }
                        if($time == $file["htime"]) {
                            if(!$dont_delete_bitmap && empty($GLOBALS["dont_delete_bitmap"])) {
                                $this->remove_bitmap($vps["vpsid"], $file["bitmap"], $disk["num"]);
                            }
                            $to_unlink["file"] = $filepath;
                            $inf_file = get_inf_name($vps, $file["htime"]);
                            $to_unlink["inf"] = $bkp_dir . $inf_file;
                            unset($json[$chain]["children"][$t]);
                            $get_next_file = 1;
                        }
                        if($get_next_file && $time != $file["htime"]) {
                            $next_file = basename($file["filepath"]);
                            $get_next_file = 0;
                            if(!empty($next_file) && empty($prev_file)) {
                                $prev_file = basename($json[$chain]["filepath"]);
                            }
                            if(!empty($prev_file) && !empty($next_file)) {
                                if(version_compare($qemu_details["qemu_ver"], "6.1.0", ">=")) {
                                    $opt = " -F qcow2";
                                }
                                vexec("cd " . $bkp_dir . ";qemu-img rebase" . $opt . " -b " . $prev_file . " " . $next_file);
                                $class->_unlink($to_unlink["file"]);
                                $class->_unlink($to_unlink["inf"]);
                            }
                            if(!empty($to_unlink)) {
                                $class->_unlink($to_unlink["file"]);
                                $class->_unlink($to_unlink["inf"]);
                            }
                            save_disk_json($vps["vpsid"], $json, $disk["num"]);
                            $delete_all_files = $get_next_file = 0;
                            $prev_file = $next_file = "";
                        }
                    } else {
                        if($time == $file["htime"]) {
                            if(!$dont_delete_bitmap && empty($GLOBALS["dont_delete_bitmap"])) {
                                $this->remove_bitmap($vps["vpsid"], $file["bitmap"], $disk["num"]);
                            }
                            $class->_unlink($filepath);
                            $inf_file = get_inf_name($vps, $file["htime"]);
                            $class->_unlink($bkp_dir . $inf_file);
                            unset($json[$chain]["children"][$t]);
                            $delete_all_files = 1;
                        }
                        if($delete_all_files && $time != $file["htime"] && empty($GLOBALS["dont_delete_bitmap"])) {
                            $this->remove_bitmap($vps["vpsid"], $file["bitmap"], $disk["num"]);
                            $class->_unlink($filepath);
                            $inf_file = get_inf_name($vps, $file["htime"]);
                            $class->_unlink($bkp_dir . $inf_file);
                            unset($json[$chain]["children"][$t]);
                        }
                    }
                }
            }
        }
        return true;
    }
    public function clean_vps_cache($vpsid)
    {
        $vps = getvps($vpsid);
        $has_support = $this->guest_agent_support($vpsid, "guest-exec", $not_installed);
        if(!empty($has_support["done"])) {
            if(preg_match("/windows/is", $vps["os_name"])) {
                $drives = $this->ga_exec($vpsid, "wmic", ["logicaldisk", "get", "name"]);
                unset($drives[0]);
                foreach ($drives as $d) {
                    $d_letter = trim(substr($d, 0, 1));
                    $this->ga_exec($vpsid, "powershell", ["Write-VolumeCache", $d_letter]);
                }
            } else {
                $this->ga_exec($vpsid, "sync");
            }
            usleep(500000);
        }
    }
    public function backuply_backup($vpsid, $bkp_dir, $disk_num, $pref_type)
    {
        global $error;
        global $backup_folder;
        $vps = getvps($vpsid);
        $disk = get_vps_disk($vpsid, "", $disk_num);
        $filename = $vpsid . "_" . parse_backup_hostname($vps["hostname"]) . (!empty($disk_num) ? "_" . $disk_num : "") . "_" . $GLOBALS["backup_file_time"];
        if(empty($pref_type)) {
            $type = "full";
        }
        if($pref_type == "inc") {
            $type = "inc";
        } elseif($pref_type == "diff") {
            $type = "diff";
        } elseif($pref_type == "full") {
            $type = "full";
        }
        if(!$this->can_take_inc_backup($vpsid, $type)) {
            $type = "full";
        }
        $device = $this->get_device($vpsid, $disk_num);
        if(os_distro_check("debian")) {
            $this->apparmor_file_addrem($vpsid, $backup_folder, "add");
        }
        if($type == "full") {
            $bitmaps = $this->list_bitmaps($vpsid);
            if(!empty($bitmaps[$disk_num])) {
                foreach ($bitmaps[$disk_num] as $bitmap) {
                    $this->remove_bitmap($vpsid, $bitmap, $disk_num);
                }
            }
            $filename = $filename . ".full";
            $filepath = $bkp_dir . $filename;
            $status = $this->vps_status_statewise($vpsid, 1);
            if($status == 1) {
                $params = ["execute" => "transaction", "arguments" => ["actions" => [["type" => "block-dirty-bitmap-add", "data" => ["node" => $device, "name" => "bitmap_0"]]]]];
                vexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($params)) . " 2>&1", $o, $r);
                if($r != 0) {
                    $error[] = print_r($o, 1);
                    return false;
                }
                usleep(500000);
            }
            $GLOBALS["DONT_LOG"] = 1;
            $this->clean_vps_cache($vpsid);
            $GLOBALS["DONT_LOG"] = 0;
            if(preg_match("/ceph/is", $disk["type"])) {
                $cpath = preg_split("/" . preg_quote("/dev/rbd/", "/") . "/i", $disk["path"]);
                $cpath = $cpath[1];
                $disk_path = explode("/", $cpath);
                unset($o);
                unset($r);
                vexec("rbd ls " . xss($disk_path[0]) . " | grep -E " . xss($disk_path[1] . "\$"), $o, $r);
                if(!empty($r)) {
                    return false;
                }
                unset($r);
                unset($o);
                vexec("rbd showmapped | grep -E " . xss("(.*)" . $disk_path[1] . "(\\s)"), $o, $r);
                if(!empty($r)) {
                    vexec("rbd map " . xss($cpath) . " 2>&1");
                    sleep(1);
                }
            }
            vexec("qemu-img convert -U -O qcow2 " . $disk["path"] . " " . $bkp_dir . $filename . " 2>&1", $o, $r);
            if($r != 0) {
                $error[] = print_r($o, 1);
                unlink($bkp_dir . $filename);
                return false;
            }
        } elseif($type == "inc" || $type == "diff") {
            $file_contents = get_disk_json($vpsid, $disk_num);
            ksort($file_contents);
            $last_chain = array_end($file_contents);
            $prev_file = $last_chain["filepath"];
            $count = 0;
            if(!empty($last_chain["children"])) {
                ksort($last_chain["children"]);
                $prev_file = array_end($last_chain["children"])["filepath"];
                $count = array_end($last_chain["children"])["file_count"] + 1;
            }
            $filename = $filename . "." . $type . $count;
            $filepath = $bkp_dir . $filename;
            if(!file_exists($prev_file)) {
                echo "\n\n Creating new backing file \n\n";
                vexec("qemu-img create -f qcow2 " . $prev_file . " " . $disk["size"] . "G 2>&1", $o, $r);
                usleep(500000);
            }
            vexec("qemu-img create -f qcow2 " . $filepath . " " . $disk["size"] . "G -b " . basename($prev_file) . " -F qcow2 2>&1", $o, $r);
            if($r != 0) {
                $error[] = print_r($o, 1);
                unlink($bkp_dir . $filename);
                return false;
            }
            usleep(500000);
            if(os_distro_check("debian")) {
                chown($filepath, "libvirt-qemu");
            } else {
                chown($filepath, "qemu");
            }
            $bitmap = "bitmap_0";
            if($type == "inc") {
                $bitmap = $this->get_last_bitmap($vpsid, $disk_num);
                echo "bitmap : " . $bitmap . "\n\n";
                $tmp_bitmap = cexplode("_", $bitmap, 1);
                $bit_count = (int) $tmp_bitmap[1];
                $bit_count = $bit_count + 1;
                $params = ["execute" => "transaction", "arguments" => ["actions" => [["type" => "block-dirty-bitmap-add", "data" => ["node" => $device, "name" => "bitmap_" . $bit_count]]]]];
                vexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($params)) . " 2>&1", $o, $r);
                if($r != 0) {
                    $error[] = print_r($o, 1);
                    return false;
                }
            }
            $GLOBALS["DONT_LOG"] = 1;
            $this->clean_vps_cache($vpsid);
            $GLOBALS["DONT_LOG"] = 0;
            $params = ["execute" => "drive-backup", "arguments" => ["device" => $device, "bitmap" => $bitmap, "target" => $filepath, "format" => "qcow2", "sync" => "incremental", "mode" => "existing", "job-id" => "virt_snap0"]];
            vexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss(json_encode($params)) . " 2>&1", $o, $r);
            if($r != 0) {
                $error[] = print_r($o, 1);
                unlink($bkp_dir . $filename);
                return false;
            }
            $time_to_wait = "30";
            $GLOBALS["DONT_LOG"] = 1;
            while (true) {
                oexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss("{\"execute\":\"query-block-jobs\"}"), $o, $r);
                $o = json_decode($o, 1);
                if(empty($o["return"])) {
                    break;
                }
                foreach ($o["return"] as $val) {
                    if($val["type"] == "backup" && $val["paused"]) {
                        $bitmaps = $this->list_bitmaps($vpsid);
                        if(!empty($bitmaps[$disk_num])) {
                            foreach ($bitmaps[$disk_num] as $bitmap) {
                                $this->remove_bitmap($vpsid, $bitmap, $disk_num);
                            }
                        }
                        @unlink($filepath);
                        oexec("virsh qemu-monitor-command " . $vps["vps_name"] . " " . xss("{\"execute\":\"block-job-cancel\", \"arguments\" : {\"device\" : \"" . $val["device"] . "\"}}"), $o, $r);
                        return false;
                    } elseif($val["type"] == "backup" && $val["status"] != "running") {
                    }
                }
            }
            $GLOBALS["DONT_LOG"] = 0;
            if(os_distro_check("debian")) {
                $this->apparmor_file_addrem($vpsid, $backup_folder, "remove");
            }
        }
        $date = DateTime::createFromFormat("Y_m_d-H_i_s", $GLOBALS["backup_file_time"]);
        $disk_new_arr = ["filepath" => $filepath, "htime" => $GLOBALS["backup_file_time"], "time" => $date->format("U"), "bitmap" => $bitmap, "size" => vfilesize($filepath), "folder_format" => basename(dirname($backup_folder)), "file_count" => $count];
        $disk_json = get_disk_json($vpsid, $disk_num);
        $disk_arr = !empty($disk_json) ? $disk_json : [];
        $disk_new_arr["type"] = $pref_type;
        if(!empty($disk_arr)) {
            if($type == "full") {
                $disk_arr[basename($backup_folder)] = $disk_new_arr;
                $disk_arr[basename($backup_folder)]["hostname"] = $vps["hostname"];
                $disk_arr[basename($backup_folder)]["vps_uuid"] = $vps["uuid"];
                $disk_arr[basename($backup_folder)]["vpsid"] = $vps["vpsid"];
            } else {
                $disk_arr[basename($backup_folder)]["children"][time()] = $disk_new_arr;
            }
        } else {
            $disk_arr[basename($backup_folder)] = $disk_new_arr;
            $disk_arr[basename($backup_folder)]["hostname"] = $vps["hostname"];
            $disk_arr[basename($backup_folder)]["vps_uuid"] = $vps["uuid"];
            $disk_arr[basename($backup_folder)]["vpsid"] = $vps["vpsid"];
        }
        save_disk_json($vpsid, $disk_arr, $disk_num);
        return array_merge(["filename" => $filename], $disk_new_arr);
    }
    public function backuply_restore($vpsid, $backing_file, $disk_num)
    {
        global $error;
        $last_actid = $GLOBALS["current_taskid"];
        $this->poweroff($vpsid);
        $GLOBALS["current_taskid"] = $last_actid;
        $disk = get_vps_disk($vpsid, "", $disk_num);
        vexec("qemu-img convert -O " . $disk["format"] . " " . $backing_file . " " . $disk["path"] . " 2>&1", $o, $r);
        if($r != 0) {
            $error[] = print_r($o, 1);
            return false;
        }
        return true;
    }
    public function rebase_files($vpsid, $rebase_files)
    {
        $full_backup = $rebase_files[0];
        unset($rebase_files[0]);
        $count = count($rebase_files);
        $flag = 0;
        $opt = "";
        $qemu_details = get_qemu_details();
        if(version_compare($qemu_details["qemu_ver"], "6.1.0", ">=")) {
            $opt = " -F qcow2";
        }
        foreach ($rebase_files as $key => $file) {
            $flag = $flag + 1;
            vexec("qemu-img rebase" . $opt . " -b " . $full_backup . " " . $file, $o, $r);
            if($r != 0) {
                return false;
            }
            if(0 < $count - $flag) {
                vexec("qemu-img commit " . $file, $o1, $r1);
                if($r1 != 0) {
                    return false;
                }
            }
        }
        return $full_backup;
    }
    public function guest_agent_support($vpsid, $command = "", &$not_installed = 0)
    {
        global $l;
        $res = [];
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name)) {
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-info\"}"), $info, $ret);
        if(!empty($ret)) {
            $res["error"] = $info;
            $not_installed = 1;
            return $res;
        }
        $info = @json_decode($info, 1);
        $res["info"] = $info;
        if(!empty($command)) {
            $ga_pass_support = false;
            foreach ($info["return"]["supported_commands"] as $ik => $com) {
                if(preg_match("/" . $command . "/", $com["name"]) && !empty($com["enabled"])) {
                    $ga_pass_support = true;
                    if(!$ga_pass_support) {
                        $res["error"] = lang_vars_name($l["kvm_guest_agent_err"], ["version" => $info["return"]["version"], "command" => $command]);
                        return $res;
                    }
                }
            }
        }
        $res["done"] = 1;
        return $res;
    }
    public function ga_read_file($vpsid, $file)
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name) || empty($file)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-file-open", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-open\", \"arguments\": {\"path\": \"" . $file . "\",\"mode\" : \"r\" }}"), $handle, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $handle = json_decode($handle, true);
        $handle = $handle["return"];
        if(empty($handle)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-file-read", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-read\", \"arguments\" : {\"handle\":" . (int) $handle . "}}"), $proc, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $proc = json_decode($proc, true);
        $final_output = base64_decode($proc["return"]["buf-b64"]);
        $final_output = cexplode("\n", $final_output, 0, 1);
        $final_output = array_values($final_output);
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-close\", \"arguments\" : {\"handle\":" . (int) $handle . "}}"), $proc, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        return $final_output;
    }
    public function ga_write_file($vpsid, $file, $data)
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name) || empty($file)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-file-open", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-open\", \"arguments\": {\"path\": \"" . $file . "\",\"mode\" : \"w+\" }}"), $handle, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $handle = json_decode($handle, true);
        $handle = $handle["return"];
        if(empty($handle)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-file-write", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        $data = base64_encode($data);
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-write\", \"arguments\" : {\"handle\":" . (int) $handle . ", \"buf-b64\" : \"" . $data . "\"}}"), $proc, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $final_output = json_decode($proc, true);
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-file-close\", \"arguments\" : {\"handle\":" . (int) $handle . "}}"), $o, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        return $final_output;
    }
    public function ga_exec($vpsid, $command, $args = [], $input_data = "")
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name) || empty($command)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-exec", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        $_args = "";
        if(!empty($args)) {
            $_args = "\"arg\" : " . json_encode($args) . ",";
        }
        $_input_data = "";
        if(!empty($input_data)) {
            $_input_data = "\"input-data\" : " . json_encode(base64_encode($input_data)) . ",";
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-exec\", \"arguments\": {\"path\": \"" . $command . "\"," . $_args . $_input_data . "\"capture-output\":true }}"), $pid, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $pid = json_decode($pid, true);
        $pid = $pid["return"]["pid"];
        if(empty($pid)) {
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-exec-status\", \"arguments\" : {\"pid\":" . (int) $pid . "}}"), $proc, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $proc = json_decode($proc, true);
        if(empty($proc["return"]["exited"])) {
            $flag = $count = 0;
            while ($count <= 60) {
                oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-exec-status\", \"arguments\" : {\"pid\":" . (int) $pid . "}}"), $proc, $ret);
                if(!empty($ret) && empty($flag)) {
                    $error[] = $exec_err;
                    return false;
                    break;
                }
                if(!empty($ret) && !empty($flag)) {
                } else {
                    $proc = json_decode($proc, true);
                    if(!empty($proc)) {
                        $flag = 1;
                    }
                    if(!empty($proc["return"]["exited"])) {
                    } else {
                        $count++;
                        sleep(1);
                    }
                }
            }
        }
        $key = "out-data";
        if(!empty($proc["return"]["exitcode"])) {
            $key = "err-data";
        }
        $final_output = [];
        if(isset($proc["return"][$key])) {
            $tmp_output = @base64_decode($proc["return"][$key]);
            $final_output = @cexplode("\n", $tmp_output, 0, 1);
            return $final_output;
        }
        return $proc["return"]["exitcode"] ? false : true;
    }
    public function ga_network_get_interfaces($vpsid)
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-network-get-interfaces", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-network-get-interfaces\"}"), $out, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $out = json_decode($out, true);
        return $out["return"];
    }
    public function ga_os_info($vpsid)
    {
        global $exec_err;
        global $error;
        $vps_name = $this->getname($vpsid);
        if(empty($vps_name)) {
            return false;
        }
        $has_support = $this->guest_agent_support($vpsid, "guest-get-osinfo", $not_installed);
        if(!empty($not_installed) || empty($has_support["done"])) {
            $error[] = $has_support["error"];
            return false;
        }
        oexec("virsh qemu-agent-command " . $vps_name . " " . xss("{\"execute\":\"guest-get-osinfo\"}"), $info, $ret);
        if(!empty($ret)) {
            $error[] = $exec_err;
            return false;
        }
        $info = json_decode($info, true);
        $info = $info["return"];
        if(empty($info)) {
            return false;
        }
        return $info;
    }
    public function perform_vertical_scaling()
    {
        global $globals;
        if(!check_licensepro()) {
            return false;
        }
        if(empty($globals["inhouse_billing"])) {
            echo "Enable billing from billing settings for scaling to take effect\n";
            return false;
        }
        @logdir("scaling/ver_scaling");
        $res = makequery("SELECT uid, pid FROM users WHERE \n\t\t\t\t\t\t`type` = 2 AND \n\t\t\t\t\t\tinhouse_billing = 1\n\t\t\t\t\t\tORDER BY email");
        $users = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $users[$row["uid"]] = $row;
        }
        if(empty($users)) {
            echo "No Cloud user found with billing enabled\n";
            return false;
        }
        $res = makequery("SELECT uid, pid FROM users WHERE \n\t\t\t\t\t\t`pid` IN (" . implode(", ", array_keys($users)) . ")\n\t\t\t\t\t\tORDER BY email");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $users[$row["uid"]] = $row;
        }
        $res = makequery("SELECT v.vpsid, \n\t\t\t\t\t\t\t\tv.serid, \n\t\t\t\t\t\t\t\tv.vps_name, \n\t\t\t\t\t\t\t\tv.hostname, \n\t\t\t\t\t\t\t\tv.uuid, \n\t\t\t\t\t\t\t\tv.os_name, \n\t\t\t\t\t\t\t\tv.uid, \n\t\t\t\t\t\t\t\tv.cores, \n\t\t\t\t\t\t\t\tv.ram, \n\t\t\t\t\t\t\t\tv.data \n\t\t\t\t\t\t\t\tFROM vps v, users u \n\t\t\t\t\t\t\t\tWHERE u.uid = v.uid AND v.uid IN (" . implode(", ", array_keys($users)) . ")");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $vps = vsql_fetch_assoc($res);
            $vps["data"] = json_decode($vps["data"], 1);
            $owner = !empty($users[$vps["uid"]]["pid"]) ? $users[$vps["uid"]]["pid"] : $vps["uid"];
            if(!empty($globals["enable_ver_scaling"]) || !empty($vps["data"]["enable_ver_scaling"])) {
                echo "----------------------------------------\n";
                echo "Next VPSID:" . $vps["vpsid"] . "\n\n";
                if(preg_match("/windows/is", $vps["os_name"])) {
                    echo "Vps having Id " . $vps["vpsid"] . " skipped for scaling as it has windows OS" . "\n\n";
                } else {
                    $vps_status = $this->vps_status_statewise($vps["vpsid"], true);
                    if($vps_status != 1) {
                        echo "Vps having Id " . $vps["vpsid"] . " skipped for scaling as it is off/suspended" . "\n\n";
                    } else {
                        $final_resource = [];
                        if(is_master()) {
                            $resource_pricing = resource_rates();
                            foreach ($resource_pricing as $resource => $rate) {
                                if(!in_array($resource, ["cores", "ram"])) {
                                } else {
                                    $final_resource[$resource] = $rate;
                                }
                            }
                        }
                        $vps["ver_ram_inc_by"] = !empty($vps["data"]["ver_ram_inc_by"]) ? $vps["data"]["ver_ram_inc_by"] : $globals["ver_ram_inc_by"];
                        $vps["ver_cpu_inc_by"] = !empty($vps["data"]["ver_cpu_inc_by"]) ? $vps["data"]["ver_cpu_inc_by"] : $globals["ver_cpu_inc_by"];
                        $ver_data = get_vps_meta($vps["uuid"], ["ver_ram_inc_by", "ver_cpu_inc_by"]);
                        if(!empty($ver_data)) {
                            foreach ($ver_data as $vv) {
                                if(!empty($vv["meta_value"])) {
                                    $vps[$vv["meta_key"]] = $vv["meta_value"];
                                }
                            }
                        }
                        if(!empty($globals["ver_max_ram"]) || !empty($vps["data"]["ver_max_ram"])) {
                            $this->vertical_scale_ram($vps, $owner, $final_resource);
                        }
                        if(!empty($globals["ver_max_cpu"]) || !empty($vps["data"]["ver_max_cpu"])) {
                            $this->vertical_scale_cpu($vps, $owner, $final_resource);
                        }
                    }
                }
            }
        }
        if(is_slave()) {
            initiate_reverse_sync();
        }
        echo "\n";
    }
    public function vertical_scale_ram($vps, $owner, $resources)
    {
        global $globals;
        global $servers;
        global $l;
        if(!check_licensepro()) {
            return false;
        }
        $vps_name = $vps["vps_name"];
        $min_ram = $vps["ram"];
        $max_ram = !empty($vps["data"]["ver_max_ram"]) ? $vps["data"]["ver_max_ram"] : $globals["ver_max_ram"];
        $usr_threshold = !empty($vps["data"]["ver_ram_threshold"]) ? $vps["data"]["ver_ram_threshold"] : $globals["ver_ram_threshold"];
        $inc_by = $vps["ver_ram_inc_by"] * 1024;
        $ram_log_path = logdir("/scaling/ver_scaling/") . $vps["vpsid"] . "_ram";
        $fcont = @json_decode(@read_file($ram_log_path), 1);
        if(empty($max_ram) || empty($usr_threshold) || empty($inc_by)) {
            return false;
        }
        $get_ram_stats = function ($vps_name) {
            vexec("virsh dommemstat " . $vps_name . " --live", $o, $r);
            $free = $o[5];
            $free = explode(" ", $free);
            $free = round($free[1] / 1024, 2);
            $actual_balloon = $o[0];
            $actual_balloon = explode(" ", $actual_balloon);
            $actual_balloon = round($actual_balloon[1] / 1024, 2);
            $total = $o[6];
            $total = explode(" ", $total);
            $total = round($total[1] / 1024, 2);
            return ["free" => $free, "total" => $total, "actual_balloon" => $actual_balloon];
        };
        $apply_billing = function ($vps, $owner, $resources, $inc_by) {
            global $globals;
            global $servers;
            global $l;
            $vals = [];
            $vals["vps_uuid"] = $vps["uuid"];
            $vals["uid"] = $owner;
            $vals["updatetime"] = time();
            $vals["endtime"] = $vals["updatetime"];
            $vals["starttime"] = $vals["endtime"];
            $vals["resource"] = "vertical_ram";
            if(is_master()) {
                $h_used = $resources["ram"]["h_rate"][$servers[$vps["serid"]]["sgid"]];
                if(empty($h_used)) {
                    $h_used = $resources["ram"]["h_rate"][-1];
                }
                $vals["h_used"] = $h_used * $inc_by;
            }
            $vals["data"] = serialize(["hostname" => $vps["hostname"]]);
            $set = [];
            foreach ($vals as $k => $v) {
                $set[$k] = "`" . $k . "` = :" . $k;
            }
            if(is_slave()) {
                $post["usage"]["vals"] = $vals;
                $post["usage"]["set"] = $set;
                $post["inc_by"] = $inc_by;
                $post["serid"] = $globals["slave"];
                make_api_call_from_slave("index.php?rsync_to_master=1&billing_sync=1", [], $post);
            } else {
                insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
            }
        };
        vexec("virsh dommemstat " . $vps_name . " --period 2 --live", $o, $r);
        $num_of_iterations = 2;
        for ($i = 0; $i < $num_of_iterations; $i++) {
            usleep(500000);
            $ram_stats = $get_ram_stats($vps_name);
            $free = $ram_stats["free"];
            $total = $ram_stats["total"];
            $actual_balloon = $ram_stats["actual_balloon"];
            $used_ram = round($total - $free, 2);
            $perc_used[$i] = round($used_ram / $total * 100, 3);
            $perc_free[$i] = round($free / $total * 100, 3);
        }
        $sum_used = array_sum($perc_used);
        $threshold = $sum_used / $num_of_iterations;
        $rem_ram = $max_ram - $total;
        echo "--SCALING RAM--\n";
        echo "Free (IN VM) : " . $free . " MB\n";
        echo "Total (IN VM) : " . $total . " MB\n";
        echo "Actual Balloon Value : " . $actual_balloon . " MB\n";
        echo "Percentage used : " . $threshold . "\n";
        if($usr_threshold < $threshold && 0 < $rem_ram) {
            $arr = [];
            $new_ram = round($total + $inc_by);
            if($max_ram < $new_ram) {
                $new_ram = $max_ram;
                $arr["maxed_out"] = 1;
            }
            $arr["new_ram"] = $new_ram;
            echo "Increasing Ram to : " . $new_ram . "MB\n";
            vexec("grep MemFree /proc/meminfo", $server_free_memory);
            virt_preg_replace("/(MemFree:\\s+)(.*)/", $server_free_memory[0], $server_free_memory, 2);
            $server_free_memory = (int) $server_free_memory / 1024;
            if($server_free_memory < $new_ram) {
                echo "ERROR : Insufficient RAM on server hence cannot perform scaling.\n Free RAM : " . $server_free_memory . " MB\n Required RAM : " . $new_ram . " MB";
                return false;
            }
            vexec("virsh setmem " . $vps_name . " " . $new_ram . "M --live", $o, $ret);
            if($ret != 0) {
                echo "Error: There was an error while increasing ram!\n";
                return false;
            }
            $arr["time"] = time() + 3600;
            @writefile($ram_log_path, @json_encode($arr), 1);
            if(!empty($fcont["maxed_out"]) && !empty($fcont["time"]) && $fcont["time"] < time()) {
                $fcont["maxed_out"] = 0;
                $inc_by = round($max_ram - $min_ram);
            }
            if(empty($fcont["maxed_out"]) && !empty($fcont["time"]) && $fcont["time"] < time() && !empty($fcont["new_ram"])) {
                $fcont["maxed_out"] = 0;
                $inc_by = round($fcont["new_ram"] - $min_ram);
            }
            if(empty($fcont["maxed_out"])) {
                $inc_by = $inc_by / 1024;
                $apply_billing($vps, $owner, $resources, $inc_by);
            }
        } elseif($threshold < $usr_threshold) {
            $time = $fcont["time"];
            if(!empty($time) && $time <= time()) {
                if($used_ram < $min_ram) {
                    $tmp_usage = $used_ram / $min_ram * 100;
                    if($tmp_usage < $usr_threshold) {
                        echo "Setting RAM to Actual Min RAM: " . $min_ram . "M\n";
                        vexec("virsh setmem " . $vps_name . " " . $min_ram . "M --live", $o, $ret);
                        if($ret != 0) {
                            echo "Error: There was an error while decreasing ram!\n";
                            return false;
                        }
                        if($ret == 0) {
                            @unlink($ram_log_path);
                        }
                    } elseif(!empty($fcont["new_ram"])) {
                        $inc_by = round(($fcont["new_ram"] - $min_ram) / 1024);
                        $apply_billing($vps, $owner, $resources, $inc_by);
                    }
                } elseif($min_ram < $total) {
                    $new_ram = round($total - $inc_by);
                    if($new_ram < $min_ram) {
                        $new_ram = $min_ram;
                    }
                    if($used_ram < $new_ram) {
                        $old_ram = 0;
                        $i = $used_ram + $inc_by;
                        while ($i < $total) {
                            if($usr_threshold <= $i / $total * 100) {
                                $new_ram = $old_ram;
                                break;
                            }
                            $old_ram = $i;
                            $i = $i + $inc_by;
                        }
                        $tmp_usage = $used_ram / $new_ram * 100;
                        if($tmp_usage < $usr_threshold) {
                            echo "Decreasing RAM to : " . $new_ram . "M\n";
                            vexec("virsh setmem " . $vps_name . " " . $new_ram . "M --live", $o, $ret);
                            if($ret != 0) {
                                echo "Error: There was an error while decreasing ram!\n";
                                return false;
                            }
                            if($min_ram < $new_ram) {
                                $inc_by = round(($new_ram - $min_ram) / 1024);
                                $apply_billing($vps, $owner, $resources, $inc_by);
                            }
                            if($ret == 0) {
                                @unlink($ram_log_path);
                            }
                        } elseif(!empty($fcont["new_ram"])) {
                            $inc_by = round(($fcont["new_ram"] - $min_ram) / 1024);
                            $apply_billing($vps, $owner, $resources, $inc_by);
                        }
                    }
                }
            }
        }
    }
    public function vertical_scale_cpu($vps, $owner, $resources)
    {
        global $globals;
        global $servers;
        if(!check_licensepro()) {
            return false;
        }
        $vps_name = $vps["vps_name"];
        $min_cpu = $vps["cores"];
        $max_cpu = !empty($vps["data"]["ver_max_cpu"]) ? $vps["data"]["ver_max_cpu"] : $globals["ver_max_cpu"];
        $usr_threshold = !empty($vps["data"]["ver_cpu_threshold"]) ? $vps["data"]["ver_cpu_threshold"] : $globals["ver_cpu_threshold"];
        $inc_by = $vps["ver_cpu_inc_by"];
        $cpu_log_path = logdir("/scaling/ver_scaling/") . $vps["vpsid"] . "_cpu";
        $file_time = @read_file($cpu_log_path);
        if(empty($max_cpu) || empty($usr_threshold) || empty($inc_by)) {
            return false;
        }
        $get_vcpus = function ($vps_name) {
            $_vcpu = [];
            vexec("virsh vcpuinfo " . $vps_name, $_vcpu, $ret);
            $vcpu = 0;
            foreach ($_vcpu as $v) {
                if(preg_match("/VCPU/", $v)) {
                    $vcpu++;
                }
            }
            return $vcpu;
        };
        $num_of_iterations = 2;
        $time = $usage = $tot_usage = $_time = [];
        $time_interval = 1;
        $vcpu = $get_vcpus($vps_name);
        for ($i = 0; $i < $num_of_iterations; $i++) {
            for ($j = 0; $j < 2; $j++) {
                vexec("virsh cpu-stats " . $vps_name . " --total", $o, $r);
                $_time = array_values(array_filter(explode(" ", $o[1])));
                $time[$j] = $_time[1];
                if($j == 1) {
                } else {
                    sleep($time_interval);
                }
            }
            $tot_usage[$i] = 100 * ($time[1] - $time[0]) / $time_interval;
            $usage[$i] = $tot_usage[$i] / $vcpu;
        }
        $sum_used = array_sum($tot_usage);
        $tot_threshold = $sum_used / $num_of_iterations;
        $sum_used = array_sum($usage);
        $threshold = $sum_used / $num_of_iterations;
        $rem_vcpu = $max_cpu - $vcpu;
        echo "\n--SCALING CPU--\n";
        echo "Total usage (" . $vcpu . " VCPUs): " . round($tot_threshold, 3) . "%\n";
        echo "Avg CPU Usage per vCPU: " . round($threshold, 3) . "%\n";
        if($usr_threshold < $threshold && 0 < $rem_vcpu) {
            $new_cpu = $vcpu + $inc_by;
            if($max_cpu < $new_cpu) {
                $new_cpu = $max_cpu;
            }
            echo "Increasing CPU core to : " . $new_cpu . " core\n";
            vexec("virsh setvcpus " . $vps_name . " " . $new_cpu . " --live", $o, $ret);
            if($ret != 0) {
                echo "Error: There was an error while increasing cpu cores!\n";
                return false;
            }
            @writefile($cpu_log_path, @time() + 3600, 1);
            if($vcpu != $max_cpu) {
                $vals = [];
                $vals["vps_uuid"] = $vps["uuid"];
                $vals["uid"] = $owner;
                $vals["updatetime"] = time();
                $vals["endtime"] = $vals["updatetime"];
                $vals["starttime"] = $vals["endtime"];
                $vals["resource"] = "vertical_cores";
                if(is_master()) {
                    $h_used = $resources["cores"]["h_rate"][$servers[$vps["serid"]]["sgid"]];
                    if(empty($h_used)) {
                        $h_used = $resources["cores"]["h_rate"][-1];
                    }
                    $vals["h_used"] = $h_used * $inc_by;
                }
                $vals["data"] = serialize(["hostname" => $vps["hostname"]]);
                $set = [];
                foreach ($vals as $k => $v) {
                    $set[$k] = "`" . $k . "` = :" . $k;
                }
                if(is_slave()) {
                    $post["usage"]["vals"] = $vals;
                    $post["usage"]["set"] = $set;
                    $post["inc_by"] = $inc_by;
                    $post["serid"] = $vps["serid"];
                    make_api_call_from_slave("index.php?rsync_to_master=1&billing_sync=1", [], $post);
                } else {
                    insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                }
            }
        } elseif($threshold < $usr_threshold && !empty($file_time) && $file_time <= time()) {
            echo "Decreasing CPU core to : " . $min_cpu . " core\n";
            vexec("virsh setvcpus " . $vps_name . " " . $min_cpu . " --live", $o, $ret);
            if($ret != 0) {
                echo "Error: There was an error while decreasing cpu cores!\n";
                return false;
            }
            @unlink($cpu_log_path);
        }
    }
    public function change_disk_conf($vid)
    {
        $vps_name = $this->getname($vid);
        $cfg = "/etc/libvirt/qemu/" . $vps_name . ".xml";
        $file = file($cfg);
        if(!empty($file)) {
            $lines = [];
            foreach ($file as $k => $v) {
                if(preg_match("/source(.*)((dev|file).*=.*')/is", $v)) {
                    $lines[] = $k;
                }
            }
            getvps($vid, 0);
            $disks = get_vps_DISKS($vid);
            if(count($disks) == count($lines)) {
                foreach ($disks as $k => $D) {
                    if(preg_match("/lightbit/is", $D["type"]) && preg_match("/rescue/is", basename($D["path"]))) {
                        $uuid = get_lightbit_uuid($D);
                        $pathinfo = pathinfo($D["path"]);
                        $D["path"] = $pathinfo["dirname"] . "/nvme-uuid." . $uuid;
                    }
                    $file[$lines[$k]] = "\n<source " . (preg_match("/file/is", $D["type"]) ? "file" : "dev") . "='" . $D["path"] . "'/>\n";
                }
            }
            writefile($cfg, implode("", $file), 1);
            @chmod($cfg, 384);
        }
    }
    public function pci_assign($vpsid, $data)
    {
        global $l;
        $return = [];
        $vps_name = $this->getname($vpsid);
        $status = no_log_status($vpsid, 1, $this);
        if($status == 1) {
            oexec("virsh dumpxml " . $vps_name, $xml, $err1);
            $xmlarray = xmlstring2array($xml);
            if(!empty($xmlarray["devices"]["hostdev"])) {
                if(is_int(array_key_first($xmlarray["devices"]["hostdev"]))) {
                    foreach ($xmlarray["devices"]["hostdev"] as $hostdev) {
                        if(preg_match("/pci/", $hostdev["@attributes"]["type"])) {
                            $assigned_pcis[] = $hostdev["source"]["address"]["@attributes"]["domain"] . $hostdev["source"]["address"]["@attributes"]["bus"] . $hostdev["source"]["address"]["@attributes"]["slot"] . $hostdev["source"]["address"]["@attributes"]["function"];
                        }
                    }
                } elseif(preg_match("/pci/", $xmlarray["devices"]["hostdev"]["@attributes"]["type"])) {
                    $assigned_pcis[] = $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["domain"] . $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["bus"] . $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["slot"] . $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["function"];
                }
            }
            foreach ($data["pci"] as $pid => $v) {
                $pci_props = passthrough_dev_properties($v["dev_fullname"], "pci");
                if(!in_array("0x" . $pci_props["domain"] . "0x" . $pci_props["bus"] . "0x" . $pci_props["slot"] . "0x" . $pci_props["function"], $assigned_pcis)) {
                    $xml_path = "/tmp/" . $pid . "_pci_segment_assign.xml";
                    $device_xml = "<hostdev mode='subsystem' type='pci' managed='yes'>\n\t\t\t\t\t\t<source>\n\t\t\t\t\t\t\t<address domain='0x" . $pci_props["domain"] . "' bus='0x" . $pci_props["bus"] . "' slot='0x" . $pci_props["slot"] . "' function='0x" . $pci_props["function"] . "'/>\n\t\t\t\t\t\t</source>\n\t\t\t\t\t</hostdev>\n\t\t\t\t\t";
                    writefile($xml_path, $device_xml, 1);
                    vexec("virsh attach-device " . $vps_name . " " . $xml_path . " --current 2>&1", $o, $err);
                    if(!empty($err)) {
                        $return["err"][$pid] = $o;
                        log_message(logdir("passthrough") . "vps_" . $vpsid, "Error : " . print_r($o, 1));
                    } else {
                        log_message(logdir("passthrough") . "vps_" . $vpsid, "Success ");
                    }
                    @unlink($xml_path);
                }
            }
        } else {
            $return["err"] = lang_vars_name($l["passthrough_offline_vps"], ["action" => "assign", "passthrough_dev_type" => "PCI"]);
        }
        return $return;
    }
    public function pci_remove($vpsid, $data)
    {
        global $l;
        $vps_name = $this->getname($vpsid);
        $status = no_log_status($vpsid, 1, $this);
        if($status == 1) {
            oexec("virsh dumpxml " . $vps_name, $xml, $err1);
            $xmlarray = xmlstring2array($xml);
            if(!empty($xmlarray["devices"]["hostdev"])) {
                if(is_int(array_key_first($xmlarray["devices"]["hostdev"]))) {
                    foreach ($xmlarray["devices"]["hostdev"] as $hostdev) {
                        if(preg_match("/pci/", $hostdev["@attributes"]["type"])) {
                            $assigned_pcis[] = $hostdev["source"]["address"]["@attributes"]["domain"] . $hostdev["source"]["address"]["@attributes"]["bus"] . $hostdev["source"]["address"]["@attributes"]["slot"] . $hostdev["source"]["address"]["@attributes"]["function"];
                        }
                    }
                } elseif(preg_match("/pci/", $xmlarray["devices"]["hostdev"]["@attributes"]["type"])) {
                    $assigned_pcis[] = $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["domain"] . $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["bus"] . $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["slot"] . $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["function"];
                }
            }
            foreach ($data["pci"] as $k => $v) {
                $pci_props = passthrough_dev_properties($v["dev_fullname"], "pci");
                if(in_array("0x" . $pci_props["domain"] . "0x" . $pci_props["bus"] . "0x" . $pci_props["slot"] . "0x" . $pci_props["function"], $assigned_pcis)) {
                    $address = "<address domain='0x" . $pci_props["domain"] . "' bus='0x" . $pci_props["bus"] . "' slot='0x" . $pci_props["slot"] . "' function='0x" . $pci_props["function"] . "'/>";
                    $tmp_pci_segmentxml_path = "/tmp/" . $k . "_pci_segment.xml";
                    $pci_segmentxml = "<hostdev mode='subsystem' type='pci' managed='yes'>\n\t\t\t\t\t\t<source>\n\t\t\t\t\t\t\t" . $address . "\n\t\t\t\t\t\t</source>\n\t\t\t\t\t</hostdev>\n\t\t\t\t\t";
                    log_message(logdir("passthrough") . "vps_" . $vpsid, "Removing PCI device - : " . print_r($pci_segmentxml, 1));
                    writefile($tmp_pci_segmentxml_path, $pci_segmentxml, 1);
                    vexec("virsh detach-device " . $vps_name . " " . $tmp_pci_segmentxml_path . " 2>&1", $o, $err);
                    if(!empty($err)) {
                        vexec("cat /run/libvirt/qemu/" . $vps_name . ".xml | grep \"" . $address . "\"", $vps_USBcontrollers, $err1);
                        if(!empty($err1)) {
                            $return["err"][$k] = $o;
                            log_message(logdir("passthrough") . "vps_" . $vpsid, "Error : " . print_r($o, 1));
                        } else {
                            log_message(logdir("passthrough") . "vps_" . $vpsid, "Success ");
                        }
                    } else {
                        log_message(logdir("passthrough") . "vps_" . $vpsid, "Success ");
                    }
                }
            }
        } else {
            $return["err"] = lang_vars_name($l["passthrough_offline_vps"], ["action" => "remove", "passthrough_dev_type" => "PCI"]);
        }
        return $return;
    }
    public function detach_pci_device($vpsid, $data)
    {
        foreach ($data["pci"] as $pid => $v) {
            vexec("virsh nodedev-detach " . $v["pci_name"] . " 2>&1", $o, $err);
            if(!empty($err)) {
                $return["err"][] = empty($o) ? $pid : $o;
            } else {
                log_message(logdir("passthrough") . "vps_" . $vpsid, "Detaching the PCI device from the node - : " . print_r($v["pci_name"], 1));
            }
        }
        return !empty($return["err"]) ? $return : $o;
    }
    public function usb_assign($vpsid, $data)
    {
        global $globals;
        global $l;
        $return = [];
        $vps_name = $this->getname($vpsid);
        $status = no_log_status($vpsid, 1, $this);
        if($status != 1) {
            $return["passthrough_offline_vps"] = $l["passthrough_offline_vps"];
            return $return["passthrough_offline_vps"];
        }
        oexec("virsh dumpxml " . $vps_name, $xml, $err1);
        $xmlarray = xmlstring2array($xml);
        if(!empty($xmlarray["devices"]["controller"])) {
            if(is_int(array_key_first($xmlarray["devices"]["controller"]))) {
                foreach ($xmlarray["devices"]["controller"] as $controller) {
                    if(preg_match("/usb/", $controller["@attributes"]["type"])) {
                        $usb_controllers[$controller["@attributes"]["index"]]["index"] = $controller["@attributes"]["index"];
                        $usb_controllers[$controller["@attributes"]["index"]]["model"] = $controller["@attributes"]["model"];
                        $usb_controllers[$controller["@attributes"]["index"]]["ports"] = [];
                    }
                }
            } elseif(preg_match("/usb/", $xmlarray["devices"]["controller"]["@attributes"]["type"])) {
                $usb_controllers[$xmlarray["devices"]["controller"]["@attributes"]["index"]]["index"] = $xmlarray["devices"]["controller"]["@attributes"]["index"];
                $usb_controllers[$xmlarray["devices"]["controller"]["@attributes"]["index"]]["model"] = $xmlarray["devices"]["controller"]["@attributes"]["model"];
                $usb_controllers[$xmlarray["devices"]["controller"]["@attributes"]["index"]]["ports"] = [];
            }
        }
        if(!empty($usb_controllers)) {
            if(!empty($xmlarray["devices"]["hostdev"])) {
                if(is_int(array_key_first($xmlarray["devices"]["hostdev"]))) {
                    foreach ($xmlarray["devices"]["hostdev"] as $hostdev) {
                        if(preg_match("/usb/", $hostdev["@attributes"]["type"])) {
                            foreach ($usb_controllers as $k => $controller) {
                                if($controller["index"] == $hostdev["address"]["@attributes"]["bus"]) {
                                    $usb_controllers[$k]["ports"][] = $hostdev["address"]["@attributes"]["port"];
                                    $assigned_usbs[$hostdev["source"]["vendor"]["@attributes"]["id"] . $hostdev["source"]["product"]["@attributes"]["id"] . $hostdev["source"]["address"]["@attributes"]["bus"] . $hostdev["source"]["address"]["@attributes"]["device"]] = $hostdev["address"]["@attributes"]["bus"];
                                }
                            }
                        }
                    }
                } elseif(preg_match("/usb/", $xmlarray["devices"]["hostdev"]["@attributes"]["type"])) {
                    foreach ($usb_controllers as $k => $controller) {
                        if($controller["index"] == $xmlarray["devices"]["hostdev"]["address"]["@attributes"]["bus"]) {
                            $usb_controllers[$k]["ports"][] = $xmlarray["devices"]["hostdev"]["address"]["@attributes"]["port"];
                            $assigned_usbs[$xmlarray["devices"]["hostdev"]["source"]["vendor"]["@attributes"]["id"] . $xmlarray["devices"]["hostdev"]["source"]["product"]["@attributes"]["id"] . $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["bus"] . $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["device"]] = $xmlarray["devices"]["hostdev"]["address"]["@attributes"]["bus"];
                        }
                    }
                }
            }
            foreach ($data["usb"] as $pid => $db_row) {
                $usb = passthrough_dev_properties($db_row["dev_fullname"], "usb", "all");
                if(!array_key_exists("0x" . $usb["vendor_id"] . "0x" . $usb["product_id"] . $usb["bus_id"] . $usb["dev_id"], $assigned_usbs)) {
                    $tmp_starting_port = $globals["usb_models"][$usb["model"]["name"]]["attributes"]["port_start"];
                    $tmp_ending_port = $globals["usb_models"][$usb["model"]["name"]]["attributes"]["port_end"];
                    $starting_port = !is_null($tmp_starting_port) ? $tmp_starting_port : 2;
                    $ending_port = !is_null($tmp_ending_port) ? $tmp_ending_port : 6;
                    $total_ports = $ending_port - $starting_port + 1;
                    $controller_index = 0;
                    $controller_port = $starting_port;
                    foreach ($usb_controllers as $k => $controller) {
                        if(in_array($controller["model"], array_column($globals["usb_models"], "name")) && $controller["model"] == $usb["model"]["name"] && count($controller["ports"]) < $total_ports) {
                            while (in_array($controller_port, $controller["ports"])) {
                                $controller_port++;
                            }
                            if($controller_port <= $ending_port) {
                                $controller_index = $controller["index"];
                                if(!empty($controller_index)) {
                                    $hostdev = "<hostdev mode='subsystem' type='usb' managed='yes'>\n\t\t\t\t\t\t\t<source>\n\t\t\t\t\t\t\t\t<vendor id='0x" . $usb["vendor_id"] . "'/>\n\t\t\t\t\t\t\t\t<product id='0x" . $usb["product_id"] . "'/>\n\t\t\t\t\t\t\t\t<address bus='" . $usb["bus_id"] . "' device='" . $usb["dev_id"] . "'/>\n\t\t\t\t\t\t\t</source>\n\t\t\t\t\t\t\t<address type='usb' bus='" . $controller_index . "' port='" . $controller_port . "'/>\n\t\t\t\t\t\t</hostdev>";
                                    $tmpfile = "/tmp/USBxml_" . $pid . ".xml";
                                    writefile($tmpfile, $hostdev, 1);
                                    vexec("virsh attach-device " . $vps_name . " --file " . $tmpfile . " 2>&1", $o, $err);
                                    if(!empty($err)) {
                                        $return["err"][$pid] = $o;
                                    } else {
                                        foreach ($usb_controllers as $k => $controller) {
                                            if($controller["index"] == $controller_index) {
                                                $usb_controllers[$k]["ports"][] = $controller_port;
                                                $assigned_usbs[$usb["vendor_id"] . $usb["product_id"] . $usb["bus_id"] . $usb["dev_id"]] = $controller_index;
                                            }
                                        }
                                    }
                                    @unlink($tmpfile);
                                } else {
                                    $return["passthrough_nocontroller"] = $l["passthrough_nocontroller"];
                                }
                            }
                        }
                    }
                }
            }
        } else {
            $return["passthrough_nocontroller"] = $l["passthrough_nocontroller"];
        }
        return $return;
    }
    public function usb_remove($vpsid, $data)
    {
        global $l;
        global $globals;
        $return = [];
        $vps_name = $this->getname($vpsid);
        $status = no_log_status($vpsid, 1, $this);
        if($status != 1) {
            $return["err"] = $l["passthrough_offline_vps"];
            return $return["err"];
        }
        oexec("virsh dumpxml " . $vps_name, $xml, $err1);
        $xmlarray = xmlstring2array($xml);
        foreach ($data["usb"] as $pid => $v) {
            $is_present = false;
            $usb = passthrough_dev_properties($v["dev_fullname"], "usb", "all");
            if(is_int(array_key_first($xmlarray["devices"]["hostdev"]))) {
                foreach ($xmlarray["devices"]["hostdev"] as $hostdev) {
                    if(preg_match("/usb/", $hostdev["@attributes"]["type"]) && $hostdev["source"]["vendor"]["@attributes"]["id"] == "0x" . $usb["vendor_id"] && $hostdev["source"]["product"]["@attributes"]["id"] == "0x" . $usb["product_id"] && $hostdev["source"]["address"]["@attributes"]["bus"] == $usb["bus_id"] && $hostdev["source"]["address"]["@attributes"]["device"] == $usb["dev_id"]) {
                        $is_present = true;
                    }
                }
            } elseif(preg_match("/usb/", $xmlarray["devices"]["hostdev"]["@attributes"]["type"]) && $xmlarray["devices"]["hostdev"]["source"]["vendor"]["@attributes"]["id"] == "0x" . $usb["vendor_id"] && $xmlarray["devices"]["hostdev"]["source"]["product"]["@attributes"]["id"] == "0x" . $usb["product_id"] && $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["bus"] == $usb["bus_id"] && $xmlarray["devices"]["hostdev"]["source"]["address"]["@attributes"]["device"] == $usb["dev_id"]) {
                $is_present = true;
            }
            if($is_present) {
                $hostdev = "<hostdev mode='subsystem' type='usb' managed='yes'>\n\t\t\t\t\t<source>\n\t\t\t\t\t\t<vendor id='0x" . $usb["vendor_id"] . "'/>\n\t\t\t\t\t\t<product id='0x" . $usb["product_id"] . "'/>\n\t\t\t\t\t\t<address bus='" . $usb["bus_id"] . "' device='" . $usb["dev_id"] . "'/>\n\t\t\t\t\t</source>\n\t\t\t\t</hostdev>\n\t\t\t\t";
                $tmpfile = "/tmp/" . $vps_name . "_usbdevice.xml";
                writefile($tmpfile, $hostdev, 1);
                vexec("virsh detach-device " . $vps_name . " " . $tmpfile . " 2>&1", $o, $err);
                if(!empty($err)) {
                    $return["err"][$pid] = $o;
                }
                @unlink($tmpfile);
            }
        }
        return $return;
    }
    public function node_pci_devices()
    {
        $res = passthrough_devices("pci");
        if(empty($res)) {
            return false;
        }
        $return["node_pcis"] = $res["node_pcis"];
        foreach ($res["node_pcis"] as $n => $pci_fullname) {
            $pci_props = passthrough_dev_properties($pci_fullname, "pci");
            oexec("virsh nodedev-dumpxml " . $pci_props["pci_name"], $dumpxml, $r1);
            if(!empty($dumpxml)) {
                $return["node_pcis"][$n] = $pci_fullname;
                $return["dumpxml"][$n] = $dumpxml;
                preg_match("/iommuGroup number=(.*)?/", $dumpxml, $o);
                if(!empty($o[0])) {
                    $grp_number = explode("'", $o[0]);
                }
                $return["iommu_grp_num"][$n] = $grp_number[1];
            } else {
                $return["err"][] = $n;
            }
        }
        return $return;
    }
    public function node_usb_devices()
    {
        $res = passthrough_devices("usb");
        if(empty($res)) {
            return false;
        }
        $return["node_usbs"] = $res["node_usbs"];
        return $return;
    }
    public function node_gpuroms()
    {
        global $globals;
        $globals["vgabios_path"] = !empty($globals["vgabios_path"]) ? $globals["vgabios_path"] : "/usr/share/";
        $rom_files = @scandir($globals["vgabios_path"]);
        if(!empty($rom_files)) {
            foreach ($rom_files as $k => $v) {
                if(!preg_match("/.rom/is", $v)) {
                    unset($rom_files[$k]);
                }
            }
        }
        return $rom_files;
    }
    public function is_pci_SR_IOV()
    {
    }
}

?>