<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function import()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $ostemplates;
    global $vpsid;
    global $error;
    global $done;
    global $users;
    global $servers;
    global $storages;
    if(!load_lang("admin/import")) {
        return false;
    }
    $theme["init_theme"] = "admin/import";
    $theme["init_theme_name"] = "import";
    $theme["init_theme_func"] = ["import_default_theme"];
    oslist();
    $users = [];
    $res = makequery("SELECT * FROM users ORDER BY email");
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $users[$row["uid"]] = $row;
    }
    $sa = optGET("sa");
    $sa = empty($sa) ? "openvz" : $sa;
    switch ($sa) {
        case "default":
            import_default();
            break;
        case "virtuozzo":
        case "openvz":
            openvz_import();
            break;
        case "xen":
            xen_import();
            break;
        case "kvm":
            kvm_import();
            break;
        case "solusvm":
            solusvm_import();
            break;
        case "xcp":
            xcp_import();
            break;
        case "proxmox":
            proxmox_import();
            break;
        case "openvz7":
        case "virtuozzo7":
            openvz7_import();
            break;
    }
}
function import_default()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $ostemplates;
    global $vpsid;
    global $error;
    global $done;
    $theme["call_theme_func"] = "import_default_theme";
    if(!is_allowed("importvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    if(isset($_POST["importvps"])) {
        $vpsname = POST("vpsname", $l["novps"]);
        $vpsbandwidth = POST("vpsbandwidth", $l["no_vpsbandwidth"]);
        if(!empty($error)) {
            return false;
        }
        $checkvps = makequery("SELECT vpsid FROM vps WHERE\n\t\t\t\t\t\t\t  vps_name = :vpsname", [":vpsname" => $vpsname]);
        if(0 < vsql_num_rows($checkvps)) {
            $error[] = $l["vpsavailable"];
            return false;
        }
        if(!is_file("/etc/vz/conf/" . $vpsname . ".conf")) {
            $error[] = $l["novpsfound"];
            return false;
        }
        $vconf = $kernel->getconf("/etc/vz/conf/" . $vpsname . ".conf");
        $space = !empty($vconf["DISKSPACE"]) ? explode(":", $vconf["DISKSPACE"]) : [0, 0];
        $space = $space[1] / 1024 / 1024;
        $inodes = !empty($vconf["DISKINODES"]) ? explode(":", $vconf["DISKINODES"]) : [0, 0];
        $inodes = $inodes[1];
        $osid = 0;
        foreach ($ostemplates as $k => $v) {
            if(strtolower(trim($vconf["OSTEMPLATE"], ".")) == strtolower($v["name"])) {
                $osid = $k;
            }
        }
        $pips = [];
        if(!empty($vconf["IP_ADDRESS"])) {
            $tmp = $vconf["IP_ADDRESS"];
            $pips = explode(" ", $tmp);
            foreach ($pips as $k => $v) {
                if(empty($v)) {
                    unset($pips[$k]);
                }
            }
            $pips = array_values($pips);
            $qres = makequery("SELECT *\n\t\t\t\t\t\t\tFROM ips \n\t\t\t\t\t\t\tWHERE ip IN('" . implode("','", $pips) . "')");
            $usedips = [];
            $unusedip = [];
            for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                $row = vsql_fetch_assoc($qres);
                if(empty($row["vpsid"])) {
                    $unusedip[] = $row["ip"];
                } else {
                    $usedips[] = $row["ip"];
                }
            }
            if(!empty($usedips)) {
                $error[] = $l["used_ip"] . "<br />" . implode(", ", $usedips);
                return false;
            }
        }
        $hostname = !empty($vconf["HOSTNAME"]) ? $vconf["HOSTNAME"] : "";
        $ioprio = !empty($vconf["IOPRIO"]) ? $vconf["IOPRIO"] : 3;
        $cpuunits = !empty($vconf["CPUUNITS"]) ? $vconf["CPUUNITS"] : 1000;
        $cpulimit = !empty($vconf["CPULIMIT"]) ? $vconf["CPULIMIT"] : 10;
        $cpu = !empty($vconf["CPUS"]) ? $vconf["CPUS"] : 1;
        $ram = explode(":", $vconf["SHMPAGES"]);
        $tram = round($ram[1] * 4 / 1024);
        if(!empty($vconf["PRIVVMPAGES"])) {
            $bram = explode(":", $vconf["PRIVVMPAGES"]);
            $tbram = round($bram[1] * 4 / 1024);
        } else {
            $tbram = $tram;
        }
        $_ubc = ["kmemsize", "lockedpages", "numproc", "physpages", "numtcpsock", "numflock", "numpty", "numsiginfo", "tcpsndbuf", "tcprcvbuf", "othersockbuf", "dgramrcvbuf", "numothersock", "dcachesize", "numfile", "numiptent", "swappages"];
        $ubc = [];
        foreach ($_ubc as $k => $v) {
            if(!empty($vconf[strtoupper($v)])) {
                $ubc[strtoupper($v)] = explode(":", $vconf[strtoupper($v)]);
            }
        }
        $serializedubc = !empty($ubc) ? serialize($ubc) : "";
        $vpsid = insert_and_id("INSERT INTO vps \n\t\t\t\t\tSET vps_name = :vps_name,\n\t\t\t\t\tserid = :serid,\n\t\t\t\t\tvirt = :virt,\n\t\t\t\t\thostname  = :hostname,\n\t\t\t\t\tosid = :osid,\n\t\t\t\t\tspace = :space,\n\t\t\t\t\tinodes = :inodes,\n\t\t\t\t\tram = :ram,\n\t\t\t\t\tburst = :burst,\n\t\t\t\t\tcpu = :cpu,\n\t\t\t\t\tcores = :cores,\n\t\t\t\t\tcpu_percent = :cpu_percent,\n\t\t\t\t\tbandwidth = :bandwidth,\n\t\t\t\t\tio = :io,\n\t\t\t\t\tubc = :ubc", [":vps_name" => $vpsname, ":serid" => "0", ":virt" => "openvz", ":hostname" => $hostname, ":osid" => $osid, ":space" => $space, ":inodes" => $inodes, ":ram" => $tram, ":burst" => $tbram, ":cpu" => $cpuunits, ":cores" => $cpu, ":cpu_percent" => $cpulimit, ":bandwidth" => $vpsbandwidth, ":io" => $ioprio, ":ubc" => $serializedubc]);
        if(empty($vpsid)) {
            $error[] = $l["err_insert"];
            return false;
        }
        $p_counter = 1;
        foreach ($pips as $k => $v) {
            if(in_array($v, $unusedip)) {
                $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\t\tSET vpsid = :vpsid,\n\t\t\t\t\t\t\t\t\t`primary` = :primary\n\t\t\t\t\t\t\t\t\tWHERE ip = :ip", [":vpsid" => $vpsid, ":primary" => -1 * $p_counter, ":ip" => $v]);
            } else {
                $res = insert_and_id("INSERT INTO ips SET\n\t\t\t\t\t\t\t\t\t ip = :ip,\n\t\t\t\t\t\t\t\t\t `primary` = :primary,\n\t\t\t\t\t\t\t\t\t vpsid = :vpsid", [":ip" => $v, ":primary" => -1 * $p_counter, ":vpsid" => $vpsid]);
            }
            $p_counter++;
        }
        $res = update_query("UPDATE ips\n\t\t\t\t\t\t\tSET `primary`  = 1\n\t\t\t\t\t\t\tWHERE ip = '" . $pips[0] . "'");
        logs_admin("import", $vpsname, 1, $vpsid, $user["uid"]);
        $done = true;
    }
}
function openvz_import()
{
    global $theme;
    global $globals;
    global $cluster;
    global $users;
    global $l;
    global $ostemplates;
    global $user;
    global $error;
    global $done;
    global $orphan;
    global $is_openvz7;
    global $vps_list;
    $theme["call_theme_func"] = "openvz_import_theme";
    if(!is_allowed("importvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $orphan = $cluster->openvz_orphan($globals["server"]);
    if(!empty($orphan["is_openvz7"])) {
        $is_openvz7 = true;
        unset($orphan["is_openvz7"]);
    }
    if(optPOST("importvps")) {
        $toimport = [];
        $vps_list = $_POST["vps_list"];
        if(empty($vps_list)) {
            $vps_list = array_keys($orphan);
        }
        foreach ($vps_list as $v) {
            $toimport[$v]["vps_name"] = $v;
            $toimport[$v]["bandwidth"] = optPOST("vsbw_" . $v);
            $toimport[$v]["uid"] = optPOST("vsuser_" . $v);
            if(empty($users[$toimport[$v]["uid"]])) {
                $toimport[$v]["uid"] = 0;
            }
        }
        $imported = $cluster->openvz_import($globals["server"], array_keys($toimport));
        if(empty($imported)) {
            $error[] = $l["err_openvz_import"];
            return false;
        }
        foreach ($imported as $k => $v) {
            $vpsid = 0;
            if(!empty($v["ips"][0])) {
                $qres = makequery("SELECT *\tFROM ips \n\t\t\t\t\t\t\tWHERE ip IN('" . implode("','", $v["ips"]) . "')");
                $usedips = [];
                $unusedip = [];
                for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                    $row = vsql_fetch_assoc($qres);
                    if(empty($row["vpsid"])) {
                        $unusedip[] = $row["ip"];
                    } else {
                        $usedips[] = $row["ip"];
                    }
                }
                if(!empty($usedips)) {
                    $error[] = "<b>" . $k . "</b> - " . $l["err_openvz_usedip"] . " " . implode(", ", $usedips);
                }
            }
            $sa = optREQ("sa");
            $v["virt"] = "openvz";
            if($sa == "vzo") {
                $v["virt"] = "vzo";
            }
            if($sa == "proxmox") {
                $v["virt"] = "proxo";
            }
            $v["bandwidth"] = $toimport[$k]["bandwidth"];
            $v["uid"] = $toimport[$k]["uid"];
            $v["vps_name"] = $k;
            $_err = import_vps_data($v, $vpsid);
            if(!empty($_err)) {
                $error[] = $_err;
            } else {
                logs_admin("import", $k, 1, $vpsid, $user["uid"]);
            }
        }
        $sres = $cluster->sync($globals["server"]);
        if(empty($error)) {
            $done = 1;
        }
    }
}
function API_openvz_import()
{
    global $error;
    global $done;
    global $orphan;
    global $users;
    global $vps_list;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($orphan)) {
        $GLOBALS["_api"]["orphan"] = $orphan;
    }
    if(!empty($users)) {
        $GLOBALS["_api"]["users"] = $users;
    }
    if(!empty($vps_list)) {
        $GLOBALS["_api"]["vps_list"] = $vps_list;
    }
}
function kvm_import()
{
    global $theme;
    global $globals;
    global $cluster;
    global $users;
    global $l;
    global $ostemplates;
    global $user;
    global $error;
    global $done;
    global $orphan;
    global $vps_list;
    $theme["call_theme_func"] = "kvm_import_theme";
    if(!is_allowed("importvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $orphan = $cluster->kvm_orphan($globals["server"]);
    if(optPOST("importvps")) {
        $toimport = [];
        $vps_list = $_POST["vps_list"];
        if(empty($vps_list)) {
            $vps_list = array_keys($orphan);
        }
        foreach ($vps_list as $v) {
            $toimport[$v]["vps_name"] = $v;
            $toimport[$v]["bandwidth"] = optPOST("vsbw_" . $v);
            $toimport[$v]["uid"] = optPOST("vsuser_" . $v);
            if(empty($users[$toimport[$v]["uid"]])) {
                $toimport[$v]["uid"] = 0;
            }
        }
        $imported = $cluster->kvm_import($globals["server"], array_keys($toimport));
        if(empty($imported)) {
            $error[] = $l["err_kvm_import"];
            return false;
        }
        foreach ($imported as $k => $vps) {
            $vps["vps_name"] = $vps["hostname"];
            $vps["bandwidth"] = $toimport[$k]["bandwidth"];
            $vps["uid"] = $toimport[$k]["uid"];
            $vps["time"] = time();
            $vps["virt"] = "kvm";
            $_err = import_vps_data($vps, $vpsid);
            if(!empty($_err)) {
                $error[] = $_err;
            } else {
                logs_admin("import", $k, 1, $vpsid, $user["uid"]);
            }
        }
        if(empty($error)) {
            $sres = $cluster->sync($globals["server"]);
            $done = 1;
        }
    }
}
function API_kvm_import()
{
    global $error;
    global $done;
    global $orphan;
    global $users;
    global $vps_list;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($orphan)) {
        $GLOBALS["_api"]["orphan"] = $orphan;
    }
    if(!empty($users)) {
        $GLOBALS["_api"]["users"] = $users;
    }
    if(!empty($vps_list)) {
        $GLOBALS["_api"]["vps_list"] = $vps_list;
    }
}
function xen_import()
{
    global $theme;
    global $globals;
    global $cluster;
    global $users;
    global $l;
    global $ostemplates;
    global $user;
    global $error;
    global $done;
    global $orphan;
    global $vps_list;
    global $vps_success_imp;
    $theme["call_theme_func"] = "xen_import_theme";
    if(!is_allowed("importvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $orphan = $cluster->xen_orphan($globals["server"]);
    $vps_success_imp = [];
    if(optPOST("importvps")) {
        $toimport = [];
        $vps_list = $_POST["vps_list"];
        if(empty($vps_list)) {
            $vps_list = array_keys($orphan);
        }
        foreach ($vps_list as $v) {
            $toimport[$v]["vps_name"] = $v;
            $toimport[$v]["bandwidth"] = optPOST("vsbw_" . $v);
            $toimport[$v]["uid"] = optPOST("vsuser_" . $v);
            if(empty($users[$toimport[$v]["uid"]])) {
                $toimport[$v]["uid"] = 0;
            }
        }
        $imported = $cluster->xen_import($globals["server"], array_keys($toimport));
        if(empty($imported)) {
            $error[] = $l["err_xen_import"];
            return false;
        }
        foreach ($imported as $k => $v) {
            if(empty($v["space"])) {
                $error[] = lang_vars_name($l["err_empty_space"], ["vps_name" => $k, "size" => $vps["disks"][0]["size"]]);
            } else {
                $v["vps_name"] = $k;
                $v["bandwidth"] = $toimport[$k]["bandwidth"];
                $v["uid"] = $toimport[$k]["uid"];
                $v["time"] = time();
                $v["virt"] = "xen";
                $_err = import_vps_data($v, $vpsid);
                if(!empty($_err)) {
                    $error[] = $_err;
                } else {
                    logs_admin("import", $k, 1, $vpsid, $user["uid"]);
                    $vps_success_imp[] = $v["vps_name"];
                }
            }
        }
        if(empty($error)) {
            $sres = $cluster->sync($globals["server"]);
        }
        if(!empty($error)) {
            return false;
        }
        $done = 1;
    }
}
function API_xen_import()
{
    global $error;
    global $done;
    global $orphan;
    global $users;
    global $vps_list;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($orphan)) {
        $GLOBALS["_api"]["orphan"] = $orphan;
    }
    if(!empty($users)) {
        $GLOBALS["_api"]["users"] = $users;
    }
    if(!empty($vps_list)) {
        $GLOBALS["_api"]["vps_list"] = $vps_list;
    }
}
function xcp_import()
{
    global $theme;
    global $globals;
    global $cluster;
    global $users;
    global $l;
    global $ostemplates;
    global $user;
    global $error;
    global $done;
    global $orphan;
    global $vps_list;
    $theme["call_theme_func"] = "xcp_import_theme";
    if(!is_allowed("importvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $orphan = $cluster->xcp_orphan($globals["server"]);
    if(optPOST("importvps")) {
        $toimport = [];
        $vps_list = $_POST["vps_list"];
        if(empty($vps_list)) {
            $vps_list = array_keys($orphan);
        }
        foreach ($vps_list as $v) {
            $toimport[$v]["vps_name"] = $v;
            $toimport[$v]["bandwidth"] = optPOST("vsbw_" . $v);
            $toimport[$v]["uid"] = optPOST("vsuser_" . $v);
            if(empty($users[$toimport[$v]["uid"]])) {
                $toimport[$v]["uid"] = 0;
            }
        }
        $imported = $cluster->xcp_import($globals["server"], array_keys($toimport));
        if(empty($imported)) {
            $error[] = $l["err_xen_import"];
            return false;
        }
        foreach ($imported as $k => $vps) {
            $vps["bandwidth"] = $toimport[$k]["bandwidth"];
            $vps["uid"] = $toimport[$k]["uid"];
            $_err = import_vps_data($vps, $vpsid);
            if(!empty($_err)) {
                $error[] = $_err;
            } else {
                logs_admin("import", $k, 1, $vpsid, $user["uid"]);
            }
        }
        if(empty($error)) {
            $sres = $cluster->sync($globals["server"]);
            $done = 1;
        }
    }
}
function API_xcp_import()
{
    global $error;
    global $done;
    global $orphan;
    global $users;
    global $vps_list;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($orphan)) {
        $GLOBALS["_api"]["orphan"] = $orphan;
    }
    if(!empty($users)) {
        $GLOBALS["_api"]["users"] = $users;
    }
    if(!empty($vps_list)) {
        $GLOBALS["_api"]["vps_list"] = $vps_list;
    }
}
function solusvm_import()
{
    global $theme;
    global $globals;
    global $cluster;
    global $users;
    global $l;
    global $ostemplates;
    global $user;
    global $servers;
    global $error;
    global $done;
    global $orphan;
    global $solusvm_nodes;
    global $virt_solus_servers;
    global $solusvm_users;
    global $v_users;
    global $inserted;
    global $info;
    $theme["call_theme_func"] = "solusvm_import_theme";
    if(!is_allowed("importvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $file = "/usr/local/solusvm/includes/solusvm.conf";
    if(!is_file($file)) {
        $error["no_file"] = $l["no_file"];
        return false;
    }
    $f = trim(@file_get_contents($file));
    $solus_conf = explode(":", $f);
    $conn_solusvm = new PDO("mysql:host=" . $solus_conf[3] . ";unix_socket=/var/lib/mysql/mysql.sock;dbname=" . $solus_conf[0] . "", $solus_conf[1], $solus_conf[2], [PDO::MYSQL_ATTR_MULTI_STATEMENTS => false]);
    if(!$conn_solusvm) {
        $error["so_conn_err"] = $l["so_conn_err"];
        return false;
    }
    $res = makequery("SELECT * FROM `nodes`", [], 0, $conn_solusvm);
    if(!$res) {
        $error["no_query"] = $l["no_query"];
        return false;
    }
    for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
        $solusvm_nodes[$row["nodeid"]] = $row;
        $solusvm_nodes_ipwise[trim($row["ip"])] = $row["nodeid"];
    }
    foreach ($servers as $k => $v) {
        if($k == 0) {
            $v["ip"] = $globals["primary_ip"];
        }
        if(empty($solusvm_nodes_ipwise[$v["ip"]])) {
        } else {
            $virt_solus_servers[$solusvm_nodes_ipwise[$v["ip"]]] = $k;
        }
    }
    $ta = optGET("ta");
    $load_others = 0;
    if($ta == "vps") {
        $load_others = 1;
    }
    if($ta == "nodes" && !is_api_call()) {
        $theme["call_theme_func"] = "solusvm_nodes_import_theme";
    }
    if($ta == "nodegroups") {
        global $v_server_groups;
        global $v_sg_matches;
        global $solusvm_nodegroups;
        if(!is_api_call()) {
            $theme["call_theme_func"] = "solusvm_nodegroups_import_theme";
        }
        $res = makequery("SELECT * FROM `nodegroups`", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        $solusvm_nodegroups[0]["id"] = 0;
        $solusvm_nodegroups[0]["name"] = "Default";
        $solusvm_nodegroups[0]["description"] = "Default Pool";
        $solusvm_nodegroups[0]["autotype"] = 1;
        $v_sg_matches["Default"] = -1;
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $solusvm_nodegroups[$row["id"]] = $row;
            $v_sg_matches[$row["name"]] = -1;
        }
        $v_server_groups = server_groups();
        foreach ($v_server_groups as $k => $v) {
            if(array_key_exists($v["sg_name"], $v_sg_matches)) {
                $v_sg_matches[$v["sg_name"]] = $v["sgid"];
            }
        }
        foreach ($v_sg_matches as $k => $v) {
            if($v < 0) {
                unset($v_sg_matches[$k]);
            }
        }
        foreach ($solusvm_nodes as $k => $v) {
            if(!isset($virt_solus_servers[$k])) {
            } else {
                $group_wise_nodes[$v["groupid"]][$k] = $virt_solus_servers[$k];
            }
        }
        if(isset($_POST["solusvm_ng"])) {
            foreach ($solusvm_nodegroups as $k => $v) {
                $sgid = -1;
                if(isset($v_sg_matches[$v["name"]])) {
                    $sgid = $v_sg_matches[$v["name"]];
                }
                if($sgid == -1) {
                    $sgid = insert_and_id("INSERT INTO `server_groups` \n\t\t\t\t\t\t\t\t\t\t\tSET sg_name = :sg_name,\n\t\t\t\t\t\t\t\t\t\t\t`sg_desc` = :sg_desc", [":sg_name" => $v["name"], ":sg_desc" => $v["description"]]);
                    if(empty($sgid)) {
                        $error[] = $l["err_importing_nodegroups"] . " " . $v["name"];
                    }
                }
                if(!empty($group_wise_nodes[$k])) {
                    foreach ($group_wise_nodes[$k] as $nk => $nv) {
                        $res = makequery("UPDATE servers \n\t\t\t\t\t\t\t\t\t\tSET sgid = :sgid\n\t\t\t\t\t\t\t\t\t\tWHERE serid = :serid", [":sgid" => $sgid, ":serid" => $nv]);
                    }
                }
            }
            $done = 1;
        }
    }
    if($ta == "plans" || $load_others) {
        global $v_plans;
        global $v_plans_matches;
        global $solusvm_plans;
        if(!is_api_call()) {
            $theme["call_theme_func"] = "solusvm_plans_import_theme";
        }
        $res = makequery("SELECT * FROM `plans`", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $row["ram"] = $row["ram"] / 1024 / 1024;
            $row["swap"] = $row["burst"] / 1024 / 1024;
            $row["burst"] = $row["burst"] / 1024 / 1024;
            $row["disk"] = $row["disk"] / 1024 / 1024 / 1024;
            $row["bandwidth"] = $row["bandwidth"] / 1024 / 1024 / 1024;
            $row["type"] = preg_match("/xen/", $row["type"]) ? "xen" : $row["type"];
            if($row["type"] == "kvm") {
                $row["swap"] = $row["kvmswap"];
            }
            $solusvm_plans[$row["planid"]] = $row;
            $v_plans_matches[$row["type"] . "-" . $row["name"]] = -1;
        }
        $res = makequery("SELECT * FROM plans\n\t\t\t\t\t\tORDER BY plid");
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $v_plans[$row["plid"]] = $row;
            $v_plans_matches[$row["virt"] . "-" . $row["plan_name"]] = $row["plid"];
        }
        foreach ($v_plans_matches as $k => $v) {
            if($v < 0) {
                unset($v_plans_matches[$k]);
            }
        }
        if(isset($_POST["solusvm_plans"])) {
            foreach ($solusvm_plans as $k => $v) {
                $plid = -1;
                if(isset($v_plans_matches[$v["type"] . "-" . $v["name"]])) {
                    $plid = $v_plans_matches[$v["type"] . "-" . $v["name"]];
                }
                if($plid == -1) {
                    $plid = insert_and_id("INSERT INTO `plans` \n\t\t\t\t\t\t\t\t\t\t\tSET plan_name = '" . $v["name"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`virt` = '" . $v["type"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`ips` = '1',\n\t\t\t\t\t\t\t\t\t\t\t`ips6` = '" . $v["ipv6"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`ips6_subnet` = '" . $v["ipv6subnets"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`space` = '" . $v["disk"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`inodes` = '" . $v["type"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`ram` = '" . $v["ram"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`burst` = '" . $v["burst"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`swap` = '" . $v["swap"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`cpu` = '" . $v["cpuunits"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`cores` = '" . $v["cpus"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`cpu_percent` = '" . $v["cpulimit"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`bandwidth` = '" . $v["bandwidth"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`network_speed` = '" . $v["networkspeed"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`io` = '" . $v["iopriority"] . "'");
                    if(empty($plid)) {
                        $error[] = $l["err_importing_plan"] . " " . $v["name"];
                    }
                }
            }
            $done = 1;
        }
    }
    if($ta == "users" || $load_others) {
        if(!is_api_call()) {
            $theme["call_theme_func"] = "solusvm_users_import_theme";
        }
        $res = makequery("SELECT * FROM `clients`", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $solusvm_users[$row["clientid"]] = $row;
        }
        foreach ($users as $k => $v) {
            $v_users[$k] = $v["email"];
        }
        if(isset($_POST["solusvm_users"])) {
            $info = [];
            foreach ($solusvm_users as $k => $v) {
                if(empty($v["emailaddress"])) {
                } elseif(in_array($v["emailaddress"], $v_users)) {
                } else {
                    $type = !empty($v["resellerid"]) && $v["resellerid"] == $v["clientid"] ? 2 : 0;
                    $virts = [];
                    foreach ($globals["virts"] as $vk => $vv) {
                        if(!empty($v["rs" . $vk])) {
                            $virts[] = $vv;
                        }
                    }
                    $prefs["fname"] = $v["firstname"];
                    $prefs["lname"] = $v["lastname"];
                    $preferences = serialize($prefs);
                    $inserted = insert_and_id("INSERT INTO `users` \n\t\t\t\t\t\t\t\t\t\tSET email = :email,\n\t\t\t\t\t\t\t\t\t\t`password` = :password,\n\t\t\t\t\t\t\t\t\t\t`type` = :type,\n\t\t\t\t\t\t\t\t\t\t`num_vs` = :num_vs,\n\t\t\t\t\t\t\t\t\t\t`space` = :space,\n\t\t\t\t\t\t\t\t\t\t`ram` = :ram,\n\t\t\t\t\t\t\t\t\t\t`num_users` = :num_users,\n\t\t\t\t\t\t\t\t\t\t`num_ipv4` = :num_ipv4,\n\t\t\t\t\t\t\t\t\t\t`num_ipv6` = :num_ipv6,\n\t\t\t\t\t\t\t\t\t\t`burst` = :burst,\n\t\t\t\t\t\t\t\t\t\t`allowed_virts` = '" . implode(" ", $virts) . "',\n\t\t\t\t\t\t\t\t\t\t`cores` = :cores,\n\t\t\t\t\t\t\t\t\t\t`bandwidth` = :bandwidth,\n\t\t\t\t\t\t\t\t\t\t`preferences` = :preferences", [":email" => $v["emailaddress"], ":password" => $v["password"], ":type" => $type, ":num_vs" => $v["rsmaxvps"], ":space" => $v["rsmaxvps"] / 1024 / 1024 / 1024, ":ram" => $v["rsmaxmemory"] / 1024 / 1024, ":num_users" => $v["rsmaxuser"], ":num_ipv4" => $v["rsmaxipv4"], ":num_ipv6" => $v["rsmaxipv6"], ":burst" => $v["rsmaxburst"] / 1024 / 1024, ":cores" => $v["rsdefcpu"], ":bandwidth" => $v["rsmaxbandwidth"] / 1024 / 1024 / 1024, ":preferences" => $preferences]);
                    if(empty($inserted)) {
                        $error[] = $l["err_importing_user"] . " " . $v["emailaddress"];
                    }
                    if(!empty($v["resellerid"]) && $v["resellerid"] != $v["clientid"]) {
                        $sub_users[$inserted] = $solusvm_users[$v["resellerid"]]["emailaddress"];
                    }
                }
            }
            if(!empty($sub_users)) {
                foreach ($sub_users as $sk => $sv) {
                    makequery("UPDATE `users` u, `users` u2 \n\t\t\t\t\t\t\tSET u.pid = u2.uid \n\t\t\t\t\t\t\tWHERE u2.email = :email\n\t\t\t\t\t\t\tAND u.uid = :uid", [":email" => $sv, ":uid" => $sk]);
                }
            }
            $done = 1;
        }
    }
    if($ta == "ips") {
        global $v_ippools;
        global $v_ipmatches;
        global $solusvm_ipblocks;
        global $solusvm_ipblocknodes;
        global $show_solusvm_int_ips;
        $node_ip = empty($globals["server"]) ? $globals["primary_ip"] : $servers[$globals["server"]]["ip"];
        $solus_serid = $solusvm_nodes_ipwise[$node_ip];
        if(!is_api_call()) {
            $theme["call_theme_func"] = "solusvm_ips_import_theme";
        }
        $res = makequery("SELECT * FROM ippool ORDER BY ippid");
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $v_ippools[$row["ippid"]] = $row;
            $v_ipmatches[$row["ippool_name"] . "_" . $row["gateway"] . "/" . $row["netmask"]] = -1 * $row["ippid"];
        }
        $res = makequery("SELECT * FROM ippool_servers\n\t\t\t\t\t\tWHERE serid > -1\n\t\t\t\t\t\tAND sgid = -2\n\t\t\t\t\t\tORDER BY ippid");
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $v_ippools[$row["ippid"]]["servers"][$row["serid"]] = $row;
        }
        $res = makequery("SELECT * FROM `ipblocks`", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            if($row["iptype"] != 4) {
                $row["mask"] = $row["ipv6netmask"];
            }
            $solusvm_ipblocks[$row["blockid"]] = $row;
            if(!empty($v_ipmatches[$row["name"] . "_" . $row["gateway"] . "/" . $row["mask"]])) {
                $v_ipmatches[$row["name"] . "_" . $row["gateway"] . "/" . $row["mask"]] = -1 * $v_ipmatches[$row["name"] . "_" . $row["gateway"] . "/" . $row["mask"]];
            }
        }
        $res = makequery("SELECT * FROM `ipblocknodes`", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $solusvm_ipblocknodes[$row["blockid"]][$row["nodeid"]] = $row;
        }
        $show_solusvm_int_ips = [];
        $int_pool_exists = 0;
        $res = makequery("SELECT * FROM `internalips`\n\t\t\t\t\t\t\t\t\tWHERE nodeid = '" . $solus_serid . "'", [], 0, $conn_solusvm);
        $vres = makequery("SELECT ippool_name FROM `ippool`\n\t\t\t\t\t\t\tWHERE ippool_name = 'SolusVM_internal_" . $globals["server"] . "'");
        if(0 < vsql_num_rows($vres)) {
            $int_pool_exists = 1;
        }
        if(0 < vsql_num_rows($res) && empty($int_pool_exists)) {
            for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                $show_solusvm_int_ips[$row["ipaddress"]] = $row;
            }
            $show_solusvm_int_ips["gateway"] = $solusvm_nodes[$solus_serid]["intipgateway"];
            $show_solusvm_int_ips["netmask"] = $solusvm_nodes[$solus_serid]["intipnetmask"];
            $show_solusvm_int_ips["nameserver1"] = "8.8.8.8";
            $show_solusvm_int_ips["nameserver1"] = "8.8.4.4";
        }
        foreach ($v_ipmatches as $k => $v) {
            if($v < 0) {
                unset($v_ipmatches[$k]);
            }
        }
        if(isset($_POST["solusvm_ips"])) {
            $info = [];
            foreach ($solusvm_ipblocks as $k => $v) {
                if($v["iptype"] == 4) {
                    $netmask = $v["mask"];
                    $ipv6 = 0;
                } else {
                    $netmask = $v["ipv6netmask"];
                    $ipv6 = 1;
                }
                $ippid = $v_ipmatches[$v["name"] . "_" . $v["gateway"] . "/" . $v["mask"]];
                if(empty($ippid)) {
                    $ippid = insert_and_id("INSERT INTO `ippool` \n\t\t\t\t\t\t\t\t\t\t\tSET ippool_name = '" . $v["name"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`gateway` = '" . $v["gateway"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`netmask` = '" . $netmask . "',\n\t\t\t\t\t\t\t\t\t\t\t`ns1` = '" . $v["nameserver1"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`ns2` = '" . $v["nameserver2"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`ipv6` = " . $ipv6);
                }
                if(empty($ippid)) {
                    $error[] = $l["err_importing_ipblock"] . " " . $v["name"] . " - " . $v["gateway"] . "/" . $netmask;
                }
                if(!empty($solusvm_ipblocknodes[$k])) {
                    foreach ($solusvm_ipblocknodes[$k] as $nk => $nv) {
                        if(!isset($virt_solus_servers[$nk])) {
                        } elseif(!empty($v_ippools[$ippid]["servers"][$virt_solus_servers[$nk]])) {
                        } else {
                            $inserted = insert_and_id("INSERT INTO `ippool_servers` \n\t\t\t\t\t\t\t\t\tSET ippid = " . $ippid . ",\n\t\t\t\t\t\t\t\t\tserid = " . $virt_solus_servers[$nk] . ",\n\t\t\t\t\t\t\t\t\tsgid = -2");
                        }
                    }
                }
                $solusvm_ips = [];
                if(empty($ipv6)) {
                    $res = makequery("SELECT * FROM `ipaddresses`\n\t\t\t\t\t\t\t\t\tWHERE blockid = " . $k, [], 0, $conn_solusvm);
                    if(!$res) {
                        $error["no_query"] = $l["no_query"];
                        return false;
                    }
                    for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                        $solusvm_ips[$row["ipaddress"]] = $row;
                    }
                } elseif(!empty($ipv6) && $v["iptype"] == 6) {
                    $res = makequery("SELECT * FROM `ipv6`\n\t\t\t\t\t\t\t\t\tWHERE blockid = " . $k, [], 0, $conn_solusvm);
                    if(!$res) {
                        $error["no_query"] = $l["no_query"];
                        return false;
                    }
                    for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                        $solusvm_ips[$row["ipaddress"]] = $row;
                    }
                } elseif(function_exists("gmp_strval")) {
                    include_once $globals["mainfiles"] . "/functions/ips.php";
                    $res = makequery("SELECT * FROM `inet6`\n\t\t\t\t\t\t\t\t\tWHERE blockid = " . $k, [], 0, $conn_solusvm);
                    if(!$res) {
                        $error["no_query"] = $l["no_query"];
                        return false;
                    }
                    for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                        $row["ipaddress"] = int64_to_inet6([(string) $row["section1"], (string) $row["section2"]]);
                        $solusvm_ips[$row["ipaddress"]] = $row;
                    }
                }
                if(0 < count($solusvm_ips)) {
                    $ptoks = vsql_in_tokens(array_keys($solusvm_ips));
                    $res = makequery("SELECT * FROM ips\n\t\t\t\t\t\t\t\t\tWHERE ippid = " . $ippid . "\n\t\t\t\t\t\t\t\t\tAND ip IN (" . $ptoks["query"] . ")\n\t\t\t\t\t\t\t\t\tORDER BY ipid", $ptoks["tokens"]);
                    unset($ptoks);
                    if(!$res) {
                        $error["no_query"] = $l["no_query"];
                        return false;
                    }
                    for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                        unset($solusvm_ips[$row["ip"]]);
                    }
                }
                if(0 < count($solusvm_ips)) {
                    foreach ($solusvm_ips as $ik => $iv) {
                        $inserted = insert_and_id("INSERT INTO `ips`\n\t\t\t\t\t\t\t\t\tSET ippid = " . $ippid . ",\n\t\t\t\t\t\t\t\t\tip = '" . $iv["ipaddress"] . "',\n\t\t\t\t\t\t\t\t\tipv6 = " . $ipv6 . ",\n\t\t\t\t\t\t \t\t\t" . (!empty($iv["section1"]) ? "ipr_netmask = '" . $iv["prefix"] . "'," : "") . "\n\t\t\t\t\t\t\t\t\t" . (!empty($iv["reserved"]) ? "locked = '1'," : "") . "\n\t\t\t\t\t\t\t\t\tmac_addr = '" . @trim($iv["mac"]) . "'");
                        if(empty($inserted)) {
                            $error[] = $l["err_importing_ip"] . " " . $v["name"] . " - " . $iv["ipaddress"];
                        }
                    }
                }
            }
            $res = makequery("SELECT * FROM `internalips`\n\t\t\t\t\t\t\t\t\tWHERE nodeid = '" . $solus_serid . "'", [], 0, $conn_solusvm);
            if(0 < vsql_num_rows($res)) {
                for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                    $solusvm_int_ips[$row["ipaddress"]] = $row;
                }
                $res = makequery("SELECT ippool_name FROM `ippool`\n\t\t\t\t\t\t\t\t\tWHERE ippool_name = 'SolusVM_internal_" . $globals["server"] . "'");
                if(0 < vsql_num_rows($res)) {
                    $error[] = $l["err_intpool_exist"] . " SolusVM_internal_" . $globals["server"];
                    return false;
                }
                $int_ippid = insert_and_id("INSERT INTO ippool \n\t\t\t\t\t\t\t\t\t\tSET ipp_serid = '0',\t\n\t\t\t\t\t\t\t\t\t\tippool_name = :ippool_name,\n\t\t\t\t\t\t\t\t\t\tgateway = :gateway,\n\t\t\t\t\t\t\t\t\t\tnetmask = :netmask,\n\t\t\t\t\t\t\t\t\t\tns1 = :ns1,\n\t\t\t\t\t\t\t\t\t\tns2 = :ns2,\n\t\t\t\t\t\t\t\t\t\tinternal = :internal,\n\t\t\t\t\t\t\t\t\t\tbridge = :bridge", [":ippool_name" => "SolusVM_internal_" . $globals["server"], ":gateway" => $solusvm_nodes[$solus_serid]["intipgateway"], ":netmask" => $solusvm_nodes[$solus_serid]["intipnetmask"], ":ns1" => "8.8.8.8", ":ns2" => "8.8.4.4", ":internal" => 1, ":bridge" => $solusvm_nodes[$solus_serid]["inipbridge"]]);
                $inserted = insert_and_id("INSERT INTO `ippool_servers` \n\t\t\t\t\t\t\t\tSET ippid = " . $int_ippid . ",\n\t\t\t\t\t\t\t\tserid = " . $virt_solus_servers[$solus_serid] . ",\n\t\t\t\t\t\t\t\tsgid = -2");
                if(0 < count($solusvm_int_ips)) {
                    foreach ($solusvm_int_ips as $ik => $iv) {
                        $inserted = insert_and_id("INSERT INTO `ips`\n\t\t\t\t\t\t\t\t\tSET ippid = " . $int_ippid . ",\n\t\t\t\t\t\t\t\t\tip = '" . $iv["ipaddress"] . "'\n\t\t\t\t\t\t\t\t\t" . (!empty($iv["reserved"]) ? ",locked = '1'," : ""));
                        if(empty($inserted)) {
                            $error[] = $l["err_importing_ip"] . " " . $v["name"] . " - " . $iv["ipaddress"];
                        }
                    }
                }
            }
            $done = 1;
        }
    }
    if($ta == "os" || $load_others) {
        global $ostemplates;
        global $oslist;
        global $os_map;
        global $solusvm_templates;
        if(!is_api_call()) {
            $theme["call_theme_func"] = "solusvm_os_import_theme";
        }
        oslist();
        $config_path = "/var/virtualizor/solus_templates.conf";
        $os_map = [];
        if(file_exists($config_path)) {
            $file = file_get_contents($config_path);
            $tmp = _unserialize($file);
            if(is_array($tmp)) {
                $os_map = $tmp;
            }
            foreach ($os_map as $k => $v) {
                foreach ($v as $kk => $vv) {
                    $os_map[$k][$kk] = -1 * $vv;
                }
            }
        }
        foreach ($ostemplates as $k => $v) {
            if(!empty($v["hvm"])) {
                $v["type"] = "xenhvm";
            }
            $os_map[$v["type"]][$v["filename"]] = -1 * $k;
        }
        $res = makequery("SELECT DISTINCT `type`, template, templatename \n\t\t\t\t\t\t\tFROM `vservers`", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            if($row["templatename"] == "-") {
            } else {
                $row["template"] = empty($row["template"]) ? $row["templatename"] : $row["template"];
                $_templates[$row["type"]][$row["template"]] = $row["templatename"];
            }
        }
        $res = makequery("SELECT * FROM `templates` WHERE (`type` = 'openvz' OR `type` = 'ez' AND filename IN ('" . implode("', '", array_keys($_templates["openvz"])) . "'))OR (`type` = 'xen' AND filename IN ('" . implode("', '", array_keys($_templates["xen"])) . "'))", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $tmp_type = $row["type"];
            if($row["type"] == "ez") {
                $tmp_type = "vzo";
                $row["type"] = "vzo";
            }
            $row["filename"] = str_replace("-ez", "", $row["filename"]);
            $row["_filename"] = $row["filename"] . ".tar.gz";
            $solusvm_templates[$tmp_type][$row["templateid"]] = $row;
            if(!empty($os_map[$tmp_type][$row["_filename"]])) {
                $os_map[$tmp_type][$row["_filename"]] = abs($os_map[$tmp_type][$row["_filename"]]);
            }
        }
        if(!empty($_templates["xenhvm"])) {
            $res = makequery("SELECT * FROM `hvmtemplates` \n\t\t\t\t\t\t\t\tWHERE filename IN ('" . implode("', '", array_keys($_templates["xenhvm"])) . "')\n\t\t\t\t\t\t\t\tOR friendlyname IN ('" . implode("', '", $_templates["xenhvm"]) . "')", [], 0, $conn_solusvm);
            if(!$res) {
                $error["no_query"] = $l["no_query"];
                return false;
            }
            for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                $row["_filename"] = $row["filename"] . ".tar.gz." . $row["templateid"] . ".solus.xenhvm";
                $row["type"] = "xenhvm";
                $solusvm_templates[$row["type"]][$row["templateid"]] = $row;
                if(!empty($os_map[$row["type"]][$row["_filename"]])) {
                    $os_map[$row["type"]][$row["_filename"]] = abs($os_map[$row["type"]][$row["_filename"]]);
                }
            }
        }
        if(!empty($_templates["kvm"])) {
            $res = makequery("SELECT * FROM `kvmtemplates` \n\t\t\t\t\t\t\t\tWHERE filename IN ('" . implode("', '", array_keys($_templates["kvm"])) . "')\n\t\t\t\t\t\t\t\tOR friendlyname IN ('" . implode("', '", $_templates["kvm"]) . "')", [], 0, $conn_solusvm);
            if(!$res) {
                $error["no_query"] = $l["no_query"];
                return false;
            }
            for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                $row["_filename"] = $row["filename"] . ".gz." . $row["templateid"] . ".solus.kvm";
                $solusvm_templates[$row["type"]][$row["templateid"]] = $row;
                if(!empty($os_map[$row["type"]][$row["_filename"]])) {
                    $os_map[$row["type"]][$row["_filename"]] = abs($os_map[$row["type"]][$row["_filename"]]);
                }
            }
        }
        foreach ($os_map as $kk => $vv) {
            foreach ($vv as $k => $v) {
                if($v < 1) {
                    unset($os_map[$kk][$k]);
                }
            }
        }
        $to_save_map = [];
        if(isset($_POST["solusvm_os"])) {
            foreach ($solusvm_templates as $type => $type_v) {
                foreach ($type_v as $k => $v) {
                    $osid = 0;
                    if($v["type"] == "kvm" || $v["type"] == "xenhvm") {
                        $osid = optPOST($v["type"] . "_" . $k);
                        if(empty($ostemplates[$osid])) {
                            $error["no_os_selected"] = $l["no_os_selected"] . " " . $v["filename"] . " (" . $v["type"] . " ID: " . $k . ")";
                            return false;
                        }
                        $to_save_map[$v["type"]][$v["_filename"]] = $osid;
                    } elseif(!empty($os_map[$v["type"]][$v["_filename"]])) {
                    } else {
                        $res = makequery("SELECT MAX(osid) AS num FROM `os`\n\t\t\t\t\t\t\t\t\t\tWHERE osid > 100000");
                        if(0 < vsql_num_rows($res)) {
                            $tmp = vsql_fetch_assoc($res);
                            $newosid = $tmp["num"] + 1;
                        }
                        if(empty($newosid) || $newosid < 100001) {
                            $newosid = 100001;
                        }
                        if($v["type"] == "xen" && !file_exists($globals["xenos"] . "/" . $v["_filename"])) {
                            vexec("ln -s /home/solusvm/xen/template/" . $v["_filename"] . " " . $globals["xenos"] . "/" . $v["_filename"]);
                        }
                        $newos["type"] = $v["type"];
                        $newos["filename"] = $v["_filename"];
                        $newos["name"] = $v["filename"];
                        $newos["size"] = (double) @vfilesize($globals[$newos["type"] . "os"] . "/" . $newos["filename"]);
                        if($v["type"] == "xen") {
                            $newos["drive"] = "xvda";
                            if(!empty($v["kernel"])) {
                                $newos["pygrub"] = 1;
                            }
                            if(!empty($v["extra"])) {
                                $newos["extra"] = $v["extra"];
                            }
                            if(empty($v["exttype"])) {
                                $newos["fstype"] = "ext4";
                            }
                        }
                        $osid = insert_and_id("INSERT INTO `os` \n\t\t\t\t\t\t\t\t\t\t\tSET osid = '" . $newosid . "',\n\t\t\t\t\t\t\t\t\t\t\tosdata = '" . serialize($newos) . "',\n\t\t\t\t\t\t\t\t\t\t\tmg = '" . (!empty($newosmgs) ? implode(",", $newosmgs) : "") . "'");
                    }
                }
            }
            $done = 1;
            if(!empty($to_save_map)) {
                writefile($config_path, serialize($to_save_map), 1);
            }
        }
    }
    if($ta == "vps") {
        global $v_vps;
        global $v_vps_matches;
        global $solusvm_vps;
        global $v_users;
        global $vps_success_imp;
        if(!is_api_call()) {
            $theme["call_theme_func"] = "solusvm_vps_import_theme";
        }
        $node_ip = empty($globals["server"]) ? $globals["primary_ip"] : $servers[$globals["server"]]["ip"];
        $solus_serid = $solusvm_nodes_ipwise[$node_ip];
        $res = makequery("SELECT v.*, c.emailaddress, d.vz_vswap FROM `vservers` v\n\t\t\t\t\t\tLEFT JOIN vzdata d ON (v.vserverid = d.vserverid)\n\t\t\t\t\t\tLEFT JOIN clients c ON (v.clientid = c.clientid)\n\t\t\t\t\t\tWHERE v.`type` = 'openvz'\n\t\t\t\t\t\tAND v.nodeid = " . $solus_serid . "\n\t\t\t\t\t\tORDER BY v.vserverid", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        $tmp_type = "openvz";
        if(in_array("vzo", $servers[$globals["server"]]["virts"])) {
            $tmp_type = "openvz7";
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $row["_type"] = $tmp_type;
            $row["_template"] = $row["type"] == "openvz" ? str_replace("-ez", "", $row["template"]) . ".tar.gz" : $row["template"];
            $v_vps_matches[$row["ctid"]] = 0;
            $solusvm_vps[$row["vserverid"]] = $row;
        }
        $res = makequery("SELECT v.*, c.emailaddress, d.* FROM `vservers` v\n\t\t\t\t\t\tLEFT JOIN kvmdata d ON (v.vserverid = d.vserverid)\n\t\t\t\t\t\tLEFT JOIN clients c ON (v.clientid = c.clientid)\n\t\t\t\t\t\tWHERE v.`type` = 'kvm'\n\t\t\t\t\t\tAND v.nodeid = " . $solus_serid . "\n\t\t\t\t\t\tORDER BY v.vserverid", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $row["_type"] = "kvm";
            $row["ctid"] = "kvm" . $row["xid"];
            $row["_template"] = $solusvm_templates["kvm"][$row["buildt"]]["_filename"];
            $v_vps_matches[$row["ctid"]] = 0;
            $solusvm_vps[$row["vserverid"]] = $row;
        }
        $res = makequery("SELECT v.*, c.emailaddress, d.* FROM `vservers` v\n\t\t\t\t\t\tLEFT JOIN xendata d ON (v.vserverid = d.vserverid)\n\t\t\t\t\t\tLEFT JOIN clients c ON (v.clientid = c.clientid)\n\t\t\t\t\t\tWHERE v.`type` LIKE '%xen%'\n\t\t\t\t\t\tAND v.nodeid = " . $solus_serid . "\n\t\t\t\t\t\tORDER BY v.vserverid", [], 0, $conn_solusvm);
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $row["_type"] = "xen";
            $row["ctid"] = "vm" . $row["xid"];
            $row["_template"] = $row["type"] == "xen" ? $row["template"] . ".tar.gz" : $solusvm_templates["xenhvm"][$row["buildt"]]["_filename"];
            $v_vps_matches[$row["ctid"]] = 0;
            $solusvm_vps[$row["vserverid"]] = $row;
        }
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t\tWHERE serid = '" . $globals["server"] . "'\n\t\t\t\t\t\tORDER BY vpsid");
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
            $v_vps[$row["vpsid"]] = $row;
            $v_vps_matches[$row["vps_name"]] = $row["vpsid"];
        }
        foreach ($v_vps_matches as $k => $v) {
            if($v < 1) {
                unset($v_vps_matches[$k]);
            }
        }
        if(isset($_POST["solusvm_vps"])) {
            $toimport = [];
            $_vps_list = $_POST["vps_list"];
            foreach ($solusvm_vps as $k => $v) {
                $vpsid = empty($v_vps_matches[$v["ctid"]]) ? 0 : $v_vps_matches[$v["ctid"]];
                if(empty($vpsid)) {
                    $toimport[$v["_type"]][$v["ctid"]] = [];
                }
            }
            if(empty($_vps_list)) {
                $vps_list = $toimport;
            } else {
                foreach ($_vps_list as $sk) {
                    $vps_list[$sk] = $solusvm_vps[$sk];
                }
            }
            foreach ($vps_list as $sk => $sv) {
                $vpsid = empty($v_vps_matches[$sv["ctid"]]) ? 0 : $v_vps_matches[$sv["ctid"]];
                if(empty($vpsid)) {
                    $toimport[$sv["_type"]][$sv["ctid"]] = [];
                }
            }
            if(count($toimport) < 1) {
                $error[] = $l["solus_no_vps_left"];
                return false;
            }
            $imported = [];
            foreach ($toimport as $k => $v) {
                if(empty($k)) {
                } else {
                    $virt_import = $k . "_import";
                    $imported[$k] = $cluster->{$virt_import}($globals["server"], array_keys($v));
                    if(empty($imported[$k])) {
                        $error[] = $l["err_" . $k . "_import"];
                        return false;
                    }
                }
            }
            $vps_success_imp = [];
            foreach ($solusvm_vps as $k => $v) {
                $vpsid = empty($v_vps_matches[$v["ctid"]]) ? 0 : $v_vps_matches[$v["ctid"]];
                if(empty($v["ctid"])) {
                    $error[] = $l["err_empty_vps_name"];
                } elseif(!empty($vpsid)) {
                } else {
                    $vps = $imported[$v["_type"]][$v["ctid"]];
                    if(in_array($v["_type"], ["xen", "kvm"]) && (empty($vps["disks"][0]["path"]) || preg_match("/_swap^/", $vps["disks"][0]["path"]) || !empty($vps["disks"][0]["path"]) && !preg_match("/_swap^/", $vps["disks"][0]["path"]) && (!$vps["disks"][0]["primary"] || $vps["disks"][0]["size"] == 0))) {
                        $error[] = lang_vars_name($l["err_empty_space"], ["vps_name" => $v["ctid"], "size" => $vps["disks"][0]["size"]]);
                    } else {
                        $vps["vpsid"] = $v["vserverid"];
                        $vps["vps_name"] = $v["ctid"];
                        $vps["virt"] = $v["_type"];
                        $vps["serid"] = $globals["server"];
                        $vps["uid"] = array_search($v["emailaddress"], $v_users);
                        $tmp_type = $v["type"];
                        if($v["_type"] == "openvz7") {
                            $tmp_type = "vzo";
                        }
                        $vps["osid"] = (int) $os_map[$tmp_type][$v["_template"]];
                        $net_speed = $v["networkspeed"];
                        if($v["networkspeed"] == "2250" || $v["networkspeed"] == "5500") {
                            $net_speed = substr($v["networkspeed"], 1);
                        }
                        $nw_speed_kb = $net_speed * 1024 / 8;
                        if($v["networkspeed"] == "250" || $v["networkspeed"] == "500") {
                            $nw_speed_kb = $net_speed;
                        }
                        $vps["network_speed"] = $nw_speed_kb;
                        $vps["bandwidth"] = $v["bandwidth"] / 1024 / 1024 / 1024;
                        $vps["band_suspend"] = $v["bwsuspend"];
                        $vps["suspended"] = $v["disabled"];
                        $vps["mac"] = $v["mac"];
                        $vps["time"] = time();
                        $vps["primaryip"] = $v["mainipaddress"];
                        if($v["type"] == "kvm") {
                            $imported_from = ["imported_from" => "solusvm", "viif_name" => str_replace(["vif", "vifvm"], ["kvm", "kvm"], $v["vif0"])];
                            $vps["ubc"] = serialize($imported_from);
                        }
                        if($v["type"] == "openvz") {
                            $vps["ram"] = $v["ram"] / 1024 / 1024;
                            $vps["burst"] = empty($v["vz_vswap"]) ? $v["burst"] / 1024 / 1024 : $v["vz_vswap"];
                        } else {
                            if(empty($vps["swap"])) {
                                $vps["swap"] = $v["_type"] == "kvm" ? $v["kvmswap"] : $v["burst"] / 1024 / 1024;
                            }
                            $vps["acpi"] = $v["acpi"];
                            $vps["apic"] = $v["apic"];
                            $vps["pae"] = $v["pae"];
                            $vps["shadow"] = $v["shadow"];
                            $vps["hostname"] = $v["hostname"];
                            if($v["type"] == "kvm") {
                                $confpath = "/etc/libvirt/qemu/" . $vps["vps_name"] . ".xml";
                                if(file_exists($confpath)) {
                                    $data = file_get_contents($confpath);
                                    $tmpxml = xmlstring2array($data);
                                    if(is_array($tmpxml) && !empty($tmpxml["devices"]["disk"])) {
                                        foreach ($tmpxml["devices"]["disk"] as $tmp_d => $tmp_dval) {
                                            if($tmp_dval["target"]["@attributes"]["bus"] == "virtio") {
                                                $vps["virtio"] = 1;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if($v["type"] == "xenhvm") {
                            $vps["hvm"] = 1;
                            $vps["pv_on_hvm"] = $v["pvhvmd"];
                        }
                        $vps["ips"] = [];
                        $solusvm_ips = [];
                        $res = makequery("SELECT * FROM `ipaddresses`\n\t\t\t\t\t\t\t\t\tWHERE vserverid = " . $k, [], 0, $conn_solusvm);
                        if(!$res) {
                            $error[] = $vps["vps_name"] . ": " . $l["no_query"];
                        } else {
                            for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                                $solusvm_ips[$row["ipaddress"]] = $row;
                            }
                            $res = makequery("SELECT * FROM `internalips`\n\t\t\t\t\t\t\t\t\tWHERE vserverid = " . $k, [], 0, $conn_solusvm);
                            if(!$res) {
                                $error[] = $vps["vps_name"] . ": " . $l["no_query"];
                            } else {
                                for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                                    $solusvm_ips[$row["ipaddress"]] = $row;
                                }
                                $res = makequery("SELECT * FROM `ipv6`\n\t\t\t\t\t\t\t\tWHERE vserverid = " . $k, [], 0, $conn_solusvm);
                                if(!$res) {
                                    $error[] = $vps["vps_name"] . ": " . $l["no_query"];
                                } else {
                                    for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                                        $solusvm_ips[$row["ipaddress"]] = $row;
                                    }
                                    if(function_exists("gmp_strval")) {
                                        include_once $globals["mainfiles"] . "/functions/ips.php";
                                        $res = makequery("SELECT * FROM `inet6`\n\t\t\t\t\t\t\t\t\tWHERE vserverid = " . $k, [], 0, $conn_solusvm);
                                        if(!$res) {
                                            $error[] = $vps["vps_name"] . ": " . $l["no_query"];
                                        } else {
                                            for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                                                $row["ipaddress"] = int64_to_inet6([(string) $row["section1"], (string) $row["section2"]]);
                                                $solusvm_ips[$row["ipaddress"]] = $row;
                                            }
                                        }
                                    }
                                    if(0 < count($solusvm_ips)) {
                                        foreach ($solusvm_ips as $ik => $iv) {
                                            $vps["ips"][] = $ik;
                                        }
                                    }
                                    $res = makequery("SELECT * FROM ips \n\t\t\t\t\t\tWHERE ip IN ('" . implode("', '", $vps["ips"]) . "')\n\t\t\t\t\t\tAND vpsid = 0\n\t\t\t\t\t\tORDER BY ipid");
                                    if(!$res) {
                                        $error[] = $vps["vps_name"] . ": " . $l["no_query"];
                                    } else {
                                        if(vsql_num_rows($res) != count($vps["ips"])) {
                                            for ($i = 0; $row = vsql_fetch_assoc($res); $i++) {
                                                $tmp_ips[$row["ip"]] = $row;
                                            }
                                            $ip_not_free[$v["ctid"]] = [];
                                            foreach ($solusvm_ips as $ik => $iv) {
                                                if(empty($tmp_ips[$ik])) {
                                                    $ip_not_free[$v["ctid"]][] = $ik;
                                                }
                                            }
                                            if(!empty($ip_not_free[$v["ctid"]])) {
                                                $error[] = $l["solus_ip_not_free"] . " " . implode(", ", $ip_not_free[$v["ctid"]]) . " - CTID : " . $v["ctid"];
                                                unset($ip_not_free[$v["ctid"]]);
                                            }
                                        }
                                        $_err = import_vps_data($vps, $vpsid);
                                        if(in_array("vzo", $servers[$globals["server"]]["virts"])) {
                                            $re_virt = makequery("UPDATE vps SET virt = 'vzo' WHERE vps_name = '" . $vps["vps_name"] . "' AND serid = '" . $globals["server"] . "'");
                                        }
                                        $cluster->bandwidth_reset($vps["vpsid"]);
                                        if(!empty($_err)) {
                                            $error[] = $_err;
                                        } else {
                                            logs_admin("import", $k, 1, $vpsid, $user["uid"]);
                                            $vps_success_imp[] = $vps["vps_name"];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if(!empty($globals["server"])) {
                $cluster->sync($globals["server"]);
            }
            if(!empty($error)) {
                return false;
            }
            $done = 1;
        }
    }
}
function API_solusvm_import()
{
    global $solusvm_vps;
    global $error;
    global $done;
    global $solusvm_nodes;
    global $solusvm_nodegroups;
    global $solusvm_plans;
    global $solusvm_users;
    global $solusvm_ipblocks;
    global $solusvm_ipblocknodes;
    global $solusvm_templates;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($solusvm_nodes)) {
        $GLOBALS["_api"]["solusvm_nodes"] = $solusvm_nodes;
    }
    if(!empty($solusvm_nodegroups)) {
        $GLOBALS["_api"]["solusvm_nodegroups"] = $solusvm_nodegroups;
    }
    if(!empty($solusvm_plans)) {
        $GLOBALS["_api"]["solusvm_plans"] = $solusvm_plans;
    }
    if(!empty($solusvm_users)) {
        $GLOBALS["_api"]["solusvm_users"] = $solusvm_users;
    }
    if(!empty($solusvm_ipblocks)) {
        $GLOBALS["_api"]["solusvm_ipblocks"] = $solusvm_ipblocks;
    }
    if(!empty($solusvm_ipblocknodes)) {
        $GLOBALS["_api"]["solusvm_ipblocknodes"] = $solusvm_ipblocknodes;
    }
    if(!empty($solusvm_templates)) {
        $GLOBALS["_api"]["solusvm_templates"] = $solusvm_templates;
    }
    if(!empty($solusvm_vps)) {
        $GLOBALS["_api"]["solusvm_vps"] = $solusvm_vps;
    }
}
function proxmox_import()
{
    global $theme;
    global $globals;
    global $cluster;
    global $users;
    global $l;
    global $ostemplates;
    global $user;
    global $servers;
    global $error;
    global $done;
    global $orphan;
    global $proxmox_nodes;
    global $virt_proxmox_servers;
    global $proxmox_users;
    global $v_users;
    global $inserted;
    global $info;
    global $pve2;
    global $storages;
    global $proxmox_storages;
    global $v_storages;
    global $proxmox_nodes_ipwise;
    $theme["call_theme_func"] = "proxmox_import_theme";
    if(!is_allowed("importvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    if(!preg_match("/prox/is", $servers[$globals["server"]]["virt"])) {
        $error[] = $l["select_prox_server"];
        return false;
    }
    $proxmox_nodes = $cluster->get_prox_node_data($globals["server"]);
    foreach ($servers as $k => $v) {
        if($k == 0) {
            $v["node"] = $globals["proxmox_server_name"];
        } else {
            $v["node"] = $cluster->get_prox_node_name($k);
        }
        if(empty($proxmox_nodes[1][$v["node"]])) {
        } else {
            $virt_proxmox_servers[$proxmox_nodes[1][$v["node"]]] = $k;
        }
    }
    $ta = optGET("ta");
    $load_others = 0;
    if($ta == "vps") {
        $load_others = 1;
    }
    if($ta == "nodes" && !is_api_call()) {
        $theme["call_theme_func"] = "proxmox_nodes_import_theme";
    }
    if($ta == "users" || $load_others) {
        global $proxmox_users;
        if(!is_api_call()) {
            $theme["call_theme_func"] = "proxmox_users_import_theme";
        }
        $proxmox_users = $cluster->get_prox_user_data($globals["server"]);
        foreach ($users as $k => $v) {
            $v_users[$k] = $v["email"];
        }
        if(isset($_POST["proxmox_users"])) {
            $info = [];
            foreach ($proxmox_users as $k => $v) {
                if(empty($v["email"])) {
                } elseif(in_array($v["email"], $v_users)) {
                } else {
                    $type = 0;
                    $virts = [];
                    foreach ($globals["virts"] as $vk => $vv) {
                        if(!empty($v["rs" . $vk])) {
                            $virts[] = $vv;
                        }
                    }
                    $prefs["fname"] = $v["firstname"];
                    $prefs["lname"] = $v["lastname"];
                    $preferences = serialize($prefs);
                    $inserted = insert_and_id("INSERT INTO `users` \n\t\t\t\t\t\t\t\t\t\tSET email = '" . $v["email"] . "',\n\t\t\t\t\t\t\t\t\t\t`password` = '" . $v["password"] . "',\n\t\t\t\t\t\t\t\t\t\t`type` = " . $type . ",\n\t\t\t\t\t\t\t\t\t\t`allowed_virts` = '" . implode(" ", $virts) . "',\n\t\t\t\t\t\t\t\t\t\t`preferences` = '" . $preferences . "'");
                    if(empty($inserted)) {
                        $error[] = $l["err_importing_user"] . " " . $v["email"];
                    }
                }
            }
            $done = 1;
        }
    }
    if($ta == "storages") {
        global $proxmox_storages;
        $all_storages = [];
        $res = makequery("SELECT * FROM `storage`");
        $res_num = vsql_num_rows($res);
        for ($i = 1; $i <= $res_num; $i++) {
            $row = vsql_fetch_assoc($res);
            $all_storages[$row["stid"]] = $row;
        }
        unset($res);
        unset($res_num);
        unset($row);
        unset($i);
        if(!is_api_call()) {
            $theme["call_theme_func"] = "proxmox_storages_import_theme";
        }
        $proxmox_storages = $cluster->get_prox_storage_data($globals["server"]);
        foreach ($storages as $k => $v) {
            $v_storages[$k] = $v["name"];
        }
        if(isset($_POST["proxmox_storages"])) {
            $info = [];
            $ser_hostname = $cluster->hostname($globals["server"]);
            $ser_hostname = strtolower($ser_hostname);
            foreach ($proxmox_storages as $k => $v) {
                if(empty($v["storage"])) {
                } elseif(in_array($v["storage"], $v_storages)) {
                } else {
                    $st_uuid = generateRandStr(16);
                    if($v["type"] == "lvm") {
                        $v["path"] = "/dev/" . $v["vgname"];
                        $storage_type = "block";
                    } elseif($v["type"] == "zfspool" && !empty($v["pool"])) {
                        $v["path"] = "/dev/zvol/" . $v["pool"];
                        $storage_type = "zfs" . (!empty($v["sparse"]) ? " thin " : " ") . "block";
                    } elseif($v["type"] == "lvmthin" && !empty($v["thinpool"])) {
                        $v["path"] = "/dev/" . $v["vgname"] . "/" . $v["thinpool"];
                        $storage_type = "thin block";
                    } elseif($v["type"] == "rbd" && !empty($v["pool"])) {
                        $v["path"] = "/dev/rbd/" . trim($v["pool"]);
                        $storage_type = "ceph block";
                    } else {
                        $storage_type = "file";
                    }
                    $stor_nodes = [];
                    $stor_exists = false;
                    $inserted = 0;
                    if(isset($v["shared"]) && !empty($v["shared"])) {
                        $v["nodes"] = strtolower($v["nodes"]);
                        $stor_nodes = preg_split("/\\s*,\\s*/", $v["nodes"]);
                        if(in_array($ser_hostname, $stor_nodes)) {
                            foreach ($all_storages as $sk => $sv) {
                                if($sv["type"] == $storage_type && $sv["name"] == $v["storage"] && $sv["path"] == $v["path"]) {
                                    $stor_exists = true;
                                    $inserted = $sv["stid"];
                                }
                            }
                        }
                    }
                    if(!$stor_exists) {
                        $inserted = insert_and_id("INSERT INTO `storage` \n\t\t\t\t\t\t\t\t\t\t\tSET st_uuid = '" . $st_uuid . "',\n\t\t\t\t\t\t\t\t\t\t\t`name` = '" . $v["storage"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`path` = '" . $v["path"] . "',\n\t\t\t\t\t\t\t\t\t\t\t`type` = '" . $storage_type . "',\n\t\t\t\t\t\t\t\t\t\t\t`format` = 'raw'");
                        if(empty($inserted)) {
                            $error[] = $l["err_importing_storage"] . " " . $v["storage"];
                        }
                    }
                    if(!empty($inserted)) {
                        $qres = insert_and_id("INSERT INTO storage_servers\n\t\t\t\t\t\t\t\t\t\t\tSET stid = :stid,\n\t\t\t\t\t\t\t\t\t\t\tserid = :serid,\n\t\t\t\t\t\t\t\t\t\t\tsgid = :sgid", [":stid" => $inserted, ":serid" => $globals["server"], ":sgid" => "-2"]);
                    }
                }
            }
            $done = 1;
        }
    }
    if($ta == "vps") {
        global $v_vps;
        global $v_vps_matches;
        global $proxmox_vps;
        global $v_users;
        global $kernel;
        global $importVm;
        if(!is_api_call()) {
            $theme["call_theme_func"] = "proxmox_vps_import_theme";
        }
        $proxmox_serid = $proxmox_nodes[1][$globals["proxmox_server_name"]];
        $proxmox_vps = $cluster->get_prox_vps_data($globals["server"]);
        $res = makequery("SELECT * FROM vps \n\t\t\t\t\t\tWHERE serid = '" . $globals["server"] . "'\n\t\t\t\t\t\tORDER BY vpsid");
        if(!$res) {
            $error["no_query"] = $l["no_query"];
            return false;
        }
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $v_vps[$row["vpsid"]] = $row;
            $v_vps_matches[$row["vps_name"]] = $row["vpsid"];
        }
        foreach ($v_vps_matches as $k => $v) {
            if($v < 1) {
                unset($v_vps_matches[$k]);
            }
        }
        foreach ($proxmox_vps as $k => $v) {
            $vpsid = empty($v_vps_matches[$v["vmid"]]) ? 0 : $v_vps_matches[$v["vmid"]];
            if(empty($vpsid)) {
                $importVm[$v["vmid"]] = $v;
            }
        }
        if(isset($_POST["proxmox_vps"])) {
            $toimport = [];
            $_vps_list = $_POST["vps_list"];
            if(empty($_vps_list)) {
                $vps_list = $importVm;
            } else {
                foreach ($_vps_list as $sk) {
                    $vps_list[$sk] = $proxmox_vps[$sk];
                }
            }
            foreach ($vps_list as $v) {
                $vpsid = empty($v_vps_matches[$v["vmid"]]) ? 0 : $v_vps_matches[$v["vmid"]];
                if(empty($vpsid)) {
                    $toimport[$v["type"]][$v["vmid"]] = [];
                }
            }
            if(count($toimport) < 1) {
                $error[] = $l["solus_no_vps_left"];
                return false;
            }
            $imported = [];
            foreach ($toimport as $k => $v) {
                $virt_import = $k . "_import";
                $imported[$k] = $cluster->{$virt_import}($globals["server"], array_keys($v));
                if(empty($imported[$k])) {
                    $error[] = $l["err_" . $k . "_import"];
                    return false;
                }
            }
            foreach ($vps_list as $v) {
                $vpsid = empty($v_vps_matches[$v["vmid"]]) ? 0 : $v_vps_matches[$v["vmid"]];
                if(!empty($vpsid)) {
                } else {
                    $vps = $imported[$v["type"]][$v["vmid"]];
                    if(empty($vps["space"])) {
                        $error[] = $l["err_detect_vs_space"] . " " . $v["vmid"];
                    } else {
                        $vps["vpsid"] = $v["id"];
                        $vps["vps_name"] = $v["vmid"];
                        $vps["virt"] = $v["type"] == "openvz" ? "proxo" : $v["type"];
                        $vps["serid"] = $globals["server"];
                        $user_id = optPOST("vsuser_" . $v["vmid"]);
                        $vps["time"] = time();
                        if(empty($users[$user_id])) {
                            $user_id = 0;
                        }
                        $vps["uid"] = $user_id;
                        $vps["osid"] = (int) $os_map[$v["type"]][$v["path"]];
                        $vps["bandwidth"] = $v["bandwidthlimit"];
                        $vps["suspended"] = $v["suspended"];
                        if($v["type"] == "openvz") {
                            $vps["burst"] = $v["swap"];
                        }
                        $_err = import_vps_data($vps, $vpsid);
                        if(!empty($_err)) {
                            $error[] = $_err;
                        } else {
                            logs_admin("import", $k, 1, $vpsid, $user["uid"]);
                        }
                    }
                }
            }
            if(!empty($error)) {
                return false;
            }
            if(!empty($globals["server"])) {
                $cluster->sync($globals["server"]);
            }
            $done = 1;
        }
    }
}
function API_proxmox_import()
{
    global $error;
    global $done;
    global $proxmox_nodes;
    global $proxmox_users;
    global $proxmox_storages;
    global $proxmox_vps;
    global $vps_list;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($proxmox_nodes)) {
        $GLOBALS["_api"]["proxmox_nodes"] = $proxmox_nodes;
    }
    if(!empty($proxmox_users)) {
        $GLOBALS["_api"]["proxmox_users"] = $proxmox_users;
    }
    if(!empty($proxmox_storages)) {
        $GLOBALS["_api"]["proxmox_storages"] = $proxmox_storages;
    }
    if(!empty($proxmox_vps)) {
        $GLOBALS["_api"]["proxmox_vps"] = $proxmox_vps;
    }
    if(!empty($vps_list)) {
        $GLOBALS["_api"]["vps_list"] = $vps_list;
    }
}
function openvz7_import()
{
    global $theme;
    global $globals;
    global $cluster;
    global $users;
    global $l;
    global $ostemplates;
    global $user;
    global $error;
    global $done;
    global $orphan;
    $theme["call_theme_func"] = "openvz_import_theme";
    if(!is_allowed("importvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $orphan = $cluster->openvz7_orphan($globals["server"]);
    if(optPOST("importvps")) {
        $toimport = [];
        $vps_list = $_POST["vps_list"];
        if(empty($vps_list)) {
            $vps_list = array_keys($orphan);
        }
        foreach ($vps_list as $v) {
            $toimport[$v]["vps_name"] = $v;
            $toimport[$v]["bandwidth"] = optPOST("vsbw_" . $v);
            $toimport[$v]["uid"] = optPOST("vsuser_" . $v);
            if(empty($users[$toimport[$v]["uid"]])) {
                $toimport[$v]["uid"] = 0;
            }
        }
        $imported = $cluster->openvz7_import($globals["server"], array_keys($toimport));
        if(empty($imported)) {
            $error[] = $l["err_openvz_import"];
            return false;
        }
        foreach ($imported as $k => $v) {
            $vpsid = 0;
            if(!empty($v["ips"][0])) {
                $qres = makequery("SELECT *\tFROM ips \n\t\t\t\t\t\t\tWHERE ip IN('" . implode("','", $v["ips"]) . "')");
                $usedips = [];
                $unusedip = [];
                for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                    $row = vsql_fetch_assoc($qres);
                    if(empty($row["vpsid"])) {
                        $unusedip[] = $row["ip"];
                    } else {
                        $usedips[] = $row["ip"];
                    }
                }
                if(!empty($usedips)) {
                    $error[] = "<b>" . $k . "</b> - " . $l["err_openvz_usedip"] . " " . implode(", ", $usedips);
                }
            }
            $v["bandwidth"] = $toimport[$k]["bandwidth"];
            $v["uid"] = $toimport[$k]["uid"];
            $v["vps_name"] = $k;
            $v["time"] = time();
            $_err = import_vps_data($v, $vpsid);
            if(!empty($_err)) {
                $error[] = $_err;
            } else {
                logs_admin("import", $k, 1, $vpsid, $user["uid"]);
            }
        }
        $sres = $cluster->sync($globals["server"]);
        if(empty($error)) {
            $done = 1;
        }
    }
}
function API_openvz7_import()
{
    global $error;
    global $done;
    global $orphan;
    global $users;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($orphan)) {
        $GLOBALS["_api"]["orphan"] = $orphan;
    }
    if(!empty($users)) {
        $GLOBALS["_api"]["users"] = $users;
    }
}
function import_vps_data($v, &$vpsid)
{
    global $globals;
    global $l;
    global $error;
    global $stid;
    global $storages;
    $v["serid"] = isset($v["serid"]) ? $v["serid"] : $globals["server"];
    if(!empty($v["ips"][0])) {
        $qres = makequery("SELECT * FROM ips \n\t\t\t\t\tWHERE ip IN('" . implode("','", $v["ips"]) . "')");
        $usedips = [];
        $unusedip = [];
        for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
            $row = vsql_fetch_assoc($qres);
            if(empty($row["vpsid"])) {
                $unusedip[] = $row["ip"];
            } else {
                $usedips[] = $row["ip"];
            }
        }
        if(!empty($usedips)) {
            return "<b>" . $v["vps_name"] . "</b> - " . $l["err_openvz_usedip"] . " " . implode(", ", $usedips);
        }
    }
    if(is_array($v["disks"])) {
        $stid = storage_get_primary($v["virt"]);
        if(empty($stid) || empty($storages[$stid]["st_uuid"])) {
            return $l["err_no_storage"];
        }
        foreach ($v["disks"] as $dk => $dv) {
            if(empty($v["disks"][$dk]["st_uuid"])) {
                $v["disks"][$dk]["st_uuid"] = $storages[$stid]["st_uuid"];
            }
        }
        $disks = $v["disks"];
        unset($v["disks"]);
    }
    if(empty($v["uuid"])) {
        $v["uuid"] = generateRandStr(16);
    }
    $query = [];
    $token_vals = [];
    foreach ($v as $kk => $vv) {
        if($kk == "ips" || $kk == "primaryip") {
        } else {
            $query[$kk] = "`" . $kk . "` = :" . $kk;
            $token_vals[":" . $kk] = $vv;
        }
    }
    $vpsid = insert_and_id("INSERT INTO vps\n\t\t\t\tSET " . implode(",", $query), $token_vals);
    if(!empty($disks)) {
        foreach ($disks as $dk => $dv) {
            $dv["num"] = $dk;
            vpsdisk_add($v["uuid"], $dv);
        }
    }
    if(!empty($v["ips"][0])) {
        $p_counter = 1;
        foreach ($v["ips"] as $ik => $iv) {
            if(in_array($iv, $unusedip)) {
                $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\t\tSET vpsid = :vpsid,\n\t\t\t\t\t\t\t\t\t`primary` = :primary,\n\t\t\t\t\t\t\t\t\tipv6 = :ipv6\n\t\t\t\t\t\t\t\t\tWHERE ip = :ip", [":vpsid" => $vpsid, ":primary" => -1 * $p_counter, ":ipv6" => !valid_ipv6($iv) ? 0 : 1, ":ip" => $iv]);
            } else {
                $res = insert_and_id("INSERT INTO ips SET\n\t\t\t\t\t\t\t\t\tip = :ip,\n\t\t\t\t\t\t\t\t\tvpsid = :vpsid,\n\t\t\t\t\t\t\t\t\t`primary` = :primary,\n\t\t\t\t\t\t\t\t\tip_serid = :ip_serid,\n\t\t\t\t\t\t\t\t\tipv6 = :ipv6", [":ip" => $iv, ":vpsid" => $vpsid, ":primary" => -1 * $p_counter, ":ip_serid" => $v["serid"], ":ipv6" => !valid_ipv6($iv) ? 0 : 1]);
            }
            $p_counter++;
        }
        $res = update_query("UPDATE ips\n\t\t\t\t\t\t\tSET `primary` = 1\n\t\t\t\t\t\t\tWHERE ip = '" . (!empty($v["primaryip"]) ? $v["primaryip"] : $v["ips"][0]) . "'");
    }
    return "";
}
function API_import()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $oslist;
    global $done;
    global $vpsid;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    $GLOBALS["_api"]["oslist"] = $oslist;
    $GLOBALS["_api"]["vpsid"] = $vpsid;
}

?>