<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function editserver()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $cluster;
    global $error;
    global $servers;
    global $saved;
    global $serid;
    global $serv;
    global $servergroups;
    if(!load_lang("admin/editserver")) {
        return false;
    }
    $theme["init_theme"] = "admin/editserver";
    $theme["init_theme_name"] = "Add Server";
    $theme["init_theme_func"] = ["editserver_theme"];
    $theme["call_theme_func"] = "editserver_theme";
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant_head"]);
        return false;
    }
    if(!is_allowed("editserver")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $serid = (int) optGET("serid");
    if(empty($servers[$serid])) {
        redirect("");
    }
    $serv = $servers[$serid];
    $servergroups = server_groups();
    if(isset($_REQUEST["editserver"])) {
        $locked = checkbox("locked");
        $internal_ip = optPOST("internal_ip");
        if(!empty($internal_ip) && !valid_ip($internal_ip)) {
            $error["internal_ip"] = $l["wrong_internal_ip"];
            return false;
        }
        if(empty($serid)) {
            $updated = update_query("UPDATE `servers` SET\n\t\t\t\t\t\t\t\tlocked = :locked,\n\t\t\t\t\t\t\t\tinternal_ip = :internal_ip\n\t\t\t\t\t\t\t\tWHERE serid = :serid", [":locked" => $locked, ":internal_ip" => $internal_ip, ":serid" => $serid]);
            logs_admin("editserver", $server_name, 1, $serid, $user["uid"]);
            $saved = true;
            return false;
        }
        $server_name = POST("server_name", $l["no_name"]);
        $ip = POST("ip", $l["no_ip"]);
        $pass = optPOST("pass");
        $sgid = POST("sgid", $l["no_sgid"]);
        if(!valid_ip($ip)) {
            $error["ip"] = $l["wrong_ip"];
        }
        if(!empty($error)) {
            return false;
        }
        $pass = empty($pass) ? $GLOBALS["servers_keypass"][$serid]["pass"] : $pass;
        $details = $cluster->serverdetails($ip, $pass);
        if(empty($details)) {
            $error[] = $l["details_err"];
            return false;
        }
        if($details["globals"]["kernel"] != $serv["virt"]) {
            $error[] = $l["virt_changed"];
            return false;
        }
        if($details["globals"]["masterkey"] != $globals["key"]) {
            $error[] = $l["is_slave"];
            return false;
        }
        $updated = update_query("UPDATE `servers`\n\t\t\t\tSET sgid = :sgid,\n\t\t\t\tserver_name = :server_name,\n\t\t\t\tip = :ip,\n\t\t\t\tinternal_ip = :internal_ip,\n\t\t\t\t`key` = :key,\n\t\t\t\tpass = :pass,\n\t\t\t\tlocked = :locked,\n\t\t\t\thvm = :hvm\n\t\t\t\tWHERE serid = :serid", [":sgid" => $sgid, ":server_name" => $server_name, ":ip" => $ip, ":internal_ip" => $internal_ip, ":key" => $details["globals"]["key"], ":pass" => $pass, ":locked" => $locked, ":hvm" => empty($details["servers"][0]["hvm"]) ? 0 : $details["servers"][0]["hvm"], ":serid" => $serid]);
        list_servers();
        if(!empty($servergroups[$sgid]["sg_ha"])) {
            $publickey = $servergroups[$sgid]["sg_public_key"];
            $privatekey = $servergroups[$sgid]["sg_private_key"];
            if(!$cluster->install_public_key($serid, $publickey)) {
                $error[] = $l["err_public_key"];
                return false;
            }
            if(!$cluster->install_private_key($serid, $privatekey)) {
                $error[] = $l["err_private_key"];
                return false;
            }
            $data = [];
            $data["sg_password"] = $servergroups[$sgid]["sg_password"];
            $data["sg_name"] = $servergroups[$sgid]["sg_name"];
            $data["sg_salt"] = $servergroups[$sgid]["sg_salt"];
            $data["server_ip"] = $ip;
            $data["serid"] = $serid;
            $data["add_node"] = 0;
            $count = 0;
            foreach ($servers as $k => $v) {
                if($v["sgid"] == $sgid) {
                    $count++;
                }
            }
            if(1 < $count) {
                $data["add_node"] = $serid;
                foreach ($servers as $k => $v) {
                    if($v["sgid"] == $sgid && !empty($v["ha_master"])) {
                        $data["ha_master"] = $v["serid"];
                    }
                }
            } else {
                makequery("UPDATE `servers` SET\n\t\t\t\t\tha_master = :ha_master\n\t\t\t\t\tWHERE serid = :serid", [":serid" => $serid, ":ha_master" => $sgid]);
            }
            $slaveactid = $cluster->installha($serid, $data);
            for ($i = 0; $i <= 3; $i++) {
                $cluster->reverse_sync($serid);
                $res = makequery("SELECT * FROM tasks WHERE\n\t\t\t\t\t\t\t\t\tserid = :serid\n\t\t\t\t\t\t\t\t\t" . ($serid == 0 ? "AND actid = :slaveactid" : "AND slaveactid = :slaveactid") . " ORDER BY time DESC", [":serid" => $serid, ":slaveactid" => $slaveactid]);
                $row = vsql_fetch_assoc($res);
                $actid = $row["actid"];
                if(!empty($actid)) {
                    break;
                }
                sleep(1);
            }
            vexec($globals["com"]["php"] . " " . $globals["scriptfiles"] . "/installha_master.php " . $actid . " > " . logdir() . "installha_master.log 2>&1 &");
            logs_admin("installha", $server_name, 1, 0, $user["uid"]);
        }
        $cluster->resources($serid);
        logs_admin("editserver", $server_name, 1, $serid, $user["uid"]);
        $saved = true;
    }
}
function API_editserver()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $ipblocks;
    global $cluster;
    global $error;
    global $saved;
    global $serid;
    global $serv;
    global $servergroups;
    if(!empty($saved)) {
        $GLOBALS["_api"]["saved"] = $saved;
    }
    $GLOBALS["_api"]["ipblocks"] = $ipblocks;
    $GLOBALS["_api"]["serid"] = $serid;
    $GLOBALS["_api"]["serv"] = $serv;
    $GLOBALS["_api"]["servergroups"] = $servergroups;
}

?>