<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function editippool()
{
    global $theme;
    global $globals;
    global $cluster;
    global $user;
    global $l;
    global $ippid;
    global $servers;
    global $error;
    global $ippool;
    global $done;
    global $ippool_servers;
    global $servergroups;
    global $users;
    global $pdns_servers;
    if(!load_lang("admin/editippool")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant_head"]);
        return false;
    }
    $theme["init_theme"] = "admin/editippool";
    $theme["init_theme_name"] = "editippool";
    $theme["init_theme_func"] = ["editippool_theme"];
    $theme["call_theme_func"] = "editippool_theme";
    if(!is_allowed("editippool")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $servergroups = server_groups();
    $pdns_servers = get_pdns_servers();
    $ippid = (int) optGET("ippid");
    if(empty($ippid)) {
        redirect("act=ippool");
    }
    $res = makequery("SELECT i.*, i.ipp_serid AS serid FROM ippool i\n\t\t\t\t\t WHERE i.ippid = :ippid", [":ippid" => $ippid]);
    if(vsql_num_rows($res) < 1) {
        redirect("act=ippool");
    }
    $ippool = vsql_fetch_assoc($res);
    $iptype = !empty($ippool["ipv6"]) ? 6 : 4;
    $params["query"] = "SELECT uid, email FROM users WHERE pid < 1";
    $params["id"] = "uid";
    $users = select_query($params);
    $resid = makequery("SELECT * FROM ippool_servers\n\t\t\t\t\t\tWHERE ippid = :ippid", [":ippid" => $ippool["ippid"]]);
    if(1 <= vsql_num_rows($resid)) {
        for ($i = 0; $i < vsql_num_rows($resid); $i++) {
            $prow = vsql_fetch_assoc($resid);
            $ippool_servers[$prow["ippid"] . "|" . $prow["serid"] . "|" . $prow["sgid"]] = $prow;
        }
    }
    if(isset($_POST["editippool"])) {
        $ippool_name = POST("ippool_name", $l["no_name"]);
        $gateway = POST("gateway", $l["no_gateway"]);
        $netmask = POST("netmask", $l["no_netmask"]);
        $ns1 = POST("ns1", $l["no_ns1"]);
        $ns2 = POST("ns2", $l["no_ns2"]);
        $routing = (int) checkbox("routing");
        $serid = $_POST["serid"];
        $mtu = (int) optPOST("mtu");
        $vlan_tag = (int) optPOST("vlan_tag");
        if(!empty($vlan_tag) && ($vlan_tag < 0 || 4094 < $vlan_tag)) {
            $error[] = $l["vlan_tag_err"];
        }
        $uid = (int) optPOST("uid");
        if(0 < $uid && !empty($internal)) {
            $error[] = $l["no_int_pool"];
        }
        $pdns_id = (int) optPOST("pdns_id");
        if($pdns_id < 0) {
            $error[] = $l["invalid_pdns"];
        }
        if(!is_array($serid)) {
            $serid[] = (int) $serid;
        }
        foreach ($serid as $key => $ser) {
            if(0 < substr_count($ser, "_")) {
                $tmp = explode("_", $ser);
                if(empty($servergroups[$tmp[0]])) {
                    $error[] = $l["inv_group"];
                }
            } elseif($ser != -1 && empty($servers[$ser])) {
                $error[] = $l["inv_server"];
            }
        }
        if(!empty($ippool["nat"])) {
            foreach ($serid as $k => $v) {
                $__serid = -2;
                $__sgid = -2;
                if(0 < substr_count($v, "_")) {
                    $tmp = explode("_", $v);
                    $__sgid = $tmp[0];
                } else {
                    $__serid = $v;
                }
                if(empty($ippool_servers[$ippid . "|" . $__serid . "|" . $__sgid])) {
                    $error[] = $l["nat_not_allowed"];
                }
            }
            if(count($ippool_servers) != count($serid)) {
                $error[] = $l["nat_not_allowed"];
            }
        }
        if(!empty($error)) {
            return false;
        }
        if(!valid_ip($gateway) && $iptype == 4) {
            $error[] = $l["inv_gateway"];
        }
        if(!valid_ip($netmask) && $iptype == 4) {
            $error[] = $l["inv_netmask"];
        } elseif((127 < $netmask || $netmask < 1) && $iptype == 6) {
            $error[] = $l["inv_netmask_6"];
        }
        if(!valid_ip($ns1) && $iptype == 4) {
            $error[] = $l["inv_ns1"];
        }
        if(!valid_ip($ns2) && $iptype == 4) {
            $error[] = $l["inv_ns2"];
        }
        if(!empty($error)) {
            return false;
        }
        if(!empty($ippool["nat"]) && ($gateway != $ippool["gateway"] || $netmask != $ippool["netmask"])) {
            $ippool["nat"] = explode("-", $ippool["nat"]);
            $cluster->destroynat($ippool["serid"], $ippool["nat_name"]);
            if(!$cluster->createnat($ippool["serid"], ["ippid" => $ippid, "gateway" => $gateway, "netmask" => $netmask, "firstip" => $ippool["nat"][0], "lastip" => $ippool["nat"][1], "nat_name" => $ippool["nat_name"]])) {
                $error[] = $l["err_edit_nat"];
                return false;
            }
        }
        $qres = update_query("UPDATE ippool\n\t\t\t\t\t\t\tSET ippool_name  = :ippool_name,\n\t\t\t\t\t\t\tgateway  = :gateway,\n\t\t\t\t\t\t\tnetmask  = :netmask,\n\t\t\t\t\t\t\tns1  = :ns1,\n\t\t\t\t\t\t\tns2  = :ns2,\n\t\t\t\t\t\t\trouting = :routing,\n\t\t\t\t\t\t\tmtu = :mtu,\n\t\t\t\t\t\t\tuid = :uid,\n\t\t\t\t\t\t\tpdns_id = :pdns_id,\n\t\t\t\t\t\t\tvlan_tag = :vlan_tag\n\t\t\t\t\t\t\tWHERE ippid = :ippid", [":ippool_name" => $ippool_name, ":gateway" => $gateway, ":netmask" => $netmask, ":ns1" => $ns1, ":ns2" => $ns2, ":routing" => $routing, ":mtu" => $mtu, ":uid" => $uid, ":vlan_tag" => $vlan_tag, ":ippid" => $ippid, ":pdns_id" => $pdns_id]);
        $qres = makequery("DELETE FROM ippool_servers\n\t\t\t\t\t\t\t\tWHERE ippid = :ippid", [":ippid" => $ippid]);
        foreach ($serid as $key => $value) {
            $servergp = explode("_", $value);
            $qres = insert_and_id("INSERT INTO ippool_servers\n\t\t\t\t\t\t\t\t\tSET ippid = " . $ippid . ",\n\t\t\t\t\t\t\t\t\tserid = " . (!empty($servergp[1]) ? "-2" : $servergp[0]) . ",\n\t\t\t\t\t\t\t\t\tsgid = " . (empty($servergp[1]) ? "-2" : $servergp[0]) . "");
        }
        logs_admin("editippool", $ippool_name, 1, $ippid, $user["uid"]);
        $done = true;
    }
}
function API_editippool()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $ippool;
    global $ippid;
    global $done;
    global $ippool_servers;
    global $users;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    if(!empty($users)) {
        $GLOBALS["_api"]["users"] = $users;
    }
    $GLOBALS["_api"]["ippool"] = $ippool;
    $GLOBALS["_api"]["ippid"] = $ippid;
    $GLOBALS["_api"]["ippool_servers"] = $ippool_servers;
}

?>