<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function editinvoice()
{
    global $theme;
    global $globals;
    global $kernel;
    global $cluster;
    global $user;
    global $l;
    global $error;
    global $done;
    global $users;
    global $invoice;
    global $tax;
    if(!load_lang("admin/editinvoice")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/editinvoice";
    $theme["init_theme_name"] = "editinvoice";
    $theme["init_theme_func"] = ["editinvoice_theme"];
    $theme["call_theme_func"] = "editinvoice_theme";
    if(!is_allowed("config")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $invoid = (int) optREQ("invoid");
    $res = makequery("SELECT * FROM invoices\n\t\t\t\t\tWHERE invoid = :invoid", [":invoid" => $invoid]);
    if(vsql_num_rows($res) < 1) {
        redirect("act=invoices");
    }
    $invoice = vsql_fetch_assoc($res);
    $res = makequery("SELECT uid, email FROM users ORDER BY email");
    $users = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $users[$row["uid"]] = $row;
    }
    $apply_tax = optREQ("apply_tax");
    if(!empty($apply_tax)) {
        $uid = optREQ("uid");
        $amount = optREQ("amt");
        $disc = optREQ("disc");
        if(!empty($disc) && 0 < $disc) {
            $amount = $amount - $disc;
        }
        $tax = get_tax($uid, $amount);
    }
    if(isset($_POST["editinvoice"])) {
        $vals["uid"] = POST("uid", $l["no_uid"]);
        $vals["invodate"] = POST("invodate", $l["no_invodate"]);
        $vals["duedate"] = POST("duedate", $l["no_duedate"]);
        $vals["paydate"] = optPOST("paydate");
        $vals["item"] = POST("item", $l["no_item"]);
        $vals["item_desc"] = optPOST("item_desc");
        $vals["amt"] = POST("amt", $l["no_amt"]);
        $vals["disc"] = optPOST("disc");
        $vals["token"] = optPOST("token");
        if(!empty($error)) {
            return false;
        }
        if(empty($users[$vals["uid"]])) {
            $error["inv_uid"] = $l["inv_uid"];
            return false;
        }
        $vals["invodate"] = valid_date($vals["invodate"]);
        if(!empty($vals["invodate"]) && !$vals["invodate"]) {
            $error["inv_invodate"] = $l["inv_invodate"];
            return false;
        }
        $vals["duedate"] = valid_date($vals["duedate"]);
        if(!empty($vals["duedate"]) && !$vals["duedate"]) {
            $error["inv_duedate"] = $l["inv_duedate"];
            return false;
        }
        $vals["paydate"] = valid_date($vals["paydate"]);
        if(!empty($vals["paydate"]) && !$vals["paydate"]) {
            $error["inv_paydate"] = $l["inv_paydate"];
            return false;
        }
        $vals["invotime"] = strtotime($vals["invodate"]);
        $vals["paytime"] = !empty($vals["paydate"]) ? strtotime($vals["paydate"]) : 0;
        $vals["net"] = $vals["amt"] - $vals["disc"];
        if(!empty($tax)) {
            $vals["net"] = $tax["total_payable_amt"];
            $vals["tax"] = serialize($tax);
            $vals["amt"] = $tax["amt_to_be_credited"];
        }
        foreach ($vals as $k => $v) {
            $set[$k] = "`" . $k . "` = :" . $k;
        }
        $res = makequery("UPDATE invoices \n\t\t\t\t\t\t\tSET " . implode(", ", $set) . "\n\t\t\t\t\t\t\tWHERE invoid = :invoid", array_merge([":invoid" => $invoid], $vals));
        $done = $invoid;
        logs_admin("editinvoice", $invoid, 1, $done, $user["uid"]);
    }
}
function API_editinvoice()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $done;
    global $error;
    global $users;
    global $invoice;
    global $tax;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($users)) {
        $GLOBALS["_api"]["users"] = $users;
    }
    if(!empty($invoice)) {
        $GLOBALS["_api"]["invoice"] = $invoice;
    }
    if(!empty($tax)) {
        $GLOBALS["_api"]["tax"] = $tax;
    }
}

?>