<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function editfirewall_plan()
{
    global $theme;
    global $user;
    global $globals;
    global $l;
    global $done;
    global $error;
    global $cluster;
    global $protocol_array;
    global $vpses;
    global $fw_vps;
    global $ckernel;
    global $firewall_stati;
    global $firewall_plan;
    $theme["init_theme"] = "admin/editfirewall_plan";
    $theme["init_theme_name"] = "Edit Firewall Plans";
    $theme["init_theme_func"] = ["editfirewallplan_theme"];
    $theme["call_theme_func"] = "editfirewallplan_theme";
    if(!load_lang("admin/editfirewall_plan")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    if(!is_allowed("editfirewall_plan")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $protocol_array = ["TCP", "UDP", "GRE", "ESP", "ICMP"];
    $sports = $_POST["sport"];
    $dports = $_POST["dport"];
    $protocols = $_POST["protocol"];
    $direction = $_POST["direction"];
    $source_addrs = $_POST["source_addr"];
    $iptypes = $_POST["ip"];
    $decision = $_POST["decision"];
    $save_firewall = $_POST["save_firewall"];
    $fwid = (int) optREQ("fwid");
    $rules = [];
    $res = makequery("SELECT * FROM firewall_plans WHERE fwid = :fwid", [":fwid" => $fwid]);
    if(vsql_num_rows($res) < 1) {
        redirect("act=firewall_plans");
    }
    $firewall_plan = vsql_fetch_assoc($res);
    if(!empty($save_firewall)) {
        $fw_plan_name = POST("fwp_name", $l["no_plan_name"]);
        $admin_default = (int) optPOST("admin_default");
        $default_policy = optPOST("default_policy");
        if(!is_admin($firewall_plan["uid"])) {
            $error[] = $l["admin_not_allowed_enduser_firewalledit"];
        }
        if(!empty($error)) {
            return false;
        }
        $res = makequery("SELECT fwid FROM firewall_plans WHERE \n\t\t\t\t\t\t\tfw_plan_name = :fw_plan_name AND \n\t\t\t\t\t\t\tuid = :uid AND \n\t\t\t\t\t\t\tfwid != :fwid", [":fw_plan_name" => $fw_plan_name, ":uid" => $firewall_plan["uid"], ":fwid" => $fwid]);
        if(0 < vsql_num_rows($res)) {
            $error[] = $l["fwp_exists"];
            return false;
        }
        $data = check_firewall_rules($iptypes, $direction, $decision, $protocols, $sports, $dports, $source_addrs);
        if(!empty($data["error"])) {
            $error = $data["error"];
            return false;
        }
        $tmp_rules = array_unique($data["rules"]);
        if($globals["firewall_rule_limit"] < count($tmp_rules)) {
            $error[] = lang_vars($l["rules_exceed_limit"], [$globals["firewall_rule_limit"]]);
        }
        $rules = json_encode($tmp_rules);
        $policy_changed = $firewall_plan["default_policy"] != $default_policy ? 1 : 0;
        if(!empty($fw_plan_name) && !empty($tmp_rules) && !empty($fwid) && empty($error)) {
            $res = update_query("UPDATE firewall_plans SET \n\t\t\t\t\t\t\t\tfw_plan_name = :fw_plan_name,\n\t\t\t\t\t\t\t\tuid = :uid,\n\t\t\t\t\t\t\t\trules = :rules,\n\t\t\t\t\t\t\t\tadmin_default = :admin_default,\n\t\t\t\t\t\t\t\tdefault_policy = :default_policy\n\t\t\t\t\t\t\t\tWHERE fwid = :fwid", [":fw_plan_name" => $fw_plan_name, "fwid" => $fwid, ":uid" => $firewall_plan["uid"], ":rules" => $rules, ":admin_default" => $admin_default, ":default_policy" => $default_policy]);
        }
        $done["msg"] = $l["fwp_added"];
        logs_admin("edifirewall_plan", $fw_plan_name, 1, $fwid, $user["uid"]);
        if(!empty($fwid) && empty($error)) {
            $current_rules = json_decode($firewall_plan["rules"]);
            if(array_diff($current_rules, $tmp_rules) || array_diff($tmp_rules, $current_rules) || !empty($policy_changed)) {
                $res = makequery("SELECT vpsid, serid, fwid FROM vps WHERE admin_fwid = :fwid ORDER BY serid ASC", [":fwid" => $fwid]);
                $actid = 0;
                if(vsql_num_rows($res) < 1) {
                    return true;
                }
                $vps_firewall_to_removed = $vps_firewall_to_add = $enduser_fwids = $enduser_firewall_plans = [];
                for ($i = 0; $i < vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $vpsids[$row["vpsid"]] = $row;
                    if(!empty($row["fwid"]) && !isset($enduser_fwids[$row["fwid"]])) {
                        $enduser_fwids[$row["fwid"]] = $row["fwid"];
                    }
                }
                $enduser_firewall_plans = get_firewall_plan($enduser_fwids);
                foreach ($vpsids as $tmp_vpsid => $v) {
                    $tmp_rules = $tmp_policies = [];
                    if(!empty($v["fwid"])) {
                        $tmp_rules = json_decode($enduser_firewall_plans[$v["fwid"]]["rules"], 1);
                        array_push($tmp_policies, $enduser_firewall_plans[$v["fwid"]]["default_policy"]);
                    }
                    array_push($tmp_policies, $firewall_plan["default_policy"]);
                    $tmp_rules = array_merge($tmp_rules, $current_rules);
                    $vps_firewall_to_removed[$v["serid"]][$tmp_vpsid]["firewall_data"] = ["policy" => $tmp_policies, "rules" => json_encode($tmp_rules)];
                    $vps_firewall_to_add[$v["serid"]][$tmp_vpsid] = ["fwid" => $v["fwid"], "admin_fwid" => $fwid];
                }
                $tmp_data["vps_firewall_to_removed"] = $vps_firewall_to_removed;
                $tmp_data["vps_firewall_to_add"] = $vps_firewall_to_add;
                $actid = tasks_admin_process("updatevpsfirewall", serialize($tmp_data), 1, 0, $user["uid"], 0, 0);
                vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/update_vpsfirewall.php " . $actid . " 2>&1 &");
            }
        }
        $firewall_plan["rules"] = $rules;
    }
}
function API_editfirewall_plan()
{
    global $user;
    global $theme;
    global $globals;
    global $done;
    global $error;
    global $protocol_array;
    global $firewall_plan;
    $GLOBALS["_api"]["protocol"] = $protocol_array;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    $GLOBALS["_api"]["firewall_plan"] = $firewall_plan;
}

?>