<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
session_start();
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function databackup()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $done;
    global $vps_name;
    global $vpslist;
    global $filename;
    global $tables;
    global $tablesname;
    global $checkval;
    global $path;
    global $backup_servers;
    if(!load_lang("admin/databackup")) {
        return false;
    }
    $theme["init_theme"] = "admin/databackup";
    $theme["init_theme_name"] = "databackup";
    $theme["init_theme_func"] = ["databackup_theme"];
    $theme["call_theme_func"] = "databackup_theme";
    if(!is_allowed("databackup")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    ini_set("memory_limit", "-1");
    $backup_servers = [];
    $res = makequery("SELECT bid,name,type FROM backup_servers");
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $backup_servers[$row["bid"]] = $row;
    }
    if(isset($_POST["databasebackups"])) {
        $type = POST("type", $l["no_type"]);
        if(!in_array($type, ["FTP", "SSH", "EMAIL"])) {
            $error[] = $l["inv_backup_type"];
        }
        $db_cron = POST("dbbackup_cron", $l["no_databasebackups_cron"]);
        $email = optREQ("email", "");
        $dbbackup_server = (int) optREQ("dbbackup_server", 0);
        $dbbackup_server_dir = optREQ("dbbackup_server_dir", "");
        if(in_array($type, ["FTP", "SSH"])) {
            if(!empty($backup_servers[$dbbackup_server])) {
                $row = $backup_servers[$dbbackup_server];
                if($row["type"] != $type) {
                    $error[] = $l["inv_backup_server"];
                }
            } else {
                $error[] = $l["inv_backup_server"];
            }
            if(empty($dbbackup_server_dir)) {
                $error[] = $l["inv_backup_server_dir"];
            }
        }
        if(!empty($error)) {
            return false;
        }
        $data["dbbackup_type"] = $type;
        $data["dbbackup_email"] = $email;
        $data["dbbackup_server"] = $dbbackup_server;
        $data["dbbackup_server_dir"] = $dbbackup_server_dir;
        $data["dbbackup_cron"] = $db_cron;
        $result = $cluster->config_save(0, $data);
        if(!$result) {
            $error[] = $l["saving_error"];
            return false;
        }
        if(!$cluster->set_databasebackup_cron(0, $db_cron)) {
            $error[] = $l["err_saving"];
        } else {
            $done["cron_set"] = 1;
        }
    }
    if(isset($_POST["databasebackups_delete"])) {
        $data["dbbackup_email"] = "";
        $data["dbbackup_cron"] = "";
        $result = $cluster->config_save(0, $data);
        if(file_exists("/etc/cron.d/virtualizor-databasebackups")) {
            unlink("/etc/cron.d/virtualizor-databasebackups");
        }
    }
    $path = "/var/virtualizor";
    $dbdown = optREQ("dbdown");
    if(!empty($dbdown)) {
        $email_db = checkbox("email_db");
        $actid = tasks_admin_process("dbbackups", "", 5, 0, $user["uid"], 0, 0);
        if(5242880 < vfilesize(logdir() . "virtualizor-dbbackup.log")) {
            vexec("echo \"\" > " . logdir() . "virtualizor-dbbackup.log");
        }
        vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/databasebackups.php -a" . $actid . " -l" . (empty($email_db) ? "" : "r") . " >> " . logdir() . "virtualizor-dbbackup.log 2>&1 &");
        $done["succ"] = true;
    }
    $download = optREQ("download");
    if(!empty($download)) {
        $fullPath = $path . "/dbbackups/" . $download;
        if(!is_safe_file($fullPath)) {
            $error[] = $l["wrong_file"];
            return false;
        }
        $fsize = vfilesize($fullPath);
        $path_parts = pathinfo($fullPath);
        header("Content-Description: File Transfer");
        header("Content-Type: application/octet-stream");
        header("Content-Disposition: attachment; filename=" . basename($fullPath));
        header("Expires: 0");
        header("Cache-Control: must-revalidate");
        header("Pragma: public");
        header("Content-Length: " . $fsize);
        readfile($fullPath);
        exit;
    }
    $delids = optREQ("id");
    if(!empty($delids)) {
        if(!is_allowed("deletedatabackup")) {
            reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
            return false;
        }
        $delids = cexplode(",", $delids);
        $err_ids = [];
        foreach ($delids as $k => $delete) {
            $fullPath = $path . "/dbbackups/" . $delete;
            if(!is_safe_file($fullPath) || !file_exists($fullPath)) {
                $err_ids[] = $delete;
            } elseif(file_exists($fullPath)) {
                unlink($fullPath);
            }
        }
        if(0 < count($err_ids)) {
            $error[] = $l["wrong_file"] . "\n" . implode("\n", array_values($err_ids));
        } else {
            $done["delete"] = true;
        }
    }
    if(is_dir($path . "/dbbackups")) {
        $files1 = scandir($path . "/dbbackups");
        $countval = sizeof($files1);
        if($countval == 2) {
            $done["db_no_avi"] = true;
        }
        for ($i = 0; $i < sizeof($files1); $i++) {
            if($files1[$i] != "." && $files1[$i] != "..") {
                $filename[$i] = $files1[$i];
            }
        }
    }
}
function API_databackup()
{
    global $theme;
    global $globals;
    global $kernel;
    global $error;
    global $user;
    global $l;
    global $done;
    global $backup_servers;
    global $filename;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($filename)) {
        $GLOBALS["_api"]["filename"] = $filename;
    }
    if(!empty($backup_servers)) {
        $GLOBALS["_api"]["backup_servers"] = $backup_servers;
    }
}

?>