<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function billing()
{
    global $theme;
    global $servers;
    global $globals;
    global $kernel;
    global $cluster;
    global $user;
    global $l;
    global $error;
    global $done;
    global $info;
    global $user_plans;
    global $gateways;
    global $country_codes;
    if(!load_lang("admin/billing")) {
        return false;
    }
    $theme["init_theme"] = "admin/billing";
    $theme["init_theme_name"] = "billing";
    $theme["init_theme_func"] = ["billing_theme"];
    $theme["call_theme_func"] = "billing_theme";
    if(!is_allowed("billing")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $master = 1;
    if($master) {
        set_active_server(0);
    }
    $res = makequery("SELECT uplid, plan_name, `type`, `inhouse_billing` FROM user_plans");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $user_plans[$row["uplid"]] = $row;
    }
    $gateways = get_payment_gateways();
    $tmp_gateways_data = get_payment_gateway_data($gateways);
    $country_codes = ["91" => "IN", "US", "44" => "GB", "86" => "CN", "61" => "CC", "355" => "AL", "213" => "DZ", "1684" => "AS", "376" => "AD", "244" => "AO", "1264" => "AI", "1268" => "AG", "54" => "AR", "374" => "AM", "297" => "AW", "43" => "AT", "1242" => "BS", "973" => "BH", "880" => "BD", "1246" => "BB", "375" => "BY", "32" => "BE", "501" => "BZ", "229" => "BJ", "1441" => "BM", "975" => "BT", "591" => "BO", "387" => "BA", "267" => "BW", "55" => "BR", "246" => "IO", "1284" => "VG", "673" => "BN", "359" => "BG", "226" => "BF", "257" => "BI", "855" => "KH", "237" => "CM", "238" => "CV", "599" => "CW", "1345" => "KY", "236" => "CF", "235" => "TD", "56" => "CL", "57" => "CO", "269" => "KM", "243" => "CD", "242" => "CG", "682" => "CK", "506" => "CR", "225" => "CI", "385" => "HR", "53" => "CU", "357" => "CY", "420" => "CZ", "45" => "DK", "253" => "DJ", "1767" => "DM", "593" => "EC", "20" => "EG", "503" => "SV", "240" => "GQ", "291" => "ER", "372" => "EE", "251" => "ET", "500" => "FK", "298" => "FO", "679" => "FJ", "358" => "AX", "33" => "FR", "594" => "GF", "689" => "PF", "241" => "GA", "220" => "GM", "995" => "GE", "49" => "DE", "233" => "GH", "350" => "GI", "30" => "GR", "299" => "GL", "1473" => "GD", "590" => "MF", "1671" => "GU", "502" => "GT", "224" => "GN", "245" => "GW", "592" => "GY", "509" => "HT", "504" => "HN", "852" => "HK", "36" => "HU", "354" => "IS", "62" => "ID", "98" => "IR", "964" => "IQ", "353" => "IE", "972" => "IL", "39" => "VA", "1876" => "JM", "81" => "JP", "962" => "JO", "7" => "RU", "254" => "KE", "686" => "KI", "383" => "XK", "965" => "KW", "996" => "KG", "856" => "LA", "371" => "LV", "961" => "LB", "266" => "LS", "231" => "LR", "218" => "LY", "423" => "LI", "370" => "LT", "352" => "LU", "853" => "MO", "389" => "MK", "261" => "MG", "265" => "MW", "60" => "MY", "960" => "MV", "223" => "ML", "356" => "MT", "692" => "MH", "596" => "MQ", "222" => "MR", "230" => "MU", "262" => "RE", "52" => "MX", "691" => "FM", "373" => "MD", "377" => "MC", "976" => "MN", "382" => "ME", "1664" => "MS", "258" => "MZ", "95" => "MM", "264" => "NA", "674" => "NR", "977" => "NP", "31" => "NL", "687" => "NC", "64" => "NZ", "505" => "NI", "227" => "NE", "234" => "NG", "683" => "NU", "672" => "NF", "850" => "KP", "47" => "SJ", "968" => "OM", "92" => "PK", "680" => "PW", "970" => "PS", "507" => "PA", "675" => "PG", "595" => "PY", "51" => "PE", "63" => "PH", "48" => "PL", "351" => "PT", "974" => "QA", "40" => "RO", "250" => "RW", "290" => "SH", "1869" => "KN", "1758" => "LC", "508" => "PM", "1784" => "VC", "685" => "WS", "378" => "SM", "239" => "ST", "966" => "SA", "221" => "SN", "381" => "RS", "248" => "SC", "232" => "SL", "65" => "SG", "1721" => "SX", "421" => "SK", "386" => "SI", "677" => "SB", "252" => "SO", "27" => "ZA", "82" => "KR", "211" => "SS", "34" => "ES", "94" => "LK", "249" => "SD", "597" => "SR", "268" => "SZ", "46" => "SE", "41" => "CH", "963" => "SY", "886" => "TW", "992" => "TJ", "255" => "TZ", "66" => "TH", "670" => "TL", "228" => "TG", "690" => "TK", "676" => "TO", "1868" => "TT", "216" => "TN", "90" => "TR", "993" => "TM", "1649" => "TC", "688" => "TV", "1340" => "VI", "256" => "UG", "380" => "UA", "971" => "AE", "598" => "UY", "998" => "UZ", "678" => "VU", "58" => "VE", "84" => "VN", "681" => "WF", "967" => "YE", "260" => "ZM", "263" => "ZW"];
    if(isset($_POST["editsettings"])) {
        $data["inhouse_billing"] = checkbox("inhouse_billing") ? 1 : 0;
        $data["force_preference"] = checkbox("force_preference") ? 1 : 0;
        $data["cp_url"] = POST("cp_url", $l["no_cp_url"]);
        $data["billing_day"] = (int) optPOST("billing_day");
        $data["billing_currency"] = POST("billing_currency", $l["no_billing_currency"]);
        $data["billing_symbol"] = POST("billing_symbol", $l["no_billing_symbol"]);
        $data["billing_warn_bal"] = (int) optPOST("billing_warn_bal");
        $data["billing_min"] = (int) POST("billing_min", $l["no_billing_min"]);
        $data["billing_max"] = (int) POST("billing_max", $l["no_billing_max"]);
        $data["billing_min_charge"] = optPOST("billing_min_charge");
        $data["donot_return_advance_payment"] = (int) optPOST("donot_return_advance_payment");
        $data["enable_registration"] = checkbox("enable_registration") ? 1 : 0;
        $data["default_uplid"] = (int) optPOST("default_uplid");
        $data["user_pass_min_char"] = (int) optPOST("user_pass_min_char");
        $data["support_email"] = POST("support_email", $l["no_support_email"]);
        $data["billing_comp"] = POST("billing_comp", $l["no_billing_comp"]);
        $data["billing_addr1"] = POST("billing_addr1", $l["no_billing_addr1"]);
        $data["billing_addr2"] = optPOST("billing_addr2");
        $data["billing_additional"] = optPOST("billing_additional");
        $data["captcha_sitekey"] = rawGPC($_POST["captcha_sitekey"]);
        $data["terms_conditions"] = rawGPC($_POST["terms_conditions"]);
        $data["captcha_secret"] = rawGPC($_POST["captcha_secret"]);
        $data["bcc_invoice_email"] = optPOST("bcc_invoice_email");
        $data["invoice_logo"] = optPOST("invoice_logo");
        $data["invoice_terms_conditions"] = rawGPC($_POST["invoice_terms_conditions"]);
        $data["sms_api"] = optPOST("sms_api");
        $data["sms_registration"] = optPOST("sms_registration");
        $data["default_country_code"] = optPOST("default_country_code");
        if(!empty($data["sms_registration"]) && empty($data["sms_api"])) {
            $error["err_no_sms_api"] = $l["err_no_sms_api"];
            return false;
        }
        $gateway_data = [];
        foreach ($gateways as $key => $value) {
            if(!empty($value["status"])) {
                foreach ($value["fields"] as $name => $details) {
                    if($details["type"] == "checkbox") {
                        $gateway_data[$key][$name] = checkbox($name) ? 1 : 0;
                    } else {
                        $gateway_data[$key][$name] = optPOST($name);
                    }
                }
            }
        }
        $enabled_gateways = $_POST["gateways"];
        $enabled_gateways = serialize($enabled_gateways);
        if(!empty($data["billing_warn_bal"]) && (100 < $data["billing_warn_bal"] || $data["billing_warn_bal"] < 0)) {
            $error["inv_billing_warn_bal"] = $l["inv_billing_warn_bal"];
        }
        if($data["billing_max"] < $data["billing_min"]) {
            $error["inv_billing_min"] = $l["inv_billing_min"];
        }
        if(!empty($data["enable_registration"]) && empty($user_plans[$data["default_uplid"]])) {
            $error["inv_default_uplid"] = $l["inv_default_uplid"];
        }
        if(!empty($data["captcha_sitekey"]) && empty($data["captcha_secret"]) || empty($data["captcha_sitekey"]) && !empty($data["captcha_secret"])) {
            $error["captcha_keys_required"] = $l["captcha_keys_required"];
        }
        if(!empty($error)) {
            return false;
        }
        writefile($globals["path"] . "/billing.json", json_encode($data, JSON_PRETTY_PRINT), 1, 384);
        $result = $cluster->config_save($globals["server"], $data);
        update_registry("enabled_gateways", $enabled_gateways);
        foreach ($gateway_data as $key => $value) {
            if(!empty($value)) {
                update_registry($key, $value);
            }
        }
        if(!$result) {
            $error[] = $l["saving_error"];
            return false;
        }
        foreach ($gateways as $key => $value) {
            if(in_array($key, $_POST["gateways"])) {
                $gateways[$key]["status"] = 1;
            } else {
                $gateways[$key]["status"] = 0;
            }
        }
        $tmp_gateways_data = get_payment_gateway_data($gateways);
        $_POST = array_merge($_POST, $tmp_gateways_data);
        if(!empty($data["invoice_logo"])) {
            $invimgsize = getremoteheader($data["invoice_logo"]);
            $extension = pathinfo($data["invoice_logo"], PATHINFO_EXTENSION);
            if(!empty($invimgsize) && $invimgsize < 300000 && 0 < $invimgsize && preg_match("/jpeg|jpg|png|svg/", $extension)) {
                $new_image_path = $globals["themes"] . "/" . $globals["theme_folder"] . "/images/custom/";
                $new_image = $new_image_path . "invoice_logo." . $extension;
                if(!is_dir($new_image_path)) {
                    mkdir_recursive($new_image_path, 493);
                }
                if(file_exists($new_image)) {
                    unlink($new_image);
                }
                save_web_file($data["invoice_logo"], $new_image);
            } else {
                $error["inv_billing_img"] = $l["inv_billing_img"];
            }
        }
        logs_admin("billing_settings", "", 1, 0, $user["uid"]);
        $done = true;
    }
    if(!is_slave() && $master) {
        $info = load_master_settings();
    }
    $info = array_merge($info, $tmp_gateways_data);
}
function API_billing()
{
    global $theme;
    global $servers;
    global $globals;
    global $kernel;
    global $cluster;
    global $user;
    global $l;
    global $error;
    global $done;
    global $info;
    global $user_plans;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    $GLOBALS["_api"]["info"] = $info;
}

?>