<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function backupservers()
{
    global $theme;
    global $globals;
    global $cluster;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $backupservers;
    global $done;
    global $done_test;
    global $request_test;
    if(!load_lang("admin/backupservers")) {
        return false;
    }
    $theme["init_theme"] = "admin/backupservers";
    $theme["init_theme_name"] = "backupservers";
    $theme["init_theme_func"] = ["backupservers_theme"];
    $theme["call_theme_func"] = "backupservers_theme";
    if(!is_allowed("backupservers")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $test = (int) optREQ("test");
    if(!empty($test)) {
        $qres = makequery("SELECT * FROM backup_servers WHERE bid = :test", [":test" => $test]);
        if(0 < vsql_num_rows($qres)) {
            $backupServer = vsql_fetch_assoc($qres);
            $request_test = 1;
            $bid = $test;
            if($backupServer["type"] == "FTP") {
                $ftp_con = connect_ftp($backupServer);
                if(!$ftp_con) {
                    $done_test = 0;
                } else {
                    $done_test = 1;
                }
            } else {
                $connection = connect_ssh($backupServer);
                if(!$connection) {
                    $done_test = 0;
                } else {
                    $done_test = 1;
                }
            }
        } else {
            $done_test = 0;
        }
        return true;
    }
    $bid = optREQ("delete");
    if(!empty($bid)) {
        if(!is_allowed("deletebackupserver")) {
            reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
            return false;
        }
        $bid = cexplode(",", $bid, 1);
        $res = makequery("SELECT `bid`, `type`, `name`, `hostname`, `port`, `username`, `dir` FROM backup_servers WHERE bid IN ('" . implode("','", $bid) . "')");
        $back_inuse = [];
        if(vsql_num_rows($res) < 0) {
            $error[] = $l["err_inv_bid"];
            return false;
        }
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $qres = makequery("SELECT bid FROM vpsbackup_settings WHERE serid = :serid AND bid=:bid", [":serid" => $globals["server"], ":bid" => $row["bid"]]);
            if(0 < vsql_num_rows($qres)) {
                $back_inuse[$row["bid"]] = $row["name"];
            } else {
                $_bservers[$row["bid"]] = $row;
            }
        }
        foreach ($_bservers as $k => $delbserver) {
            $res = makequery("DELETE FROM backup_servers WHERE bid = :bid", [":bid" => $delbserver["bid"]]);
            if(!$res) {
                $error[] = $l["err_del_backupserver"];
            }
            logs_admin("delbackupserver", $delbserver["name"], 1, $delbserver["bid"], $user["uid"]);
        }
        $sres = $cluster->sync($globals["server"]);
        if(empty($sres)) {
            $error[] = $l["err_save_slave"];
        }
        if(0 < count($back_inuse)) {
            $error[] = $l["err_backupserver_in_use"] . "\n" . implode("\n", array_values($back_inuse));
        } else {
            $done = $_bservers;
        }
        return true;
    } else {
        $tokens = [];
        $name = optREQ("name");
        if(!empty($name)) {
            $where["ftpname"] = "name LIKE :name";
            $tokens[":name"] = wildsearch($name);
        }
        $hostname = optREQ("hostname");
        if(!empty($hostname)) {
            $where["hostname"] = "hostname LIKE :hostname";
            $tokens[":hostname"] = wildsearch($hostname);
        }
        $type = optREQ("type");
        if(!empty($type)) {
            $where["type"] = "type LIKE :type";
            $tokens[":type"] = wildsearch($type);
        }
        $res = makequery("SELECT COUNT(bid) AS num FROM backup_servers\n\t\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)), $tokens);
        $globals["cur_page"] = get_page();
        $globals["reslen"] = (int) optREQ("reslen");
        $globals["reslen"] = $globals["reslen"] <= 0 ? 50 : $globals["reslen"];
        $tmp = vsql_fetch_assoc($res);
        $globals["num_res"] = $tmp["num"];
        $res = makequery("SELECT * FROM backup_servers\n\t\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)) . "\n\t\t\t\t\tLIMIT " . $globals["cur_page"] . ", " . $globals["reslen"], $tokens);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $backupservers[$row["bid"]] = $row;
            unset($backupservers[$row["bid"]]["password"]);
            unset($backupservers[$row["bid"]]["salt"]);
        }
    }
}
function API_backupservers()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $v;
    global $host;
    global $backupservers;
    global $error;
    global $done;
    global $done_test;
    global $request_test;
    global $cluster;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($backupservers)) {
        $GLOBALS["_api"]["backupservers"] = $backupservers;
    }
    if(!empty($request_test)) {
        $GLOBALS["_api"]["test_result"] = !empty($done_test) ? $l["success_connect"] : $l["unable_connect"];
    }
}

?>