<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function backup_plans()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $backup_plans;
    global $bpid;
    global $error;
    global $done;
    global $cluster;
    global $servers;
    if(!load_lang("admin/backup_plans")) {
        return false;
    }
    $theme["init_theme"] = "admin/backup_plans";
    $theme["init_theme_name"] = "backup_plans";
    $theme["init_theme_func"] = ["backup_plans_theme"];
    $theme["call_theme_func"] = "backup_plans_theme";
    if(!is_allowed("backup_plans")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $bpid = optREQ("delete");
    if(!empty($bpid)) {
        if(allow_slave_action()) {
            reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
            return false;
        }
        if(!is_allowed("deletebackup_plan")) {
            reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
            return false;
        }
        $bpid = cexplode(",", $bpid, 1);
        $res = makequery("SELECT * FROM backup_plans WHERE bpid IN ('" . implode("','", $bpid) . "')");
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $_backupplan[$row["bpid"]] = $row;
            }
            foreach ($_backupplan as $k => $v) {
                $res = makequery("UPDATE vps SET\n\t\t\t\t\t\t\t\tbpid = :_bpid\n\t\t\t\t\t\t\t\tWHERE bpid = :bpid", [":_bpid" => 0, ":bpid" => $v["bpid"]]);
                $res = makequery("UPDATE plans SET\n\t\t\t\t\t\t\t\tbpid = :_bpid\n\t\t\t\t\t\t\t\tWHERE bpid = :bpid", [":_bpid" => 0, ":bpid" => $v["bpid"]]);
                $res = makequery("DELETE FROM backup_plans WHERE bpid = :bpid", [":bpid" => $v["bpid"]]);
            }
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/sync_backup_plans.php >> " . logdir() . "sync_backup_plans.log 2>&1 &");
            if(empty($error)) {
                $done = true;
                logs_admin("delbackup_plan", $v["plan_name"], 1, $v["bpid"], $user["uid"]);
            }
            return true;
        }
    }
    $action = optREQ("action");
    $bpids = optREQ("bpids");
    $bpids = cexplode(",", $bpids, 1, 1);
    if(!empty($action) && !empty($bpids)) {
        $disabled_val = $action == "enable" ? 0 : 1;
        if(allow_slave_action()) {
            reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
            return false;
        }
        if(!is_allowed("editbackup_plan")) {
            reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
            return false;
        }
        $res = makequery("UPDATE backup_plans SET disabled = :disabled\n\t\t\t\t\t\t\tWHERE bpid IN ('" . implode("', '", $bpids) . "')", [":disabled" => $disabled_val]);
        $done = true;
        vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/sync_backup_plans.php >> " . logdir() . "sync_backup_plans.log 2>&1 &");
        return true;
    }
    $planname = optREQ("planname");
    $tokens = [];
    if(!empty($planname)) {
        $where["planname"] = "t1.plan_name LIKE :plan_name";
        $tokens[":plan_name"] = wildsearch($planname);
    }
    $res = makequery("SELECT COUNT(bpid) AS num FROM backup_plans t1\n\t\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)), $tokens);
    $globals["cur_page"] = get_page();
    $globals["reslen"] = (int) optREQ("reslen");
    $globals["reslen"] = $globals["reslen"] <= 0 ? 50 : $globals["reslen"];
    $tmp = vsql_fetch_assoc($res);
    $globals["num_res"] = $tmp["num"];
    $res = makequery("SELECT t1.*, t2.name as 'backup_server' FROM backup_plans t1\n\t\t\t\tLEFT JOIN backup_servers t2\n\t\t\t\tON t1.bid = t2.bid " . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)) . "\n\t\t\t\tORDER BY t1.bpid LIMIT " . $globals["cur_page"] . ", " . $globals["reslen"], $tokens);
    $backup_plans = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        if($row["bid"] == 0) {
            $row["backup_server"] = "Local";
        }
        $backup_plans[$row["bpid"]] = $row;
    }
}
function API_backup_plans()
{
    global $theme;
    global $globals;
    global $kernel;
    global $error;
    global $backup_plans;
    global $l;
    global $done;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["backup_plans"] = $backup_plans;
}

?>