<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function adduser()
{
    global $user;
    global $theme;
    global $globals;
    global $kernel;
    global $users;
    global $l;
    global $error;
    global $done;
    global $mgs;
    global $servergroups;
    global $dnsplans;
    global $user_plans;
    global $acls;
    global $apikeys;
    if(!load_lang("admin/adduser")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/adduser";
    $theme["init_theme_name"] = "adduser";
    $theme["init_theme_func"] = ["adduser_theme"];
    $theme["call_theme_func"] = "adduser_theme";
    if(!is_allowed("adduser")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $mgs = listmgs();
    $servergroups = server_groups();
    $res = makequery("SELECT * FROM dnsplans");
    $dnsplans = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $dnsplans[$row["dnsplid"]] = $row;
    }
    $acls = [];
    $res = makequery("SELECT * FROM admin_acl");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $acls[$row["aclid"]] = $row;
    }
    $user_plans = [];
    if(!empty($globals["inhouse_billing"])) {
        $res = makequery("SELECT uplid, type, plan_name FROM user_plans");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $user_plans[$row["uplid"]] = $row;
        }
    }
    if(isset($_POST["adduser"])) {
        $_POST = apply_filters("before_adduser", $_POST);
        $newpass = $_POST["newpass"];
        $newemail = POST("newemail", $l["no_email"]);
        $prefs["fname"] = optPOST("fname");
        $prefs["lname"] = optPOST("lname");
        $preferences = "";
        if(empty($newpass)) {
            $error[] = $l["no_new"];
        }
        if(!empty($prefs["fname"]) && !empty($prefs["lname"])) {
            $preferences = serialize($prefs);
        }
        if(!empty($error)) {
            return false;
        }
        $uplid = (int) optPOST("uplid");
        if(!empty($uplid)) {
            $res = makequery("SELECT * FROM user_plans WHERE uplid = :uplid", [":uplid" => $uplid]);
            $tmp_user_plans = vsql_fetch_assoc($res);
            if(empty($tmp_user_plans)) {
                $error[] = $l["invalid_user_plan"];
                return false;
            }
            $manual_check_key = ["uplid", "plan_name", "type", "sg", "mg", "dnsplid", "allowed_virts"];
            foreach ($tmp_user_plans as $k => $v) {
                if(in_array($k, $manual_check_key)) {
                } elseif(!isset($_POST[$k])) {
                    $_POST[$k] = $v;
                }
            }
            if(!isset($_POST["priority"])) {
                $_POST["priority"] = $tmp_user_plans["type"];
            }
            if(!isset($_POST["sgs"])) {
                $_POST["sgs"] = explode(",", $tmp_user_plans["sg"]);
            }
            if(!isset($_POST["mgs"])) {
                $_POST["mgs"] = explode(",", $tmp_user_plans["mg"]);
            }
            if(!isset($_POST["dnsplan_id"])) {
                $_POST["dnsplan_id"] = $tmp_user_plans["dnsplid"];
            }
            if(!isset($_POST["allowed_virts"])) {
                $_POST["allowed_virts"] = explode(",", $tmp_user_plans["allowed_virts"]);
            }
        }
        $user_type = (int) POST("priority", $l["nousertype"]);
        $dnsplan_id = (int) optPOST("dnsplan_id");
        $aclid = (int) optPOST("acl_id");
        $inhouse_billing = (int) optPOST("inhouse_billing");
        $max_cost = (int) optPOST("max_cost");
        $num_vs = (int) optPOST("num_vs");
        $num_users = (int) optPOST("num_users");
        $space = (int) optPOST("space");
        $ram = (int) optPOST("ram");
        $burst = (int) optPOST("burst");
        $bandwidth = (int) optPOST("bandwidth");
        $cpu = (int) optPOST("cpu");
        $cores = (int) optPOST("cores");
        $space_per_vm = (int) optPOST("space_per_vm");
        $cpu_percent = (int) optPOST("cpu_percent");
        $num_cores = (int) optPOST("num_cores");
        $num_ipv4 = (int) optPOST("num_ipv4");
        $num_ip_int = (int) optPOST("num_ip_int");
        $num_ipv6_subnet = (int) optPOST("num_ipv6_subnet");
        $num_ipv6 = (int) optPOST("num_ipv6");
        $network_speed = (int) optPOST("network_speed");
        $upload_speed = (int) optPOST("upload_speed");
        $total_iops_sec = (int) optPOST("total_iops_sec");
        $read_bytes_sec = (int) optPOST("read_bytes_sec");
        $write_bytes_sec = (int) optPOST("write_bytes_sec");
        $band_suspend = checkbox("band_suspend") ? 1 : 0;
        $service_period = (int) optPOST("service_period");
        $skip_callback = optREQ("skip_callback");
        $foreign_uid = $cur_bal = 0;
        if(!empty($dnsplan_id) && empty($dnsplans[$dnsplan_id])) {
            $error[] = $l["invalid_dnsplan_id"];
            return false;
        }
        if(!empty($skip_callback)) {
            $foreign_uid = (int) optPOST("foreign_uid");
            $cur_bal = (double) optPOST("cur_bal");
        }
        if($space < $space_per_vm) {
            $error[] = $l["space_per_vm_err"];
            return false;
        }
        $webuzo_prem_apps = 0;
        if(!empty($globals["premium_apps"])) {
            $webuzo_prem_apps = checkbox("webuzo_prem_apps") ? 1 : 0;
        }
        $virts = [];
        $allowed_virts = explode(" ", $_POST["allowed_virts"][0]);
        foreach ($globals["virts"] as $k => $v) {
            if(@in_array($v, $allowed_virts)) {
                $virts[] = $v;
            }
        }
        if(!empty($service_period)) {
            if(31 < $service_period && $service_period < 1) {
                $error[] = $l["invalid_date"];
                return false;
            }
        } else {
            $service_period = 1;
        }
        $sgs = $mg = [];
        if(isset($_POST["sgs"])) {
            foreach ($_POST["sgs"] as $k => $v) {
                $v = (int) $v;
                if(empty($servergroups[$v])) {
                } else {
                    $sgs[$v] = $v;
                }
            }
        }
        if(isset($_POST["mgs"])) {
            foreach ($_POST["mgs"] as $k => $v) {
                $v = (int) $v;
                if(empty($mgs[$v]) || !in_array($mgs[$v]["mg_type"], $virts)) {
                } else {
                    $mg[$v] = $v;
                }
            }
        }
        if(!emailvalidation($newemail)) {
            $error[] = $l["invalid_email"];
            return false;
        }
        $qres = makequery("SELECT email \n\t\t\t\t\t\tFROM users \n\t\t\t\t\t\tWHERE email = :newemail", [":newemail" => $newemail]);
        if(0 < vsql_num_rows($qres)) {
            $error[] = $l["emailexist"];
            return false;
        }
        $uid = insert_and_id("INSERT INTO users \n\t\t\t\t\t\t\tSET\ttype = :type,\n\t\t\t\t\t\t\tpassword = :password,\n\t\t\t\t\t\t\tuplid = :uplid,\n\t\t\t\t\t\t\tinhouse_billing = :inhouse_billing,\n\t\t\t\t\t\t\tmax_cost = :max_cost,\n\t\t\t\t\t\t\temail = :email,\n\t\t\t\t\t\t\tcur_bal = :cur_bal,\n\t\t\t\t\t\t\tnum_vs = :num_vs,\n\t\t\t\t\t\t\tnum_users = :num_users,\n\t\t\t\t\t\t\tspace = :space,\n\t\t\t\t\t\t\tram = :ram,\n\t\t\t\t\t\t\tburst = :burst,\n\t\t\t\t\t\t\tbandwidth = :bandwidth,\n\t\t\t\t\t\t\tcpu = :cpu,\n\t\t\t\t\t\t\tcores = :cores,\n\t\t\t\t\t\t\tspace_per_vm = :space_per_vm,\n\t\t\t\t\t\t\tcpu_percent = :cpu_percent,\n\t\t\t\t\t\t\tnum_cores = :num_cores,\n\t\t\t\t\t\t\tnum_ipv4 = :num_ipv4,\n\t\t\t\t\t\t\tnum_ip_int = :num_ip_int,\n\t\t\t\t\t\t\tnum_ipv6 = :num_ipv6,\n\t\t\t\t\t\t\tnum_ipv6_subnet = :num_ipv6_subnet,\n\t\t\t\t\t\t\tnetwork_speed = :network_speed,\n\t\t\t\t\t\t\tupload_speed = :upload_speed,\n\t\t\t\t\t\t\ttotal_iops_sec = :total_iops_sec,\n\t\t\t\t\t\t\tread_bytes_sec = :read_bytes_sec,\n\t\t\t\t\t\t\twrite_bytes_sec = :write_bytes_sec,\n\t\t\t\t\t\t\tallowed_virts = :allowed_virts,\n\t\t\t\t\t\t\tsg = :sg,\n\t\t\t\t\t\t\tmg = :mg,\n\t\t\t\t\t\t\taclid= :aclid,\n\t\t\t\t\t\t\tdnsplid = :dnsplid,\n\t\t\t\t\t\t\tpreferences = :preferences,\n\t\t\t\t\t\t\tservice_period = :service_period,\n\t\t\t\t\t\t\tband_suspend = :band_suspend,\n\t\t\t\t\t\t\tforeign_uid = :foreign_uid,\n\t\t\t\t\t\t\tdate_created = :date,\n\t\t\t\t\t\t\twebuzo_prem_apps = :webuzo_prem_apps", [":type" => $user_type, ":password" => crypt($newpass), ":email" => $newemail, ":uplid" => $uplid, ":inhouse_billing" => $inhouse_billing, ":max_cost" => $max_cost, ":num_vs" => $num_vs, ":num_users" => $num_users, ":space" => $space, ":ram" => $ram, ":burst" => $burst, ":bandwidth" => $bandwidth, ":cpu" => $cpu, ":cores" => $cores, ":space_per_vm" => $space_per_vm, ":cpu_percent" => $cpu_percent, ":num_cores" => $num_cores, ":num_ipv4" => $num_ipv4, ":num_ip_int" => $num_ip_int, ":num_ipv6" => $num_ipv6, ":num_ipv6_subnet" => $num_ipv6_subnet, ":network_speed" => $network_speed, ":upload_speed" => $upload_speed, ":total_iops_sec" => $total_iops_sec, ":write_bytes_sec" => $write_bytes_sec, ":read_bytes_sec" => $read_bytes_sec, ":allowed_virts" => implode(" ", $virts), ":sg" => implode(",", $sgs), ":mg" => implode(",", $mg), ":aclid" => $aclid, ":dnsplid" => $dnsplan_id, ":preferences" => $preferences, ":service_period" => $service_period, ":band_suspend" => $band_suspend, ":date" => time(), ":webuzo_prem_apps" => $webuzo_prem_apps, ":cur_bal" => $cur_bal, ":foreign_uid" => $foreign_uid]);
        $addkey = optREQ("addkey");
        if(!empty($addkey)) {
            $apikey = strtoupper(generateRandStr(16));
            $apipass = generateRandStr(32);
            $res = makequery("INSERT INTO `api`\n\t\t\t\t\t\tSET apikey = :apikey,\n\t\t\t\t\t\tapipass = :apipass,\n\t\t\t\t\t\tuid = :uid", [":apikey" => $apikey, ":apipass" => $apipass, ":uid" => $uid]);
            $res = makequery("SELECT * FROM `api`\n\t\t\t\t\t\t\tWHERE uid = :uid\n\t\t\t\t\t\t\tORDER BY idapi ASC", [":uid" => $uid]);
            $apikeys = [];
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $apikeys["apikey"] = $row["apikey"];
                $apikeys["apipass"] = $row["apipass"];
            }
        }
        logs_admin("adduser", $newemail, 1, $uid, $user["uid"]);
        $done = $uid;
        apply_filters("after_adduser", $uid);
    }
}
function API_adduser()
{
    global $theme;
    global $globals;
    global $kernel;
    global $_user;
    global $l;
    global $error;
    global $done;
    global $mgs;
    global $servergroups;
    global $user_plans;
    global $apikeys;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    $GLOBALS["_api"]["user_plans"] = $user_plans;
    $GLOBALS["_api"]["mgs"] = $mgs;
    $GLOBALS["_api"]["servergroups"] = $servergroups;
    if(!empty($apikeys)) {
        $GLOBALS["_api"]["apikeys"] = $apikeys;
    }
}

?>