<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addtemplate()
{
    global $theme;
    global $globals;
    global $kernel;
    global $cluster;
    global $user;
    global $l;
    global $ostemplates;
    global $oses;
    global $oslist;
    global $error;
    global $done;
    global $mgs;
    if(!load_lang("admin/addtemplate")) {
        return false;
    }
    $theme["init_theme"] = "admin/addtemplate";
    $theme["init_theme_name"] = "addtemplate";
    $theme["init_theme_func"] = ["addtemplate_theme"];
    $theme["call_theme_func"] = "addtemplate_theme";
    if(!is_allowed("addtemplate")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $oslist = [];
    oslist();
    $mgs = listmgs();
    if(isset($_POST["addtemplate"])) {
        $newos = [];
        $newos["type"] = POST("cplan", $l["no_virt"]);
        if($newos["type"] == "xenhvm") {
            $newos["type"] = "xen";
            $newos["hvm"] = 1;
        }
        if($newos["type"] == "xcphvm") {
            $newos["type"] = "xcp";
            $newos["hvm"] = 1;
        }
        $newos["extra"] = optPOST("extra");
        if(empty($newos["extra"])) {
            unset($newos["extra"]);
        }
        $newos["pygrub"] = checkbox("pygrub");
        if(empty($newos["pygrub"])) {
            unset($newos["pygrub"]);
        }
        $newos["fstype"] = checkbox("fstype");
        if(empty($newos["fstype"])) {
            $newos["fstype"] = "ext3";
        } else {
            $newos["fstype"] = "ext4";
        }
        $newos["drive"] = optPOST("drive");
        if(empty($newos["drive"])) {
            unset($newos["drive"]);
        }
        $newos["template_admin_name"] = optPOST("template_admin_name");
        if(empty($newos["template_admin_name"])) {
            unset($newos["template_admin_name"]);
        }
        $newos["noresizefs"] = checkbox("noresizefs");
        if(empty($newos["noresizefs"])) {
            unset($newos["noresizefs"]);
        }
        $newos["perf_ops"] = checkbox("perf_ops");
        if(empty($newos["perf_ops"])) {
            unset($newos["perf_ops"]);
        }
        if(($newos["type"] == "xen" || $newos["type"] == "xcp") && $newos["hvm"] == 1 || $newos["type"] == "kvm" || $newos["type"] == "proxk") {
            $newos["hvm_pass"] = optPOST("hvm_pass");
            if(empty($newos["hvm_pass"])) {
                unset($newos["hvm_pass"]);
            }
        }
        $newos["url"] = optPOST("url");
        $newos["filename"] = POST("filename", $l["no_file"]);
        $newos["name"] = str_replace([".tar.gz", ".zip", ".iso", ".tgz", ".vdi", ".img", ".qcow2"], "", $newos["filename"]);
        if(!empty($error)) {
            return false;
        }
        foreach ($ostemplates as $k => $v) {
            if($newos["filename"] == $v["filename"]) {
                $error[] = $l["premade_os_name_exist"];
                return false;
            }
        }
        foreach ($oses as $k => $v) {
            if($newos["filename"] == $v["filename"]) {
                $error[] = $l["os_name_exist"];
                return false;
            }
        }
        if(empty($globals[$newos["type"] . "os"])) {
            $error[] = $l["invalid_virt"];
            return false;
        }
        if(!empty($newos["url"])) {
            if(file_exists($globals[$newos["type"] . "os"] . "/" . $newos["filename"])) {
                $error[] = $l["file_exists"];
                return false;
            }
            $newos["size"] = (double) @getremoteheader($newos["url"]);
        } else {
            if(!file_exists($globals[$newos["type"] . "os"] . "/" . $newos["filename"])) {
                $error[] = $l["no_file_exists"] . "<b>" . $newos["filename"] . "</b>";
                return false;
            }
            $newos["size"] = (double) @vfilesize($globals[$newos["type"] . "os"] . "/" . $newos["filename"]);
        }
        if(empty($newos["size"])) {
            $error[] = $l["err_size"];
            return false;
        }
        if(!empty($_POST["mgs"])) {
            foreach ($_POST["mgs"] as $k => $v) {
                $v = (int) $v;
                if(empty($mgs[$v])) {
                } else {
                    $newosmgs[$v] = $v;
                }
            }
        }
        $disk_size = get_free_space($globals["var"]);
        $os_size = round($newos["size"] / 1024 / 1024);
        if(!empty($newos["url"]) && $disk_size < $os_size) {
            $error[] = $l["low_space_os"];
            return false;
        }
        $res = makequery("SELECT MAX(osid) AS num FROM `os`\n\t\t\t\t\t\t\tWHERE osid > 100000");
        if(0 < vsql_num_rows($res)) {
            $tmp = vsql_fetch_assoc($res);
            $newosid = $tmp["num"] + 1;
        }
        if(empty($newosid) || $newosid < 100001) {
            $newosid = 100001;
        }
        $res = makequery("INSERT INTO `os`\n\t\t\t\t\t\tSET osid = :osid,\n\t\t\t\t\t\tosdata = :osdata,\n\t\t\t\t\t\tmg = :mg", [":osid" => $newosid, ":osdata" => serialize($newos), ":mg" => !empty($newosmgs) ? implode(",", $newosmgs) : ""]);
        logs_admin("addtemplate", $newos["name"], 1, $newosid, $user["uid"]);
        if(!empty($newos["url"])) {
            if(is_api_call()) {
                $data = ["progress_msg" => $l["checking_data"], "get_oslist" => [$newosid], "serid" => $globals["server"]];
                $actid = tasks_admin_process("getos", serialize($data), 10, 0, $user["uid"], 0, 0);
                vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/os.php " . $actid . " > " . logdir() . "os.log 2>&1 &");
            } else {
                redirect("act=os&getos=" . $newosid);
                return true;
            }
        }
        $done = 1;
    }
}
function API_addtemplate()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $oslist;
    global $error;
    global $done;
    global $mgs;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    $GLOBALS["_api"]["mgs"] = $mgs;
}

?>