<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addstorage()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $cluster;
    global $error;
    global $servers;
    global $servergroups;
    global $valid_storages;
    global $stid;
    global $done;
    if(!load_lang("admin/addstorage")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["cant_add"], $l["cant_add_exp"], $l["cant_add_head"]);
        return false;
    }
    $theme["init_theme"] = "admin/addstorage";
    $theme["init_theme_name"] = "Add Storage";
    $theme["init_theme_func"] = ["addstorage_theme"];
    $theme["call_theme_func"] = "addstorage_theme";
    if(!is_allowed("addstorage")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $servergroups = server_groups();
    $valid_storages = ["openvz", "block", "thin block", "file", "zfs block", "zfs thin block", "zfs block compressed", "zfs thin block compressed", "ceph block", "lightbit block", "linbit drbd block"];
    if(isset($_POST["addstorage"])) {
        $name = POST("name", $l["no_name"]);
        $path = POST("path", $l["no_path"]);
        $path = cleanpath($path);
        $type = strtolower(POST("type", $l["no_type"]));
        $format = strtolower(optPOST("format"));
        $oversell = (int) optPOST("oversell");
        $alert_threshold = (double) optPOST("alert_threshold");
        $primary_storage = (int) checkbox("primary_storage");
        $serid = $_POST["serid"];
        $project_name = optPOST("project_name");
        if(!empty($error)) {
            return false;
        }
        if(!in_array($type, $valid_storages)) {
            $error[] = $l["invalid_st_type"] . " " . $type;
        }
        if(!is_array($serid)) {
            $serid = [(int) $serid];
        }
        foreach ($serid as $key => $ser) {
            if(0 < substr_count($ser, "_")) {
                $tmp = explode("_", $ser);
                if(empty($servergroups[$tmp[0]])) {
                    $error[] = $l["inv_group"];
                }
            } elseif($ser != -1 && empty($servers[$ser])) {
                $error[] = $l["inv_server"];
            }
        }
        if(count($serid) == 1) {
            $tmp_xcp_check = current($serid);
            if(!empty($servers[$tmp_xcp_check]) && in_array("xcp", $servers[$tmp_xcp_check]["virts"])) {
                $is_one_xcp = 1;
            }
        }
        if(!empty($is_one_xcp)) {
            if(preg_match("/block/is", $type) && $format != "raw" && $format != "vhd") {
                $error[] = $l["lvm_xcp_formats"];
            }
        } elseif((preg_match("/block/is", $type) || preg_match("/zfs/is", $type) || $type == "thin block" || $type == "ceph block") && $format != "raw") {
            $error[] = $l["lvm_raw_only"];
        }
        if(($type == "block" || $type == "thin block") && substr($path, 0, 4) != "/dev") {
            $error[] = $l["lvm_full_path"];
        }
        if($type == "openvz" && !($path == "/vz" || $path == "/vz/private")) {
            $error[] = $l["vz_path_wrong"];
        }
        if($type == "lightbit" && empty($project_name)) {
            $error[] = $l["err_proj_name"];
        }
        if(preg_match("/linbit/is", $type) && $path != $name) {
            $error[] = $l["err_linbit_path_name"];
        }
        if(!empty($error)) {
            return false;
        }
        $_sg = $_servers = [];
        foreach ($serid as $key => $value) {
            $servergp = explode("_", $value);
            if(!empty($servergp[1])) {
                $_sg[$servergp[0]] = $servergp[0];
                foreach ($servers as $k => $v) {
                    if($v["sgid"] == $servergp[0]) {
                        $_servers[$k] = $k;
                    }
                }
            } elseif($servergp[0] == -1) {
                foreach ($servers as $k => $v) {
                    $_servers[$k] = $k;
                }
            } else {
                $_servers[$servergp[0]] = $servergp[0];
            }
        }
        $storage_data["name"] = $name;
        $storage_data["path"] = $path;
        $storage_data["type"] = $type;
        $storage_data["format"] = $format;
        if(preg_match("/lightbit/is", $type)) {
            $storage_data["project_name"] = $project_name;
        }
        if($storage_data["type"] == "openvz") {
            $storage_data["virt"] = "openvz";
        }
        foreach ($_servers as $k => $v) {
            $_err = $cluster->storage_check($k, $storage_data);
            if(!empty($_err)) {
                $error[] = "Server ID : " . $k . " Error : " . $_err;
            }
        }
        if(!empty($error)) {
            return false;
        }
        $stid = insert_and_id("INSERT INTO storage\n\t\t\t\t\t\tSET name = :name,\n\t\t\t\t\t\t`st_uuid` = :st_uuid,\n\t\t\t\t\t\tpath = :path,\n\t\t\t\t\t\t`type` = :type,\n\t\t\t\t\t\tformat = :format,\n\t\t\t\t\t\toversell = :oversell,\n\t\t\t\t\t\talert_threshold = :alert_threshold,\n\t\t\t\t\t\tprimary_storage = :primary_storage,\n\t\t\t\t\t\tproject_name = :project_name", [":name" => $name, ":st_uuid" => generateRandStr(16), ":path" => $path, ":type" => $type, ":format" => $format, ":oversell" => $oversell, ":alert_threshold" => $alert_threshold, ":primary_storage" => $primary_storage, ":project_name" => $project_name]);
        if(empty($stid)) {
            $error[] = $l["err_saving"];
            return false;
        }
        foreach ($serid as $key => $value) {
            $servergp = explode("_", $value);
            $qres = insert_and_id("INSERT INTO storage_servers\n\t\t\t\t\t\t\t\t\tSET stid = :stid,\n\t\t\t\t\t\t\t\t\tserid = :serid,\n\t\t\t\t\t\t\t\t\tsgid = :sgid", [":stid" => $stid, ":serid" => !empty($servergp[1]) ? "-2" : $servergp[0], ":sgid" => empty($servergp[1]) ? "-2" : $servergp[0]]);
        }
        foreach ($_servers as $k => $v) {
            $cluster->sync($k);
            $cluster->resources($k, $servers[$k]["virt"]);
        }
        $done = $stid;
        logs_admin("addstorage", $name, 1, $done, $user["uid"]);
    }
}
function API_addstorage()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $valid_storages;
    global $stid;
    global $done;
    global $error;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
}

?>