<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addips()
{
    global $theme;
    global $globals;
    global $cluster;
    global $user;
    global $l;
    global $servers;
    global $error;
    global $ippools;
    global $done;
    global $ips;
    if(!load_lang("admin/addips")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/addips";
    $theme["init_theme_name"] = "addips";
    $theme["init_theme_func"] = ["addips_theme"];
    $theme["call_theme_func"] = "addips_theme";
    if(!is_allowed("addips")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $res = makequery("SELECT * FROM ippool \n\t\t\t\t\tORDER BY ippid");
    $ippools = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ippools[$row["ippid"]] = $row;
    }
    $ippid = (int) optGET("ippid");
    if(isset($_POST["submitip"])) {
        $range = $range_ = [];
        $iptype = optPOST("iptype") == 4 ? 4 : 6;
        $ippid = (int) optPOST("ippid");
        if($iptype == 6 && empty($ippid)) {
            $error[] = $l["no_ip_pool"];
            return false;
        }
        if(!empty($ippools[$ippid]["nat"])) {
            $error[] = $l["no_addips_nat"];
            return false;
        }
        if(!empty($ippid)) {
            $_ipv6 = $iptype == 6;
            if(empty($ippools[$ippid]) || $_ipv6 != $ippools[$ippid]["ipv6"]) {
                $error[] = $l["inv_ippool"];
                return false;
            }
            $ip_serid = (int) $ippools[$ippid]["ipp_serid"];
        } else {
            $ip_serid = (int) optPOST("ip_serid");
            if(empty($servers[$ip_serid])) {
                $error[] = $l["inv_server"];
                return false;
            }
            $ippid = 0;
        }
        if($iptype == 4) {
            $_ips = $_POST["ips"];
            $macs = $_POST["macs"];
            $macs = array_filter($macs, "strlen");
            $ips = [];
            if(!empty($_ips)) {
                foreach ($_ips as $k => $ip) {
                    $ip = trim($ip);
                    if($ip != "") {
                        $ips[$k] = ["ip" => $ip, "mac_addr" => trim($macs[$k])];
                    }
                }
            }
            if(is_array($ips) && !empty($ips)) {
                $invalid = [];
                $invalid_macs = [];
                foreach ($ips as $ip) {
                    if(empty($ip["ip"])) {
                    } else {
                        if(!valid_ip($ip["ip"])) {
                            $invalid[] = $ip["ip"];
                        }
                        if($ip["ip"] == $globals["primary_ip"]) {
                            $invalid_primary_ip[] = $ip["ip"];
                        } else {
                            $range_[] = $ip["ip"];
                        }
                        if(empty($ip["mac_addr"])) {
                            $ip["mac_addr"] = NULL;
                        } elseif(!valid_mac($ip["mac_addr"])) {
                            $invalid_macs[] = $ip["mac_addr"];
                        }
                    }
                }
                if(!empty($invalid)) {
                    $error[] = $l["ips_inv"] . " : " . implode(", ", $invalid);
                    return false;
                }
                if(!empty($invalid_macs)) {
                    $error[] = $l["macs_inv"] . " : " . implode(", ", $invalid_macs);
                    return false;
                }
                if(!empty($invalid_primary_ip)) {
                    $error[] = implode(", ", $invalid_primary_ip) . $l["error_primary_ip"];
                    return false;
                }
            }
            $firstip = optPOST("firstip");
            $lastip = optPOST("lastip");
            if(!empty($firstip) && !valid_ip($firstip)) {
                $error[] = $l["inv_startip"];
            }
            if(!empty($lastip) && !valid_ip($lastip)) {
                $error[] = $l["inv_endip"];
            }
            if(!empty($firstip) && !empty($lastip)) {
                $range = iprange($firstip, $lastip);
                if(empty($range)) {
                    $error[] = $l["invalid_range"];
                    return false;
                }
                foreach ($range as $k => $v) {
                    if($v == $globals["primary_ip"]) {
                        $error[] = $v . $l["error_primary_ip"];
                    }
                }
            }
            if(!empty($error)) {
                return false;
            }
        } else {
            $ips = $_POST["ips6"];
            if(is_array($ips) && !empty($ips)) {
                $invalid = [];
                foreach ($ips as $ip) {
                    $ip = implode(":", $ip);
                    $ip_ = trim($ip, ":");
                    if(empty($ip_)) {
                    } elseif(!valid_ipv6($ip)) {
                        $invalid[] = $ip;
                    } else {
                        $range_[] = $ip;
                    }
                }
                if(!empty($invalid)) {
                    $error[] = $l["ips_inv"] . " : " . implode(", ", $invalid);
                    return false;
                }
            }
            $ipv6[1] = optPOST("ipv6_1");
            $ipv6[2] = optPOST("ipv6_2");
            $ipv6[3] = optPOST("ipv6_3");
            $ipv6[4] = optPOST("ipv6_4");
            $ipv6[5] = optPOST("ipv6_5");
            $ipv6[6] = optPOST("ipv6_6");
            if(!empty($ipv6[1]) && !empty($ipv6[2]) && !empty($ipv6[3]) && !empty($ipv6[4]) && !empty($ipv6[5]) && !empty($ipv6[6])) {
                if(!valid_ipv6(implode(":", $ipv6) . "::")) {
                    $error[] = $l["inv_ipv6"];
                }
                $ipv6_num = (int) POST("ipv6_num", $l["no_ipv6_num"]);
                if(5000 < $ipv6_num) {
                    $error[] = $l["ipv6_too_much"];
                }
                if(!empty($error)) {
                    return false;
                }
                $range = ip6range(implode(":", $ipv6), $ipv6_num);
                if(empty($range)) {
                    $error[] = $l["inv_ipv6"];
                    return false;
                }
            }
        }
        $range = array_merge($range, $range_);
        $range = array_unique($range);
        if(empty($range)) {
            $error[] = $l["no_ips"];
            return false;
        }
        $range_token = vsql_in_tokens($range);
        $token = $range_token["tokens"];
        $query = "";
        if(!empty($ippools[$ippid]["internal"])) {
            $query = " AND ippid = :ippid";
            $token = array_merge($token, [":ippid" => $ippid]);
        }
        $qres = makequery("SELECT DISTINCT ip \n\t\t\t\t\t\tFROM ips \n\t\t\t\t\t\tWHERE ip IN (" . $range_token["query"] . ")" . $query, $token);
        $common = [];
        for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
            $row = vsql_fetch_assoc($qres);
            $common[] = $row["ip"];
        }
        if(!empty($common)) {
            $error[] = $l["ips_exist"] . " : " . implode(", ", $common);
            return false;
        }
        $_range = [];
        foreach ($range as $k => $value) {
            $qres = insert_and_id("INSERT INTO ips\n\t\t\t\t\t\t  SET ippid = :ippid,\n\t\t\t\t\t\t  ip = :ip,\n\t\t\t\t\t\t  ip_serid = :ip_serid,\n\t\t\t\t\t\t  ipv6 = :ipv6,\n\t\t\t\t\t\t  mac_addr = :mac_addr", [":ippid" => $ippid, ":ip" => $value, ":ip_serid" => $ip_serid, ":ipv6" => $iptype == 4 ? 0 : 1, ":mac_addr" => trim($macs[$k])]);
            if(empty($qres)) {
                $error[] = $l["err_ip"] . " : " . $value;
                return false;
            }
            $_range[$qres] = $value;
        }
        $done = [];
        $done["range"] = $_range;
        $done["done"] = 1;
    }
}
function API_addips()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $ipblocks;
    global $error;
    global $cluster;
    global $done;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
}

?>