<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once "inc.php";
global $error;
global $mail_error_log;
global $servers;
$GLOBALS["lvname"] = "backup-" . substr($globals["key"], 0, 8);
$virt = explode(" ", $servers[0]["virt"]);
foreach ($virt as $key => $virtvalue) {
    $stid = storage_get_primary($virtvalue);
    if(!bg_vpsbackups($virtvalue)) {
        global $error;
        foreach ($mail_error_log as $k => $v) {
            $temp_error_log .= "\n" . $v;
        }
        $site_domain = !empty($globals["site_domain"]) && $globals["site_domain"] != $globals["primary_ip"] ? $l["server_domain"] . $globals["site_domain"] : "";
        $site_domain = unhtmlentities($site_domain);
        $mail[0]["to"] = $globals["soft_email"];
        $mail[0]["subject"] = $l["admin_vpsbackups_err_sub"];
        $mail[0]["message"] = lang_vars_name($l["admin_vpsbackups_err_body"], ["sn" => $globals["sn"], "error_log" => $temp_error_log, "primary_ip" => $globals["primary_ip"], "server_domain" => $site_domain]);
        _mail($mail);
        log_output($l["log_err_end"]);
    }
}
if(!empty($error)) {
    echo "Errors: \n";
    r_print($error);
}
if(defined("debug")) {
    r_print($GLOBALS["logr"]);
}
function bg_vpsbackups($virt)
{
    global $globals;
    global $kernel;
    global $servers;
    global $l;
    global $error;
    global $mail_error_log;
    global $user;
    $script_tstart = microtime(true);
    if(!load_lang("admin/vpsbackup_settings")) {
        return false;
    }
    $res = makequery("SELECT * FROM vpsbackup_settings WHERE serid=0");
    $backup_settings = vsql_fetch_assoc($res);
    $backup_settings["vpsids"] = unserialize($backup_settings["vpsids"]);
    $res = makequery("SELECT `type` FROM backup_servers \n\t\t\t\t\tWHERE bid = '" . $backup_settings["bid"] . "'");
    $backup_ser = vsql_fetch_assoc($res);
    if(!empty($backup_settings["bid"])) {
        if($backup_ser["type"] == "SSH") {
            $backup_settings["type"] = "SSH";
        } else {
            $backup_settings["type"] = "FTP";
        }
    } else {
        $backup_settings["type"] = "LOCAL";
    }
    if(empty($backup_settings["enabled"])) {
        log_output("Backups are not enabled for this server !");
        return true;
    }
    log_output($l["log_start"]);
    log_output("Storage : " . $GLOBALS["stid"] . " Virt :" . $virt);
    proc_nice((int) $backup_settings["nice"]);
    vexec("/usr/bin/ionice -c " . (int) $backup_settings["ionice_class"] . " -n " . (int) $backup_settings["ionice_prio"] . " -p " . getmypid());
    log_output($l["log_scanning"]);
    $res = makequery("SELECT * FROM `tasks` WHERE action = \"vpsbackups\" ORDER BY actid DESC");
    if(0 < vsql_num_rows($res)) {
        $row = vsql_fetch_assoc($res);
        $prev_process = unserialize($row["data"]);
        if(!empty($prev_process["pid"]) && $prev_process["pid"] != getmypid()) {
            vexec("/bin/ps " . $prev_process["pid"], $output);
            if(1 < count($output)) {
                log_output($l["err_process_running"]);
                exit;
            }
            if($virt != "openvz") {
                log_output($l["log_abortclean"]);
                cleanup_temp_storage($GLOBALS["stid"], $prev_process["lv"], "backup", $virt);
            }
        }
    }
    $res = makequery("SELECT * FROM backup_servers WHERE bid=" . $backup_settings["bid"]);
    $backup_server = vsql_fetch_assoc($res);
    $backup_server["password"] = pass_decrypt($backup_server["password"], $backup_server["salt"]);
    $vs = [];
    $res = makequery("SELECT * FROM vps where serid=0 AND vpsid IN (" . implode(",", $backup_settings["vpsids"]) . ") AND virt='" . $virt . "'");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $vs[] = $row;
    }
    if(empty($vs)) {
        return true;
    }
    $msg = "VID:";
    foreach ($vs as $k => $v) {
        $msg .= " " . $v["vpsid"] . ", ";
    }
    if($backup_settings["type"] != "LOCAL") {
        if($virt != "openvz") {
            log_output($l["log_createtemp_loc"]);
            log_output("Storage : " . $GLOBALS["stid"] . " LV Name :" . $GLOBALS["lvname"]);
            $temp_backup_dir = create_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $backup_settings["vpsids"]);
            if(empty($temp_backup_dir) || !empty($error)) {
                $err = $l["log_err_createtemp_loc"] . "(" . implode(" . ", $error) . ")";
                log_output($err);
                $mail_error_log[] = $err;
                log_output($l["log_cleaning"]);
                cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $virt);
                log_output($l["log_err_cant_proceed"]);
                return false;
            }
        } else {
            $temp_backup_dir = "/vz/dump";
        }
    } elseif($virt == "openvz" || $virt == "vzo") {
        $temp_backup_dir = "/vz/dump";
    }
    log_output("Temp Dir : " . $temp_backup_dir);
    $actid = tasks_admin_process("vpsbackups", @serialize(["lv" => $GLOBALS["lvname"], "pid" => @getmypid()]), 0, 0, $user["uid"], 0, 0);
    task_start($actid);
    log_output($l["log_backup_type"] . $backup_settings["type"]);
    $counter = round(90 / count($vs) / 2);
    $status = $counter + 10;
    if($backup_settings["type"] == "FTP") {
        log_output($l["log_connect"]);
        $ftp_con = connect_ftp($backup_server["hostname"], $backup_server["username"], $backup_server["password"], $backup_server["port"]);
        task_update($actid, $l["log_connect"], 5);
        if(!$ftp_con) {
            log_output($l["log_err_ftp_connect"]);
            $mail_error_log[] = $l["log_err_ftp_connect"];
            cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $virt);
            task_update($actid, $l["log_err_ftp_connect"], -1);
            return false;
        }
        log_output($l["log_create_backup_folder"]);
        task_update($actid, $l["log_create_backup_folder"], 10);
        $backup_folder = create_backup_folders($ftp_con, $backup_settings["dir"], $backup_settings["rotation"]);
        if(empty($backup_folder)) {
            $err = $l["log_err_create_backup_folder"] . "(" . implode(" . ", $error) . ")";
            log_output($err);
            $mail_error_log[] = $err;
            cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $virt);
            task_update($actid, $l["log_err_create_backup_folder"], -1);
            return false;
        }
        foreach ($vs as $k => $v) {
            log_output("[VID:" . $v["vpsid"] . "] " . $l["log_create_backup"] . " [Disk Size: " . $v["space"] . "GB]");
            task_update($actid, "VID: " . $v["vpsid"] . " - " . $l["log_create_backup"] . "", $status);
            $status = $status + $counter;
            $tstart = microtime(true);
            $temp_bk_name = $kernel->backup($v, $temp_backup_dir, $backup_settings["disable_compression"]);
            $tend = microtime(true);
            $elapsed = $tend - $tstart;
            if(empty($temp_bk_name)) {
                $err = "[VID:" . $v["vpsid"] . "] " . $l["log_err_create_backup"] . " (" . implode(" . ", $error) . ")";
                log_output($err);
                $mail_error_log[] = $err;
                $error = [];
            } else {
                log_output("[VID:" . $v["vpsid"] . "] " . $l["log_vps_backup_done"] . ": " . round($elapsed / 60, 1) . " minutes");
                task_update($actid, "[VID:" . $v["vpsid"] . "] " . $l["log_vps_backup_done"] . ": " . round($elapsed / 60, 1) . " minutes", $status);
            }
            $status = $status + $counter;
            $ftp_con = connect_ftp($backup_server["hostname"], $backup_server["username"], $backup_server["password"], $backup_server["port"]);
            if(!$ftp_con) {
                log_output($l["log_err_ftp_connect"]);
                $mail_error_log[] = $l["log_err_ftp_connect"];
            }
            log_output("[VID:" . $v["vpsid"] . "] " . $l["log_upload"]);
            if(!ftp_put($ftp_con, $backup_folder . "/" . $temp_bk_name, $temp_backup_dir . "/" . $temp_bk_name, FTP_BINARY)) {
                $err = "[VID:" . $v["vpsid"] . "] " . $l["log_err_upload"];
                log_output($err);
                $mail_error_log[] = $err;
            }
            if(get_resource_type($ftp_con) == "Unknown") {
                $ftp_con = connect_ftp($backup_server["hostname"], $backup_server["username"], $backup_server["password"], $backup_server["port"]);
            }
            if(!ftp_put($ftp_con, $backup_folder . "/" . $v["vpsid"] . ".inf", $temp_backup_dir . "/" . $v["vpsid"] . ".inf", FTP_BINARY)) {
                $err = "[VID:" . $v["vpsid"] . "] " . $l["log_err_inf_upload"];
                log_output($err);
                $mail_error_log[] = $err;
            }
            $tmp_of_tmp = trim(cleanpath($temp_backup_dir));
            if($tmp_of_tmp == "/" || empty($tmp_of_tmp)) {
                log_output("[VID:" . $v["vpsid"] . "] Temp Dir empty");
                task_update($actid, "[VID:" . $v["vpsid"] . "] Temp Dir empty", -1);
                return false;
            }
            ftp_close($ftp_con);
            vexec("/bin/rm -rf " . $temp_backup_dir . "/*");
            $status = $status + $counter;
        }
        log_output($l["log_cleaning"]);
        cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $virt);
    } elseif($backup_settings["type"] == "RSYNC") {
    } elseif($backup_settings["type"] == "SSH") {
        log_output($l["log_connect"]);
        task_update($actid, $l["log_connect"], 5);
        $connection = ssh2_connect($backup_server["hostname"], $backup_server["port"]);
        if(!ssh2_auth_password($connection, $backup_server["username"], $backup_server["password"])) {
            log_output($l["log_err_ssh_conn"]);
            $mail_error_log[] = $l["log_err_ssh_conn"];
            cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $virt);
            task_update($actid, $l["log_err_ssh_conn"], -1);
            return false;
        }
        $date = @datify(@time(), 0, 1, "Ymd");
        $back_path = $backup_settings["dir"] . "/" . $date;
        $dirlister = get_ssh_backup_list($connection, $backup_settings["dir"]);
        $folders_exist = array_keys($dirlister);
        $folders = $folders_exist;
        if(count($folders_exist) == $backup_settings["rotation"]) {
            $folders_to_delete = [min($folders_exist)];
        } elseif($backup_settings["rotation"] < count($folders_exist)) {
            $folder_delete_count = count($folders_exist) - $backup_settings["rotation"];
            $folder_delete_count++;
            for ($i = 0; $i < $folder_delete_count; $i++) {
                $folders_to_delete[] = min($folders);
                $folders = array_diff($folders_exist, $folders_to_delete);
            }
        }
        log_output("Folders to Delete : ");
        log_output($folders_to_delete);
        foreach ($folders_to_delete as $key => $dir) {
            if(!ssh2_exec($connection, "rm -rf " . xss($backup_settings["dir"] . "/" . $dir))) {
                log_output($l["unable_del_backup_folder"]);
                $mail_error_log[] = $l["unable_del_backup_folder"];
                cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $virt);
                task_update($actid, $l["unable_del_backup_folder"], -1);
                return false;
            }
        }
        if(!ssh2_exec($connection, "mkdir -p " . xss($back_path))) {
            $err = $l["log_err_create_backup_folder"] . "(" . $back_path . ")";
            log_output($err);
            $mail_error_log[] = $err;
            cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $virt);
            task_update($actid, $l["log_err_create_backup_folder"], -1);
            return false;
        }
        task_update($actid, $l["create_backup_folder"], 10);
        ssh2_exec($connection, "exit");
        foreach ($vs as $k => $v) {
            log_output("[VID:" . $v["vpsid"] . "] " . $l["log_create_backup"] . " [Disk Size: " . $v["space"] . "GB]");
            task_update($actid, "[VID:" . $v["vpsid"] . "] " . $l["log_create_backup"] . " [Disk Size: " . $v["space"] . "GB]", $status);
            $status = $status + $counter;
            $tstart = microtime(true);
            $temp_bk_name = $kernel->backup($v, $temp_backup_dir, $backup_settings["disable_compression"]);
            $tend = microtime(true);
            $elapsed = $tend - $tstart;
            if(empty($temp_bk_name)) {
                $err = "[VID:" . $v["vpsid"] . "] " . $l["log_err_create_backup"] . "(" . implode(" . ", $error) . ")";
                log_output($err);
                $mail_error_log[] = $err;
                $error = [];
            } else {
                log_output("[VID:" . $v["vpsid"] . "] " . $l["log_vps_backup_done"] . ": " . round($elapsed / 60, 1) . " minutes");
                task_update($actid, "[VID:" . $v["vpsid"] . "] " . $l["log_vps_backup_done"] . ": " . round($elapsed / 60), $status);
            }
            $status = $status + $counter;
            log_output("[VID:" . $v["vpsid"] . "] " . $l["log_upload"]);
            $connection = ssh2_connect($backup_server["hostname"], $backup_server["port"]);
            if(!ssh2_auth_password($connection, $backup_server["username"], $backup_server["password"])) {
                log_output($l["log_err_ssh_conn"]);
                $mail_error_log[] = $l["log_err_ssh_conn"];
                task_update($actid, $l["log_err_ssh_conn"], -1);
                cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $virt);
                return false;
            }
            if(!ssh2_scp_send($connection, $temp_backup_dir . "/" . $temp_bk_name, $back_path . "/" . $temp_bk_name)) {
                $err = "[VID:" . $v["vpsid"] . "] " . $l["log_err_ssh_send"];
                log_output($err);
                $mail_error_log[] = $err;
            }
            if(!ssh2_scp_send($connection, $temp_backup_dir . "/" . $v["vpsid"] . ".inf", $back_path . "/" . $v["vpsid"] . ".inf")) {
                $err = "[VID:" . $v["vpsid"] . "] " . $l["log_err_inf_upload"];
                log_output($err);
                $mail_error_log[] = $err;
            }
            ssh2_exec($connection, "exit");
            $tmp_of_tmp = trim(cleanpath($temp_backup_dir));
            if($tmp_of_tmp == "/" || empty($tmp_of_tmp)) {
                log_output("[VID:" . $v["vpsid"] . "] Temp Dir empty");
                task_update($actid, "[VID:" . $v["vpsid"] . "] Temp Dir empty", -1);
                return false;
            }
            vexec("/bin/rm -rf " . $temp_backup_dir . "/*");
        }
        log_output($l["log_cleaning"]);
        cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "backup", $virt);
    } elseif($backup_settings["type"] == "LOCAL") {
        log_output($l["log_create_backup_folder"]);
        task_update($actid, $l["log_create_backup_folder"], 10);
        $backup_folder = create_local_backup_folders($backup_settings["dir"], $backup_settings["rotation"]);
        if(empty($backup_folder)) {
            $err = $l["log_err_create_backup_folder"] . " (" . implode(" . ", $error) . ")";
            log_output($err);
            $mail_error_log[] = $err;
            task_update($actid, $l["log_err_create_backup_folder"], -1);
            return false;
        }
        if($virt != "openvz") {
            $temp_backup_dir = $backup_folder;
        }
        foreach ($vs as $k => $v) {
            log_output("[VID:" . $v["vpsid"] . "] " . $l["log_create_backup"] . " [Disk Size: " . $v["space"] . "GB]");
            task_update($actid, "[VID:" . $v["vpsid"] . "] " . $l["log_create_backup"] . " [Disk Size: " . $v["space"] . "GB]", $status);
            $status = $status + $counter;
            $tstart = microtime(true);
            $temp_bk_name = $kernel->backup($v, $temp_backup_dir, $backup_settings["disable_compression"]);
            $tend = microtime(true);
            $elapsed = $tend - $tstart;
            if(empty($temp_bk_name)) {
                $err = "[VID:" . $v["vpsid"] . "] " . $l["log_err_create_backup"] . "(" . implode(" . ", $error) . ")";
                log_output($err);
                $mail_error_log[] = $err;
                $error = [];
            } else {
                log_output("[VID:" . $v["vpsid"] . "] " . $l["log_vps_backup_done"] . ": " . round($elapsed / 60, 1) . " minutes");
                task_update($actid, "[VID:" . $v["vpsid"] . "] " . $l["log_vps_backup_done"] . ": " . round($elapsed / 60, 1) . " minutes", $status);
            }
            $status = $status + $counter;
            if($virt == "openvz") {
                @rename($temp_backup_dir . "/" . $v["vpsid"] . ".tar.gz", $backup_folder . "/" . $v["vpsid"] . ".tar.gz");
                @rename($temp_backup_dir . "/" . $v["vpsid"] . ".inf", $backup_folder . "/" . $v["vpsid"] . ".inf");
                if(file_exists($temp_backup_dir . "/" . $v["vpsid"] . ".tar.gz")) {
                    log_output("[VID:" . $v["vpsid"] . "] " . $l["log_err_local_move_backup"]);
                    $mail_error_log[] = "[VID:" . $v["vpsid"] . "] " . $l["log_err_local_move_backup"];
                }
            }
        }
    }
    if(!empty($mail_error_log)) {
        task_update($actid, implode(". ", array_values($mail_error_log)), -1);
        return false;
    }
    $site_domain = !empty($globals["site_domain"]) && $globals["site_domain"] != $globals["primary_ip"] ? $l["server_domain"] . $globals["site_domain"] : "";
    $site_domain = unhtmlentities($site_domain);
    $mail[0]["to"] = $globals["soft_email"];
    $mail[0]["subject"] = $l["admin_vpsbackups_end_sub"];
    $mail[0]["message"] = lang_vars_name($l["admin_vpsbackups_end_body"], ["sn" => $globals["sn"], "primary_ip" => $globals["primary_ip"], "server_domain" => $site_domain]);
    _mail($mail);
    $script_tend = microtime(true);
    $script_elapsed = $script_tend - $script_tstart;
    log_output($l["log_vps_backup_script_done"] . ": " . round($script_elapsed / 60, 1) . " minutes");
    task_update($actid, $l["log_vps_backup_script_done"] . ": " . round($script_elapsed / 60, 1) . " minutes", 100);
    return true;
}

?>