<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once "inc.php";
global $theme;
global $globals;
global $kernel;
global $user;
global $l;
global $error;
global $cluster;
global $servers;
global $storages;
global $done;
global $virt;
global $hvm;
global $mail_error_log;
global $vpsid;
global $backup_vpsid;
global $backupserver;
global $backup_settings;
global $backup_date;
global $temp_restore_dir;
global $actid;
$script_tstart = microtime(true);
$arguments = getopt("v:d:b::");
if(1 < count($arguments)) {
    $vpsid = $arguments["v"];
    $backup_date = $arguments["d"];
    $backup_vpsid = empty($arguments["b"]) ? $vpsid : $arguments["b"];
    if(!load_lang("admin/vpsbackups")) {
        return false;
    }
    $vps = getvps($vpsid);
    if(empty($vps)) {
        log_output("No VPS Found");
        return false;
    }
    $virt = $vps["virt"];
    $hvm = $vps["hvm"];
    $res = makequery("SELECT * FROM vpsbackup_settings WHERE serid=0");
    $backup_settings = vsql_fetch_assoc($res);
    $bid = $backup_settings["bid"];
    if(!empty($vps["disks"])) {
        $st_uuid = $vps["disks"][0]["st_uuid"];
        foreach ($storages as $sk => $sv) {
            if($sv["st_uuid"] == $st_uuid) {
                $stid = $sk;
            }
        }
    }
    if(empty($stid)) {
        $stid = storage_get_primary($virt);
    }
    if(empty($stid)) {
        $error["no_storage"] = $l["no_storage"];
        return false;
    }
    if(empty($storages[$stid])) {
        log_output("No Storage Found :" . $stid);
        exit;
    }
    log_output("Storage for Restore : " . $stid);
    $GLOBALS["lvname"] = "restore-" . substr($globals["key"], 0, 8);
    $res = makequery("SELECT * FROM backup_servers WHERE bid=" . $bid);
    $backupserver = vsql_fetch_assoc($res);
    $backupserver["password"] = pass_decrypt($backupserver["password"], $backupserver["salt"]);
    if(!empty($backup_settings["bid"])) {
        if($backupserver["type"] == "SSH") {
            $backup_settings["type"] = "SSH";
        } else {
            $backup_settings["type"] = "FTP";
        }
    } else {
        $backup_settings["type"] = "LOCAL";
    }
    log_output($l["log_start"] . " [VID:" . $vps["vpsid"] . "]");
    $res = makequery("SELECT * FROM `tasks` WHERE action = \"restorevps\"");
    if(0 < vsql_num_rows($res)) {
        $row = vsql_fetch_assoc($res);
        $prev_process = unserialize($row["data"]);
        $prev_lv = $prev_process["lv"];
        vexec("/bin/ps " . $prev_process["pid"], $output);
        if(1 < count($output)) {
            log_output($l["err_process_running"]);
            exit;
        }
        log_output($l["log_abortclean"]);
        cleanup_temp_storage($GLOBALS["stid"], $prev_lv, "restore", $virt);
    }
    proc_nice(19);
    vexec("/usr/bin/ionice -c 3 -n 1 -p " . getmypid());
    log_output($l["log_restore_type"] . $backup_settings["type"]);
    $result = restorevps($backup_settings["type"]);
    log_output($l["log_cleaning"]);
    task_update($actid, $l["log_cleaning"], 95);
    if($backup_settings["type"] == "FTP" || $backup_settings["type"] == "SSH") {
        cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "restore", $virt);
    }
    if(!$result) {
        $mail[0]["to"] = $globals["soft_email"];
        $mail[0]["subject"] = $l["admin_vpsrestore_err_sub"];
        $mail[0]["message"] = lang_vars_name($l["admin_vpsrestore_err_body"], ["sn" => $globals["sn"], "error_log" => $mail_error_log]);
        _mail($mail);
        log_output($l["log_err_end"]);
        task_update($actid, $l["log_err_end"], -1);
    } else {
        if($result) {
            $mail[0]["to"] = $globals["soft_email"];
            $mail[0]["subject"] = $l["admin_vpsrestore_end_sub"];
            $mail[0]["message"] = lang_vars_name($l["admin_vpsrestore_end_body"], ["vpsid" => "VID: " . $vpsid, "sn" => $globals["sn"]]);
            _mail($mail);
        }
        $script_tend = microtime(true);
        $script_elapsed = $script_tend - $script_tstart;
        log_output($l["log_vps_restore_script_done"] . ": " . round($script_elapsed / 60, 1) . " minutes");
        task_update($actid, $l["log_end"], 100);
        if(!empty($error)) {
            echo "Errors: \n";
            r_print($error);
        }
        if(defined("debug")) {
            r_print($GLOBALS["logr"]);
        }
    }
} else {
    $err = "Missing mandatory arguments.\nUsage: /usr/local/emps/bin/php /usr/local/virtualizor/scripts/restorevps.php -v<vpsid> -d<backup-date> [ -b<backup-vpsid> ]";
    exit($err);
}
function restorevps($type)
{
    global $l;
    global $error;
    global $mail_error_log;
    global $vpsid;
    global $backup_vpsid;
    global $backupserver;
    global $backup_settings;
    global $backup_date;
    global $temp_restore_dir;
    global $kernel;
    global $virt;
    global $temp_bak_name;
    global $actid;
    global $user;
    global $vps;
    global $cluster;
    $actid = tasks_admin_process("restorevps", @serialize(["lv" => $GLOBALS["lvname"], "pid" => @getmypid()]), 0, $vpsid, $user["uid"], 0, 0);
    task_start($actid);
    if($type == "FTP" || $type == "SSH") {
        if($virt != "openvz") {
            log_output($l["log_createtemp_loc"]);
            task_update($actid, $l["log_createtemp_loc"], 10);
            $temp_restore_dir = create_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "restore", $vpsid);
            if(empty($temp_restore_dir)) {
                $err = $l["log_err_createtemp_loc"] . "(" . implode(" . ", $error) . ")";
                log_output($err);
                $mail_error_log[] = $err;
                log_output($l["log_cleaning"]);
                task_update($actid, $l["log_err_createtemp_loc"], -1);
                cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "restore", $virt);
                log_output($l["log_err_cant_proceed"]);
                return false;
            }
        } else {
            $temp_restore_dir = "/vz/dump";
        }
    } elseif($virt == "openvz") {
        $temp_restore_dir = "/vz/dump";
    }
    if($type == "FTP") {
        log_output($l["log_connect"]);
        task_update($actid, $l["log_connect"], 20);
        $ftp_con = connect_ftp($backupserver["hostname"], $backupserver["username"], $backupserver["password"], $backupserver["port"]);
        if(!$ftp_con) {
            log_output($l["log_err_ftp_connect"]);
            $mail_error_log[] = $l["log_err_create_restore_ftp_connect"];
            task_update($actid, $l["log_err_ftp_connect"], -1);
            return false;
        }
        log_output($l["log_download"]);
        task_update($actid, $l["log_download"], 30);
        $rem_file_list = _ftp_nlist($ftp_con, $backup_settings["dir"] . "/" . $backup_date);
        $extensions = get_backup_extensions($vps["virt"]);
        foreach ($extensions as $ext) {
            if(in_array($backup_settings["dir"] . "/" . $backup_date . "/" . $backup_vpsid . "." . $ext, $rem_file_list)) {
                $temp_bak_name = $backup_vpsid . "." . $ext;
                log_output("Downloading : " . $temp_bak_name);
                task_update($actid, "Downloading : " . $temp_bak_name, 40);
                if(!@ftp_get($ftp_con, $temp_restore_dir . "/" . $temp_bak_name, $backup_settings["dir"] . "/" . $backup_date . "/" . $temp_bak_name, FTP_BINARY)) {
                    log_output($l["log_err_download"]);
                    $mail_error_log[] = $l["log_err_download"];
                    task_update($actid, $l["log_err_download"], -1);
                    return false;
                }
            }
        }
    } elseif($type == "SSH") {
        task_update($actid, $l["log_connect"], 20);
        $connection = ssh2_connect($backupserver["hostname"], $backupserver["port"]);
        if(!ssh2_auth_password($connection, $backupserver["username"], $backupserver["password"])) {
            log_output($l["log_err_ssh_conn"]);
            $mail_error_log[] = $l["log_err_ssh_conn"];
            task_update($actid, $l["log_err_ssh_conn"], -1);
            return false;
        }
        $sftp = ssh2_sftp($connection);
        $back_dir = opendir("ssh2.sftp://" . intval($sftp) . $backup_settings["dir"] . "/" . $backup_date . "");
        $extensions = get_backup_extensions($vps["virt"]);
        task_update($actid, $l["log_download"], 30);
        while (($backup_file = readdir($back_dir)) !== false) {
            foreach ($extensions as $ext) {
                if($backup_file == $backup_vpsid . "." . $ext) {
                    $temp_bak_name = $backup_file;
                }
            }
        }
        task_update($actid, "Downloading : " . $temp_bak_name, 40);
        log_output("Downloading : " . $temp_bak_name);
        if(!ssh2_scp_recv($connection, $backup_settings["dir"] . "/" . $backup_date . "/" . $temp_bak_name, $temp_restore_dir . "/" . $temp_bak_name)) {
            log_output("From : " . $backup_settings["dir"] . "/" . $backup_date . "/" . $temp_bak_name . " And To : " . $temp_restore_dir . "/" . $temp_bak_name);
            log_output($l["log_err_download"]);
            $mail_error_log[] = $l["log_err_download"];
            task_update($actid, $l["log_err_download"], -1);
            return false;
        }
    } elseif($type == "LOCAL") {
        $extensions = get_backup_extensions($vps["virt"]);
        $file_list = filelist($backup_settings["dir"] . "/" . $backup_date, 0);
        foreach ($file_list as $file => $fileinfo) {
            $file_parts = pathinfo($file);
            foreach ($extensions as $ext) {
                if($file_parts["basename"] == $backup_vpsid . "." . $ext) {
                    $temp_bak_name = $file_parts["basename"];
                }
            }
        }
        task_update($actid, $l["chck_local_backup"], 50);
        $temp_restore_dir = $backup_settings["dir"] . "/" . $backup_date;
    }
    log_output($l["log_restore"] . " [VID:" . $vps["vpsid"] . "]");
    task_update($actid, $l["log_restore"] . " [VID:" . $vps["vpsid"] . "]", 60);
    $tstart = microtime(true);
    if(!$kernel->restore($vps, $temp_restore_dir, $temp_bak_name)) {
        $err = $l["log_err_create_restore"] . " [VID:" . $vps["vpsid"] . "] " . "(" . implode(" . ", $error) . ")";
        log_output($err);
        cleanup_temp_storage($GLOBALS["stid"], $GLOBALS["lvname"], "restore", $virt);
        $mail_error_log = $err;
        task_update($actid, $l["log_err_create_restore"] . " [VID:" . $vps["vpsid"] . "] ", -1);
        return false;
    }
    if(!$cluster->editvps($vps["vpsid"])) {
        task_update_echo($actid, $l["err_couldnt_edit"], -1);
        return false;
    }
    if($kernel->features("build_dhcp", $vps["virt"])) {
        $cluster->build_dhcp(0);
    }
    if(empty($vps["suspended"])) {
        $start_log = $cluster->startvps(0, $vps["vpsid"]);
    }
    $tend = microtime(true);
    $elapsed = $tend - $tstart;
    task_update($actid, $l["log_vps_restore_done"] . ": " . round($elapsed / 60, 1) . " minutes", 90);
    log_output($l["log_vps_restore_done"] . ": " . round($elapsed / 60, 1) . " minutes");
    return true;
}

?>