<div class="card">
    <div class="card-header">
        <h3>User Verification</h3>
    </div>
    <div class="card-body">
        {if $message}
            <div class="alert alert-{$messageType}">{$message}</div>
        {/if}


        <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
<script src="https://unpkg.com/persian-date@1.1.0/dist/persian-date.min.js"></script>
<script src="https://unpkg.com/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>


        <!-- Progress Bar -->
        <div class="progress mb-4">
            <div class="progress-bar {if $userLevel == 1}bg-primary{elseif $userLevel > 1}bg-success{else}bg-secondary{/if}" role="progressbar" style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" title="Mobile Not Authenticated">1</div>
            <div class="progress-bar {if $userLevel == 2}bg-primary{elseif $userLevel > 2}bg-success{else}bg-secondary{/if}" role="progressbar" style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" title="Mobile Authenticated">2</div>
            <div class="progress-bar {if $userLevel == 3}bg-primary{elseif $userLevel > 3}bg-success{else}bg-secondary{/if}" role="progressbar" style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" title="National Code Verified">3</div>
            <div class="progress-bar {if $userLevel == 4}bg-primary{elseif $userLevel > 4}bg-success{else}bg-secondary{/if}" role="progressbar" style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" title="ID & Birthday Verified">4</div>
            <div class="progress-bar {if $userLevel == 5}bg-success{else}bg-secondary{/if}" role="progressbar" style="width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100" title="Information Updated">5</div>
        </div>
        
        <!-- Level Description -->
        <div class="mb-4">
            <h5>Verification Status: Level {$userLevel}</h5>
            <p>
                {if $userLevel == 1}
                    Your mobile number needs to be verified.
                {elseif $userLevel == 2}
                    Your mobile number is verified. Next step: Verify national code ownership.
                {elseif $userLevel == 3}
                    National code and mobile verified. Next step: Verify ID and birthday.
                {elseif $userLevel == 4}
                    ID and birthday verified. Next step: Complete information update.
                {elseif $userLevel == 5}
                    <span class="text-success"><i class="fas fa-check-circle"></i> Your verification is complete!</span>
                {/if}
            </p>
        </div>
        
        <!-- Level 1-2: Mobile Verification -->
        {if $userLevel <= 1}
            <div class="row">
                <!-- Step 1: Enter Mobile Number -->
                {if $userLevel == 1 && (!$mobileNumber || $editMode)}
                    <div class="col-md-12 mb-4">
                        <div class="card">
                            <div class="card-header bg-primary text-white">
                                <h4>Step 1: Enter Your Mobile Number</h4>
                            </div>
                            <div class="card-body">
                                <form method="post" action="{$modulelink}&action=verify">
                                    <div class="form-group">
                                        <label for="mobile_number">Mobile Number</label>
                                        <input type="text" class="form-control" id="mobile_number" name="mobile_number" value="{$mobileNumber}" placeholder="Enter your mobile number" required>
                                        <small class="form-text text-muted">Format: 09XXXXXXXXX</small>
                                    </div>
                                    <button type="submit" name="save_mobile" class="btn btn-primary">Save & Continue</button>
                                </form>
                            </div>
                        </div>
                    </div>
                {/if}
                
                <!-- Mobile Verification (Request & Enter Code) -->
                {if $userLevel == 1}
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header bg-primary text-white">
                                <h4>Step 2: Request Verification Code</h4>
                            </div>
                            <div class="card-body">
                                <p>We will send a verification code to: <strong>{$mobileNumber}</strong></p>
                                <form method="post" action="{$modulelink}&action=verify">
                                    <button type="submit" name="request_code" id="resendButton" class="btn btn-primary btn-block" {if $cooldownActive}disabled{/if}>
                                        {if $cooldownActive}
                                            Send Code (<span id="countdown">{$remainingSeconds}</span>s)
                                        {else}
                                            Send Verification Code
                                        {/if}
                                    </button>
                                 </form>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header bg-primary text-white">
                                <h4>Step 3: Enter Verification Code</h4>
                            </div>
                            <div class="card-body">
                                <p>Enter the code sent to your mobile</p>
                                <form method="post" action="{$modulelink}&action=verify">
                                    <div class="form-group">
                                        <label for="verification_code">Verification Code</label>
                                        <input type="text" class="form-control" id="verification_code" name="verification_code" placeholder="Enter the code" required>
                                    </div>
                                    <button type="submit" name="verify_code" class="btn btn-success btn-block">
                                        Verify Code
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                {/if}
            </div>
        {/if}
        
        <!-- Level 2-3: National Code Verification -->
        {if $userLevel == 2}
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h4>Verify National Code Ownership</h4>
                </div>
                <div class="card-body">
                    <p>Please enter your national code to verify it matches your mobile number.</p>
                    {$APIResultShahkar}
                    <form method="post" action="{$modulelink}&action=verify">
                        <div class="form-group">
                            <label for="national_code">National Code</label>
                            <input type="text" class="form-control" id="national_code" name="national_code" value="{$nationalCode}" placeholder="Enter your national code" required>
                        </div>
                        <button type="submit" name="verify_national_code" class="btn btn-primary">Verify National Code</button>
                    </form>
                </div>
            </div>
        {/if}
        
        <!-- Level 3-4: ID and Birthday Verification -->
        {if $userLevel == 3}
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h4>Verify ID and Birthday</h4>
                </div>
                <div class="card-body">
                    <p>Please enter your ID document number and birthday for verification.</p>
                    <form method="post" action="{$modulelink}&action=verify">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="id_number">ID Document Number</label>
                                    <input type="text" class="form-control" id="id_number" name="id_number" placeholder="Enter your ID number" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="birthday">Birthday</label>

<input type="text" class="form-control" id="birthday" name="birthday" placeholder="انتخاب تاریخ تولد" readonly required>
<input type="hidden" id="birthday_gregorian" name="birthday_gregorian">
<script>
    $(document).ready(function() {
        $("#birthday").pDatepicker({
            format: 'YYYY/MM/DD',
            autoClose: true,
            initialValue: false,
            onSelect: function(unix) {
                // Convert to Gregorian date for server-side processing
                var date = new persianDate(unix);
                var gregorianDate = date.toCalendar('gregorian').format('YYYY-MM-DD');
                $('#birthday_gregorian').val(gregorianDate);
            }
        });
    });
</script>


                                </div>
                            </div>
                        </div>
                        <button type="submit" name="verify_id_birthday" class="btn btn-primary">Verify Information</button>
                    </form>
                </div>
            </div>
        {/if}
        
        <!-- Level 4-5: Complete Information Update -->
        {if $userLevel == 4}
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h4>Complete Information Update</h4>
                </div>
                <div class="card-body">
                    <p>
                        <img id="imageLoading" src="/modules/addons/userverification/assets/image/loading.gif" />
                            لطفا اندکی صبر نمایید 
                    </p>
                    <p id="result">
                        در حال بررسی اطلاعات
                    </p>
                        <button onclick="VerifyUser()"  class="btn btn-primary">Check My Information</button>
                </div>
            </div>

<style>
    #imageLoading {
        vertical-align: middle;
        margin-right: 10px;
        display: inline-block;
        max-height: 60px;
        }</style>
            <script>
                function VerifyUser() {
                    const resultDiv = document.getElementById('result');
                    resultDiv.innerHTML = ''; // clear
              
                    fetch("/modules/addons/userverification/verify.php").then(response => {
                      const reader = response.body.getReader();
                      const decoder = new TextDecoder("utf-8");
              
                      function read() {
                        reader.read().then(({ done, value }) => {
                          if (done) {
                           // window.location.reload();
                           return;
                          }
                          const chunk = decoder.decode(value, { stream: true });
                          resultDiv.insertAdjacentHTML("beforeend", chunk);
                          read();
                        });
                      }
              
                      read();
                    });
                  }
            </script>
        {/if}
        
        <!-- Level 5: Verification Complete -->
        {if $userLevel == 5}
            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    <h4><i class="fas fa-check-circle"></i> Verification Complete</h4>
                </div>
                <div class="card-body">
                    <div class="alert alert-success">
                        <p>Your account has been fully verified. Thank you!</p>
                        <p>Mobile: <strong>{$mobileNumber}</strong></p>
                        <p>National Code: <strong>{$nationalCode}</strong></p>
                    </div>
                </div>
            </div>
        {/if}
    </div>
</div>

<!-- Countdown Script -->

<script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function() {
        var countdownElement = document.getElementById('countdown');
        var resendButton = document.getElementById('resendButton');
        var remainingSeconds = {$remainingSeconds};
        
        function updateCountdown() {
            if (remainingSeconds <= 0) {
                resendButton.disabled = false;
                resendButton.innerHTML = 'Send Verification Code';
                clearInterval(countdownInterval);
            } else {
                countdownElement.textContent = remainingSeconds;
                remainingSeconds--;
            }
        }
        var countdownInterval = setInterval(updateCountdown, 1000);
        updateCountdown();
    });
</script>

