{if $message}
    <div class="alert alert-{$messageType}">
        {$message}
    </div>
{/if}

<!-- Edit/Add Form -->
<div class="card mb-4">
    <div class="card-header">
        <h3>{if $editRecord}Edit Record{else}Add New Record{/if}</h3>
    </div>
    <div class="card-body">
        <form method="post" action="{$modulelink}">
            <input type="hidden" name="action" value="{if $editRecord}update{else}add{/if}">
            {if $editRecord}
                <input type="hidden" name="id" value="{$editRecord.id}">
            {/if}
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="user_id">User ID</label>
                        <input type="number" class="form-control" id="user_id" name="user_id" 
                               value="{if $editRecord}{$editRecord.user_id}{/if}" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="card_number">Card Number</label>
                        <input type="text" class="form-control" id="card_number" name="card_number" 
                               value="{if $editRecord}{$editRecord.card_number}{/if}" required>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="mobile_number">Mobile Number</label>
                        <input type="text" class="form-control" id="mobile_number" name="mobile_number" 
                               value="{if $editRecord}{$editRecord.mobile_number}{/if}" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="national_code">National Code</label>
                        <input type="text" class="form-control" id="national_code" name="national_code" 
                               value="{if $editRecord}{$editRecord.national_code}{/if}" required>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="verification_status">Status</label>
                        <select class="form-control" id="verification_status" name="verification_status" required>
                            <option value="pending" {if $editRecord && $editRecord.verification_status == 'pending'}selected{/if}>Pending</option>
                            <option value="verified" {if $editRecord && $editRecord.verification_status == 'verified'}selected{/if}>Verified</option>
                            <option value="failed" {if $editRecord && $editRecord.verification_status == 'failed'}selected{/if}>Failed</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <button type="submit" class="btn btn-primary">
                {if $editRecord}Update Record{else}Add Record{/if}
            </button>
            {if $editRecord}
                <a href="{$modulelink}" class="btn btn-secondary">Cancel</a>
            {/if}
        </form>
    </div>
</div>

<!-- Search Form -->
<div class="card mb-4">
    <div class="card-header">
        <h3>Search Records</h3>
    </div>
    <div class="card-body">
        <form method="get" action="{$modulelink}">
            <input type="hidden" name="m" value="UserVerification">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="search_user_id">User ID</label>
                        <input type="number" class="form-control" id="search_user_id" name="search_user_id" 
                               value="{$searchUserId}" placeholder="Enter User ID">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="search_card_number">Card Number</label>
                        <input type="text" class="form-control" id="search_card_number" name="search_card_number" 
                               value="{$searchCardNumber}" placeholder="Enter Card Number">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-info">Search</button>
                            <a href="{$modulelink}" class="btn btn-secondary">Clear</a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Records List -->
<div class="card">
    <div class="card-header">
        <h3>User Verification Records ({$totalRecords} total)</h3>
    </div>
    <div class="card-body">
        {if $records}
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User ID</th>
                            <th>Card Number</th>
                            <th>Mobile</th>
                            <th>National Code</th>
                            <th>Status</th>
                            <th>Date Added</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $records as $record}
                            <tr>
                                <td>{$record.id}</td>
                                <td>{$record.user_id}</td>
                                <td>{$record.card_number_masked}</td>
                                <td>{$record.mobile_number}</td>
                                <td>{$record.national_code}</td>
                                <td>
                                    <span class="badge badge-{$record.status_class}">
                                        {$record.verification_status|ucfirst}
                                    </span>
                                </td>
                                <td>{$record.date_added}</td>
                                <td>
                                    <a href="{$modulelink}&edit_id={$record.id}" class="btn btn-sm btn-warning">Edit</a>
                                    <form method="post" action="{$modulelink}" style="display:inline;" 
                                          onsubmit="return confirm('Are you sure you want to delete this record?');">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="id" value="{$record.id}">
                                        <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            {if $totalPages > 1}
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center">
                        {if $currentPage > 1}
                            <li class="page-item">
                                <a class="page-link" href="{$modulelink}&page={$currentPage-1}&search_user_id={$searchUserId}&search_card_number={$searchCardNumber}">Previous</a>
                            </li>
                        {/if}
                        
                        {for $i=1 to $totalPages}
                            <li class="page-item {if $i == $currentPage}active{/if}">
                                <a class="page-link" href="{$modulelink}&page={$i}&search_user_id={$searchUserId}&search_card_number={$searchCardNumber}">{$i}</a>
                            </li>
                        {/for}
                        
                        {if $currentPage < $totalPages}
                            <li class="page-item">
                                <a class="page-link" href="{$modulelink}&page={$currentPage+1}&search_user_id={$searchUserId}&search_card_number={$searchCardNumber}">Next</a>
                            </li>
                        {/if}
                    </ul>
                </nav>
            {/if}
        {else}
            <div class="alert alert-info">
                No records found.
            </div>
        {/if}
    </div>
</div>