<?php
use WHMCS\Database\Capsule;
// if (!defined("WHMCS")) {
//     die("This file cannot be accessed directly");
// }

function whmcsreseller_MetaData()
{
    return array(
        'DisplayName' => 'KelonCloud Server Reseller Based On Hourly Payment',
        'APIVersion' => '1.1',
        'RequiresServer' => true,
        'DefaultSSLPort' => '443',
    );
}
function whmcsreseller_ReturnResellerAccount()
{
    $whmcsresellers = Capsule::table('tblservers')
        ->where('type', 'whmcsreseller')
        ->first();

    $apikey = $whmcsresellers->accesshash;
    $username = $whmcsresellers->username;
    $password = $whmcsresellers->password;
    $command = 'DecryptPassword';
    $postData = array(
        'password2' => $password,
    );

    $results = localAPI($command, $postData);
    return [
        "apikey" => $apikey,
        "username" => $username,
        "password" => $results["password"]
    ];
}
function whmcsreseller_GetProductList()
{
    $info = whmcsreseller_ReturnResellerAccount();
    $response = whmcsreseller_Requests(
        "/products/get/",
        ["apikey" => $info["apikey"]],
        [
            "username" => $info["username"],
            "password" => $info["password"]
        ]
    );
    return $response;
}
function whmcsreseller_ConfigOptions()
{
    $productList = whmcsreseller_GetProductList();
    $products = [];
    foreach ($productList["products"] as $p) {
        $products[$p["id"]] = "(" . $p["groupname"] . ")" . $p["name"];
    }


    return array(
        // a text field type allows for single line text input
        'Product Type' => array(
            'Type' => 'dropdown',
            'Options' => array(
                'option1' => 'KelonCloud Account',
                'option2' => 'My Account',
            ),
            'Description' => 'Choose Your Service Creation Source',
        ),
        'Select Your Product' => array(
            'Type' => 'dropdown',
            'Options' => $products,
            'Description' => 'Choose one',
        ),
    );
}

function whmcsreseller_CreateAccount(array $params)
{
    try {
        // Call the service's provisioning function, using the values provided
        // by WHMCS in `$params`.
        //
        // A sample `$params` array may be defined as:
        //
        // ```
        // array(
        //     'domain' => 'The domain of the service to provision',
        //     'username' => 'The username to access the new service',
        //     'password' => 'The password to access the new service',
        //     'configoption1' => 'The amount of disk space to provision',
        //     'configoption2' => 'The new services secret key',
        //     'configoption3' => 'Whether or not to enable FTP',
        //     ...
        // )
        // ```
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}
function whmcsreseller_SuspendAccount(array $params)
{
    try {
        // Call the service's suspend function, using the values provided by
        // WHMCS in `$params`.
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}

function whmcsreseller_UnsuspendAccount(array $params)
{
    try {
        // Call the service's unsuspend function, using the values provided by
        // WHMCS in `$params`.
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}

function whmcsreseller_TerminateAccount(array $params)
{
    try {
        // Call the service's terminate function, using the values provided by
        // WHMCS in `$params`.
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}

function whmcsreseller_ChangePassword(array $params)
{
    try {
        // Call the service's change password function, using the values
        // provided by WHMCS in `$params`.
        //
        // A sample `$params` array may be defined as:
        //
        // ```
        // array(
        //     'username' => 'The service username',
        //     'password' => 'The new service password',
        // )
        // ```
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}

function whmcsreseller_ChangePackage(array $params)
{
    try {
        // Call the service's change password function, using the values
        // provided by WHMCS in `$params`.
        //
        // A sample `$params` array may be defined as:
        //
        // ```
        // array(
        //     'username' => 'The service username',
        //     'configoption1' => 'The new service disk space',
        //     'configoption3' => 'Whether or not to enable FTP',
        // )
        // ```
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}

function whmcsreseller_Renew(array $params)
{
    try {
        // Call the service's provisioning function, using the values provided
        // by WHMCS in `$params`.
        //
        // A sample `$params` array may be defined as:
        //
        // ```
        // array(
        //     'domain' => 'The domain of the service to provision',
        //     'username' => 'The username to access the new service',
        //     'password' => 'The password to access the new service',
        //     'configoption1' => 'The amount of disk space to provision',
        //     'configoption2' => 'The new services secret key',
        //     'configoption3' => 'Whether or not to enable FTP',
        //     ...
        // )
        // ```
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}
function whmcsreseller_TestConnection(array $params)
{
    $validAPIHostname = ["cl.keloncloud.com", "api.keloncloud.com", "reseller.keloncloud.com"];
    if (!in_array($params["serverhostname"], $validAPIHostname)) {
        return array(
            'success' => false,
            'error' => "Hostname  is invalid"
        );
    }
    $username = $params["serverusername"];
    $password = $params["serverpassword"];
    $token = $params["serveraccesshash"];
    $ApiResult = whmcsreseller_Requests(
        "/server/get/",
        ["apikey" => $token],
        ["username" => $username, "password" => $password]
    );


    try {
        if ($ApiResult["status"] == "success") {
            return array(
                'success' => true
            );
        } else {
            return array(
                'success' => false,
                'error' => $ApiResult["message"]
            );
        }

    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        $success = false;
        $errorMsg = $e->getMessage();
    }

    return array(
        'success' => $success,
        'error' => $errorMsg,
    );
}

function whmcsreseller_AdminCustomButtonArray()
{
    return array(
        "Button 1 Display Value" => "buttonOneFunction",
        "Button 2 Display Value" => "buttonTwoFunction",
    );
}
function whmcsreseller_ClientAreaCustomButtonArray()
{
    return array(
        "Action 1 Display Value" => "actionOneFunction",
        "Action 2 Display Value" => "actionTwoFunction",
    );
}

function whmcsreseller_buttonOneFunction(array $params)
{
    try {
        // Call the service's function, using the values provided by WHMCS in
        // `$params`.
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}

function whmcsreseller_actionOneFunction(array $params)
{
    try {
        // Call the service's function, using the values provided by WHMCS in
        // `$params`.
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}

function whmcsreseller_AdminServicesTabFields(array $params)
{
    try {
        // Call the service's function, using the values provided by WHMCS in
        // `$params`.
        $response = array();

        // Return an array based on the function's response.
        return array(
            'Number of Apples' => (int) $response['numApples'],
            'Number of Oranges' => (int) $response['numOranges'],
            'Last Access Date' => date("Y-m-d H:i:s", $response['lastLoginTimestamp']),
            'Something Editable' => '<input type="hidden" name="whmcsreseller_original_uniquefieldname" '
                . 'value="' . htmlspecialchars($response['textvalue']) . '" />'
                . '<input type="text" name="whmcsreseller_uniquefieldname"'
                . 'value="' . htmlspecialchars($response['textvalue']) . '" />',
        );
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        // In an error condition, simply return no additional fields to display.
    }

    return array();
}

function whmcsreseller_AdminServicesTabFieldsSave(array $params)
{
    // Fetch form submission variables.
    $originalFieldValue = isset($_REQUEST['whmcsreseller_original_uniquefieldname'])
        ? $_REQUEST['whmcsreseller_original_uniquefieldname']
        : '';

    $newFieldValue = isset($_REQUEST['whmcsreseller_uniquefieldname'])
        ? $_REQUEST['whmcsreseller_uniquefieldname']
        : '';

    // Look for a change in value to avoid making unnecessary service calls.
    if ($originalFieldValue != $newFieldValue) {
        try {
            // Call the service's function, using the values provided by WHMCS
            // in `$params`.
        } catch (Exception $e) {
            // Record the error in WHMCS's module log.
            logModuleCall(
                'whmcsreseller',
                __FUNCTION__,
                $params,
                $e->getMessage(),
                $e->getTraceAsString()
            );

            // Otherwise, error conditions are not supported in this operation.
        }
    }
}

function whmcsreseller_ServiceSingleSignOn(array $params)
{
    try {
        // Call the service's single sign-on token retrieval function, using the
        // values provided by WHMCS in `$params`.
        $response = array();

        return array(
            'success' => true,
            'redirectTo' => $response['redirectUrl'],
        );
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return array(
            'success' => false,
            'errorMsg' => $e->getMessage(),
        );
    }
}
function whmcsreseller_AdminSingleSignOn(array $params)
{
    try {
        // Call the service's single sign-on admin token retrieval function,
        // using the values provided by WHMCS in `$params`.
        $response = array();

        return array(
            'success' => true,
            'redirectTo' => $response['redirectUrl'],
        );
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return array(
            'success' => false,
            'errorMsg' => $e->getMessage(),
        );
    }
}

function whmcsreseller_ClientArea(array $params)
{
    // Determine the requested action and set service call parameters based on
    // the action.
    $requestedAction = isset($_REQUEST['customAction']) ? $_REQUEST['customAction'] : '';

    if ($requestedAction == 'manage') {
        $serviceAction = 'get_usage';
        $templateFile = 'templates/manage.tpl';
    } else {
        $serviceAction = 'get_stats';
        $templateFile = 'templates/overview.tpl';
    }

    try {
        // Call the service's function based on the request action, using the
        // values provided by WHMCS in `$params`.
        $response = array();

        $extraVariable1 = 'abc';
        $extraVariable2 = '123';

        return array(
            'tabOverviewReplacementTemplate' => $templateFile,
            'templateVariables' => array(
                'extraVariable1' => $extraVariable1,
                'extraVariable2' => $extraVariable2,
            ),
        );
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'whmcsreseller',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        // In an error condition, display an error page.
        return array(
            'tabOverviewReplacementTemplate' => 'error.tpl',
            'templateVariables' => array(
                'usefulErrorHelper' => $e->getMessage(),
            ),
        );
    }
}
function whmcsreseller_Requests($url, $header, $data)
{
    $ips = whmcsreseller_GetIPS();
    if ($ips["status"] == "error") {
        return ["status" => "error", "message" => "Error in connection to server"];
    }
    $RHeader = [];
    foreach ($header as $h => $p) {
        $RHeader[] = $h . ": " . $p;
    }
    $RHeader[] = "domain: " . $_SERVER["HTTP_HOST"];
    $RHeader[] = "HOST: cl.keloncloud.com";
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://cl.keloncloud.com/modules/addons/WHMCSResellers/api" . $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => $RHeader,
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    return json_decode($response, true);
}
function whmcsreseller_GetIPS()
{
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://info.centraldnshost.com/whmcsreseller/api/server/ip/',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_HTTPHEADER => array(
            'Content-Length: 0',
            'authkey: 68a2b042e22b892906af2ac246230ee904647e7eee0e1e11b8b00a9e709b1eac'
        ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $responses = json_decode($response, true);
    if ($responses["status"] == "success") {
        return ["status" => "success", "ips" => $responses["ips"]];
    } else {
        return ["status" => "error"];
    }
}



