<?php

use WHMCS\Database\Capsule;

require_once(__DIR__ . '/../../../init.php');
header('Content-Type: application/json; charset=utf-8');
if (!isset($_SESSION['adminid'])) {
    echo 'access denied!';
} else {
    if (isset($_POST["action"])) {
        $functionName = "WHMCSResellers_" . $_POST["action"];
        //show output of function based on posted action
        if (function_exists($functionName)) {
            $output = $functionName();
            echo json_encode($output);
        } else {
            echo json_encode(["status" => "error", "message" => "action is invalid"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "request is not valid"]);
        die();
    }
}

function WHMCSResellers_UserModification()
{
    //1- Check User Exist OR  not
    $user_id = $_POST["userid"];
    $user = Capsule::table('tblclients')->where('id', '=', $user_id);
    if ($user->exists()) {
        //2- check User is in resellers table
        $reseller = Capsule::table('mod_WHMCSResellers')->where('userid', '=', $user_id);
        if ($reseller->exists()) {
            //3- if user exist update data in to db
            $reseller = Capsule::table('mod_WHMCSResellers')->where('userid', '=', $user_id)->update([
                'status' => $_POST["status"],
                'credit' => $_POST["credit"],
                'apikey' => $_POST["apikey"],
                'domain' => $_POST["domain"],
                'updated_at' => date("Y-m-d H:i:s")
            ]);
            return ["status" => "success", "message" => "user updated", "data" => $_POST];
        } else {
            //3- if user not exist generate apikey and insert to db
            $reseller = Capsule::table('mod_WHMCSResellers')->insert([
                'userid' => $user_id,
                'credit' => $_POST["credit"],
                'status' => $_POST["status"],
                'domain' => $_POST["domain"],
                'apikey' => WHMCSResellers_GenrateAPIKey(),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s")
            ]);
            return ["status" => "success", "message" => "user added to resellers", "data" => $_POST];
        }
    } else {
        return ["status" => "error", "message" => "user not found"];
    }
}
function WHMCSResellers_GenrateAPIKey()
{
    $stringHash = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    $apikey = substr(str_shuffle($stringHash), 0, 32);
    return "WHMCSResellerLeased-" . $apikey;
}

function WHMCSResellers_ProductModification()
{
    $product_id = $_POST["prid"]; // product id
    $product = Capsule::table('tblproducts')->where('id', '=', $product_id);
    if ($product->exists()) {
        $reseller_product = Capsule::table('mod_WHMCSResellers_products')->where(
            "product_id",
            "=",
            $product_id
        );
        if ($reseller_product->exists()) {
            $reseller_product = Capsule::table('mod_WHMCSResellers_products')->where(
                "product_id",
                "=",
                $product_id
            )->update([
                'minimum_balance' => $_POST["minimumbalance"],
                'service_amount' => $_POST["serviceprice"],
                'traffic_amount' => $_POST["trafficamount"],
                'free_traffic' => $_POST["freetraffic"],
                'traffic_type' => $_POST["trtypes"],
                'updated_at' => date("Y-m-d H:i:s")
            ]);
            return ["status" => "success", "message" => "product updated", "data" => $_POST];
        } else {
            $reseller_product = Capsule::table('mod_WHMCSResellers_products')->insert([
                'product_id' => $product_id,
                'minimum_balance' => $_POST["minimumbalance"],
                'service_amount' => $_POST["serviceprice"],
                'traffic_amount' => $_POST["trafficamount"],
                'free_traffic' => $_POST["freetraffic"],
                'traffic_type' => $_POST["trtypes"],
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s")
            ]);
            return ["status" => "success", "message" => "product added to resellers", "data" => $_POST];
        }
    } else {
        return ["status" => "error", "message" => "product not found"];
    }
}
function WHMCSResellers_CustomProductModification()
{
    $product_id = $_POST["prid"];
    $userid = $_POST["userid"];
    $reseller_product = Capsule::table('mod_WHMCSResellers_products_user')
        ->where("product_id", "=", $product_id)
        ->where("userid", "=", $userid);
    if ($reseller_product->exists()) {
        $reseller_product = Capsule::table('mod_WHMCSResellers_products_user')
            ->where("product_id", "=", $product_id)
            ->where("userid", "=", $userid)->update([
                'minimum_balance' => $_POST["minimumbalance"],
                'service_amount' => $_POST["serviceprice"],
                'traffic_amount' => $_POST["trafficamount"],
                'free_traffic' => $_POST["freetraffic"],
                'traffic_type' => $_POST["trtypes"],
                'updated_at' => date("Y-m-d H:i:s")
            ]);
        return ["status" => "success", "message" => "product updated", "data" => $_POST];
    } else {
        return ["status" => "error", "message" => "product not found"];
    }
}
