<?php

use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\WHMCSResellers\Admin\AdminDispatcher;
use WHMCS\Module\Addon\WHMCSResellers\Client\ClientDispatcher;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function WHMCSResellers_config()
{
    return [
        // Display name for your module
        'name' => 'WHMCS Reseller ',
        // Description displayed within the admin interface
        'description' => 'This module can create services and bandwidth based on hourly price  on WHMCS Resellers.',
        // Module author name
        'author' => '@KelonCloud Developer Team , Keloncloud.com',
        // Default language
        'language' => 'english',
        // Version number
        'version' => '1.0.0',
    ];
}
function WHMCSResellers_activate()
{
    // Create custom tables and schema required by your module
    try {
        Capsule::schema()
            ->create(
                'mod_WHMCSResellers',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->integer('userid');
                    $table->text('domain');
                    $table->text('apikey');
                    $table->enum('status', ['Pending', 'Active', 'Suspended', 'Terminated']);
                    $table->integer('credit');
                    $table->timestamps();
                }
            );
        Capsule::schema()
            ->create(
                'mod_WHMCSResellers_products',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->integer('product_id');
                    $table->integer('minimum_balance');
                    $table->integer('service_amount');
                    $table->integer('traffic_amount');
                    $table->integer('free_traffic');
                    $table->enum('traffic_type', ['download', 'upload', 'both']);
                    $table->timestamps();
                }
            );
        Capsule::schema()
            ->create(
                'mod_WHMCSResellers_service',
                function ($table) {
                    $table->increments('id');
                    $table->integer('service_id');
                    $table->integer('client_service_id');
                    $table->integer('resellerid');
                    $table->datetime('start_time');
                    $table->datetime('last_calculated');
                    $table->datetime('last_service_calculated');
                    $table->integer('last_traffic');
                    $table->enum('status', ['Active', 'Suspended', 'Terminated']);
                    $table->timestamps();
                }
            );
        return [
            'status' => 'success',
            'description' => 'Module Successfully activated',
        ];
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            'status' => 'error',
            'description' => $e->getMessage(),
        ];
    }
}
function WHMCSResellers_deactivate()
{
    // Undo any database and schema modifications made by your module here
    try {
        Capsule::schema()
            ->dropIfExists('mod_WHMCSResellers_products');
        Capsule::schema()
            ->dropIfExists('mod_WHMCSResellers_service');
        Capsule::schema()
            ->dropIfExists('mod_WHMCSResellers');
        return [
            // Supported values here include: success, error or info
            'status' => 'success',
            'description' => 'This is a demo module only. '
                . 'In a real module you might report a success here.',
        ];
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            "status" => "error",
            "description" => "Unable to drop mod_addonexample: {$e->getMessage()}",
        ];
    }
}
function WHMCSResellers_upgrade($vars)
{
}
function WHMCSResellers_output($vars)
{
    $modulelink = $vars['modulelink'];

    $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'index';
    $dispatcher = new AdminDispatcher();
    $response = $dispatcher->dispatch($action, $vars);
    echo $response;
}
function WHMCSResellers_sidebar($vars)
{
}
function WHMCSResellers_clientarea($vars)
{
    $modulelink = "/modules/addons/WHMCSResellers";
    $LANG = $vars['_lang'];
    return array(
        'pagetitle' => $LANG["pagetitle"],
        'breadcrumb' => array(
            'index.php?m=WHMCSResellers' =>
                $LANG["pagetitle"]
        ),
        'templatefile' => 'publicpage',
        'requirelogin' => true, # accepts true/false
        'forcessl' => false, # accepts true/false
        'vars' => array(
            'testvar' => 'demo',
            'anothervar' => 'value',
            'sample' => 'test',
        ),
    );
}
function WHMCSResellers_CheckHeader($vars)
{
    if (!isset($_SERVER['HTTP_APIKEY']) || empty($_SERVER['HTTP_APIKEY'])) {
        http_response_code(401);
        array("status" => "error", "message" => "API key is missing");
        exit();
    }
    if (!isset($_SERVER['HTTP_DOMAIN']) || empty($_SERVER['HTTP_DOMAIN'])) {
        http_response_code(401);
        return array("status" => "error", "message" => "Domain is missing");
        exit();
    }
    return ["status" => "success"];
}
function WHMCSResellers_CheckCredit($vars)
{
    $headers = WHMCSResellers_CheckHeader($vars);
    if ($headers["status"] == "error") {
        return ["status" => "error", "message" => $headers["message"]];
    }
    $apikey = $_SERVER['HTTP_APIKEY'];
    $domain = $_SERVER['HTTP_DOMAIN'];
    $apikey = trim($apikey);
    $apikey = str_replace(" ", "", $apikey);

    $domain = str_replace("http://", "", $domain);
    $domain = str_replace("https://", "", $domain);
    $domain = trim($domain);
    $domain = strtolower($domain);
    $domain = str_replace(" ", "", $domain);

    $whmcsresellers = Capsule::table('mod_WHMCSResellers')
        ->where('apikey', $apikey)
        ->where('domain', $domain)
        ->first();
    if (!$whmcsresellers) {

        http_response_code(401);
        return array("status" => "error", "message" => "Invalid API key");
        exit();
    }
    if ($whmcsresellers->status != "Active") {
        http_response_code(401);
        array(
            "status" => "error",
            "ResellerStatus" => $whmcsresellers->status,
            "message" => "Reseller is " . $whmcsresellers->status,
        );
        exit();
    }
    $credit = $whmcsresellers->credit;
    $credit = floatval($credit);
    $credit = number_format($credit);
    if ($credit < 0) {
        http_response_code(401);
        array(
            "status" => "error",
            "credit" => $whmcsresellers->credit,
            "message" => "your credit is negative, please contact support",
        );
    }
    return array("status" => "success", "credit" => $credit);
}
function WHMCSResellers_ReturnProductList($userid)
{
    $headers = WHMCSResellers_CheckHeader([]);
    if ($headers["status"] == "error") {
        return ["status" => "error", "message" => $headers["message"]];
    }
    $perpage = $_GET["perpage"];
    $page = $_GET["page"];
    $perpage = intval($perpage);
    $page = intval($page);
    if ($perpage < 1) {
        $perpage = 10;
    }
    if ($page < 1) {
        $page = 1;
    }
    $offset = ($page - 1) * $perpage;
    $products = WHMCSResellers_GetProducts($perpage, $offset);
    $count = WHMCSResellers_GetProductsCount();
    if (WHMCSResellers_CheckUserHasCustomPrice($userid) > 0) {
        $products = WHMCSResellers_GetCustomProducts($perpage, $offset, $userid);
        $count = WHMCSResellers_GetCustomProductsCount($userid);
    }
    $count = intval($count);
    $count = number_format($count);
    // $products = array_slice($products, 0, $perpage);
    return array(
        "status" => "success",
        "products" => $products,
        "count" => $count,
        "perpage" => $perpage,
        "page" => $page,
    );
}
function WHMCSResellers_CheckUserHasCustomPrice($userid)
{
    $iscustom = Capsule::table("mod_WHMCSResellers_products")
        ->where("userid", "=", $userid)
        ->count();
    return $iscustom;
}
function WHMCSResellers_GetProducts($perpage, $offset)
{
    $count =
        $results = Capsule::table('tblproductgroups')
            ->join('tblproducts', 'tblproductgroups.id', '=', 'tblproducts.gid')
            ->join('mod_WHMCSResellers_products', 'tblproducts.id', '=', 'mod_WHMCSResellers_products.product_id')
            ->select([
                'tblproducts.name',
                'tblproductgroups.name as groupname',
                'mod_WHMCSResellers_products.id',
                'mod_WHMCSResellers_products.minimum_balance',
                'mod_WHMCSResellers_products.service_amount',
                'mod_WHMCSResellers_products.traffic_amount',
                'mod_WHMCSResellers_products.free_traffic',
                'mod_WHMCSResellers_products.traffic_type',
                'tblproductgroups.name as groupname',
                'tblproductgroups.id as group_id'
            ])
            ->skip($offset)
            ->take($perpage)
            ->get();
    if ($offset == 0) {
        $count =
            Capsule::table('tblproductgroups')
                ->join('tblproducts', 'tblproductgroups.id', '=', 'tblproducts.gid')
                ->join('mod_WHMCSResellers_products', 'tblproducts.id', '=', 'mod_WHMCSResellers_products.product_id')
                ->select([
                    'tblproducts.name',
                    'mod_WHMCSResellers_products.id',
                    'tblproductgroups.name as groupname',

                    'mod_WHMCSResellers_products.minimum_balance',
                    'mod_WHMCSResellers_products.service_amount',
                    'mod_WHMCSResellers_products.traffic_amount',
                    'mod_WHMCSResellers_products.free_traffic',
                    'mod_WHMCSResellers_products.traffic_type',
                    'tblproductgroups.name as groupname',
                    'tblproductgroups.id as group_id'
                ])
                ->take($perpage)
                ->get();
    }
    return $count;
}
function WHMCSResellers_GetCustomProducts($perpage, $offset, $userid)
{
    $count =
        $results = Capsule::table('tblproductgroups')
            ->join('tblproducts', 'tblproductgroups.id', '=', 'tblproducts.gid')
            ->join('mod_WHMCSResellers_products', 'tblproducts.id', '=', 'mod_WHMCSResellers_products.product_id')
            ->select([
                'tblproducts.name',
                'tblproductgroups.name as groupname',
                'mod_WHMCSResellers_products.id',
                'mod_WHMCSResellers_products.minimum_balance',
                'mod_WHMCSResellers_products.service_amount',
                'mod_WHMCSResellers_products.traffic_amount',
                'mod_WHMCSResellers_products.free_traffic',
                'mod_WHMCSResellers_products.traffic_type',
                'tblproductgroups.name as groupname',
                'tblproductgroups.id as group_id'
            ])
            ->where("mod_WHMCSResellers_products.userid", "=", $userid)
            ->skip($offset)
            ->take($perpage)
            ->get();
    if ($offset == 0) {
        $count = Capsule::table('tblproductgroups')
            ->join('tblproducts', 'tblproductgroups.id', '=', 'tblproducts.gid')
            ->join('mod_WHMCSResellers_products', 'tblproducts.id', '=', 'mod_WHMCSResellers_products.product_id')
            ->select([
                'tblproducts.name',
                'mod_WHMCSResellers_products.id',
                'tblproductgroups.name as groupname',
                'mod_WHMCSResellers_products.minimum_balance',
                'mod_WHMCSResellers_products.service_amount',
                'mod_WHMCSResellers_products.traffic_amount',
                'mod_WHMCSResellers_products.free_traffic',
                'mod_WHMCSResellers_products.traffic_type',
                'tblproductgroups.name as groupname',
                'tblproductgroups.id as group_id'
            ])
            ->where("mod_WHMCSResellers_products.userid", "=", $userid)

            ->take($perpage)
            ->get();
    }
    return $count;
}
function WHMCSResellers_GetCustomProductsCount($userid)
{
    $count = Capsule::table('mod_WHMCSResellers_products')
        ->where("userid", "=", $userid)
        ->count();
    return $count;
}
function WHMCSResellers_GetProductsCount()
{
    $count = Capsule::table('mod_WHMCSResellers_products')
        ->count();
    return $count;
}
