<?php

namespace WHMCS\Module\Addon\userverification\Admin;
/**
 * Sample Admin Area Controller
 */
class Controller
{
    public function ReturnMenu($vars)
    {
        $modulelink = $vars['modulelink'];
        $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'index';
        $activebtn = " btn btn-primary";
        $list = '
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                      <li class="nav-item">
                        <a class="nav-link ' . ($action == 'index' ? ' btn btn-primary' : '') . ' "  href="' . $modulelink . '&action=index"  >Price Actions</a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link ' . ($action == 'show' ? ' btn btn-primary' : '') . ' "   href="' . $modulelink . '&action=show"  >Request Lists</a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link ' . ($action == 'userslist' ? ' btn btn-primary' : '') . ' "   href="' . $modulelink . '&action=userslist"  >User list</a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link ' . ($action == 'usercards' ? ' btn btn-primary' : '') . ' "   href="' . $modulelink . '&action=usercards"  >User Cards</a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link ' . ($action == 'config' ? ' btn btn-primary' : '') . ' "   href="' . $modulelink . '&action=config"  >Field Configuration</a>
                      </li>
                      <li class="nav-item">
                        <a class="nav-link ' . ($action == 'configManager' ? ' btn btn-primary' : '') . ' "   href="' . $modulelink . '&action=configManager"  >Configuration Manager</a>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                </div>';

        return $list;
    }
    public function index($vars)
    {
        $ReturnMenu = $this->ReturnMenu($vars);
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. userverifications.php?module=userverification
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables

        // Get module configuration parameters
        return <<<EOF
                {$ReturnMenu}
        EOF;
    }
    public function show($vars)
    {
        $ReturnMenu = $this->ReturnMenu($vars);
        // Get common module parameters
        return <<<EOF
            {$ReturnMenu}
        EOF;
    }

    public function config($vars)
    {
        $ReturnMenu = $this->ReturnMenu($vars);
        $modulelink = $vars['modulelink'];

        $message = '';
        $messageType = '';

        // Handle form submission
        if (isset($_POST['save_config'])) {
            $mobileField = $_POST['mobile_field'];
            $nationalCodeField = $_POST['national_code_field'];

            // Save configuration


            $table = " mod_userverification_config";
            $values = array(
                "option" => "mobile_field",
                "value" => $mobileField
            );
            $newid1 = insert_query($table, $values);
            $table = " mod_userverification_config";
            $values = array(
                "option" => "national_code_field",
                "value" => $nationalCodeField
            );
            $newid = insert_query($table, $values);

            // if ($newid && $newid1) {
            $message = 'Configuration saved successfully.';
            $messageType = 'success';
            // } else {
            //  $message = 'Failed to save configuration.';
            //  $messageType = 'danger';
            //}
        }

        // Get current configuration
        $currentMobileField = '';
        $currentNationalCodeField = '';

        $query = "SELECT * FROM mod_userverification_config WHERE option IN ('mobile_field', 'national_code_field')";
        $result = full_query($query);
        while ($data = mysql_fetch_array($result)) {
            if ($data['option'] == 'mobile_field') {
                $currentMobileField = $data['value'];
            } elseif ($data['option'] == 'national_code_field') {
                $currentNationalCodeField = $data['value'];
            }
        }

        // Get custom fields
        $customFieldsQuery = "SELECT id, fieldname, fieldtype FROM tblcustomfields WHERE type = 'client' ORDER BY fieldname";
        $customFieldsResult = full_query($customFieldsQuery);

        $customFieldOptions = '<option value="">-- Select Field --</option>';
        while ($field = mysql_fetch_array($customFieldsResult)) {
            $selectedMobile = $field['id'] == $currentMobileField ? 'selected' : '11';
            $selectedNational = $field['id'] == $currentNationalCodeField ? 'selected' : '22';
            $customFieldOptions .= "<option value='{$field['id']}' data-mobile='{$selectedMobile}' data-national='{$selectedNational}'>{$field['fieldname']} ({$field['fieldtype']})</option>";
        }

        return <<<EOF
            {$ReturnMenu}
            <div class="card mt-4">
                <div class="card-header">
                    <h3>Field Configuration</h3>
                </div>
                <div class="card-body">
                <div class='alert alert-{$messageType}'>{$message}</div> 
                    
                    <form method="post" action="{$modulelink}&action=config">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="mobile_field">Mobile Number Field</label>
                                    <select name="mobile_field" id="mobile_field" class="form-control" required>
                                        {$customFieldOptions}
                                    </select>
                                    <small class="form-text text-muted">Select the custom field that contains mobile numbers</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="national_code_field">National Code Field</label>
                                    <select name="national_code_field" id="national_code_field" class="form-control" required>
                                        {$customFieldOptions}
                                    </select>
                                    <small class="form-text text-muted">Select the custom field that contains national codes</small>
                                </div>
                            </div>
                        </div>
                        
                        <button type="submit" name="save_config" class="btn btn-primary">Save Configuration</button>
                    </form>
                    
                    <hr>
                    
                    <h5>Current Configuration:</h5>
                    <ul>
                        <li><strong>Mobile Field ID:</strong> {$currentMobileField}</li>
                        <li><strong>National Code Field ID:</strong> {$currentNationalCodeField}</li>
                    </ul>
                </div>
            </div>
            
            <script>
                // Set selected values
                document.addEventListener('DOMContentLoaded', function() {
                    var mobileSelect = document.getElementById('mobile_field');
                    var nationalSelect = document.getElementById('national_code_field');
                    
                    // Set mobile field selection
                    for (var i = 0; i < mobileSelect.options.length; i++) {
                        if (mobileSelect.options[i].value == '{$currentMobileField}') {
                            mobileSelect.selectedIndex = i;
                            break;
                        }
                    }
                    
                    // Set national code field selection
                    for (var i = 0; i < nationalSelect.options.length; i++) {
                        if (nationalSelect.options[i].value == '{$currentNationalCodeField}') {
                            nationalSelect.selectedIndex = i;
                            break;
                        }
                    }
                });
            </script>
EOF;
    }

    public function usercards($vars)
    {
        $ReturnMenu = $this->ReturnMenu($vars);
        $modulelink = $vars['modulelink'];

        $page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
        $limit = isset($_GET['limit']) ? (int) $_GET['limit'] : 10;
        $search = isset($_GET['search']) ? $_GET['search'] : '';
        $offset = ($page - 1) * $limit;

        $searchCondition = '';
        if (!empty($search)) {
            $searchCondition = "AND (tblclients.firstname LIKE '%{$search}%' OR tblclients.lastname LIKE '%{$search}%' OR mod_userverification.cardnumber LIKE '%{$search}%')";
        }

        $countQuery = "SELECT COUNT(*) as total FROM mod_userverification, tblclients WHERE userid = tblclients.id {$searchCondition}";
        $countResult = full_query($countQuery);
        $totalRecords = mysql_fetch_array($countResult)['total'];
        $totalPages = ceil($totalRecords / $limit);

        $query = "SELECT * FROM mod_userverification, tblclients WHERE userid = tblclients.id {$searchCondition} ORDER BY created_at DESC LIMIT {$limit} OFFSET {$offset}";
        $result = full_query($query);

        $tableRows = '';
        while ($data = mysql_fetch_array($result)) {
            $statusClass = $data['verification_status'] == 'Approved' ? 'success' : ($data['verification_status'] == 'Rejected' ? 'danger' : 'warning');
            $tableRows .= "<tr>
                <td>{$data['id']}</td>
                <td>{$data['firstname']} {$data['lastname']}</td>
                <td>{$data['cardnumber']}</td>
                <td>{$data['message']}</td>
                <td><span class='badge badge-{$statusClass}'>{$data['verification_status']}</span></td>
                <td>{$data['created_at']}</td>
            </tr>";
        }

        $pagination = '';
        if ($totalPages > 1) {
            $pagination .= '<nav><ul class="pagination">';
            for ($i = 1; $i <= $totalPages; $i++) {
                $active = $i == $page ? 'active' : '';
                $pagination .= "<li class='page-item {$active}'><a class='page-link' href='{$modulelink}&action=usercards&page={$i}&limit={$limit}&search={$search}'>{$i}</a></li>";
            }
            $pagination .= '</ul></nav>';
        }

        return <<<EOF
            {$ReturnMenu}
            <div class="card mt-4">
                <div class="card-header">
                    <h3>User Cards List ({$totalRecords} records)</h3>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <form method="get" class="form-inline">
                                <input type="hidden" name="m" value="UserVerification">
                                <input type="hidden" name="action" value="usercards">
                                <input type="text" name="search" class="form-control mr-2" placeholder="Search..." value="{$search}">
                                <button type="submit" class="btn btn-primary">Search</button>
                            </form>
                        </div>
                        <div class="col-md-6 text-right">
                            <form method="get" class="form-inline justify-content-end">
                                <input type="hidden" name="m" value="UserVerification">
                                <input type="hidden" name="action" value="usercards">
                                <input type="hidden" name="search" value="{$search}">
                                <label class="mr-2">Show:</label>
                                <select name="limit" class="form-control mr-2" onchange="this.form.submit()">
                                    <option value="10">10</option>
                                    <option value="25">25</option>
                                    <option value="50">50</option>
                                    <option value="100">100</option>
                                </select>
                                <span>per page</span>
                            </form>
                        </div>
                    </div>
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>User Name</th>
                                <th>Card Number</th>
                                <th>Message</th>
                                <th>Status</th>
                                <th>Date Added</th>
                            </tr>
                        </thead>
                        <tbody>
                            {$tableRows}
                        </tbody>
                    </table>
                    {$pagination}
                </div>
            </div>
EOF;
    }
    public function configManager($vars)
    {
        $ReturnMenu = $this->ReturnMenu($vars);
        $modulelink = $vars['modulelink'];
        $message = '';
        $messageType = '';

        // Handle form submissions
        if (isset($_POST['actions'])) {
            if ($_POST['actions'] == 'add' || $_POST['actions'] == 'update') {
                $option = $_POST['option'];
                $value = $_POST['value'];

                if (empty($option)) {
                    $message = 'Option name cannot be empty';
                    $messageType = 'danger';
                } else {
                    // Check if option already exists
                    $checkQuery = "SELECT * FROM mod_userverification_config WHERE `option` = '$option'";
                    $checkResult = mysql_query($checkQuery);
                    $exists = mysql_num_rows($checkResult) > 0;

                    if ($_POST['actions'] == 'add' && $exists) {
                        $message = 'Option already exists. Please use update instead.';
                        $messageType = 'warning';
                    } else {
                        if ($_POST['actions'] == 'add' || !$exists) {
                            $query = "INSERT INTO mod_userverification_config (`option`, `value`) VALUES ('$option', '$value')";
                        } else {
                            $query = "UPDATE mod_userverification_config SET `value` = '$value' WHERE `option` = '$option'";
                        }

                        $success = mysql_query($query);
                        $message = $success ? 'Configuration saved successfully' : 'Failed to save configuration';
                        $messageType = $success ? 'success' : 'danger';
                    }
                }
            } elseif ($_POST['actions'] == 'delete') {
                $option = $_POST['option'];
                $query = "DELETE FROM mod_userverification_config WHERE `option` = '$option'";
                $success = mysql_query($query);
                $message = $success ? 'Configuration deleted successfully' : 'Failed to delete configuration';
                $messageType = $success ? 'success' : 'danger';
            }
        }

        // Get edit record if requested
        $editRecord = null;
        if (isset($_GET['edit'])) {
            $option = $_GET['edit'];
            $query = "SELECT * FROM mod_userverification_config WHERE `option` = '$option'";
            $result = mysql_query($query);
            $editRecord = mysql_fetch_array($result);
        }

        // Get all config records
        $query = "SELECT * FROM mod_userverification_config WHERE option NOT in ('mobile_field','national_code_field') ORDER BY `option`";
        $result = mysql_query($query);

        $configRows = '';
        while ($row = mysql_fetch_array($result)) {
            $configRows .= "<tr>
            <td>" . $row['option'] . "</td>
            <td>" . htmlspecialchars($row['value']) . "</td>
            <td>
                <a href='" . $modulelink . "&action=configManager&edit=" . urlencode($row['option']) . "' class='btn btn-sm btn-warning'>Edit</a>
                <form method='post' style='display:inline;' onsubmit=\"return confirm('Are you sure you want to delete this configuration?');\">
                    <input type='hidden' name='actions' value='delete'>
                    <input type='hidden' name='option' value='" . $row['option'] . "'>
                    <button type='submit' class='btn btn-sm btn-danger'>Delete</button>
                </form>
            </td>
        </tr>";
        }

        // Handle edit record values safely for older PHP
        $editOptionValue = '';
        $editValueValue = '';
        if ($editRecord) {
            $editOptionValue = isset($editRecord['option']) ? $editRecord['option'] : '';
            $editValueValue = isset($editRecord['value']) ? $editRecord['value'] : '';
        }

        // Create option select field
        $optionSelectField = '
    <div class="form-group">
        <label for="option">Option Name</label>
        <select class="form-control" id="option" name="option" required ' . ($editRecord ? 'disabled' : '') . '>
            <option value="">-- Select Option --</option>
            <option value="sms_api_key" ' . ($editOptionValue == 'sms_api_key' ? 'selected' : '') . '>SMS API Key</option>
            <option value="sms_pattern_name" ' . ($editOptionValue == 'sms_pattern_name' ? 'selected' : '') . '>Pattern Name</option>
            <option value="sms_code_parameter" ' . ($editOptionValue == 'sms_code_parameter' ? 'selected' : '') . '>SMS Code Paramtere</option>
            <option value="api_password" ' . ($editOptionValue == 'api_password' ? 'selected' : '') . '>API Password</option>
            <option value="mobile_field" ' . ($editOptionValue == 'mobile_field' ? 'selected' : '') . '>Mobile Field</option>
            <option value="national_code_field" ' . ($editOptionValue == 'national_code_field' ? 'selected' : '') . '>National Code Field</option>
            <option value="verification_required" ' . ($editOptionValue == 'verification_required' ? 'selected' : '') . '>Verification Required</option>
            <option value="verification_message" ' . ($editOptionValue == 'verification_message' ? 'selected' : '') . '>Verification Message</option>
        </select>
        <small class="form-text text-muted">Select the configuration option</small>
    </div>';

        // Add hidden field for edit mode
        $hiddenOptionField = $editRecord ? "<input type='hidden' name='option' value='" . $editOptionValue . "'>" : '';

        $formTitle = $editRecord ? 'Edit' : 'Add';
        $formAction = $editRecord ? 'update' : 'add';
        $formButton = $editRecord ? 'Update' : 'Add';
        $cancelButton = $editRecord ? "<a href='" . $modulelink . "&action=configManager' class='btn btn-secondary'>Cancel</a>" : '';

        $messageHtml = '';
        if ($message) {
            $messageHtml = "<div class='alert alert-" . $messageType . "'>" . $message . "</div>";
        }

        return $ReturnMenu . '
        <div class="card mt-4">
            <div class="card-header">
                <h3>' . $formTitle . ' Configuration</h3>
            </div>
            <div class="card-body">
                ' . $messageHtml . '
                
                <form method="post" action="' . $modulelink . '&action=configManager">
                    <input type="hidden" name="actions" value="' . $formAction . '">
                    ' . $hiddenOptionField . '
                    
                    <div class="row">
                        <div class="col-md-6">
                            ' . $optionSelectField . '
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="value">Value</label>
                                <input type="text" class="form-control" id="value" name="value" value="' . $editValueValue . '">
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">' . $formButton . ' Configuration</button>
                    ' . $cancelButton . '
                </form>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                <h3>Configuration List</h3>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Option</th>
                            <th>Value</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        ' . $configRows . '
                    </tbody>
                </table>
            </div>
        </div>';
    }

    function getHoursDifference($startDateTime, $endDateTime)
    {
        // Create DateTime objects
        $start = new DateTime($startDateTime);
        $end = new DateTime($endDateTime);

        // Calculate the difference
        $interval = $start->diff($end);

        // Convert the difference to total hours
        $hours = $interval->h + ($interval->days * 24);

        return $hours;
    }

    /**
     * Send SMS to a user using pattern
     * 
     * @param int $clientId WHMCS client ID
     * @return array Response with success status and message
     */
    public function sendSmsToUser($clientId)
    {
        $sentsms = false;
        $lastSmsQuery = "SELECT created_at FROM mod_userverification_smsverify 
                 WHERE userid = '$clientId' 
                 ORDER BY created_at DESC 
                 LIMIT 1";
        $lastSmsResult = mysql_query($lastSmsQuery);

        if (mysql_num_rows($lastSmsResult) > 0) {
            $lastSmsRow = mysql_fetch_array($lastSmsResult);
            $lastSendTime = strtotime($lastSmsRow['created_at']);
            $currentTime = time();

            $sentsms = true;

            $usertime = strtotime($lastSmsRow['created_at']);
            $now = time();
            $diff = $now - $usertime;
            $start = new \DateTime('now');

            $last = new \DateTime($lastSmsRow['created_at']);
            $seconds = $start->getTimestamp() - $last->getTimestamp();



            if ($seconds < 180) {
                // if ($diff > 0) {
                return array(
                    'success' => false,
                    'message' => 'Please wait before requesting another code',
                    'remaining_seconds' => $seconds,
                    'wait' => 180 - $seconds
                );
                // }
            }
            // return array(
            //     'success' => false,
            //     'message' => '2Please wait before requesting another code',
            //     'remaining_seconds' => $now . ">" . $lastSmsRow['created_at'] . ">" . $usertime . ">" . $diff
            // );
            // $timeDiff = $currentTime - $lastSendTime;
            // $cooldownPeriod = 180; // 3 minutes in seconds

            // if ($timeDiff < $cooldownPeriod) {
            //     $remainingSeconds = $cooldownPeriod - $timeDiff;
            //     return array(
            //         'success' => false,
            //         'message' => 'Please wait before requesting another code',
            //         'remaining_seconds' => $remainingSeconds
            //     );
            // }
        }


        // Get API configuration from database
        $apiConfigQuery = "SELECT * FROM mod_userverification_config WHERE `option` IN ('sms_api_key', 
                            'sms_code_parameter', 'sms_pattern_name')";
        $apiConfigResult = mysql_query($apiConfigQuery);


        $config = array();
        while ($row = mysql_fetch_array($apiConfigResult)) {
            $config[$row['option']] = $row['value'];
        }

        // Get mobile field ID from config
        $mobileFieldQuery = "SELECT * FROM mod_userverification_config WHERE `option` = 'mobile_field'";
        $mobileFieldResult = mysql_query($mobileFieldQuery);
        $mobileFieldRow = mysql_fetch_array($mobileFieldResult);
        $mobileFieldId = $mobileFieldRow['value'];

        // Get user's mobile number from custom fields
        $mobileQuery = "SELECT value FROM tblcustomfieldsvalues WHERE fieldid = '$mobileFieldId' AND relid = '$clientId'";
        $mobileResult = mysql_query($mobileQuery);
        $mobileRow = mysql_fetch_array($mobileResult);
        $mobileNumber = $mobileRow['value'];

        // Format mobile number if needed
        if (!empty($mobileNumber) && substr($mobileNumber, 0, 1) == '0') {
            $mobileNumber = '+98' . substr($mobileNumber, 1);
        }

        if (empty($mobileNumber)) {
            return array('success' => false, 'message' => 'Mobile number not found for this user');
        }

        // Generate verification code
        $verificationCode = rand(10000, 99999);
        // Store in smsverify table BEFORE sending (to ensure it's recorded even if API fails)
        if ($sentsms) {
            $insertQuery = "UPDATE mod_userverification_smsverify set 
            code ='$verificationCode' ,  created_at = NOW() 
            where userid='$clientId'";

        } else {
            $insertQuery = "INSERT INTO mod_userverification_smsverify 
            (userid, mobile, code, status, created_at) 
            VALUES 
            ('$clientId', '$mobileNumber', '$verificationCode', 'pending', NOW())";

        }
        $insertResult = mysql_query($insertQuery);

        if (!$insertResult) {
            return array(
                'success' => false,
                'message' => 'Failed to record verification attempt in database'
            );
        }
        // Prepare API request
        $apiUrl = 'https://edge.ippanel.com/v1/api/send';
        $sms_api_key = $config['sms_api_key'];
        $sms_code_parameter = $config['sms_code_parameter'];
        $sms_pattern_name = $config['sms_pattern_name'];


        $postData = array(
            'sending_type' => 'pattern',
            'from_number' => "+983000505",
            'code' => $sms_pattern_name,
            'recipients' => array($mobileNumber),
            'params' => array(
                $sms_code_parameter => $verificationCode
            )
        );

        // Send API request
        $ch = curl_init($apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: ' . $sms_api_key
        ));

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Store in smsverify table
        $status = ($httpCode == 200) ? 'sent' : 'failed';
        // $insertQuery = "INSERT INTO mod_userverification_smsverify 
        //                     (userid, mobile, code, status, created_at) 
        //                     VALUES 
        //                     ('$clientId', '$mobileNumber', '$verificationCode', '$status', NOW())";
        // mysql_query($insertQuery);



        // Return result
        if ($httpCode == 200) {
            return array(
                'success' => true,
                'message' => 'SMS sent successfully',
                'verification_code' => $verificationCode
            );
        } else {
            return array(
                'success' => false,
                'message' => 'Failed to send SMS. HTTP Code: ' . $httpCode
            );
        }
    }

    /**
     * Update user verification level
     * 
     * @param int $userId User ID
     * @param int $newLevel New verification level
     * @return bool Success status
     */
    public function updateUserVerificationLevel($userId, $newlevel = 1)
    {
        // Check if user already exists in the levels table
        $checkQuery = "SELECT level FROM mod_userverification_levels WHERE userid = '$userId'";
        $checkResult = mysql_query($checkQuery);

        if (mysql_num_rows($checkResult) > 0) {
            $currentLevel = mysql_fetch_array($checkResult)['level'];
            $updateQuery = "UPDATE mod_userverification_levels 
                           SET level = '$newlevel', updated_at = NOW() 
                           WHERE userid = '$userId'";
            return mysql_query($updateQuery);
        } else {
            // Insert new record if user doesn't exist in the table
            $insertQuery = "INSERT INTO mod_userverification_levels (userid, level, created_at) 
                       VALUES ('$userId', 1, NOW())";
            return mysql_query($insertQuery);
        }
    }
    /**
     * Log a verification request to the database
     * 
     * @param int $userId User ID
     * @param string $requestData Request data (JSON or string)
     * @param string $responseData Response data (JSON or string)
     * @param string $type Request type (optional)
     * @return bool Success status
     */
    function logVerificationRequest($userId, $requestData, $responseData, $type = '')
    {
        // Escape data for SQL insertion
        $userId = (int) $userId;
        $requestData = mysql_real_escape_string($requestData);
        $responseData = mysql_real_escape_string($responseData);
        $type = mysql_real_escape_string($type);

        // Insert record
        $query = "INSERT INTO mod_userverification_request 
              (userid, request, response, type, created_at) 
              VALUES 
              ('$userId', '$requestData', '$responseData', '$type', NOW())";

        return mysql_query($query);
    }
    public function verifyShahkar($nationalCode, $mobileNumber,$ClientID)
    {
        // Step 1: Get authentication token
        $tokenUrl = 'https://drapi.ir/auth/http/token';
        $tokenData = [
            'username' => "Abr_Apadana_TLS",
            'password' => "T0e'YB%vix@A"
        ];

        $tokenCh = curl_init($tokenUrl);
        curl_setopt($tokenCh, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($tokenCh, CURLOPT_POST, true);
        curl_setopt($tokenCh, CURLOPT_POSTFIELDS, json_encode($tokenData));
        curl_setopt($tokenCh, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

        $tokenResponse = curl_exec($tokenCh);
        $tokenHttpCode = curl_getinfo($tokenCh, CURLINFO_HTTP_CODE);
        curl_close($tokenCh);

        if ($tokenHttpCode != 200) {
            return [
                'success' => false,
                'message' => 'Authentication failed',
                'http_code' => $tokenHttpCode
            ];
        }

        $tokenData = json_decode($tokenResponse, true);
        $accessToken = $tokenData['access_token'];

        // Step 2: Call Shahkar verification API
        $apiUrl = 'https://drapi.ir/rest/api/main/it_org/v1.0/istelamshahkar';
        $apiData = [
            'nationalCode' => $nationalCode,
            'mobileNumber' => $mobileNumber
        ];

        $apiCh = curl_init($apiUrl);
        curl_setopt($apiCh, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($apiCh, CURLOPT_POST, true);
        curl_setopt($apiCh, CURLOPT_POSTFIELDS, json_encode($apiData));
        curl_setopt($apiCh, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $accessToken
        ]);

        $apiResponse = curl_exec($apiCh);
        $apiHttpCode = curl_getinfo($apiCh, CURLINFO_HTTP_CODE);
        curl_close($apiCh);

        $result = json_decode($apiResponse, true);

        $this->logVerificationRequest($ClientID, json_encode($apiData),
        $apiResponse, "Shahkar");
        return [
            'success' => ($apiHttpCode == 200),
            'data' => $result,
            'http_code' => $apiHttpCode
        ];
    }
    public function validateIranianNationalCode($nationalCode) {
        $nationalCode = (string)$nationalCode;
        if (strlen($nationalCode) != 10 || !ctype_digit($nationalCode)) {
            return false;
        }
    
        $checkDigit = (int)$nationalCode[9];
        $sum = 0;
        for ($i = 0; $i < 9; $i++) {
            $sum += (int)$nationalCode[$i] * (10 - $i);
        }
    
        $remainder = $sum % 11;
    
        if ($remainder < 2) {
            return $checkDigit == $remainder;
        } else {
            return $checkDigit == 11 - $remainder;
        }
    }
    
}