<?php

use WHMCS\Database\Capsule;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function getUsersTable($whereClause, $adminurl) {
    $content = '
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Users Traffic Summary</h3>
        </div>
        <div class="panel-body">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>IP Address</th>
                        <th>Usage</th>
                        <th>Limit</th>
                        <th>Usage %</th>
                        <th>Next Due Date</th>
                    </tr>
                </thead>
                <tbody>';
    
    // Run query to get all users
    $usersQuery = full_query("SELECT *,tblclients.id as userid,firstname,lastname,dedicatedip,tblproducts.id as productid,tblhosting.id as hostingid 
            FROM `tblproducts`,tblhosting,tblclients 
            WHERE userid=tblclients.id $whereClause and packageid=tblproducts.id and domainstatus='Active'");
    
    if ($usersQuery) {
        while ($data = mysql_fetch_array($usersQuery)) {
            // Get traffic limit
            $sql = full_query("SELECT * from tblcustomfields,tblcustomfieldsvalues
            WHERE tblcustomfields.relid=" . $data["productid"] . " and tblcustomfieldsvalues.relid = " . $data["hostingid"] . " 
            and tblcustomfieldsvalues.fieldid = tblcustomfields.id and tblcustomfields.fieldname='TrafficLimit'");
            $limit = mysql_fetch_array($sql);
            
            // Get usage
            $nsql = full_query("SELECT * from mod_trafficusage WHERE product_id=" . $data["hostingid"]);
            $usage = mysql_fetch_array($nsql);
            
            // Calculate percentage
            $usageValue = $usage["usage"] . str_replace(",", "");
            $limitValue = $limit["value"];
            $percentage = ($limitValue > 0) ? round(($usageValue / $limitValue) * 100, 2) : 0;
            
            // Set color based on usage percentage
            $rowClass = '';
            if ($percentage >= 90) {
                $rowClass = 'danger';
            } elseif ($percentage >= 75) {
                $rowClass = 'warning';
            } elseif ($percentage >= 50) {
                $rowClass = 'info';
            }
            
            $content .= '
                <tr class="' . $rowClass . '">
                    <td><a href="' . $adminurl . '/clientssummary.php?userid=' . $data["userid"] . '">' . 
                        $data["firstname"] . ' ' . $data["lastname"] . '</a></td>
                    <td><a href="' . $adminurl . '/clientsservices.php?userid=' . $data["userid"] . '&id=' . $data["hostingid"] . '">' . 
                        $data["dedicatedip"] . '</a></td>
                    <td>' . $usageValue . ' GB</td>
                    <td>' . $limitValue . ' GB</td>
                    <td>' . $percentage . '%</td>
                    <td>' . $data["nextduedate"] . '</td>
                </tr>';
        }
    }
    
    $content .= '
                </tbody>
            </table>
        </div>
    </div>';
    
    return $content;
}

function getUsersWithGraphs($whereClause, $adminurl) {
    $content = '';
    
    // Run a fresh query to get all users with their graphs
    $usersQuery = full_query("SELECT *,tblclients.id as userid,firstname,lastname,dedicatedip,tblproducts.id as productid,tblhosting.id as hostingid 
            FROM `tblproducts`,tblhosting,tblclients 
            WHERE userid=tblclients.id $whereClause and packageid=tblproducts.id and domainstatus='Active'");
    
    if ($usersQuery) {
        while ($data = mysql_fetch_array($usersQuery)) {
            $sql = full_query("SELECT * from tblcustomfields,tblcustomfieldsvalues
            WHERE tblcustomfields.relid=" . $data["productid"] . " and tblcustomfieldsvalues.relid = " . $data["hostingid"] . " 
            and tblcustomfieldsvalues.fieldid = tblcustomfields.id and tblcustomfields.fieldname='monitoringID'");
            $s = mysql_fetch_array($sql);
            
            $nextduedate = $data["nextduedate"];
            $date = date_create($nextduedate);
            $ex = date_modify($date, '-1 month');
            $start = $ex->format("Y-m-d-00-00-00");
            $end = date("Y-m-d-h-i-s");
            
            // Get server for this product
            $serverMapping = Capsule::table('mod_prtg_product_servers')
                ->where('product_id', $data["productid"])
                ->first();
            
            $serverName = 'Default';
            $serverUsername = 'admin';
            $serverPasshash = '1314677760';
            $serverUrl = '';
            
            if ($serverMapping) {
                $server = Capsule::table('mod_prtg_servers')
                    ->where('id', $serverMapping->server_id)
                    ->first();
                
                if ($server) {
                    $serverName = htmlspecialchars($server->name);
                    $serverUsername = $server->username;
                    $serverPasshash = $server->passhash;
                    $serverUrl = $server->url;
                }
            }
            
            $content .= '
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">
                        <a href="' . $adminurl . '/clientssummary.php?userid=' . $data["userid"] . '">' . 
                        $data["firstname"] . ' ' . $data["lastname"] . '</a> - 
                        <a href="' . $adminurl . '/clientsservices.php?userid=' . $data["userid"] . '&id=' . $data["hostingid"] . '">' . 
                        $data["dedicatedip"] . '</a>
                    </h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-4">
                            <strong>Server:</strong> ' . $serverName . '<br>
                            <strong>Monitoring ID:</strong> ' . $s["value"] . '<br>
                            <strong>Next Due Date:</strong> ' . $data["nextduedate"] . '
                        </div>
                        <div class="col-md-8">
                            <img class="img-responsive" src="' . rtrim($serverUrl, '/') . '/chart.png?username=' . $serverUsername . 
                            '&passhash=' . $serverPasshash . '&id=' . $s["value"] . 
                            '&avg=15&sdate=' . $start . '&edate=' . $end . 
                            '&width=850&height=470&graphstyling=baseFontSize=%2712%27%20showLegend=%271%27%20graphid=-1" />
                        </div>
                    </div>
                </div>
            </div>';
        }
    }
    
    return $content;
}