<?php
/**
 * Direct fix for license form display issue
 */

// Add this code to your prtgmonitoring.php file right before the switch statement
// that handles the action cases. This will ensure the license form is always shown
// regardless of license status.

/*
// Generate the page content based on the action
$content = '';

switch ($action) {
    // Other cases...
    
    case 'license':
        // Always show license form regardless of license status
        $content = renderLicenseForm($modulelink);
        break;
        
    // Other cases...
}
*/

// Copy and paste the code below into your prtgmonitoring.php file:

function alwaysShowLicenseForm($modulelink) {
    // This is a direct fix - add this function to your prtgmonitoring.php file
    // and modify your switch statement to call this function for the license case
    
    $licenseKey = getLicenseKey();
    $licenseCache = getLicenseCache();
    
    $status = isset($licenseCache['status']) ? $licenseCache['status'] : 'unknown';
    $message = isset($licenseCache['message']) ? $licenseCache['message'] : '';
    
    $statusClass = 'danger';
    if ($status === 'active') {
        $statusClass = 'success';
    } elseif ($status === 'pending') {
        $statusClass = 'warning';
    }
    
    return '
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">License Management</h3>
        </div>
        <div class="panel-body">
            <form method="post" action="' . $modulelink . '&action=license">
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="license_key">License Key:</label>
                            <input type="text" name="license_key" id="license_key" class="form-control" value="' . htmlspecialchars($licenseKey) . '" placeholder="Enter your license key">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <button type="submit" name="save_license" class="btn btn-primary form-control">Save License</button>
                        </div>
                    </div>
                </div>
            </form>
            
            <div class="alert alert-' . $statusClass . '">
                <strong>License Status:</strong> ' . ucfirst($status) . '
                ' . ($message ? '<br><small>' . htmlspecialchars($message) . '</small>' : '') . '
            </div>
            
            <p>
                <strong>Need a license?</strong> Visit <a href="https://cl.keloncloud.com" target="_blank">our website</a> to purchase a license for this module.
            </p>
            
            <p>
                <strong>Having issues?</strong> Contact our support team at <a href="mailto:support@keloncloud.com">support@keloncloud.com</a>.
            </p>
        </div>
    </div>';
}

// Then in your switch statement, change:
// case 'license':
//     $content = renderLicenseForm($modulelink);
//     break;
//
// To:
// case 'license':
//     $content = alwaysShowLicenseForm($modulelink);
//     break;