<?php
/**
 * PRTG Monitoring Module License Form
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Generate license form HTML
 * 
 * @param string $modulelink Module link for form action
 * @return string HTML form
 */
function renderLicenseForm($modulelink)
{
    $licenseKey = getLicenseKey();
    $licenseCache = getLicenseCache();
    
    $status = isset($licenseCache['status']) ? $licenseCache['status'] : 'unknown';
    $message = isset($licenseCache['message']) ? $licenseCache['message'] : '';
    
    $statusClass = 'danger';
    if ($status === 'active') {
        $statusClass = 'success';
    } elseif ($status === 'pending') {
        $statusClass = 'warning';
    }
    
    return '
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">License Management</h3>
        </div>
        <div class="panel-body">
            <form method="post" action="' . $modulelink . '&action=license">
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="license_key">License Key:</label>
                            <input type="text" name="license_key" id="license_key" class="form-control" value="' . htmlspecialchars($licenseKey) . '" placeholder="Enter your license key">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <button type="submit" name="save_license" class="btn btn-primary form-control">Save License</button>
                        </div>
                    </div>
                </div>
            </form>
            
            <div class="alert alert-' . $statusClass . '">
                <strong>License Status:</strong> ' . ucfirst($status) . '
                ' . ($message ? '<br><small>' . htmlspecialchars($message) . '</small>' : '') . '
            </div>
            
            <p>
                <strong>Need a license?</strong> Visit <a href="https://cl.keloncloud.com" target="_blank">our website</a> to purchase a license for this module.
            </p>
            
            <p>
                <strong>Having issues?</strong> Contact our support team at <a href="mailto:support@keloncloud.com">support@keloncloud.com</a>.
            </p>
        </div>
    </div>';
}