<?php

namespace WHMCS\Module\Addon\prtgmonitoring\Admin;

use WHMCS\Database\Capsule;

/**
 * PRTG Monitoring Admin Controller
 */
class Controller
{
    /**
     * Index action - displays the main admin page
     *
     * @param array $vars Module configuration parameters
     *
     * @return string
     */
    public function index($vars)
    {
        // Get common module parameters
        $modulelink = $vars['modulelink'];
        $version = $vars['version'];
        $_lang = $vars['_lang'];
        
        // Handle form submission for adding/removing product groups
        if (isset($_POST['save_groups'])) {
            // Process group IDs
            if (isset($_POST['group_id']) && !empty($_POST['group_id'])) {
                $groupId = (int)$_POST['group_id'];
                
                // Check if group already exists
                $existingGroup = Capsule::table('mod_prtg_groups')
                    ->where('group_id', $groupId)
                    ->first();
                    
                if (!$existingGroup) {
                    // Add new group
                    Capsule::table('mod_prtg_groups')->insert([
                        'group_id' => $groupId,
                        'created_at' => Capsule::raw('NOW()'),
                        'updated_at' => Capsule::raw('NOW()')
                    ]);
                }
            }
            
            // Handle deletion
            if (isset($_POST['delete_group']) && !empty($_POST['delete_group'])) {
                $deleteId = (int)$_POST['delete_group'];
                Capsule::table('mod_prtg_groups')
                    ->where('id', $deleteId)
                    ->delete();
            }
        }
        
        // Handle PRTG credentials form submission
        if (isset($_POST['save_credentials'])) {
            $username = isset($_POST['prtg_username']) ? trim($_POST['prtg_username']) : '';
            $passhash = isset($_POST['prtg_passhash']) ? trim($_POST['prtg_passhash']) : '';
            $url = isset($_POST['prtg_url']) ? trim($_POST['prtg_url']) : '';
            
            // Validate inputs
            if (!empty($username) && !empty($passhash) && !empty($url)) {
                // Check if credentials already exist
                $existingCredentials = Capsule::table('mod_prtg_credentials')->first();
                
                if ($existingCredentials) {
                    // Update existing credentials
                    Capsule::table('mod_prtg_credentials')
                        ->where('id', $existingCredentials->id)
                        ->update([
                            'username' => $username,
                            'passhash' => $passhash,
                            'url' => $url,
                            'updated_at' => Capsule::raw('NOW()')
                        ]);
                } else {
                    // Insert new credentials
                    Capsule::table('mod_prtg_credentials')->insert([
                        'username' => $username,
                        'passhash' => $passhash,
                        'url' => $url,
                        'created_at' => Capsule::raw('NOW()'),
                        'updated_at' => Capsule::raw('NOW()')
                    ]);
                }
            }
        }
        
        // Get all monitored groups
        $monitoredGroups = Capsule::table('mod_prtg_groups')->get();
        
        // Build group IDs for query
        $groupIds = [];
        foreach ($monitoredGroups as $group) {
            $groupIds[] = $group->group_id;
        }
        
        // Get PRTG credentials if they exist
        $prtgCredentials = Capsule::table('mod_prtg_credentials')->first();
        $prtgUsername = $prtgCredentials ? $prtgCredentials->username : '';
        $prtgPasshash = $prtgCredentials ? $prtgCredentials->passhash : '';
        $prtgUrl = $prtgCredentials ? $prtgCredentials->url : '';
        
        // Display PRTG credentials form
        $credentialsForm = '
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">PRTG Server Credentials</h3>
            </div>
            <div class="panel-body">
                <form method="post" action="' . $modulelink . '">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="prtg_username">PRTG Username:</label>
                                <input type="text" name="prtg_username" id="prtg_username" class="form-control" value="' . htmlspecialchars($prtgUsername) . '" placeholder="Enter PRTG username">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="prtg_passhash">PRTG Passhash:</label>
                                <input type="text" name="prtg_passhash" id="prtg_passhash" class="form-control" value="' . htmlspecialchars($prtgPasshash) . '" placeholder="Enter PRTG passhash">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="prtg_url">PRTG Server URL:</label>
                                <input type="text" name="prtg_url" id="prtg_url" class="form-control" value="' . htmlspecialchars($prtgUrl) . '" placeholder="Enter PRTG server URL">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" name="save_credentials" class="btn btn-primary">Save Credentials</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>';
        
        // Display group management form
        $groupForm = '
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Manage Product Groups to Monitor</h3>
            </div>
            <div class="panel-body">
                <form method="post" action="' . $modulelink . '">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="group_id">Add Product Group ID:</label>
                                <input type="number" name="group_id" id="group_id" class="form-control" placeholder="Enter product group ID">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" name="save_groups" class="btn btn-primary form-control">Add Group</button>
                            </div>
                        </div>
                    </div>
                </form>
                
                <h4>Currently Monitored Groups</h4>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Group ID</th>
                            <th>Added Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>';
        
        foreach ($monitoredGroups as $group) {
            $groupForm .= '
                        <tr>
                            <td>' . $group->group_id . '</td>
                            <td>' . $group->created_at . '</td>
                            <td>
                                <form method="post" action="' . $modulelink . '">
                                    <input type="hidden" name="delete_group" value="' . $group->id . '">
                                    <button type="submit" name="save_groups" class="btn btn-danger btn-sm">Delete</button>
                                </form>
                            </td>
                        </tr>';
        }
        
        $groupForm .= '
                    </tbody>
                </table>
            </div>
        </div>';
        
        // Build the query for monitored services
        $whereClause = "";
        if (!empty($groupIds)) {
            $groupIdsStr = implode(',', $groupIds);
            $whereClause = "and `gid` IN ($groupIdsStr)";
        } else {
            // If no groups are defined, use a default (for backward compatibility)
            $whereClause = "and `gid` = 26";
        }
        
        $q = full_query("SELECT *,tblclients.id as userid,firstname,lastname,dedicatedip,tblproducts.id as productid,tblhosting.id as hostingid 
                        FROM `tblproducts`,tblhosting,tblclients 
                        WHERE userid=tblclients.id $whereClause and packageid=tblproducts.id and domainstatus='Active'");
        
        $graphs = "";
        $out = '
    <table class="table table-hover" >
        <thead>
          <tr>
            <th>User</th>
            <th>IP</th>
            <th>Group ID</th>
            <th>Next Due Date</th>
            <th>Last Renew</th>
            <th>Monitoring ID</th>
            <th>Usage</th>
            <th>Limit</th>
            <th>Last Update</th>
          </tr>
        </thead>
        <tbody>
        ';
        $adminurl = "/admin";
        if (isset($GLOBALS['customadminpath']) && $GLOBALS['customadminpath'] != null)
            $adminurl = $GLOBALS['customadminpath'];
        
        if ($q) {
            while ($data = mysql_fetch_array($q)) {
                $date = date_create($data["nextduedate"]);
                date_modify($date, '-1 month');
                $sql = full_query("SELECT * from tblcustomfields,tblcustomfieldsvalues
        WHERE tblcustomfields.relid=" . $data["productid"] . " and tblcustomfieldsvalues.relid = " . $data["hostingid"] . " 
        and tblcustomfieldsvalues.fieldid = tblcustomfields.id and    tblcustomfields.fieldname='monitoringID'");
                $s = mysql_fetch_array($sql);
        
                $sql = full_query("SELECT * from tblcustomfields,tblcustomfieldsvalues
        WHERE tblcustomfields.relid=" . $data["productid"] . " and tblcustomfieldsvalues.relid = " . $data["hostingid"] . " 
        and tblcustomfieldsvalues.fieldid = tblcustomfields.id and    tblcustomfields.fieldname='TrafficLimit'");
                $m = mysql_fetch_array($sql);
        
                $nsql = full_query("SELECT * from mod_trafficusage WHERE product_id=" . $data["hostingid"]);
                $ns = mysql_fetch_array($nsql);
                $nextduedate = $data["nextduedate"];
                $date = date_create($nextduedate);
                $ex = date_modify($date, '-1 month');
                $start = $ex->format("Y-m-d-00-00-00");
                $end = date("Y-m-d-h-i-s");
        
                $out .= "<tr>
                <td><a href='" . $adminurl . "/clientssummary.php?userid=" . $data["userid"] . "'>" . $data["firstname"] . " " . $data["lastname"] . "</a></td>
                <td><a href='" . $adminurl . "/clientsservices.php?userid=" . $data["userid"] . "&id=" . $data["hostingid"] . "'>" . $data["dedicatedip"] . "</a></td>
                <td>" . $data["gid"] . "</td>
                <td>" . $data["nextduedate"] . "</td>
                <td>" . date_format($date, 'Y-m-d') . "</td>
                <td>" . $s["value"] . "</td>
                <td>" . ($ns["usage"] . str_replace(",", "")) . " GB - (" . (($ns["usage"] . str_replace(",", "")) / $m["value"] * 100) . "%)</td>
                <td>" . $m["value"] . " GB  </td>
                <td>" . $ns["lastupdate"] . "</td>
              </tr>";
                $graphs .= "<h2><a href='" . $adminurl . "/clientssummary.php?userid=" . $data["userid"] . "'>" . $data["firstname"] . " " . $data["lastname"] . "</a>
                        </h2>
                        <h3><a href='" . $adminurl . "/clientsservices.php?userid=" . $data["userid"] . "&id=" . $data["hostingid"] . "'>" . $data["dedicatedip"] . "</a></h3>
                        <img src='" . rtrim($prtgUrl, '/') . "/chart.png?username=" . ($prtgCredentials ? $prtgCredentials->username : 'admin') . "&passhash=" . ($prtgCredentials ? $prtgCredentials->passhash : '1314677760') . "&id=" . $s["value"] . "&avg=15&sdate=" . $start . "&edate=" . $end . "&width=850&height=470&graphstyling=baseFontSize=%2712%27%20showLegend=%271%27%20graphid=-1' />";
            }
        }
        
        $out .= '  
        </tbody>
      </table>
    ';
    
        $output = $credentialsForm . $groupForm . '
        <ul class="nav nav-tabs" role="tablist">
            <li class="nav-item active">
                <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab">Traffic Usage</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab">Traffic Graphs</a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="home" role="tabpanel">' . $out . '</div>
            <div class="tab-pane" id="profile" role="tabpanel">' . $graphs . '</div>
        </div>';
    
        return $output;
    }
}