<?php

use WHMCS\Database\Capsule;
require_once('../hooks.php');
// Include the WHMCS configuration file
require_once dirname(dirname(dirname(__FILE__))) . '/configuration.php';
require_once dirname(dirname(dirname(__FILE__))) . '/init.php';

$userid = null;



function ReturnUserIDByAPIKey($key)
{
    try {
        // Check if the API key exists in the database
        $license = Capsule::table('tbllicensefile')
            ->where('apikey', '=', $key)
            ->where('status', '=', 'Active')
            ->first();

        if ($license) {
            return [
                'success' => true,
                'user_id' => $license->userid,
                'order_id' => $license->orderid,
                'domain' => $license->domain,
                'last_update' => $license->lastupdate
            ];
        }

        return [
            'success' => false,
            'message' => 'Invalid API key'
        ];
    } catch (Exception $e) {
        return [
            'success' => false,
            'message' => 'Error checking API key: ' . $e->getMessage()
        ];
    }
}
function checkModuleStatus($moduleName)
{
    $query = select_query(
        'tbladdonmodules',
        'value',
        array(
            'module' => $moduleName,
            'setting' => 'access'
        )
    );
    $result = mysql_fetch_array($query);
    return !empty($result['value']);
}
function bandwidthcalculator()
{


    $outputData = [];
    $log = "\n Start Calculation : " . date("Y-m-d H:i:s");
    if (!checkModuleStatus('virtualizoraddon')) {
        echo 'You need To activate <a href="https://cl.keloncloud.com/store/whmcs-module">virtualizor Addon Module</a> first';
    } else {

        // //1- Get List of Services That we must to calculate their.
        $sql = "SELECT 
        mod_HourlyAddonSeller_services.*,mod_HourlyAddonSeller_products.*,dedicatedip,
        tblhosting.id as hostid ,value as vpsid,tblproducts.name as prname, 
        configoption3,tblhosting.userid as userid,
        tblservers.name as servername,tblservers.username,tblservers.password
        ,tblservers.hostname
        FROM `mod_HourlyAddonSeller_services`,tblhosting,tblservers,tblproducts,
        mod_HourlyAddonSeller_products 
        ,tblcustomfields,tblcustomfieldsvalues
        where  mod_HourlyAddonSeller_services.service_id = tblhosting.id and tblhosting.server=tblservers.id 
        and mod_HourlyAddonSeller_services.status='Active'  and mod_HourlyAddonSeller_products.product_id = tblproducts.id
        and (tblservers.type='virtualizor' or tblservers.type='virtualizor_cloud') 
        and tblproducts.type='server' and tblproducts.id=tblhosting.packageid
        and tblcustomfieldsvalues.fieldid= tblcustomfields.id
        and fieldname='vpsid' and tblcustomfieldsvalues.relid=tblhosting.id 
        and tblhosting.packageid=tblcustomfields.relid;
      ";

        if (!file_exists(__DIR__ . "/../virtualizoraddon/virt.php")) {
            echo "Class Library File Not Exist";
            return;
        }

        require_once(__DIR__ . "/../virtualizoraddon/virt.php");
        $result = full_query($sql);

        $i = 0;
        $output = [];
        $mastername = "";
        $allData = [];
        while ($data = mysql_fetch_array($result)) {
            $allData[] = $data;
            if ($i > 0) {
                $output[$data["hostname"]]["apikey"] = $data["username"];
                $output[$data["hostname"]]["apipass"] = $data["password"];
                $output[$data["hostname"]]["apihostname"] = $data["hostname"];
                $output[$data["hostname"]]["ids"][] = $data["vpsid"];
                $output[$data["hostname"]][$data["vpsid"]] = $data;
            } else {
                if ($mastername == $data["hostname"]) {
                    //add to array
                    $output[$data["hostname"]]["ids"][] = $data["vpsid"];
                    $output[$data["hostname"]][$data["vpsid"]] = $data;
                } else {
                    //create new
                    $output[$data["hostname"]]["apikey"] = $data["username"];
                    $output[$data["hostname"]]["apipass"] = $data["password"];
                    $output[$data["hostname"]]["apihostname"] = $data["hostname"];
                    $output[$data["hostname"]]["ids"][] = $data["vpsid"];
                    $output[$data["hostname"]][$data["vpsid"]] = $data;
                }
            }
            $mastername = $data["hostname"];
            $i++;
        }

        foreach ($output as $o) {
            $command = 'DecryptPassword';
            $postData = array(
                'password2' => $o["apipass"],
            );
            $passDecrypt = localAPI($command, $postData);
            $key = $o["apikey"];
            $pass = $passDecrypt["password"];
            $ip = $o["apihostname"];
            $admin = new VirtualizorAddon_Admin_API($ip, $key, $pass);

            $vids = $o["ids"];

            $ListOfVPS = $admin->status($vids);
            $apiKey = Hook_HourlyAddonSeller_getApiKey();
            if (empty($apiKey)) {
                throw new Exception("API key not configured");
            }

            // API endpoint URL
            $apiUrl = "https://cl.keloncloud.com/api/hourlyseller/cron.php";

            // API authentication
            $headers = [
                'Authorization: Bearer ' . $apiKey,
                'Content-Type: application/json'
            ];

            // Send request
            $ch = curl_init($apiUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($ListOfVPS));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);

            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);

            curl_close($ch);

            // foreach ($ListOfVPS as $l => $k) {
            //     $bandpay = (intval($k["used_bandwidth"]) - $output[$ip][$l]["last_traffic"] - $output[$ip][$l]["free_traffic"]) . "<br />";

            //     $log .= "\nID: " . $l;
            //     if ($bandpay > 0) {
            //         $log .= "\nbandwidth needs to pay:" . $bandpay . "<br />";
            //         $unit_price = $output[$ip][$l]["traffic_amount"];
            //         $log .= "\nAmounts for payment:" . ($bandpay * $unit_price) . "<br />";
            //         $finalAmount = $bandpay * $unit_price;
            //         $tax = $finalAmount * 10 / 100;
            //         $final = $finalAmount + $tax;
            //         //Update Balance Tables
            //         $pdo = Capsule::connection()->getPdo();
            //         $pdo->beginTransaction();
            //         $statement = $pdo->prepare(
            //             'update mod_KelonCloudPayAsYouGo_balance set balance = balance - :final where userid=:userid'
            //         );
            //         $statement->execute(
            //             [
            //                 ':final' => $final,
            //                 ':userid' => $output[$ip][$l]["userid"]
            //             ]
            //         );
            //         if ($pdo->inTransaction()) {
            //             $pdo->commit();
            //         }
            //         //Update Log Tables
            //         $table = "mod_KelonCloudPayAsYouGo_log";
            //         $values = array(
            //             "service_id" => $output[$ip][$l]["service_id"],
            //             "from" => $output[$ip][$l]["last_calculated"],
            //             "to" => date("Y-m-d H:i:s"),
            //             "description" =>
            //                 "مصرف ترافیک سرور (" . $output[$ip][$l]["dedicatedip"] . ")"
            //                 . $bandpay . "GB",
            //             "amount" => $finalAmount,
            //             "tax" => $tax,
            //             "value" => $final * (-1),
            //             "created_at" => date("Y-m-d H:i:s"),
            //             "source" => "virtualizorhourly"
            //         );
            //         insert_query($table, $values);
            //         //Update Service Tables
            //         $values = array(
            //             "updated_at" => date("Y-m-d H:i:s"),
            //             "last_calculated" => date("Y-m-d H:i:s"),
            //             "last_traffic" => intval($k["used_bandwidth"]),
            //         );
            //         Capsule::table('mod_HourlyAddonSeller_services')
            //             ->where('service_id', '=', $output[$ip][$l]["service_id"])
            //             ->where('status', '=', "Active")
            //             ->update($values);
            //     }

            //     $TimeForCalculation = getHoursDifference($output[$ip][$l]["last_service_calculated"], date("Y-m-d H:i:s"));
            //     if ($TimeForCalculation > 0) {
            //         $serverPay = $TimeForCalculation * $output[$ip][$l]["service_amount"];
            //         $unit_price = $output[$ip][$l]["service_amount"];
            //         $log .= "\nAmounts for payment:" . ($serverPay) . "<br />";

            //         $tax = $serverPay * 10 / 100;
            //         $final = $serverPay + $tax;
            //         //Update Balance Tables
            //         $pdo = Capsule::connection()->getPdo();
            //         $pdo->beginTransaction();
            //         $statement = $pdo->prepare(
            //             'update mod_KelonCloudPayAsYouGo_balance set balance = balance - :final where userid=:userid'
            //         );
            //         $statement->execute(
            //             [
            //                 ':final' => $final,
            //                 ':userid' => $output[$ip][$l]["userid"]
            //             ]
            //         );
            //         if ($pdo->inTransaction()) {
            //             $pdo->commit();
            //         }
            //         //Update Log Tables
            //         $table = "mod_KelonCloudPayAsYouGo_log";
            //         $values = array(
            //             "service_id" => $output[$ip][$l]["service_id"],
            //             "from" => $output[$ip][$l]["last_calculated"],
            //             "to" => date("Y-m-d H:i:s"),
            //             "description" => "استفاده از سرور (" . $output[$ip][$l]["dedicatedip"] . ")
            //             (" . $output[$ip][$l]["last_service_calculated"] . " - " . date("Y-m-d H:i:s") . ")",
            //             "amount" => $serverPay,
            //             "tax" => $tax,
            //             "value" => $final * (-1),
            //             "created_at" => date("Y-m-d H:i:s"),
            //             "source" => "virtualizorhourly"
            //         );
            //         insert_query($table, $values);
            //         //Update Service Tables
            //         $values = array(
            //             "updated_at" => date("Y-m-d H:i:s"),
            //             "last_service_calculated" => date("Y-m-d H:i:s")
            //         );
            //         Capsule::table('mod_HourlyAddonSeller_services')
            //             ->where('service_id', '=', $output[$ip][$l]["service_id"])
            //             ->where('status', '=', "Active")
            //             ->update($values);
            //     }
            // }
        }
        $log .= "\n End Calculation : " . date("Y-m-d H:i:s");

        file_put_contents("/home/keloncloud/cl.keloncloud.com/modules/addons/virtualizorhourly/hooktraffic.log", $log . "\n", FILE_APPEND);
    }
}
function getHoursDifference($startDateTime, $endDateTime)
{
    // Create DateTime objects
    $start = new DateTime($startDateTime);
    $end = new DateTime($endDateTime);

    // Calculate the difference
    $interval = $start->diff($end);

    // Convert the difference to total hours
    $hours = $interval->h + ($interval->days * 24);

    return $hours;
}