<?php
/**
 * Example script to get user credit balance via API
 */

// API endpoint URL - replace with your actual WHMCS URL
$apiUrl = 'https://your-whmcs-domain.com/modules/addons/AddonSeller/api.php';

// Your API key from the mod_HourlyAddonSeller table
$apiKey = 'your_api_key_here';

// User ID to check
$userId = 123; // Replace with the actual user ID

// Set up the request
$postData = [
    'action' => 'get_user_credit',
    'user_id' => $userId
];

// Initialize cURL session
$ch = curl_init($apiUrl);

// Set cURL options
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'X-API-KEY: ' . $apiKey,
    'Content-Type: application/x-www-form-urlencoded'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

// Execute cURL request
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

// Close cURL session
curl_close($ch);

// Process the response
if ($error) {
    echo "Error: " . $error . "\n";
    exit(1);
}

if ($httpCode < 200 || $httpCode >= 300) {
    echo "HTTP Error: " . $httpCode . "\n";
    echo "Response: " . $response . "\n";
    exit(1);
}

// Decode the JSON response
$data = json_decode($response, true);

// Display the results
echo "User ID: " . $data['user_id'] . "\n";
echo "Credit Balance: " . $data['credit'] . "\n";
echo "Has Account: " . ($data['has_account'] ? 'Yes' : 'No') . "\n";

if (isset($data['last_updated'])) {
    echo "Last Updated: " . $data['last_updated'] . "\n";
}

// Example of how to use the data
if ($data['credit'] <= 0) {
    echo "Warning: User has no credit or negative balance!\n";
} else {
    echo "User has sufficient credit.\n";
}