<?php

use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\HourlyAddonSeller\Admin\AdminDispatcher;
use WHMCS\Module\Addon\HourlyAddonSeller\Client\ClientDispatcher;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function HourlyAddonSeller_config()
{
    return [
        // Display name for your module
        'name' => 'Kelon Cloud Module Hourly Billing',
        // Description displayed within the admin interface
        'description' => 'Kelon Cloud Module For Selling VPS based on Hourly system',
        // Module author name
        'author' => '@kelonCloud Developer Team',
        // Default language
        'language' => 'english',
        // Version number
        'version' => '1.0',
    ];
}

function HourlyAddonSeller_activate()
{
    // Create custom tables and schema required by your module
    try {
        Capsule::schema()
            ->create(
                'mod_HourlyAddonSeller',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->text('apikey');
                    $table->enum('status', ['Active', 'Suspended', 'Terminated']);
                    $table->timestamps();
                }
            );

        // Create API request queue table
        Capsule::schema()
            ->create(
                'mod_HourlyAddonSeller_api_queue',
                function ($table) {
                    $table->increments('id');
                    $table->text('request_data');
                    $table->enum('status', ['pending', 'processing', 'failed']);
                    $table->integer('attempts')->default(0);
                    $table->datetime('last_attempt')->nullable();
                    $table->text('response')->nullable();
                    $table->text('error')->nullable();
                    $table->timestamps();
                }
            );
        Capsule::schema()
            ->create(
                'mod_HourlyAddonSeller_products',
                function ($table) {
                    $table->increments('id');
                    $table->integer('product_id');
                    $table->integer('minimum_balance');
                    $table->integer('service_amount');
                    $table->integer('traffic_amount');
                    $table->integer('free_traffic');
                    $table->enum('traffic_type', ['download', 'upload', 'both']);
                    $table->text('prtype');
                    $table->timestamps();
                }
            );
        Capsule::schema()
            ->create(
                'mod_HourlyAddonSeller_services',
                function ($table) {
                    $table->increments('id');
                    $table->integer('service_id');
                    $table->datetime('start_time');
                    $table->datetime('last_calculated');
                    $table->datetime('last_service_calculated');
                    $table->integer('last_traffic');
                    $table->enum('status', ['Active', 'Suspended', 'Terminated']);
                    $table->timestamps();
                }
            );

        Capsule::schema()
            ->create(
                'mod_HourlyAddonSeller_balance',
                function ($table) {
                    $table->integer('userid');
                    $table->integer('balance');
                    $table->timestamps();
                }
            );
        Capsule::schema()
            ->create(
                'mod_HourlyAddonSeller_invoice',
                function ($table) {
                    $table->integer('invoice_id');
                    $table->integer('amount');
                    $table->enum('status', ['unpaid', 'paid']);
                    $table->timestamps();
                }
            );
        return [
            // Supported values here include: success, error or info
            'status' => 'success',
            'description' => 'Module Activated SuccessFully',
        ];
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            'status' => "error",
            'description' => 'Unable to create HourlyAddonSeller: ' . $e->getMessage(),
        ];
    }
}

function HourlyAddonSeller_deactivate()
{
    // Undo any database and schema modifications made by your module here
    try {
        Capsule::schema()
            ->dropIfExists('mod_HourlyAddonSeller');
        Capsule::schema()
            ->dropIfExists('mod_HourlyAddonSeller_services');
        Capsule::schema()
            ->dropIfExists('mod_HourlyAddonSeller_products');
        Capsule::schema()
            ->dropIfExists('mod_HourlyAddonSeller_api_queue');

        return [
            // Supported values here include: success, error or info
            'status' => 'success',
            'description' => 'Module Deactivated Successfully',
        ];
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            "status" => "error",
            "description" => "Unable to drop mod_HourlyAddonSeller: {$e->getMessage()}",
        ];
    }
}
function HourlyAddonSeller_upgrade($vars)
{
    $currentlyInstalledVersion = $vars['version'];

    if ($currentlyInstalledVersion < 1.1) {
        $schema = Capsule::schema();
        // Alter the table and add a new text column called "demo2"
        $schema->table('mod_addonexample', function ($table) {
            $table->text('demo2');
        });
    }

    /// Perform SQL schema changes required by the upgrade to version 1.2 of your module
    if ($currentlyInstalledVersion < 1.2) {
        $schema = Capsule::schema();
        // Alter the table and add a new text column called "demo3"
        $schema->table('mod_addonexample', function ($table) {
            $table->text('demo3');
        });
    }
}
function HourlyAddonSeller_output($vars)
{
    $modulelink = $vars['modulelink'];

    $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'index';
    $dispatcher = new AdminDispatcher();
    $response = $dispatcher->dispatch($action, $vars);
    echo $response;
}

function HourlyAddonSeller_sidebar($vars)
{
}
// function HourlyAddonSeller_clientarea($vars)
// {
//     $modulelink = "/modules/addons/HourlyAddonSeller";
//     $LANG = $vars['_lang'];
//     return array(
//         'pagetitle' => $LANG["pagetitle"],
//         'breadcrumb' => array(
//             'index.php?m=HourlyAddonSeller' =>
//                 $LANG["pagetitle"]
//         ),
//         'templatefile' => 'publicpage',
//         'requirelogin' => true, # accepts true/false
//         'forcessl' => false, # accepts true/false
//         'vars' => array(
//             'testvar' => 'demo',
//             'anothervar' => 'value',
//             'sample' => 'test',
//             'btns' => $btns,
//             'items' => $items,
//             'modulelink' => $modulelink,
//             'cnd' => $cnd,
//             'listofproduct' => $ListOfProducts
//         ),
//     );
// }

function HourlyAddonSeller_ClientArea($vars)
{
    // Load messages from external file
    $messages = require_once(__DIR__ . '/messages.php');

    $modulelink = $vars['modulelink'];
    $success = '';
    $error = '';

    // Check if user is logged in
    if (!isset($_SESSION['uid'])) {
        return [
            'pagetitle' => $messages['service']['title'] ?? 'Hourly Addon Seller',
            'breadcrumb' => [
                'index.php?m=HourlyAddonSeller' => $messages['service']['title'] ?? 'Hourly Addon Seller'
            ],
            'templatefile' => 'error',
            'requirelogin' => true,
            'vars' => [
                'error' => $messages['error']['login_required'] ?? 'You must be logged in to access this page.'
            ],
        ];
    }

    // Handle form submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['amount'])) {
        $amount = (int) $_POST['amount'];

        if ($amount <= 0) {
            $error = $messages['error']['invalid_amount'] ?? 'Amount must be greater than zero.';
        } else {
            // Create invoice
            $result = createCreditInvoice($_SESSION['uid'], $amount);

            if ($result['success']) {
                // Redirect to the invoice page
                header("Location: " . $vars['systemurl'] . "/viewinvoice.php?id=" . $result['invoiceid']);
                exit;
            } else {
                $error = ($messages['error']['invoice_creation'] ?? 'Failed to create invoice: ') . $result['message'];
            }
        }
    }

    // Get current balance
    $balance = Capsule::table('mod_HourlyAddonSeller_balance')
        ->where('userid', '=', $_SESSION['uid'])
        ->value('balance');

    if ($balance === null) {
        $balance = 0;
    }

    // Return template variables
    return [
        'pagetitle' => $messages['button']['add_credit'] ?? 'Add Credit',
        'breadcrumb' => [
            'index.php?m=HourlyAddonSeller' => $messages['service']['title'] ?? 'Hourly Addon Seller',
            'index.php?m=HourlyAddonSeller&action=addcredit' => $messages['button']['add_credit'] ?? 'Add Credit'
        ],
        'templatefile' => 'addcredit',
        'requirelogin' => true,
        'vars' => [
            'modulelink' => $modulelink,
            'success' => $success,
            'error' => $error,
            'balance' => $balance
        ],
    ];
}

/**
 * Create an invoice for adding credit
 * 
 * @param int $userId User ID
 * @param int $amount Amount to add
 * @return array Result with success status and message
 */
function createCreditInvoice($userId, $amount)
{
    // Load messages from external file
    $messages = require_once(__DIR__ . '/messages.php');

    // Create invoice
    $command = 'CreateInvoice';
    $postData = [
        'userid' => $userId,
        'status' => 'Unpaid',
        'sendinvoice' => true,
        //'paymentmethod' => 'banktransfer', // Default payment method
        'taxrate' => 0,
        'date' => date('Y-m-d'),
        'duedate' => date('Y-m-d', strtotime('+7 days')),
        'itemdescription1' => $messages['invoice']['credit_addition'],
        'itemamount1' => $amount,
        'itemtaxed1' => false,
    ];

    $results = localAPI($command, $postData);

    if ($results['result'] == 'success') {
        // Record in our custom table
        Capsule::table('mod_HourlyAddonSeller_invoice')->insert([
            'invoice_id' => $results['invoiceid'],
            'amount' => $amount,
            'status' => 'unpaid',
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        ]);

        return [
            'success' => true,
            'invoiceid' => $results['invoiceid']
        ];
    } else {
        return [
            'success' => false,
            'message' => $results['message']
        ];
    }
}


/**
 * Get API key from database
 * @return string API key or empty string if not found
 */
function HourlyAddonSeller_getApiKey()
{
    try {
        $apiData = Capsule::table('mod_HourlyAddonSeller')
            ->where('id', '=', '1')
            ->first();

        return $apiData ? $apiData->apikey : '';
    } catch (\Exception $e) {
        logActivity("Error retrieving API key: " . $e->getMessage());
        return '';
    }
}

/**
 * Get user credit from external API
 * @param int $userId WHMCS user ID
 * @return array Credit information or error
 */
function HourlyAddonSeller_getUserCreditFromApi($userId)
{
    // External API endpoint
    $apiUrl = "https://cl.keloncloud.com/api/credit";

    // Get API key for authentication
    $apiKey = HourlyAddonSeller_getApiKey();

    // Prepare request data
    $postData = [
        'user_id' => $userId,
        'source' => 'whmcs'
    ];

    // Set up headers
    $headers = [
        'Authorization: Bearer ' . $apiKey,
        'Content-Type: application/json',
        'Accept: application/json'
    ];

    // Initialize cURL session
    $ch = curl_init($apiUrl);

    // Set cURL options
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    // Execute cURL request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);

    // Close cURL session
    curl_close($ch);

    // Handle errors
    if ($error) {
        logActivity("API Error when getting user credit: " . $error);
        return [
            'success' => false,
            'error' => $error,
            'credit' => 0
        ];
    }

    if ($httpCode < 200 || $httpCode >= 300) {
        logActivity("API HTTP Error when getting user credit: " . $httpCode . " - " . $response);
        return [
            'success' => false,
            'error' => "HTTP Error: " . $httpCode,
            'credit' => 0
        ];
    }

    // Parse response
    $data = json_decode($response, true);

    if (!$data || !isset($data['credit'])) {
        return [
            'success' => false,
            'error' => "Invalid response from API",
            'credit' => 0
        ];
    }

    return [
        'success' => true,
        'credit' => (int) $data['credit'],
        'last_updated' => $data['last_updated'] ?? date('Y-m-d H:i:s')
    ];
}

function HourlyAddonSeller_checkModuleStatus($moduleName)
{
    $query = select_query(
        'tbladdonmodules',
        'value',
        array(
            'module' => $moduleName,
            'setting' => 'access'
        )
    );
    $result = mysql_fetch_array($query);
    return !empty($result['value']);
}
function HourlyAddonSeller_bandwidthcalculator()
{
    $log = "\n Start Calculation : " . date("Y-m-d H:i:s");
    if (!HourlyAddonSeller_checkModuleStatus('virtualizoraddon')) {
        echo 'You need To activate <a href="https://cl.keloncloud.com/store/whmcs-module">virtualizor Addon Module</a> first';
    } else {

        // //1- Get List of Services That we must to calculate their.
        $sql = "SELECT 
mod_HourlyAddonSeller_service.*,mod_HourlyAddonSeller_product .*,dedicatedip,
tblhosting.id as hostid ,value as vpsid,tblproducts.name as prname, configoption3,tblhosting.userid as userid,
                                tblservers.name as servername,tblservers.username,tblservers.password,tblservers.hostname
FROM `mod_HourlyAddonSeller_service`,tblhosting,tblservers,tblproducts,mod_HourlyAddonSeller_product 
  ,tblcustomfields,tblcustomfieldsvalues
        where  mod_HourlyAddonSeller_service.service_id = tblhosting.id and tblhosting.server=tblservers.id and 
        mod_HourlyAddonSeller_service.status='Active'  and mod_HourlyAddonSeller.product_id = tblproducts.id
        and (tblservers.type='virtualizor' or tblservers.type='virtualizor_cloud') 
        and tblproducts.type='server' and tblproducts.id=tblhosting.packageid
        and tblcustomfieldsvalues.fieldid= tblcustomfields.id
        and fieldname='vpsid' and tblcustomfieldsvalues.relid=tblhosting.id 
        and tblhosting.packageid=tblcustomfields.relid;
      ";

        if (!file_exists(__DIR__ . "/../virtualizoraddon/virt.php")) {
            echo "Class Library File Not Exist";
            return;
        }

        require_once(__DIR__ . "/../virtualizoraddon/virt.php");
        $result = full_query($sql);

        $i = 0;
        $output = [];
        $mastername = "";
        $allData = [];
        while ($data = mysql_fetch_array($result)) {
            $allData[] = $data;
            if ($i > 0) {
                $output[$data["hostname"]]["apikey"] = $data["username"];
                $output[$data["hostname"]]["apipass"] = $data["password"];
                $output[$data["hostname"]]["apihostname"] = $data["hostname"];
                $output[$data["hostname"]]["ids"][] = $data["vpsid"];
                $output[$data["hostname"]][$data["vpsid"]] = $data;
            } else {
                if ($mastername == $data["hostname"]) {
                    //add to array
                    $output[$data["hostname"]]["ids"][] = $data["vpsid"];
                    $output[$data["hostname"]][$data["vpsid"]] = $data;
                } else {
                    //create new
                    $output[$data["hostname"]]["apikey"] = $data["username"];
                    $output[$data["hostname"]]["apipass"] = $data["password"];
                    $output[$data["hostname"]]["apihostname"] = $data["hostname"];
                    $output[$data["hostname"]]["ids"][] = $data["vpsid"];
                    $output[$data["hostname"]][$data["vpsid"]] = $data;
                }
            }
            $mastername = $data["hostname"];
            $i++;
        }

        foreach ($output as $o) {
            $command = 'DecryptPassword';
            $postData = array(
                'password2' => $o["apipass"],
            );
            $passDecrypt = localAPI($command, $postData);
            $key = $o["apikey"];
            $pass = $passDecrypt["password"];
            $ip = $o["apihostname"];
            $admin = new VirtualizorAddon_Admin_API($ip, $key, $pass);

            $vids = $o["ids"];

            $ListOfVPS = $admin->status($vids);
            foreach ($ListOfVPS as $l => $k) {
                $bandpay = (intval($k["used_bandwidth"]) - $output[$ip][$l]["last_traffic"] - $output[$ip][$l]["free_traffic"]) . "<br />";

                $log .= "\nID: " . $l;
                if ($bandpay > 0) {
                    $log .= "\nbandwidth needs to pay:" . $bandpay . "<br />";
                    $unit_price = $output[$ip][$l]["traffic_amount"];
                    $log .= "\nAmounts for payment:" . ($bandpay * $unit_price) . "<br />";
                    $finalAmount = $bandpay * $unit_price;
                    $tax = $finalAmount * 10 / 100;
                    $final = $finalAmount + $tax;
                    //Update Balance Tables
                    $pdo = Capsule::connection()->getPdo();
                    $pdo->beginTransaction();
                    $statement = $pdo->prepare(
                        'update mod_HourlyAddonSeller_balance set balance = balance - :final where userid=:userid'
                    );
                    $statement->execute(
                        [
                            ':final' => $final,
                            ':userid' => $output[$ip][$l]["userid"]
                        ]
                    );
                    if ($pdo->inTransaction()) {
                        $pdo->commit();
                    }
                    //Update Log Tables
                    $table = "mod_HourlyAddonSeller_log";
                    $values = array(
                        "service_id" => $output[$ip][$l]["service_id"],
                        "from" => $output[$ip][$l]["last_calculated"],
                        "to" => date("Y-m-d H:i:s"),
                        "description" =>
                            "مصرف ترافیک سرور (" . $output[$ip][$l]["dedicatedip"] . ")"
                            . $bandpay . "GB",
                        "amount" => $finalAmount,
                        "tax" => $tax,
                        "value" => $final * (-1),
                        "created_at" => date("Y-m-d H:i:s"),
                        "source" => "HourlyAddonSeller"
                    );
                    insert_query($table, $values);
                    //Update Service Tables
                    $values = array(
                        "updated_at" => date("Y-m-d H:i:s"),
                        "last_calculated" => date("Y-m-d H:i:s"),
                        "last_traffic" => intval($k["used_bandwidth"]),
                    );
                    Capsule::table('mod_HourlyAddonSeller_service')
                        ->where('service_id', '=', $output[$ip][$l]["service_id"])
                        ->where('status', '=', "Active")
                        ->update($values);
                }

                $TimeForCalculation = HourlyAddonSeller_getHoursDifference($output[$ip][$l]["last_service_calculated"], date("Y-m-d H:i:s"));
                if ($TimeForCalculation > 0) {
                    $serverPay = $TimeForCalculation * $output[$ip][$l]["service_amount"];
                    $unit_price = $output[$ip][$l]["service_amount"];
                    $log .= "\nAmounts for payment:" . ($serverPay) . "<br />";

                    $tax = $serverPay * 10 / 100;
                    $final = $serverPay + $tax;
                    //Update Balance Tables
                    $pdo = Capsule::connection()->getPdo();
                    $pdo->beginTransaction();
                    $statement = $pdo->prepare(
                        'update mod_HourlyAddonSeller_balance set balance = balance - :final where userid=:userid'
                    );
                    $statement->execute(
                        [
                            ':final' => $final,
                            ':userid' => $output[$ip][$l]["userid"]
                        ]
                    );
                    if ($pdo->inTransaction()) {
                        $pdo->commit();
                    }
                    //Update Log Tables
                    $table = "mod_HourlyAddonSeller_log";
                    $values = array(
                        "service_id" => $output[$ip][$l]["service_id"],
                        "from" => $output[$ip][$l]["last_calculated"],
                        "to" => date("Y-m-d H:i:s"),
                        "description" => "استفاده از سرور (" . $output[$ip][$l]["dedicatedip"] . ")
                        (" . $output[$ip][$l]["last_service_calculated"] . " - " . date("Y-m-d H:i:s") . ")",
                        "amount" => $serverPay,
                        "tax" => $tax,
                        "value" => $final * (-1),
                        "created_at" => date("Y-m-d H:i:s"),
                        "source" => "HourlyAddonSeller"
                    );
                    insert_query($table, $values);
                    //Update Service Tables
                    $values = array(
                        "updated_at" => date("Y-m-d H:i:s"),
                        "last_service_calculated" => date("Y-m-d H:i:s")
                    );
                    Capsule::table('mod_HourlyAddonSeller_service')
                        ->where('service_id', '=', $output[$ip][$l]["service_id"])
                        ->where('status', '=', "Active")
                        ->update($values);
                }
            }
        }
        $log .= "\n End Calculation : " . date("Y-m-d H:i:s");

        file_put_contents("/home/keloncloud/cl.keloncloud.com/modules/addons/HourlyAddonSeller/hooktraffic.log", $log . "\n", FILE_APPEND);
    }
}
function HourlyAddonSeller_getHoursDifference($startDateTime, $endDateTime)
{
    // Create DateTime objects
    $start = new DateTime($startDateTime);
    $end = new DateTime($endDateTime);

    // Calculate the difference
    $interval = $start->diff($end);

    // Convert the difference to total hours
    $hours = $interval->h + ($interval->days * 24);

    return $hours;
}
function HourlyAddonSeller_disableserversbybalance()
{
    $log = "\n Start Suspending : " . date("Y-m-d H:i:s");
    $data = Capsule::table('mod_HourlyAddonSeller_balance')
        ->where("balance", "<", "0") // we can add multiple where conditions
        ->get();
    foreach ($data as $d) {
        $userid = $d->userid;
        $log .= "\n Suspending User ID : " . $userid;
        $sql = "SELECT tblhosting.id from mod_HourlyAddonSeller_products,tblhosting where 
        tblhosting.packageid = mod_HourlyAddonSeller_products.product_id and 
        tblhosting.domainstatus='Active' and tblhosting.userid=" . $userid;
        $r = full_query($sql);
        while ($datad = mysql_fetch_array($r)) {
            $log .= "\n Suspending ServiceID : " . $datad["id"];
            $command = 'ModuleSuspend';
            $postData = array(
                'serviceid' => $datad["id"],
                'suspendreason' => "منفی بودن اعتبار سرویس"
            );
            $results = localAPI($command, $postData);
            $log .= "\n Suspending ServiceID result : " . json_encode($results);
        }
    }
    $log .= "\n End Suspending : " . date("Y-m-d H:i:s");
    file_put_contents("/home/keloncloud/cl.keloncloud.com/modules/addons/HourlyAddonSeller/suspend.log", $log . "\n", FILE_APPEND);
}
function HourlyAddonSeller_UnsuspendServices($userid)
{
    $log = "\n Start UnSuspending : " . date("Y-m-d H:i:s");
    $data = Capsule::table('mod_HourlyAddonSeller_balance')
        ->where("balance", ">", "0")
        ->where("userid", "=", $userid)
        ->get();
    foreach ($data as $d) {

        $log .= "\n UnSuspending User ID : " . $userid;
        $sql = "SELECT tblhosting.id as id from mod_HourlyAddonSeller_products,tblhosting where tblhosting.packageid = mod_HourlyAddonSeller_products.product_id
        and tblhosting.domainstatus='Suspended' and tblhosting.userid=" . $userid;
        $r = full_query($sql);
        while ($datad = mysql_fetch_array($r)) {
            $values = array(
                "updated_at" => date("Y-m-d H:i:s"),
                "last_service_calculated" => date("Y-m-d H:i:s")
            );
            Capsule::table('mod_HourlyAddonSeller_service')
                ->where('service_id', '=', $datad["id"])
                ->update($values);
            $log .= "\n UnSuspending ServiceID : " . $datad["id"];
            $command = 'ModuleUnsuspend';
            $postData = array(
                'serviceid' => $datad["id"]
            );
            $results = localAPI($command, $postData);

            $log .= "\n Suspending ServiceID result : " . json_encode($results);
        }
    }

    $log .= "\n End UnSuspending : " . date("Y-m-d H:i:s");
    file_put_contents("/home/keloncloud/cl.keloncloud.com/modules/addons/HourlyAddonSeller/unsuspend.log", $log . "\n", FILE_APPEND);
    return $log;
}