/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.vncviewer;

import com.tightvnc.vncviewer.InStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ZlibInStream
extends InStream {
    static final int defaultBufSize = 16384;
    private InStream underlying;
    private int bufSize;
    private int ptrOffset;
    private Inflater inflater;
    private int bytesIn;

    public ZlibInStream(int n) {
        this.bufSize = n;
        this.b = new byte[this.bufSize];
        this.ptrOffset = 0;
        this.end = 0;
        this.ptr = 0;
        this.inflater = new Inflater();
    }

    public ZlibInStream() {
        this(16384);
    }

    public void setUnderlying(InStream inStream, int n) {
        this.underlying = inStream;
        this.bytesIn = n;
        this.end = 0;
        this.ptr = 0;
    }

    public void reset() throws Exception {
        this.end = 0;
        this.ptr = 0;
        if (this.underlying == null) {
            return;
        }
        while (this.bytesIn > 0) {
            this.decompress();
            this.end = 0;
        }
        this.underlying = null;
    }

    public int pos() {
        return this.ptrOffset + this.ptr;
    }

    protected int overrun(int n, int n2) throws Exception {
        if (n > this.bufSize) {
            throw new Exception("ZlibInStream overrun: max itemSize exceeded");
        }
        if (this.underlying == null) {
            throw new Exception("ZlibInStream overrun: no underlying stream");
        }
        if (this.end - this.ptr != 0) {
            System.arraycopy(this.b, this.ptr, this.b, 0, this.end - this.ptr);
        }
        this.ptrOffset += this.ptr;
        this.end -= this.ptr;
        this.ptr = 0;
        while (this.end < n) {
            this.decompress();
        }
        if (n * n2 > this.end) {
            n2 = this.end / n;
        }
        return n2;
    }

    private void decompress() throws Exception {
        try {
            this.underlying.check(1);
            int n = this.underlying.getend() - this.underlying.getptr();
            if (n > this.bytesIn) {
                n = this.bytesIn;
            }
            if (this.inflater.needsInput()) {
                this.inflater.setInput(this.underlying.getbuf(), this.underlying.getptr(), n);
            }
            int n2 = this.inflater.inflate(this.b, this.end, this.bufSize - this.end);
            this.end += n2;
            if (this.inflater.needsInput()) {
                this.bytesIn -= n;
                this.underlying.setptr(this.underlying.getptr() + n);
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new Exception("ZlibInStream: inflate failed");
        }
    }
}

