/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.vncviewer;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import com.tightvnc.vncviewer.SocketFactory;
import com.tightvnc.vncviewer.SshPasswordRequester;
import com.tightvnc.vncviewer.SshUserNameRequester;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

class SshTunneledSocketFactory
implements SocketFactory {
    private int localPort = 0;

    SshTunneledSocketFactory() {
    }

    public Socket createSocket(String string, int n, Applet applet) throws IOException {
        return this.createSocket(string, n, applet.getParameter("SSHHOST"));
    }

    public Socket createSocket(String string, int n, String[] stringArray) throws IOException {
        return this.createSocket(string, n, this.readArg(stringArray, "SSHHOST"));
    }

    public Socket createSocket(String string, int n, String string2) throws IOException {
        if (this.localPort == 0) {
            if (string2 == null) {
                string2 = System.getProperty("user.name") + "@" + string;
                System.out.println("SSH host not specified, assuming " + string2);
            }
            System.out.println("Creating SSH tunnel to " + string2);
            try {
                this.createTunnel(string, n, string2);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("Could not create SSH tunnel; cause: " + exception.getMessage());
            }
            System.out.println("Local port for the SSH tunnel is " + this.localPort);
        }
        return new Socket("127.0.0.1", this.localPort);
    }

    private void createTunnel(String string, int n, String string2) throws Exception {
        try {
            JSch jSch = new JSch();
            int n2 = string2.indexOf(64);
            String string3 = "";
            string3 = n2 > 0 ? string2.substring(0, n2) : new SshUserNameRequester().queryUserName();
            string2 = string2.substring(n2 + 1);
            Session session = jSch.getSession(string3, string2, 22);
            MyUserInfo myUserInfo = new MyUserInfo();
            session.setUserInfo(myUserInfo);
            session.connect();
            this.localPort = session.setPortForwardingL(this.localPort, string, n);
        }
        catch (JSchException jSchException) {
            throw new IOException(jSchException);
        }
    }

    private String readArg(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            try {
                return stringArray[i + 1];
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String passwd;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String string) {
            Object[] objectArray = new Object[]{"yes", "no"};
            int n = JOptionPane.showOptionDialog(null, string, "SSH: Warning", -1, 2, null, objectArray, objectArray[0]);
            return n == 0;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public boolean promptPassword(String string) {
            SshPasswordRequester sshPasswordRequester = new SshPasswordRequester(string + ":");
            try {
                char[] cArray = sshPasswordRequester.queryPassword();
                this.passwd = new String(cArray);
                Arrays.fill(cArray, '\u0000');
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public void showMessage(String string) {
            JOptionPane.showMessageDialog(null, string);
        }

        public String[] promptKeyboardInteractive(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)new JLabel(string3), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = -1;
            JTextField[] jTextFieldArray = new JTextField[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 1.0;
                jPanel.add((Component)new JLabel(stringArray[i]), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weighty = 1.0;
                jTextFieldArray[i] = blArray[i] ? new JTextField(20) : new JPasswordField(20);
                jPanel.add((Component)jTextFieldArray[i], gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
            if (JOptionPane.showConfirmDialog(null, jPanel, string + ": " + string2, 2, 3) == 0) {
                String[] stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = jTextFieldArray[i].getText();
                }
                return stringArray2;
            }
            return null;
        }
    }
}

