/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.vncviewer;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;

public class SshPasswordDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JButton okButton;
    private JPasswordField passwordField;
    private JLabel promptLabel;
    private int returnStatus = 0;

    public SshPasswordDialog(Frame frame, boolean bl, String string) {
        super(frame, bl);
        this.initComponents();
        if (string != null) {
            this.promptLabel.setText(string);
        }
        this.setLocationRelativeTo(null);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    private void initComponents() {
        this.promptLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle("SSH Password");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SshPasswordDialog.this.closeDialog(windowEvent);
            }
        });
        this.promptLabel.setText("Please enter the password for SSH connection:");
        this.passwordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SshPasswordDialog.this.onPasswordActionPerformed(actionEvent);
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SshPasswordDialog.this.passwordFieldKeyTyped(keyEvent);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SshPasswordDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SshPasswordDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordField, GroupLayout.Alignment.TRAILING, -1, 226, Short.MAX_VALUE).addComponent(this.promptLabel, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(96, Short.MAX_VALUE).addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        groupLayout.linkSize(0, this.cancelButton, this.okButton);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.promptLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.passwordField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 17, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.getAccessibleContext().setAccessibleParent(null);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void onPasswordActionPerformed(ActionEvent actionEvent) {
        this.doClose(1);
    }

    private void passwordFieldKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u001b') {
            this.doClose(0);
        }
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

