/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.rfbplayer;

import com.tightvnc.rfbplayer.ButtonPanel;
import com.tightvnc.rfbplayer.FbsConnection;
import com.tightvnc.rfbplayer.FbsInputStream;
import com.tightvnc.rfbplayer.LWScrollPane;
import com.tightvnc.rfbplayer.RfbProto;
import com.tightvnc.rfbplayer.RfbSharedStatic;
import com.tightvnc.rfbplayer.VncCanvas;
import java.applet.Applet;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RfbPlayer
extends Applet
implements Runnable,
WindowListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    int dispW = 300;
    int dispH = 200;
    String[] mainArgs;
    FbsInputStream fbs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    LWScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    VncCanvas vc;
    String sessionURL;
    String idxPrefix;
    long initialTimeOffset;
    double playbackSpeed;
    boolean autoPlay;
    boolean showControls;
    boolean isQuitting = false;
    int deferScreenUpdates;

    public static void main(String[] stringArray) {
        RfbPlayer rfbPlayer = new RfbPlayer();
        rfbPlayer.mainArgs = stringArray;
        rfbPlayer.inAnApplet = false;
        rfbPlayer.inSeparateFrame = true;
        rfbPlayer.init();
        rfbPlayer.start();
    }

    public void init() {
        RfbSharedStatic.refApplet = this;
        this.readParameters();
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("RFB Session Player");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
        }
        this.rfbThread = new Thread((Runnable)this, "RfbThread");
        this.rfbThread.start();
    }

    public void update(Graphics graphics) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        if (this.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.buttonPanel.setLayout(new FlowLayout(0, 0, 0));
            this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
            this.vncContainer.add(this.buttonPanel);
        }
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.setVisible(true);
        } else {
            this.validate();
        }
        try {
            RfbPlayer rfbPlayer = this.inAnApplet ? this : null;
            FbsConnection fbsConnection = new FbsConnection(this.sessionURL, this.idxPrefix, rfbPlayer);
            this.fbs = fbsConnection.connect(this.initialTimeOffset);
            this.rfb = new RfbProto(this.fbs);
            this.vc = new VncCanvas(this);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.desktopScrollPane = new LWScrollPane();
            gridBagConstraints.fill = 1;
            this.gridbag.setConstraints(this.vc, gridBagConstraints);
            this.desktopScrollPane.addComp(this.vc);
            this.desktopScrollPane.setSize(this.dispW, this.dispH);
            if (this.inSeparateFrame) {
                this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
                this.vncFrame.add(this.desktopScrollPane);
                this.vncFrame.setTitle(this.rfb.desktopName);
                this.vc.resizeDesktopFrame();
            } else {
                this.desktopScrollPane.setSize(this.dispW, this.dispH);
                gridBagConstraints.fill = 0;
                this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
                this.add(this.desktopScrollPane);
                this.validate();
                this.vc.resizeEmbeddedApplet();
            }
            while (!this.isQuitting) {
                try {
                    this.setPaused(!this.autoPlay);
                    this.fbs.setSpeed(this.playbackSpeed);
                    this.vc.processNormalProtocol();
                }
                catch (EOFException eOFException) {
                    long l;
                    if (eOFException.getMessage() != null && eOFException.getMessage().equals("[JUMP]")) {
                        l = this.fbs.getSeekOffset();
                        this.autoPlay = !this.fbs.isPaused();
                    } else {
                        l = 0L;
                        this.autoPlay = false;
                    }
                    this.fbs.close();
                    this.fbs = fbsConnection.connect(l);
                    this.rfb.newSession(this.fbs);
                    this.vc.updateFramebufferSize();
                }
                catch (NullPointerException nullPointerException) {
                    throw nullPointerException;
                    return;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fatalError(fileNotFoundException.toString());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.fatalError(exception.toString());
        }
    }

    public void setPausedInt(String string) {
        int n = 1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n == 0) {
            this.setPaused(false);
        } else {
            this.setPaused(true);
        }
    }

    public void setPaused(boolean bl) {
        if (this.showControls) {
            this.buttonPanel.setPaused(bl);
        }
        if (bl) {
            this.fbs.pausePlayback();
        } else {
            this.fbs.resumePlayback();
        }
    }

    public double getSpeed() {
        return this.playbackSpeed;
    }

    public void setSpeed(double d) {
        this.playbackSpeed = d;
        this.fbs.setSpeed(d);
    }

    public void jumpTo(long l) {
        long l2 = Math.abs(l - this.fbs.getTimeOffset());
        if (l2 > 5000L) {
            this.fbs.pausePlayback();
            this.setPos(l);
            this.fbs.resumePlayback();
        }
    }

    public void setPos(long l) {
        this.fbs.setTimeOffset(l, true);
    }

    public void updatePos() {
        if (this.showControls && this.buttonPanel != null) {
            this.buttonPanel.setPos(this.fbs.getTimeOffset());
        }
    }

    public void readParameters() {
        this.sessionURL = this.readParameter("URL", true);
        this.idxPrefix = this.readParameter("Index", false);
        this.initialTimeOffset = this.readLongParameter("Position", 0L);
        if (this.initialTimeOffset < 0L) {
            this.initialTimeOffset = 0L;
        }
        this.playbackSpeed = this.readDoubleParameter("Speed", 1.0);
        if (this.playbackSpeed <= 0.0) {
            this.playbackSpeed = 1.0;
        }
        this.autoPlay = false;
        String string = this.readParameter("Autoplay", false);
        if (string != null && string.equalsIgnoreCase("Yes")) {
            this.autoPlay = true;
        }
        this.showControls = true;
        string = this.readParameter("Show_Controls", false);
        if (string != null && string.equalsIgnoreCase("No")) {
            this.showControls = false;
        }
        if (this.inAnApplet && (string = this.readParameter("Open_New_Window", false)) != null && string.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.deferScreenUpdates = (int)this.readLongParameter("Defer_screen_updates", 20L);
        if (this.deferScreenUpdates < 0) {
            this.deferScreenUpdates = 0;
        }
        this.dispW = this.readIntParameter("DISPLAY_WIDTH", this.dispW);
        this.dispH = this.readIntParameter("DISPLAY_HEIGHT", this.dispH);
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(string + " parameter not specified");
            }
            return string2;
        }
        for (int i = 0; i < this.mainArgs.length; i += 2) {
            if (!this.mainArgs[i].equalsIgnoreCase(string)) continue;
            try {
                return this.mainArgs[i + 1];
            }
            catch (Exception exception) {
                if (bl) {
                    this.fatalError(string + " parameter not specified");
                }
                return null;
            }
        }
        if (bl) {
            this.fatalError(string + " parameter not specified");
        }
        return null;
    }

    long readLongParameter(String string, long l) {
        String string2 = this.readParameter(string, false);
        long l2 = l;
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l2;
    }

    double readDoubleParameter(String string, double d) {
        String string2 = this.readParameter(string, false);
        double d2 = d;
        if (string2 != null) {
            try {
                d2 = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d2;
    }

    int readIntParameter(String string, int n) {
        String string2 = this.readParameter(string, false);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public void fatalError(String string) {
        System.err.println(string);
        if (this.inAnApplet) {
            this.vncContainer.removeAll();
            if (this.rfb != null) {
                this.rfb = null;
            }
            Label label = new Label(string);
            label.setFont(new Font("Helvetica", 0, 12));
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(label);
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
            } else {
                this.validate();
            }
            Thread.currentThread().stop();
        } else {
            System.exit(1);
        }
    }

    public void destroy() {
        this.isQuitting = true;
        this.vncContainer.removeAll();
        if (this.fbs != null) {
            this.fbs.quit();
            try {
                this.fbs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.rfbThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.inSeparateFrame) {
            this.vncFrame.removeWindowListener(this);
            this.vncFrame.dispose();
        }
    }

    public void displaySize(int n, int n2) {
        this.dispW = n;
        this.dispH = n2;
        if (!this.inSeparateFrame) {
            this.vc.resizeEmbeddedApplet();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.vncContainer.removeAll();
        if (this.rfb != null) {
            this.rfb = null;
        }
        this.vncFrame.dispose();
        if (!this.inAnApplet) {
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

