/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.rfbplayer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Observer;

class FbsInputStream
extends InputStream {
    protected InputStream in;
    protected long startTime;
    protected long timeOffset;
    protected long seekOffset;
    protected boolean farSeeking;
    protected boolean paused;
    protected boolean isQuitting = false;
    protected double playbackSpeed;
    protected byte[] buffer;
    protected int bufferSize;
    protected int bufferPos;
    protected long nextBlockOffset;
    protected Observer obs;

    FbsInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 0L, null, 0L);
        byte[] byArray = new byte[12];
        this.readFully(byArray);
        if (byArray[0] != 70 || byArray[1] != 66 || byArray[2] != 83 || byArray[3] != 32 || byArray[4] != 48 || byArray[5] != 48 || byArray[6] != 49 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new IOException("Incorrect FBS file signature");
        }
    }

    FbsInputStream(InputStream inputStream, long l, byte[] byArray, long l2) {
        this.in = inputStream;
        this.startTime = System.currentTimeMillis() - l;
        this.timeOffset = l;
        this.seekOffset = -1L;
        this.farSeeking = false;
        this.paused = false;
        this.playbackSpeed = 1.0;
        this.buffer = byArray;
        this.bufferSize = byArray != null ? byArray.length : 0;
        this.bufferPos = 0;
        this.nextBlockOffset = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        this.isQuitting = true;
        FbsInputStream fbsInputStream = this;
        synchronized (fbsInputStream) {
            this.notify();
        }
    }

    public int read() throws IOException {
        while (this.bufferSize == 0) {
            if (this.fillBuffer()) continue;
            return -1;
        }
        --this.bufferSize;
        return this.buffer[this.bufferPos++] & 0xFF;
    }

    public int available() throws IOException {
        return this.bufferSize;
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
        this.startTime = -1L;
        this.timeOffset = 0L;
        this.seekOffset = -1L;
        this.farSeeking = false;
        this.paused = false;
        this.playbackSpeed = 1.0;
        this.buffer = null;
        this.bufferSize = 0;
        this.bufferPos = 0;
        this.nextBlockOffset = 0L;
        this.obs = null;
    }

    public synchronized long getTimeOffset() {
        long l = Math.max(this.seekOffset, this.timeOffset);
        return (long)((double)l * this.playbackSpeed);
    }

    public synchronized void setTimeOffset(long l, boolean bl) {
        this.seekOffset = (long)((double)l / this.playbackSpeed);
        if (bl) {
            long l2 = this.timeOffset + (long)(10000.0 / this.playbackSpeed);
            if (this.seekOffset < this.timeOffset || this.seekOffset > l2) {
                this.farSeeking = true;
            }
        }
        this.notify();
    }

    public synchronized void setSpeed(double d) {
        long l = (long)((double)this.timeOffset * this.playbackSpeed / d);
        this.startTime += this.timeOffset - l;
        this.timeOffset = l;
        if (this.isSeeking()) {
            this.seekOffset = (long)((double)this.seekOffset * this.playbackSpeed / d);
        }
        this.playbackSpeed = d;
    }

    public boolean isSeeking() {
        return this.seekOffset >= 0L;
    }

    public long getSeekOffset() {
        return (long)((double)this.seekOffset * this.playbackSpeed);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public synchronized void pausePlayback() {
        this.paused = true;
        this.notify();
    }

    public synchronized void resumePlayback() {
        this.paused = false;
        this.startTime = System.currentTimeMillis() - this.timeOffset;
        this.notify();
    }

    public void addObserver(Observer observer) {
        this.obs = observer;
    }

    private synchronized boolean fillBuffer() throws IOException {
        long l;
        if (this.farSeeking) {
            throw new EOFException("[JUMP]");
        }
        this.waitWhilePaused();
        if (!this.readDataBlock()) {
            return false;
        }
        if (this.seekOffset >= 0L) {
            if (this.timeOffset >= this.seekOffset) {
                this.startTime = System.currentTimeMillis() - this.seekOffset;
                this.seekOffset = -1L;
            } else {
                return true;
            }
        }
        while (!this.isQuitting && (l = this.startTime + this.timeOffset - System.currentTimeMillis()) > 0L) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waitWhilePaused();
        }
        return true;
    }

    private boolean readDataBlock() throws IOException {
        long l = this.readUnsigned32();
        if (l < 0L) {
            return false;
        }
        this.bufferSize = (int)l;
        int n = this.bufferSize + 3 & 0xFFFFFFFC;
        if (this.nextBlockOffset > 0L) {
            this.in.skip(this.nextBlockOffset);
            this.bufferSize = (int)((long)this.bufferSize - this.nextBlockOffset);
            n = (int)((long)n - this.nextBlockOffset);
            this.nextBlockOffset = 0L;
        }
        if (this.bufferSize >= 0) {
            this.buffer = new byte[n];
            this.readFully(this.buffer);
            this.bufferPos = 0;
            this.timeOffset = (long)((double)this.readUnsigned32() / this.playbackSpeed);
        }
        if (this.bufferSize < 0 || this.timeOffset < 0L || this.bufferPos >= this.bufferSize) {
            this.buffer = null;
            this.bufferSize = 0;
            this.bufferPos = 0;
            throw new IOException("Invalid FBS file data");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhilePaused() {
        while (this.paused && !this.isSeeking() && !this.isQuitting) {
            FbsInputStream fbsInputStream = this;
            synchronized (fbsInputStream) {
                try {
                    this.obs.update(null, null);
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private long readUnsigned32() throws IOException {
        byte[] byArray = new byte[4];
        if (!this.readFully(byArray)) {
            return -1L;
        }
        return (long)(byArray[0] & 0xFF) << 24 | (long)((byArray[1] & 0xFF) << 16) | (long)((byArray[2] & 0xFF) << 8) | (long)(byArray[3] & 0xFF);
    }

    private boolean readFully(byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        for (int i = 0; i != n2; i += n) {
            n = this.in.read(byArray, i, n2 - i);
            if (n >= 0) continue;
            return false;
        }
        return true;
    }
}

