/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.decoder;

import com.tightvnc.decoder.RawDecoder;
import com.tightvnc.vncviewer.InStream;
import com.tightvnc.vncviewer.MemInStream;
import com.tightvnc.vncviewer.RfbInputStream;
import com.tightvnc.vncviewer.ZlibInStream;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.IOException;

public class ZRLEDecoder
extends RawDecoder {
    static final int EncodingZRLE = 16;
    private byte[] zrleBuf;
    private int zrleBufLen = 0;
    private byte[] zrleTilePixels8;
    private int[] zrleTilePixels24;
    private ZlibInStream zrleInStream;
    private boolean zrleRecWarningShown = false;

    public ZRLEDecoder(Graphics graphics, RfbInputStream rfbInputStream) {
        super(graphics, rfbInputStream);
    }

    public ZRLEDecoder(Graphics graphics, RfbInputStream rfbInputStream, int n, int n2) {
        super(graphics, rfbInputStream, n, n2);
    }

    public void handleRect(int n, int n2, int n3, int n4) throws IOException, Exception {
        int n5;
        if (this.dos != null) {
            this.dos.writeInt(16);
        }
        if (this.zrleInStream == null) {
            this.zrleInStream = new ZlibInStream();
        }
        if ((n5 = this.rfbis.readU32()) > 0x4000000) {
            throw new Exception("ZRLE decoder: illegal compressed data size");
        }
        if (this.zrleBuf == null || this.zrleBufLen < n5) {
            this.zrleBufLen = n5 + 4096;
            this.zrleBuf = new byte[this.zrleBufLen];
        }
        this.rfbis.readFully(this.zrleBuf, 0, n5);
        if (this.dos != null && !this.zrleRecWarningShown) {
            System.out.println("Warning: ZRLE session can be recorded only from the beginning");
            System.out.println("Warning: Recorded file may be corrupted");
            this.zrleRecWarningShown = true;
        }
        this.zrleInStream.setUnderlying(new MemInStream(this.zrleBuf, 0, n5), n5);
        for (int i = n2; i < n2 + n4; i += 64) {
            int n6 = Math.min(n2 + n4 - i, 64);
            for (int j = n; j < n + n3; j += 64) {
                int n7 = Math.min(n + n3 - j, 64);
                int n8 = this.zrleInStream.readU8();
                boolean bl = (n8 & 0x80) != 0;
                int n9 = n8 & 0x7F;
                int[] nArray = new int[128];
                this.readZrlePalette(nArray, n9);
                if (n9 == 1) {
                    int n10 = nArray[0];
                    Color color = this.bytesPerPixel == 1 ? this.getColor256()[n10] : new Color(0xFF000000 | n10);
                    this.graphics.setColor(color);
                    this.graphics.fillRect(j, i, n7, n6);
                    continue;
                }
                if (!bl) {
                    if (n9 == 0) {
                        this.readZrleRawPixels(n7, n6);
                    } else {
                        this.readZrlePackedPixels(n7, n6, nArray, n9);
                    }
                } else if (n9 == 0) {
                    this.readZrlePlainRLEPixels(n7, n6);
                } else {
                    this.readZrlePackedRLEPixels(n7, n6, nArray);
                }
                this.handleUpdatedZrleTile(j, i, n7, n6);
            }
        }
        this.zrleInStream.reset();
    }

    public void update() {
        int n = this.framebufferWidth;
        int n2 = this.framebufferHeight;
        if (this.bytesPerPixel == 1) {
            RawDecoder.pixels24 = null;
            RawDecoder.pixels8 = new byte[n * n2];
            RawDecoder.pixelsSource = new MemoryImageSource(n, n2, this.getColorModel8(), pixels8, 0, n);
            this.zrleTilePixels24 = null;
            this.zrleTilePixels8 = new byte[4096];
        } else {
            RawDecoder.pixels8 = null;
            RawDecoder.pixels24 = new int[n * n2];
            RawDecoder.pixelsSource = new MemoryImageSource(n, n2, this.getColorModel24(), pixels24, 0, n);
            this.zrleTilePixels8 = null;
            this.zrleTilePixels24 = new int[4096];
        }
        RawDecoder.pixelsSource.setAnimated(true);
        RawDecoder.rawPixelsImage = Toolkit.getDefaultToolkit().createImage(pixelsSource);
    }

    private void handleUpdatedZrleTile(int n, int n2, int n3, int n4) {
        Object[] objectArray;
        Object[] objectArray2;
        if (this.bytesPerPixel == 1) {
            objectArray2 = this.zrleTilePixels8;
            objectArray = pixels8;
        } else {
            objectArray2 = this.zrleTilePixels24;
            objectArray = pixels24;
        }
        int n5 = 0;
        int n6 = n2 * this.framebufferWidth + n;
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(objectArray2, n5, objectArray, n6, n3);
            n5 += n3;
            n6 += this.framebufferWidth;
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
    }

    private int readPixel(InStream inStream) throws Exception {
        int n;
        if (this.bytesPerPixel == 1) {
            n = inStream.readU8();
        } else {
            int n2 = inStream.readU8();
            int n3 = inStream.readU8();
            int n4 = inStream.readU8();
            n = (n4 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n2 & 0xFF;
        }
        return n;
    }

    private void readPixels(InStream inStream, int[] nArray, int n) throws Exception {
        if (this.bytesPerPixel == 1) {
            byte[] byArray = new byte[n];
            inStream.readBytes(byArray, 0, n);
            for (int i = 0; i < n; ++i) {
                nArray[i] = byArray[i] & 0xFF;
            }
        } else {
            byte[] byArray = new byte[n * 3];
            inStream.readBytes(byArray, 0, n * 3);
            for (int i = 0; i < n; ++i) {
                nArray[i] = (byArray[i * 3 + 2] & 0xFF) << 16 | (byArray[i * 3 + 1] & 0xFF) << 8 | byArray[i * 3] & 0xFF;
            }
        }
    }

    private void readZrlePalette(int[] nArray, int n) throws Exception {
        this.readPixels(this.zrleInStream, nArray, n);
    }

    private void readZrleRawPixels(int n, int n2) throws Exception {
        if (this.bytesPerPixel == 1) {
            this.zrleInStream.readBytes(this.zrleTilePixels8, 0, n * n2);
        } else {
            this.readPixels(this.zrleInStream, this.zrleTilePixels24, n * n2);
        }
    }

    private void readZrlePackedPixels(int n, int n2, int[] nArray, int n3) throws Exception {
        int n4 = n3 > 16 ? 8 : (n3 > 4 ? 4 : (n3 > 2 ? 2 : 1));
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6 = n5 + n;
            int n7 = 0;
            int n8 = 0;
            while (n5 < n6) {
                if (n8 == 0) {
                    n7 = this.zrleInStream.readU8();
                    n8 = 8;
                }
                int n9 = n7 >> (n8 -= n4) & (1 << n4) - 1 & 0x7F;
                if (this.bytesPerPixel == 1) {
                    this.zrleTilePixels8[n5++] = (byte)nArray[n9];
                    continue;
                }
                this.zrleTilePixels24[n5++] = nArray[n9];
            }
        }
    }

    private void readZrlePlainRLEPixels(int n, int n2) throws Exception {
        int n3 = 0;
        int n4 = n3 + n * n2;
        while (n3 < n4) {
            int n5;
            int n6 = this.readPixel(this.zrleInStream);
            int n7 = 1;
            do {
                n5 = this.zrleInStream.readU8();
                n7 += n5;
            } while (n5 == 255);
            if (n7 > n4 - n3) {
                throw new Exception("ZRLE decoder: assertion failed (len <= end-ptr)");
            }
            if (this.bytesPerPixel == 1) {
                while (n7-- > 0) {
                    this.zrleTilePixels8[n3++] = (byte)n6;
                }
                continue;
            }
            while (n7-- > 0) {
                this.zrleTilePixels24[n3++] = n6;
            }
        }
    }

    private void readZrlePackedRLEPixels(int n, int n2, int[] nArray) throws Exception {
        int n3 = 0;
        int n4 = n3 + n * n2;
        while (n3 < n4) {
            int n5;
            int n6 = this.zrleInStream.readU8();
            int n7 = 1;
            if ((n6 & 0x80) != 0) {
                do {
                    n5 = this.zrleInStream.readU8();
                    n7 += n5;
                } while (n5 == 255);
                if (n7 > n4 - n3) {
                    throw new Exception("ZRLE decoder: assertion failed (len <= end - ptr)");
                }
            }
            n5 = nArray[n6 &= 0x7F];
            if (this.bytesPerPixel == 1) {
                while (n7-- > 0) {
                    this.zrleTilePixels8[n3++] = (byte)n5;
                }
                continue;
            }
            while (n7-- > 0) {
                this.zrleTilePixels24[n3++] = n5;
            }
        }
    }
}

