/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.SignatureRSA;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;

class IdentityFile
implements Identity {
    String identity;
    byte[] key;
    byte[] iv;
    private JSch jsch;
    private HASH hash;
    private byte[] encoded_data;
    private Cipher cipher;
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private byte[] n_array;
    private byte[] e_array;
    private byte[] d_array;
    private String algname = "ssh-rsa";
    private static final int ERROR = 0;
    private static final int RSA = 1;
    private static final int DSS = 2;
    private static final int UNKNOWN = 3;
    private static final int OPENSSH = 0;
    private static final int FSECURE = 1;
    private static final int PUTTY = 2;
    private int type = 0;
    private int keytype = 0;
    private byte[] publickeyblob = null;
    private boolean encrypted = true;

    static IdentityFile newInstance(String string, String string2, JSch jSch) throws JSchException {
        byte[] byArray;
        byte[] byArray2;
        block15: {
            int n;
            byArray2 = null;
            byArray = null;
            File file = null;
            FileInputStream fileInputStream = null;
            try {
                file = new File(string);
                fileInputStream = new FileInputStream(string);
                byArray2 = new byte[(int)file.length()];
                int n2 = 0;
                while ((n = fileInputStream.read(byArray2, n2, byArray2.length - n2)) > 0) {
                    n2 += n;
                }
                fileInputStream.close();
            }
            catch (Exception exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (exception instanceof Throwable) {
                    throw new JSchException(exception.toString(), exception);
                }
                throw new JSchException(exception.toString());
            }
            String string3 = string2;
            if (string2 == null) {
                string3 = string + ".pub";
            }
            try {
                int n3;
                file = new File(string3);
                fileInputStream = new FileInputStream(string3);
                byArray = new byte[(int)file.length()];
                n = 0;
                while ((n3 = fileInputStream.read(byArray, n, byArray.length - n)) > 0) {
                    n += n3;
                }
                fileInputStream.close();
            }
            catch (Exception exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                if (string2 == null) break block15;
                if (exception instanceof Throwable) {
                    throw new JSchException(exception.toString(), exception);
                }
                throw new JSchException(exception.toString());
            }
        }
        return IdentityFile.newInstance(string, byArray2, byArray, jSch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdentityFile newInstance(String string, byte[] byArray, byte[] byArray2, JSch jSch) throws JSchException {
        try {
            IdentityFile identityFile = new IdentityFile(string, byArray, byArray2, jSch);
            return identityFile;
        }
        finally {
            Util.bzero(byArray);
        }
    }

    private IdentityFile(String string, byte[] byArray, byte[] byArray2, JSch jSch) throws JSchException {
        this.identity = string;
        this.jsch = jSch;
        try {
            int n;
            int n2;
            Class<?> clazz = Class.forName(JSch.getConfig("3des-cbc"));
            this.cipher = (Cipher)clazz.newInstance();
            this.key = new byte[this.cipher.getBlockSize()];
            this.iv = new byte[this.cipher.getIVSize()];
            clazz = Class.forName(JSch.getConfig("md5"));
            this.hash = (HASH)clazz.newInstance();
            this.hash.init();
            byte[] byArray3 = byArray;
            int n3 = byArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                if (byArray3[n4] == 66 && byArray3[n4 + 1] == 69 && byArray3[n4 + 2] == 71 && byArray3[n4 + 3] == 73) {
                    if (byArray3[n4 += 6] == 68 && byArray3[n4 + 1] == 83 && byArray3[n4 + 2] == 65) {
                        this.type = 2;
                    } else if (byArray3[n4] == 82 && byArray3[n4 + 1] == 83 && byArray3[n4 + 2] == 65) {
                        this.type = 1;
                    } else if (byArray3[n4] == 83 && byArray3[n4 + 1] == 83 && byArray3[n4 + 2] == 72) {
                        this.type = 3;
                        this.keytype = 1;
                    } else {
                        throw new JSchException("invalid privatekey: " + this.identity);
                    }
                    n4 += 3;
                    continue;
                }
                if (byArray3[n4] == 65 && byArray3[n4 + 1] == 69 && byArray3[n4 + 2] == 83 && byArray3[n4 + 3] == 45 && byArray3[n4 + 4] == 50 && byArray3[n4 + 5] == 53 && byArray3[n4 + 6] == 54 && byArray3[n4 + 7] == 45) {
                    n4 += 8;
                    if (Session.checkCipher(JSch.getConfig("aes256-cbc"))) {
                        clazz = Class.forName(JSch.getConfig("aes256-cbc"));
                        this.cipher = (Cipher)clazz.newInstance();
                        this.key = new byte[this.cipher.getBlockSize()];
                        this.iv = new byte[this.cipher.getIVSize()];
                        continue;
                    }
                    throw new JSchException("privatekey: aes256-cbc is not available " + this.identity);
                }
                if (byArray3[n4] == 67 && byArray3[n4 + 1] == 66 && byArray3[n4 + 2] == 67 && byArray3[n4 + 3] == 44) {
                    n4 += 4;
                    for (n2 = 0; n2 < this.iv.length; ++n2) {
                        this.iv[n2] = (byte)((this.a2b(byArray3[n4++]) << 4 & 0xF0) + (this.a2b(byArray3[n4++]) & 0xF));
                    }
                    continue;
                }
                if (byArray3[n4] == 13 && n4 + 1 < byArray3.length && byArray3[n4 + 1] == 10) {
                    ++n4;
                    continue;
                }
                if (byArray3[n4] == 10 && n4 + 1 < byArray3.length) {
                    if (byArray3[n4 + 1] == 10) {
                        n4 += 2;
                        break;
                    }
                    if (byArray3[n4 + 1] == 13 && n4 + 2 < byArray3.length && byArray3[n4 + 2] == 10) {
                        n4 += 3;
                        break;
                    }
                    n2 = 0;
                    for (n = n4 + 1; n < byArray3.length && byArray3[n] != 10; ++n) {
                        if (byArray3[n] != 58) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 == 0) {
                        ++n4;
                        this.encrypted = false;
                        break;
                    }
                }
                ++n4;
            }
            if (this.type == 0) {
                throw new JSchException("invalid privatekey: " + this.identity);
            }
            n2 = n4;
            while (n4 < n3) {
                if (byArray3[n4] == 10) {
                    n = byArray3[n4 - 1] == 13 ? 1 : 0;
                    System.arraycopy(byArray3, n4 + 1, byArray3, n4 - (n != 0 ? 1 : 0), n3 - n4 - 1 - (n != 0 ? 1 : 0));
                    if (n != 0) {
                        --n3;
                    }
                    --n3;
                    continue;
                }
                if (byArray3[n4] == 45) break;
                ++n4;
            }
            this.encoded_data = Util.fromBase64(byArray3, n2, n4 - n2);
            if (this.encoded_data.length > 4 && this.encoded_data[0] == 63 && this.encoded_data[1] == 111 && this.encoded_data[2] == -7 && this.encoded_data[3] == -21) {
                Buffer buffer = new Buffer(this.encoded_data);
                buffer.getInt();
                buffer.getInt();
                byte[] byArray4 = buffer.getString();
                byte[] byArray5 = buffer.getString();
                String string2 = new String(byArray5);
                if (string2.equals("3des-cbc")) {
                    buffer.getInt();
                    byte[] byArray6 = new byte[this.encoded_data.length - buffer.getOffSet()];
                    buffer.getByte(byArray6);
                    this.encoded_data = byArray6;
                    this.encrypted = true;
                    throw new JSchException("unknown privatekey format: " + this.identity);
                }
                if (string2.equals("none")) {
                    buffer.getInt();
                    this.encrypted = false;
                    byte[] byArray7 = new byte[this.encoded_data.length - buffer.getOffSet()];
                    buffer.getByte(byArray7);
                    this.encoded_data = byArray7;
                }
            }
            if (byArray2 == null) {
                return;
            }
            byArray3 = byArray2;
            n3 = byArray3.length;
            if (byArray3.length > 4 && byArray3[0] == 45 && byArray3[1] == 45 && byArray3[2] == 45 && byArray3[3] == 45) {
                n4 = 0;
                while (n3 > ++n4 && byArray3[n4] != 10) {
                }
                if (n3 <= n4) {
                    return;
                }
                while (n4 < n3) {
                    if (byArray3[n4] == 10) {
                        boolean bl = false;
                        for (int i = n4 + 1; i < n3 && byArray3[i] != 10; ++i) {
                            if (byArray3[i] != 58) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            ++n4;
                            break;
                        }
                    }
                    ++n4;
                }
                if (n3 <= n4) {
                    return;
                }
                n2 = n4;
                while (n4 < n3) {
                    if (byArray3[n4] == 10) {
                        System.arraycopy(byArray3, n4 + 1, byArray3, n4, n3 - n4 - 1);
                        --n3;
                        continue;
                    }
                    if (byArray3[n4] == 45) break;
                    ++n4;
                }
                this.publickeyblob = Util.fromBase64(byArray3, n2, n4 - n2);
                if (this.type == 3 && this.publickeyblob.length > 8) {
                    if (this.publickeyblob[8] == 100) {
                        this.type = 2;
                    } else if (this.publickeyblob[8] == 114) {
                        this.type = 1;
                    }
                }
            } else {
                if (byArray3[0] != 115 || byArray3[1] != 115 || byArray3[2] != 104 || byArray3[3] != 45) {
                    return;
                }
                for (n4 = 0; n4 < n3 && byArray3[n4] != 32; ++n4) {
                }
                if (++n4 >= n3) {
                    return;
                }
                n2 = n4;
                while (n4 < n3 && byArray3[n4] != 32 && byArray3[n4] != 10) {
                    ++n4;
                }
                this.publickeyblob = Util.fromBase64(byArray3, n2, n4 - n2);
                if (this.publickeyblob.length < 11) {
                    if (JSch.getLogger().isEnabled(2)) {
                        JSch.getLogger().log(2, "failed to parse the public key");
                    }
                    this.publickeyblob = null;
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    public String getAlgName() {
        if (this.type == 1) {
            return "ssh-rsa";
        }
        return "ssh-dss";
    }

    public boolean setPassphrase(byte[] byArray) throws JSchException {
        try {
            if (this.encrypted) {
                if (byArray == null) {
                    return false;
                }
                byte[] byArray2 = byArray;
                int n = this.hash.getBlockSize();
                byte[] byArray3 = new byte[this.key.length / n * n + (this.key.length % n == 0 ? 0 : n)];
                byte[] byArray4 = null;
                if (this.keytype == 0) {
                    int n2 = 0;
                    while (n2 + n <= byArray3.length) {
                        if (byArray4 != null) {
                            this.hash.update(byArray4, 0, byArray4.length);
                        }
                        this.hash.update(byArray2, 0, byArray2.length);
                        this.hash.update(this.iv, 0, this.iv.length > 8 ? 8 : this.iv.length);
                        byArray4 = this.hash.digest();
                        System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
                        n2 += byArray4.length;
                    }
                    System.arraycopy(byArray3, 0, this.key, 0, this.key.length);
                } else if (this.keytype == 1) {
                    int n3 = 0;
                    while (n3 + n <= byArray3.length) {
                        if (byArray4 != null) {
                            this.hash.update(byArray4, 0, byArray4.length);
                        }
                        this.hash.update(byArray2, 0, byArray2.length);
                        byArray4 = this.hash.digest();
                        System.arraycopy(byArray4, 0, byArray3, n3, byArray4.length);
                        n3 += byArray4.length;
                    }
                    System.arraycopy(byArray3, 0, this.key, 0, this.key.length);
                }
                Util.bzero(byArray2);
            }
            if (this.decrypt()) {
                this.encrypted = false;
                return true;
            }
            this.prv_array = null;
            this.pub_array = null;
            this.G_array = null;
            this.Q_array = null;
            this.P_array = null;
            return false;
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    public byte[] getPublicKeyBlob() {
        if (this.publickeyblob != null) {
            return this.publickeyblob;
        }
        if (this.type == 1) {
            return this.getPublicKeyBlob_rsa();
        }
        return this.getPublicKeyBlob_dss();
    }

    byte[] getPublicKeyBlob_rsa() {
        if (this.e_array == null) {
            return null;
        }
        Buffer buffer = new Buffer("ssh-rsa".length() + 4 + this.e_array.length + 4 + this.n_array.length + 4);
        buffer.putString("ssh-rsa".getBytes());
        buffer.putString(this.e_array);
        buffer.putString(this.n_array);
        return buffer.buffer;
    }

    byte[] getPublicKeyBlob_dss() {
        if (this.P_array == null) {
            return null;
        }
        Buffer buffer = new Buffer("ssh-dss".length() + 4 + this.P_array.length + 4 + this.Q_array.length + 4 + this.G_array.length + 4 + this.pub_array.length + 4);
        buffer.putString("ssh-dss".getBytes());
        buffer.putString(this.P_array);
        buffer.putString(this.Q_array);
        buffer.putString(this.G_array);
        buffer.putString(this.pub_array);
        return buffer.buffer;
    }

    public byte[] getSignature(byte[] byArray) {
        if (this.type == 1) {
            return this.getSignature_rsa(byArray);
        }
        return this.getSignature_dss(byArray);
    }

    byte[] getSignature_rsa(byte[] byArray) {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.rsa"));
            SignatureRSA signatureRSA = (SignatureRSA)clazz.newInstance();
            signatureRSA.init();
            signatureRSA.setPrvKey(this.d_array, this.n_array);
            signatureRSA.update(byArray);
            byte[] byArray2 = signatureRSA.sign();
            Buffer buffer = new Buffer("ssh-rsa".length() + 4 + byArray2.length + 4);
            buffer.putString("ssh-rsa".getBytes());
            buffer.putString(byArray2);
            return buffer.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    byte[] getSignature_dss(byte[] byArray) {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.dss"));
            SignatureDSA signatureDSA = (SignatureDSA)clazz.newInstance();
            signatureDSA.init();
            signatureDSA.setPrvKey(this.prv_array, this.P_array, this.Q_array, this.G_array);
            signatureDSA.update(byArray);
            byte[] byArray2 = signatureDSA.sign();
            Buffer buffer = new Buffer("ssh-dss".length() + 4 + byArray2.length + 4);
            buffer.putString("ssh-dss".getBytes());
            buffer.putString(byArray2);
            return buffer.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean decrypt() {
        if (this.type == 1) {
            return this.decrypt_rsa();
        }
        return this.decrypt_dss();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_rsa() {
        try {
            int n;
            int n2;
            byte[] byArray;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                } else {
                    if (this.keytype != 1) return false;
                    for (n2 = 0; n2 < this.iv.length; ++n2) {
                        this.iv[n2] = 0;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                }
            } else {
                if (this.n_array != null) {
                    return true;
                }
                byArray = this.encoded_data;
            }
            if (this.keytype == 1) {
                Buffer buffer = new Buffer(byArray);
                int n3 = buffer.getInt();
                if (byArray.length != n3 + 4) {
                    return false;
                }
                this.e_array = buffer.getMPIntBits();
                this.d_array = buffer.getMPIntBits();
                this.n_array = buffer.getMPIntBits();
                byte[] byArray2 = buffer.getMPIntBits();
                byte[] byArray3 = buffer.getMPIntBits();
                byte[] byArray4 = buffer.getMPIntBits();
                return true;
            }
            n2 = 0;
            int n4 = 0;
            if (byArray[n2] != 48) {
                return false;
            }
            int n5 = ++n2;
            ++n2;
            n4 = byArray[n5] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            if (byArray[n2] != 2) {
                return false;
            }
            int n6 = ++n2;
            ++n2;
            n4 = byArray[n6] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            n2 += n4;
            int n7 = ++n2;
            ++n2;
            n4 = byArray[n7] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.n_array = new byte[n4];
            System.arraycopy(byArray, n2, this.n_array, 0, n4);
            n2 += n4;
            int n8 = ++n2;
            ++n2;
            n4 = byArray[n8] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.e_array = new byte[n4];
            System.arraycopy(byArray, n2, this.e_array, 0, n4);
            n2 += n4;
            int n9 = ++n2;
            ++n2;
            n4 = byArray[n9] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.d_array = new byte[n4];
            System.arraycopy(byArray, n2, this.d_array, 0, n4);
            n2 += n4;
            int n10 = ++n2;
            ++n2;
            n4 = byArray[n10] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray5 = new byte[n4];
            System.arraycopy(byArray, n2, byArray5, 0, n4);
            n2 += n4;
            int n11 = ++n2;
            ++n2;
            n4 = byArray[n11] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray6 = new byte[n4];
            System.arraycopy(byArray, n2, byArray6, 0, n4);
            n2 += n4;
            int n12 = ++n2;
            ++n2;
            n4 = byArray[n12] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray7 = new byte[n4];
            System.arraycopy(byArray, n2, byArray7, 0, n4);
            n2 += n4;
            int n13 = ++n2;
            ++n2;
            n4 = byArray[n13] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray8 = new byte[n4];
            System.arraycopy(byArray, n2, byArray8, 0, n4);
            n2 += n4;
            int n14 = ++n2;
            ++n2;
            n4 = byArray[n14] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray9 = new byte[n4];
            System.arraycopy(byArray, n2, byArray9, 0, n4);
            n2 += n4;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_dss() {
        try {
            int n;
            int n2;
            byte[] byArray;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                } else {
                    if (this.keytype != 1) return false;
                    for (n2 = 0; n2 < this.iv.length; ++n2) {
                        this.iv[n2] = 0;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                }
            } else {
                if (this.P_array != null) {
                    return true;
                }
                byArray = this.encoded_data;
            }
            if (this.keytype == 1) {
                Buffer buffer = new Buffer(byArray);
                int n3 = buffer.getInt();
                if (byArray.length != n3 + 4) {
                    return false;
                }
                this.P_array = buffer.getMPIntBits();
                this.G_array = buffer.getMPIntBits();
                this.Q_array = buffer.getMPIntBits();
                this.pub_array = buffer.getMPIntBits();
                this.prv_array = buffer.getMPIntBits();
                return true;
            }
            n2 = 0;
            int n4 = 0;
            if (byArray[n2] != 48) {
                return false;
            }
            int n5 = ++n2;
            ++n2;
            n4 = byArray[n5] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            if (byArray[n2] != 2) {
                return false;
            }
            int n6 = ++n2;
            ++n2;
            n4 = byArray[n6] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            n2 += n4;
            int n7 = ++n2;
            ++n2;
            n4 = byArray[n7] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.P_array = new byte[n4];
            System.arraycopy(byArray, n2, this.P_array, 0, n4);
            n2 += n4;
            int n8 = ++n2;
            ++n2;
            n4 = byArray[n8] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.Q_array = new byte[n4];
            System.arraycopy(byArray, n2, this.Q_array, 0, n4);
            n2 += n4;
            int n9 = ++n2;
            ++n2;
            n4 = byArray[n9] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.G_array = new byte[n4];
            System.arraycopy(byArray, n2, this.G_array, 0, n4);
            n2 += n4;
            int n10 = ++n2;
            ++n2;
            n4 = byArray[n10] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.pub_array = new byte[n4];
            System.arraycopy(byArray, n2, this.pub_array, 0, n4);
            n2 += n4;
            int n11 = ++n2;
            ++n2;
            n4 = byArray[n11] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.prv_array = new byte[n4];
            System.arraycopy(byArray, n2, this.prv_array, 0, n4);
            n2 += n4;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public String getName() {
        return this.identity;
    }

    private byte a2b(byte by) {
        if (48 <= by && by <= 57) {
            return (byte)(by - 48);
        }
        if (97 <= by && by <= 122) {
            return (byte)(by - 97 + 10);
        }
        return (byte)(by - 65 + 10);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IdentityFile)) {
            return super.equals(object);
        }
        IdentityFile identityFile = (IdentityFile)object;
        return this.getName().equals(identityFile.getName());
    }

    public void clear() {
        Util.bzero(this.encoded_data);
        Util.bzero(this.prv_array);
        Util.bzero(this.d_array);
        Util.bzero(this.key);
        Util.bzero(this.iv);
    }

    public void finalize() {
        this.clear();
    }
}

